public import IMPORT_STATIC "ecrt"

import IMPORT_STATIC "dggal"

import "dggrsTestCase"

define I3HL0PgonArea = earthSurfaceArea / 12;
define I3HL1HexArea  = earthSurfaceArea / (10 * pow(3, 1));
define I3HL2HexArea  = earthSurfaceArea / (10 * pow(3, 2));
define I3HL3HexArea  = earthSurfaceArea / (10 * pow(3, 3));
define I3HL4HexArea  = earthSurfaceArea / (10 * pow(3, 4));
define I3HL5HexArea  = earthSurfaceArea / (10 * pow(3, 5));
define I3HL30HexArea = earthSurfaceArea / (10 * pow(3,30));

Array<DGGSTestCase> isea3HTestCases
{ [
   {
      "ISEA3H",
      "C1-4A-A",
      I3HZone { 2, 1, 0x4A, 0 },
      { -52.4191888623706, -137.4616308471657 },
      { { -57.1416370892295, -143.3298697019406 }, { -47.5120175403158, -130.7624110954168 } },
      "B3-6-B",
      "C1-4A-B",
      { [ "B1-6-C", "B3-6-B", "B1-6-D" ] },
      { [ "C1-4A-B", "C1-4A-C", "C1-4A-D", "C1-49-C", "C1-40-D", "C1-40-C", "C1-41-D" ] },
      { [ "C1-40-A", "C3-36-A", "C1-41-A", "C1-4B-A", "C1-49-A", "C3-3F-A" ] },
      I3HL4HexArea
   },
   {
      "ISEA3H",
      "C2-1A-A",
      I3HZone { 2, 2, 0x1A, 0 },
      { 46.1742429194147, -12.0546399274803 },
      { { 41.9762057076161, -19.0277386918324 }, { 50.2028892174138, -5.7135964294376 } },
      "B4-2-B",
      "C2-1A-B",
      { [ "B2-2-C", "B4-2-B", "B2-2-D" ] },
      { [ "C2-1A-B", "C2-1A-C", "C2-1A-D", "C2-19-C", "C2-10-D", "C2-10-C", "C2-11-D" ] },
      { [ "C2-10-A", "C4-6-A", "C2-11-A", "C4-7-A", "C2-19-A", "C2-23-A" ] },
      I3HL4HexArea
   },
   {
      "ISEA3H",
      "P0-8B98130DCC58-A",
      I3HZone { 15, 0, 0x8B98130DCC58, 0 },
      { 33.7851803439345, -116.5864012245285 },
      { { 33.785177730114, -116.5864043644841 }, { 33.7851829577552, -116.5863980845729 } },
      "O0-F82ACF60053-B",
      "P0-8B98130DCC58-B",
      { [ "O0-F82ACAD04DA-D", "O0-F82ACAD04D9-C", "O0-F82ACF60053-B" ] },
      { [ "P0-8B98130DCC58-B", "P0-8B98130DCC58-C", "P0-8B98130DCC58-D", "P0-8B98130DCC57-C", "P0-8B981232D9EC-D", "P0-8B981232D9EC-C", "P0-8B981232D9ED-D" ] },
      { [ "P0-8B981232D9EC-A", "P0-8B9813E8BEC4-A", "P0-8B981232D9ED-A", "P0-8B98130DCC59-A", "P0-8B98130DCC57-A", "P0-8B9813E8BEC3-A" ] },
      I3HL30HexArea
   },
   {
      "ISEA3H",
      "BB-0-A",
      I3HZone { 1, 11, 0, 0 },
      { -58.3971459074309, -168.80 },
      { { -68.6497504975911, 171.0659054044506 }, { -45.7022588393206, -148.6659054044505 } },
      "AB-0-B",
      "BB-0-B",
      { [ "AB-0-B" ] },
      { [ "BB-0-B", "B1-6-D", "B3-6-D", "B5-6-D", "B7-6-D", "B9-6-D" ] },
      { [ "B3-6-A", "B9-6-A", "B1-6-A", "B5-6-A", "B7-6-A" ] },
      I3HL2HexArea * 5/6
   },
   {
      "ISEA3H",
      "AB-0-B",
      I3HZone { 0, 11, 0, 1 },
      { -58.3971459074309, -168.80 },
      { { -79.2371363010228, 150.6950921221046 }, { -39.4695395487854, -128.295092122811 } },
      "AB-0-A",
      "BB-0-A",
      { [ "AB-0-A" ] },
      { [ "BB-0-A", "B1-6-A", "B3-6-A", "B5-6-A", "B7-6-A", "B9-6-A" ] },
      //{ [ "A3-0-D", "A9-0-D", "A1-0-D", "A5-0-D", "A7-0-D" ] },
      { [ "A9-0-D", "A1-0-D", "A3-0-D", "A5-0-D", "A7-0-D" ] },
      I3HL1HexArea * 5/6,
      { [ { 3, "C9-36-A" }, { 4, "C1-36-B" } ] },
      { [
         // Variation #28: even depths
         { 4, { [ "C1-36-B", "C9-4A-B", "C9-4A-D", "C1-36-D", "C1-40-B", "C9-40-B", "C9-40-D", "C9-49-C", "C1-3F-B", "C1-3F-C", "C1-40-D", "C1-4A-B", "C9-36-B", "C9-36-D", "C9-3F-C", "C9-49-B", "C9-49-D", "C1-3F-D", "C1-49-B", "C1-49-C", "C1-4A-D" ,"C3-36-B", "C7-4A-D", "C9-3F-B", "C9-3F-D", "C9-48-C", "C1-48-B", "C1-48-C", "C1-49-D", "C3-3F-B", "C3-36-D", "C7-4A-B", "C7-49-C", "C7-49-D", "C9-48-B", "C9-48-D", "C1-48-D", "C3-48-B", "C3-3F-D", "C3-3F-C", "C3-40-B", "C7-40-D", "C7-49-B", "C7-48-C", "C7-48-D", "CB-0-B", "C3-48-D", "C3-48-C", "C3-49-B", "C3-40-D", "C7-40-B", "C7-3F-C", "C7-3F-D", "C7-48-B", "C5-48-D", "C5-48-B", "C3-49-D", "C3-49-C", "C3-4A-B", "C7-36-D", "C7-3F-B", "C5-49-D", "C5-48-C", "C5-3F-D", "C5-3F-B", "C3-4A-D", "C7-36-B", "C5-4A-D", "C5-49-C", "C5-49-B", "C5-3F-C", "C5-36-D", "C5-36-B", "C5-4A-B", "C5-40-D", "C5-40-B" ] } },
         { 6, { [ "D1-1E6-B", "D9-2C6-B", "D9-2C6-D", "D1-1E6-D", "D1-202-B", "D9-2AA-B", "D9-2AA-D", "D9-2C5-C", "D1-201-B", "D1-201-C", "D1-202-D", "D1-21E-B", "D9-28E-B", "D9-28E-D", "D9-2A9-C", "D9-2C5-B", "D9-2C5-D", "D1-201-D", "D1-21D-B", "D1-21D-C", "D1-21E-D", "D1-23A-B", "D9-272-B", "D9-272-D", "D9-28D-C", "D9-2A9-B", "D9-2A9-D", "D9-2C4-C", "D1-21C-B", "D1-21C-C", "D1-21D-D", "D1-239-B", "D1-239-C", "D1-23A-D", "D1-256-B", "D9-256-B", "D9-256-D", "D9-271-C", "D9-28D-B", "D9-28D-D", "D9-2A8-C", "D9-2C4-B", "D9-2C4-D", "D1-21C-D", "D1-238-B", "D1-238-C", "D1-239-D", "D1-255-B", "D1-255-C", "D1-256-D", "D1-272-B", "D9-23A-B", "D9-23A-D", "D9-255-C", "D9-271-B", "D9-271-D", "D9-28C-C", "D9-2A8-B", "D9-2A8-D", "D9-2C3-C", "D1-237-B", "D1-237-C", "D1-238-D", "D1-254-B", "D1-254-C", "D1-255-D", "D1-271-B", "D1-271-C", "D1-272-D", "D1-28E-B", "D9-21E-B", "D9-21E-D", "D9-239-C", "D9-255-B", "D9-255-D", "D9-270-C", "D9-28C-B", "D9-28C-D", "D9-2A7-C", "D9-2C3-B", "D9-2C3-D", "D1-237-D", "D1-253-B", "D1-253-C", "D1-254-D", "D1-270-B", "D1-270-C", "D1-271-D", "D1-28D-B", "D1-28D-C", "D1-28E-D", "D1-2AA-B", "D9-202-B", "D9-202-D", "D9-21D-C", "D9-239-B", "D9-239-D", "D9-254-C", "D9-270-B", "D9-270-D", "D9-28B-C", "D9-2A7-B", "D9-2A7-D", "D9-2C2-C", "D1-252-B", "D1-252-C", "D1-253-D", "D1-26F-B", "D1-26F-C", "D1-270-D", "D1-28C-B", "D1-28C-C", "D1-28D-D", "D1-2A9-B", "D1-2A9-C", "D1-2AA-D", "D1-2C6-B", "D9-1E6-B", "D9-1E6-D", "D9-201-C", "D9-21D-B", "D9-21D-D", "D9-238-C", "D9-254-B", "D9-254-D", "D9-26F-C", "D9-28B-B", "D9-28B-D", "D9-2A6-C", "D9-2C2-B", "D9-2C2-D", "D1-252-D", "D1-26E-B", "D1-26E-C", "D1-26F-D", "D1-28B-B", "D1-28B-C", "D1-28C-D", "D1-2A8-B", "D1-2A8-C", "D1-2A9-D", "D1-2C5-B", "D1-2C5-C", "D1-2C6-D", "D3-1E6-B", "D7-2C6-D", "D9-201-B", "D9-201-D", "D9-21C-C", "D9-238-B", "D9-238-D", "D9-253-C", "D9-26F-B", "D9-26F-D", "D9-28A-C", "D9-2A6-B", "D9-2A6-D", "D9-2C1-C", "D1-26D-B", "D1-26D-C", "D1-26E-D", "D1-28A-B", "D1-28A-C", "D1-28B-D", "D1-2A7-B", "D1-2A7-C", "D1-2A8-D", "D1-2C4-B", "D1-2C4-C", "D1-2C5-D", "D3-201-B", "D3-1E6-D", "D7-2C6-B", "D7-2C5-C", "D7-2C5-D", "D9-21C-B", "D9-21C-D", "D9-237-C", "D9-253-B", "D9-253-D", "D9-26E-C", "D9-28A-B", "D9-28A-D", "D9-2A5-C", "D9-2C1-B", "D9-2C1-D", "D1-26D-D", "D1-289-B", "D1-289-C", "D1-28A-D", "D1-2A6-B", "D1-2A6-C", "D1-2A7-D", "D1-2C3-B", "D1-2C3-C", "D1-2C4-D", "D3-21C-B", "D3-201-D", "D3-201-C", "D3-202-B", "D7-2AA-D", "D7-2C5-B", "D7-2C4-C", "D7-2C4-D", "D9-237-B", "D9-237-D", "D9-252-C", "D9-26E-B", "D9-26E-D", "D9-289-C", "D9-2A5-B", "D9-2A5-D", "D9-2C0-C", "D1-288-B", "D1-288-C", "D1-289-D", "D1-2A5-B", "D1-2A5-C", "D1-2A6-D", "D1-2C2-B", "D1-2C2-C", "D1-2C3-D", "D3-237-B", "D3-21C-D", "D3-21C-C", "D3-21D-B", "D3-202-D", "D7-2AA-B", "D7-2A9-C", "D7-2A9-D", "D7-2C4-B", "D7-2C3-C", "D7-2C3-D", "D9-252-B", "D9-252-D", "D9-26D-C", "D9-289-B", "D9-289-D", "D9-2A4-C", "D9-2C0-B", "D9-2C0-D", "D1-288-D", "D1-2A4-B", "D1-2A4-C", "D1-2A5-D", "D1-2C1-B", "D1-2C1-C", "D1-2C2-D", "D3-252-B", "D3-237-D", "D3-237-C", "D3-238-B", "D3-21D-D", "D3-21D-C", "D3-21E-B", "D7-28E-D", "D7-2A9-B", "D7-2A8-C", "D7-2A8-D", "D7-2C3-B", "D7-2C2-C", "D7-2C2-D", "D9-26D-B", "D9-26D-D", "D9-288-C", "D9-2A4-B", "D9-2A4-D", "D9-2BF-C", "D1-2A3-B", "D1-2A3-C", "D1-2A4-D", "D1-2C0-B", "D1-2C0-C", "D1-2C1-D", "D3-26D-B", "D3-252-D", "D3-252-C", "D3-253-B", "D3-238-D", "D3-238-C", "D3-239-B", "D3-21E-D", "D7-28E-B", "D7-28D-C", "D7-28D-D", "D7-2A8-B", "D7-2A7-C", "D7-2A7-D", "D7-2C2-B", "D7-2C1-C", "D7-2C1-D", "D9-288-B", "D9-288-D", "D9-2A3-C", "D9-2BF-B", "D9-2BF-D", "D1-2A3-D", "D1-2BF-B", "D1-2BF-C", "D1-2C0-D", "D3-288-B", "D3-26D-D", "D3-26D-C", "D3-26E-B", "D3-253-D", "D3-253-C", "D3-254-B", "D3-239-D", "D3-239-C", "D3-23A-B", "D7-272-D", "D7-28D-B", "D7-28C-C", "D7-28C-D", "D7-2A7-B", "D7-2A6-C", "D7-2A6-D", "D7-2C1-B", "D7-2C0-C", "D7-2C0-D", "D9-2A3-B", "D9-2A3-D", "D9-2BE-C", "D1-2BE-B", "D1-2BE-C", "D1-2BF-D", "D3-2A3-B", "D3-288-D", "D3-288-C", "D3-289-B", "D3-26E-D", "D3-26E-C", "D3-26F-B", "D3-254-D", "D3-254-C", "D3-255-B", "D3-23A-D", "D7-272-B", "D7-271-C", "D7-271-D", "D7-28C-B", "D7-28B-C", "D7-28B-D", "D7-2A6-B", "D7-2A5-C", "D7-2A5-D", "D7-2C0-B", "D7-2BF-C", "D7-2BF-D", "D9-2BE-B", "D9-2BE-D", "D1-2BE-D", "D3-2BE-B", "D3-2A3-D", "D3-2A3-C", "D3-2A4-B", "D3-289-D", "D3-289-C", "D3-28A-B", "D3-26F-D", "D3-26F-C", "D3-270-B", "D3-255-D", "D3-255-C", "D3-256-B", "D7-256-D", "D7-271-B", "D7-270-C", "D7-270-D", "D7-28B-B", "D7-28A-C", "D7-28A-D", "D7-2A5-B", "D7-2A4-C", "D7-2A4-D", "D7-2BF-B", "D7-2BE-C", "D7-2BE-D", "DB-0-B", "D3-2BE-D", "D3-2BE-C", "D3-2BF-B", "D3-2A4-D", "D3-2A4-C", "D3-2A5-B", "D3-28A-D", "D3-28A-C", "D3-28B-B", "D3-270-D", "D3-270-C", "D3-271-B", "D3-256-D", "D7-256-B", "D7-255-C", "D7-255-D", "D7-270-B", "D7-26F-C", "D7-26F-D", "D7-28A-B", "D7-289-C", "D7-289-D", "D7-2A4-B", "D7-2A3-C", "D7-2A3-D", "D7-2BE-B", "D5-2BE-D", "D5-2BE-B", "D3-2BF-D", "D3-2BF-C", "D3-2C0-B", "D3-2A5-D", "D3-2A5-C", "D3-2A6-B", "D3-28B-D", "D3-28B-C", "D3-28C-B", "D3-271-D", "D3-271-C", "D3-272-B", "D7-23A-D", "D7-255-B", "D7-254-C", "D7-254-D", "D7-26F-B", "D7-26E-C", "D7-26E-D", "D7-289-B", "D7-288-C", "D7-288-D", "D7-2A3-B", "D5-2BF-D", "D5-2BE-C", "D5-2A3-D", "D5-2A3-B", "D3-2C0-D", "D3-2C0-C", "D3-2C1-B", "D3-2A6-D", "D3-2A6-C", "D3-2A7-B", "D3-28C-D", "D3-28C-C", "D3-28D-B", "D3-272-D", "D7-23A-B", "D7-239-C", "D7-239-D", "D7-254-B", "D7-253-C", "D7-253-D", "D7-26E-B", "D7-26D-C", "D7-26D-D", "D7-288-B", "D5-2C0-D", "D5-2BF-C", "D5-2BF-B", "D5-2A3-C", "D5-288-D", "D5-288-B", "D3-2C1-D", "D3-2C1-C", "D3-2C2-B", "D3-2A7-D", "D3-2A7-C", "D3-2A8-B", "D3-28D-D", "D3-28D-C", "D3-28E-B", "D7-21E-D", "D7-239-B", "D7-238-C", "D7-238-D", "D7-253-B", "D7-252-C", "D7-252-D", "D7-26D-B", "D5-2C1-D", "D5-2C0-C", "D5-2C0-B", "D5-2A4-D", "D5-2A4-B", "D5-288-C", "D5-26D-D", "D5-26D-B", "D3-2C2-D", "D3-2C2-C", "D3-2C3-B", "D3-2A8-D", "D3-2A8-C", "D3-2A9-B", "D3-28E-D", "D7-21E-B", "D7-21D-C", "D7-21D-D", "D7-238-B", "D7-237-C", "D7-237-D", "D7-252-B", "D5-2C2-D", "D5-2C1-C", "D5-2C1-B", "D5-2A5-D", "D5-2A4-C", "D5-289-D", "D5-289-B", "D5-26D-C", "D5-252-D", "D5-252-B", "D3-2C3-D", "D3-2C3-C", "D3-2C4-B", "D3-2A9-D", "D3-2A9-C", "D3-2AA-B", "D7-202-D", "D7-21D-B", "D7-21C-C", "D7-21C-D", "D7-237-B", "D5-2C3-D", "D5-2C2-C", "D5-2C2-B", "D5-2A6-D", "D5-2A5-C", "D5-2A5-B", "D5-289-C", "D5-26E-D", "D5-26E-B", "D5-252-C", "D5-237-D", "D5-237-B", "D3-2C4-D", "D3-2C4-C", "D3-2C5-B", "D3-2AA-D", "D7-202-B", "D7-201-C", "D7-201-D", "D7-21C-B", "D5-2C4-D", "D5-2C3-C", "D5-2C3-B", "D5-2A7-D", "D5-2A6-C", "D5-2A6-B", "D5-28A-D", "D5-28A-B", "D5-26E-C", "D5-253-D", "D5-253-B", "D5-237-C", "D5-21C-D", "D5-21C-B", "D3-2C5-D", "D3-2C5-C", "D3-2C6-B", "D7-1E6-D", "D7-201-B", "D5-2C5-D", "D5-2C4-C", "D5-2C4-B", "D5-2A8-D", "D5-2A7-C", "D5-2A7-B", "D5-28B-D", "D5-28A-C", "D5-26F-D", "D5-26F-B", "D5-253-C", "D5-238-D", "D5-238-B", "D5-21C-C", "D5-201-D", "D5-201-B", "D3-2C6-D", "D7-1E6-B", "D5-2C6-D", "D5-2C5-C", "D5-2C5-B", "D5-2A9-D", "D5-2A8-C", "D5-2A8-B", "D5-28C-D", "D5-28B-C", "D5-28B-B", "D5-26F-C", "D5-254-D", "D5-254-B", "D5-238-C", "D5-21D-D", "D5-21D-B", "D5-201-C", "D5-1E6-D", "D5-1E6-B", "D5-2C6-B", "D5-2AA-D", "D5-2A9-C", "D5-2A9-B", "D5-28D-D", "D5-28C-C", "D5-28C-B", "D5-270-D", "D5-270-B", "D5-254-C", "D5-239-D", "D5-239-B", "D5-21D-C", "D5-202-D", "D5-202-B", "D5-2AA-B", "D5-28E-D", "D5-28D-C", "D5-28D-B", "D5-271-D", "D5-270-C", "D5-255-D", "D5-255-B", "D5-239-C", "D5-21E-D", "D5-21E-B", "D5-28E-B", "D5-272-D", "D5-271-C", "D5-271-B", "D5-255-C", "D5-23A-D", "D5-23A-B", "D5-272-B", "D5-256-D", "D5-256-B" ] } },
         // Variation #22: odd depths
         { 3, { [ "C9-36-A", "C9-40-A", "C9-4A-A", "C1-36-A", "C7-4A-A", "C9-3F-A", "C9-49-A", "C1-3F-A", "C1-40-A", "C7-40-A", "C7-49-A", "C9-48-A", "C1-48-A", "C1-49-A", "C1-4A-A", "C7-36-A", "C7-3F-A", "C7-48-A", "CB-0-A", "C3-48-A", "C3-3F-A", "C3-36-A", "C5-4A-A", "C5-49-A", "C5-48-A", "C3-49-A", "C3-40-A", "C5-40-A", "C5-3F-A", "C3-4A-A", "C5-36-A" ] } },
         { 5, { [ "D9-1E6-A", "D9-202-A", "D9-21E-A", "D9-23A-A", "D9-256-A", "D9-272-A", "D9-28E-A", "D9-2AA-A", "D9-2C6-A", "D1-1E6-A", "D7-2C6-A", "D9-201-A", "D9-21D-A", "D9-239-A", "D9-255-A", "D9-271-A", "D9-28D-A", "D9-2A9-A", "D9-2C5-A", "D1-201-A", "D1-202-A", "D7-2AA-A", "D7-2C5-A", "D9-21C-A", "D9-238-A", "D9-254-A", "D9-270-A", "D9-28C-A", "D9-2A8-A", "D9-2C4-A", "D1-21C-A", "D1-21D-A", "D1-21E-A", "D7-28E-A", "D7-2A9-A", "D7-2C4-A", "D9-237-A", "D9-253-A", "D9-26F-A", "D9-28B-A", "D9-2A7-A", "D9-2C3-A", "D1-237-A", "D1-238-A", "D1-239-A", "D1-23A-A", "D7-272-A", "D7-28D-A", "D7-2A8-A", "D7-2C3-A", "D9-252-A", "D9-26E-A", "D9-28A-A", "D9-2A6-A", "D9-2C2-A", "D1-252-A", "D1-253-A", "D1-254-A", "D1-255-A", "D1-256-A", "D7-256-A", "D7-271-A", "D7-28C-A", "D7-2A7-A", "D7-2C2-A", "D9-26D-A", "D9-289-A", "D9-2A5-A", "D9-2C1-A", "D1-26D-A", "D1-26E-A", "D1-26F-A", "D1-270-A", "D1-271-A", "D1-272-A", "D7-23A-A", "D7-255-A", "D7-270-A", "D7-28B-A", "D7-2A6-A", "D7-2C1-A", "D9-288-A", "D9-2A4-A", "D9-2C0-A", "D1-288-A", "D1-289-A", "D1-28A-A", "D1-28B-A", "D1-28C-A", "D1-28D-A", "D1-28E-A", "D7-21E-A", "D7-239-A", "D7-254-A", "D7-26F-A", "D7-28A-A", "D7-2A5-A", "D7-2C0-A", "D9-2A3-A", "D9-2BF-A", "D1-2A3-A", "D1-2A4-A", "D1-2A5-A", "D1-2A6-A", "D1-2A7-A", "D1-2A8-A", "D1-2A9-A", "D1-2AA-A", "D7-202-A", "D7-21D-A", "D7-238-A", "D7-253-A", "D7-26E-A", "D7-289-A", "D7-2A4-A", "D7-2BF-A", "D9-2BE-A", "D1-2BE-A", "D1-2BF-A", "D1-2C0-A", "D1-2C1-A", "D1-2C2-A", "D1-2C3-A", "D1-2C4-A", "D1-2C5-A", "D1-2C6-A", "D7-1E6-A", "D7-201-A", "D7-21C-A", "D7-237-A", "D7-252-A", "D7-26D-A", "D7-288-A", "D7-2A3-A", "D7-2BE-A", "DB-0-A", "D3-2BE-A", "D3-2A3-A", "D3-288-A", "D3-26D-A", "D3-252-A", "D3-237-A", "D3-21C-A", "D3-201-A", "D3-1E6-A", "D5-2C6-A", "D5-2C5-A", "D5-2C4-A", "D5-2C3-A", "D5-2C2-A", "D5-2C1-A", "D5-2C0-A", "D5-2BF-A", "D5-2BE-A", "D3-2BF-A", "D3-2A4-A", "D3-289-A", "D3-26E-A", "D3-253-A", "D3-238-A", "D3-21D-A", "D3-202-A", "D5-2AA-A", "D5-2A9-A", "D5-2A8-A", "D5-2A7-A", "D5-2A6-A", "D5-2A5-A", "D5-2A4-A", "D5-2A3-A", "D3-2C0-A", "D3-2A5-A", "D3-28A-A", "D3-26F-A", "D3-254-A", "D3-239-A", "D3-21E-A", "D5-28E-A", "D5-28D-A", "D5-28C-A", "D5-28B-A", "D5-28A-A", "D5-289-A", "D5-288-A", "D3-2C1-A", "D3-2A6-A", "D3-28B-A", "D3-270-A", "D3-255-A", "D3-23A-A", "D5-272-A", "D5-271-A", "D5-270-A", "D5-26F-A", "D5-26E-A", "D5-26D-A", "D3-2C2-A", "D3-2A7-A", "D3-28C-A", "D3-271-A", "D3-256-A", "D5-256-A", "D5-255-A", "D5-254-A", "D5-253-A", "D5-252-A", "D3-2C3-A", "D3-2A8-A", "D3-28D-A", "D3-272-A", "D5-23A-A", "D5-239-A", "D5-238-A", "D5-237-A", "D3-2C4-A", "D3-2A9-A", "D3-28E-A", "D5-21E-A", "D5-21D-A", "D5-21C-A", "D3-2C5-A", "D3-2AA-A", "D5-202-A", "D5-201-A", "D3-2C6-A", "D5-1E6-A" ] } }
      ] }
   },
   {
      "ISEA3H",
      "B1-3-B",
      I3HZone { 1, 1, 3, 1 },
      { -19.9220109417641, -143.8150297468511 },
      { { -26.7203687185635, -152.1620542185438 }, { -13.1609778555479, -135.3652822448291 } },
      null,
      "C1-1B-A",
      { [ "B1-3-A" ] },
      { [ "C1-1B-A", "C1-1C-A", "C1-25-A", "C1-24-A", "C9-4D-A", "C9-4E-A", "C1-12-A" ] },
      { [ "B9-8-D", "B1-0-D", "B9-7-C", "B1-3-C", "B9-7-D", "B1-3-D" ] },
      I3HL3HexArea
   },
   {
      "ISEA3H",
      "B0-1-B",
      I3HZone { 1, 0, 1, 1 },
      { 79.2371362991038, -168.80 },
      { { 72.149054142835, 147.0348924474562 }, { 86.4035502948906, -124.6348924474316 } },
      null,
      "C0-3-A",
      { [ "B0-1-A" ] },
      { [ "C0-3-A", "C0-4-A", "C0-D-A", "C0-C-A", "C0-2-A", "C8-3E-A", "C8-35-A" ] },
      { [ "B8-8-C", "B0-0-C", "B8-5-C", "B0-1-C", "B8-5-D", "B0-1-D" ] },
      I3HL3HexArea
   },
   {
      "ISEA3H",
      "BA-0-A",
      I3HZone { 1, 10, 0, 0 },
      { 58.3971459074309, 11.20 },
      { { 45.7022588393269, -8.9340945955364 }, { 68.649750497591, 31.3340945955455 } },
      "AA-0-B",
      "BA-0-B",
      { [ "AA-0-B" ] },
      { [ "BA-0-B", "B0-2-C", "B2-2-C", "B4-2-C", "B6-2-C", "B8-2-C" ] },
      { [ "B4-2-A", "B6-2-A", "B8-2-A", "B0-2-A", "B2-2-A" ] },
      I3HL2HexArea * 5/6,
      { [ { 4, "D0-69-A" }, { 6, "E0-321-A" }, { 8, "F0-1A79-A" } ] },
      { [
         { 4, { [ "D0-69-A", "D0-86-A", "D0-6A-A", "D0-4E-A", "D0-32-A", "D2-32-A", "D2-17-A", "D0-6B-A", "D0-4F-A", "D0-33-A", "D0-17-A", "D8-86-A", "D2-69-A", "D2-4E-A", "D2-33-A", "D2-18-A", "D0-50-A", "D0-34-A", "D0-18-A", "D8-6B-A", "D8-6A-A", "D8-69-A", "D2-6A-A", "D2-4F-A", "D2-34-A", "D2-19-A", "D0-35-A", "D0-19-A", "D8-50-A", "D8-4F-A", "D8-4E-A", "D2-86-A", "D2-6B-A", "D2-50-A", "D2-35-A", "D2-1A-A", "D0-1A-A", "D8-35-A", "D8-34-A", "D8-33-A", "D8-32-A", "D4-17-A", "D4-18-A", "D4-19-A", "D4-1A-A", "DA-0-A", "D8-1A-A", "D8-19-A", "D8-18-A", "D8-17-A", "D4-32-A", "D4-33-A", "D4-34-A", "D4-35-A", "D6-1A-A", "D6-35-A", "D6-50-A", "D6-6B-A", "D6-86-A", "D4-4E-A", "D4-4F-A", "D4-50-A", "D6-19-A", "D6-34-A", "D6-4F-A", "D6-6A-A", "D4-69-A", "D4-6A-A", "D4-6B-A", "D6-18-A", "D6-33-A", "D6-4E-A", "D6-69-A", "D4-86-A", "D6-17-A", "D6-32-A" ] } }
      ] }
   },
   {
      "ISEA3H",
      "AA-0-B",
      I3HZone { 0, 10, 0, 1 },
      { 58.3971459074309, 11.20 },
      { { 39.4695395487901, -29.3049078771889 }, { 79.2371363010228, 51.7049078778955 } },
      "AA-0-A",
      "BA-0-A",
      { [ "AA-0-A" ] },
      { [ "BA-0-A", "B0-2-A", "B2-2-A", "B4-2-A", "B6-2-A", "B8-2-A" ] },
      //{ [ "A4-0-C", "A6-0-C", "A8-0-C", "A0-0-C", "A2-0-C" ] },
      { [ "A2-0-C", "A4-0-C", "A6-0-C", "A8-0-C", "A0-0-C"] },
      I3HL1HexArea * 5/6,
      { [ { 3, "C2-6-A" }, { 4, "C0-6-B" }, { 5, "D2-12-A" }, { 6, "D0-12-B" } ] },
      { [
         // Variation #27: even depths
         { 4, { [ "C0-6-B", "C0-10-B", "C0-6-C", "C8-1A-C", "C8-1A-B", "C0-1A-B", "C0-10-C", "C0-7-D", "C0-7-B", "C8-11-D", "C8-10-C", "C8-10-B", "C2-6-B", "C0-1A-C", "C0-11-D", "C0-11-B", "C0-7-C", "C8-11-C", "C8-11-B", "C8-7-D", "C8-6-C", "C8-6-B", "C2-6-C", "C2-7-B", "C0-11-C", "C0-8-D", "C0-8-B", "C8-8-D", "C8-7-C", "C8-7-B", "C6-1A-C", "C2-10-B", "C2-7-D", "C2-7-C", "C2-8-B", "C0-8-C", "C8-8-C", "C8-8-B", "C6-11-C", "C6-11-D", "C6-1A-B", "C2-10-C", "C2-11-B", "C2-8-D", "C2-8-C", "CA-0-B", "C6-8-C", "C6-8-D", "C6-11-B", "C6-10-C", "C2-1A-B", "C2-11-D", "C2-11-C", "C4-8-B", "C4-8-C", "C6-8-B", "C6-7-C", "C6-7-D", "C6-10-B", "C2-1A-C", "C4-7-B", "C4-7-C", "C4-8-D", "C4-11-C", "C6-7-B", "C6-6-C", "C4-6-B", "C4-6-C", "C4-7-D", "C4-11-B", "C4-11-D", "C4-1A-C", "C6-6-B", "C4-10-B", "C4-10-C", "C4-1A-B" ] } },
         { 6, { [ "D0-12-B", "D0-2E-B", "D0-12-C", "D8-F2-C", "D8-F2-B", "D0-4A-B", "D0-2E-C", "D0-13-D", "D0-13-B", "D8-D7-D", "D8-D6-C", "D8-D6-B", "D0-66-B", "D0-4A-C", "D0-2F-D", "D0-2F-B", "D0-13-C", "D8-D7-C", "D8-D7-B", "D8-BB-D", "D8-BA-C", "D8-BA-B", "D0-82-B", "D0-66-C", "D0-4B-D", "D0-4B-B", "D0-2F-C", "D0-14-D", "D0-14-B", "D8-BC-D", "D8-BB-C", "D8-BB-B", "D8-9F-D", "D8-9E-C", "D8-9E-B", "D0-9E-B", "D0-82-C", "D0-67-D", "D0-67-B", "D0-4B-C", "D0-30-D", "D0-30-B", "D0-14-C", "D8-BC-C", "D8-BC-B", "D8-A0-D", "D8-9F-C", "D8-9F-B", "D8-83-D", "D8-82-C", "D8-82-B", "D0-BA-B", "D0-9E-C", "D0-83-D", "D0-83-B", "D0-67-C", "D0-4C-D", "D0-4C-B", "D0-30-C", "D0-15-D", "D0-15-B", "D8-A1-D", "D8-A0-C", "D8-A0-B", "D8-84-D", "D8-83-C", "D8-83-B", "D8-67-D", "D8-66-C", "D8-66-B", "D0-D6-B", "D0-BA-C", "D0-9F-D", "D0-9F-B", "D0-83-C", "D0-68-D", "D0-68-B", "D0-4C-C", "D0-31-D", "D0-31-B", "D0-15-C", "D8-A1-C", "D8-A1-B", "D8-85-D", "D8-84-C", "D8-84-B", "D8-68-D", "D8-67-C", "D8-67-B", "D8-4B-D", "D8-4A-C", "D8-4A-B", "D0-F2-B", "D0-D6-C", "D0-BB-D", "D0-BB-B", "D0-9F-C", "D0-84-D", "D0-84-B", "D0-68-C", "D0-4D-D", "D0-4D-B", "D0-31-C", "D0-16-D", "D0-16-B", "D8-86-D", "D8-85-C", "D8-85-B", "D8-69-D", "D8-68-C", "D8-68-B", "D8-4C-D", "D8-4B-C", "D8-4B-B", "D8-2F-D", "D8-2E-C", "D8-2E-B", "D2-12-B", "D0-F2-C", "D0-D7-D", "D0-D7-B", "D0-BB-C", "D0-A0-D", "D0-A0-B", "D0-84-C", "D0-69-D", "D0-69-B", "D0-4D-C", "D0-32-D", "D0-32-B", "D0-16-C", "D8-86-C", "D8-86-B", "D8-6A-D", "D8-69-C", "D8-69-B", "D8-4D-D", "D8-4C-C", "D8-4C-B", "D8-30-D", "D8-2F-C", "D8-2F-B", "D8-13-D", "D8-12-C", "D8-12-B", "D2-12-C", "D2-13-B", "D0-D7-C", "D0-BC-D", "D0-BC-B", "D0-A0-C", "D0-85-D", "D0-85-B", "D0-69-C", "D0-4E-D", "D0-4E-B", "D0-32-C", "D0-17-D", "D0-17-B", "D8-6B-D", "D8-6A-C", "D8-6A-B", "D8-4E-D", "D8-4D-C", "D8-4D-B", "D8-31-D", "D8-30-C", "D8-30-B", "D8-14-D", "D8-13-C", "D8-13-B", "D6-F2-C", "D2-2E-B", "D2-13-D", "D2-13-C", "D2-14-B", "D0-BC-C", "D0-A1-D", "D0-A1-B", "D0-85-C", "D0-6A-D", "D0-6A-B", "D0-4E-C", "D0-33-D", "D0-33-B", "D0-17-C", "D8-6B-C", "D8-6B-B", "D8-4F-D", "D8-4E-C", "D8-4E-B", "D8-32-D", "D8-31-C", "D8-31-B", "D8-15-D", "D8-14-C", "D8-14-B", "D6-D7-C", "D6-D7-D", "D6-F2-B", "D2-2E-C", "D2-2F-B", "D2-14-D", "D2-14-C", "D2-15-B", "D0-A1-C", "D0-86-D", "D0-86-B", "D0-6A-C", "D0-4F-D", "D0-4F-B", "D0-33-C", "D0-18-D", "D0-18-B", "D8-50-D", "D8-4F-C", "D8-4F-B", "D8-33-D", "D8-32-C", "D8-32-B", "D8-16-D", "D8-15-C", "D8-15-B", "D6-BC-C", "D6-BC-D", "D6-D7-B", "D6-D6-C", "D2-4A-B", "D2-2F-D", "D2-2F-C", "D2-30-B", "D2-15-D", "D2-15-C", "D2-16-B", "D0-86-C", "D0-6B-D", "D0-6B-B", "D0-4F-C", "D0-34-D", "D0-34-B", "D0-18-C", "D8-50-C", "D8-50-B", "D8-34-D", "D8-33-C", "D8-33-B", "D8-17-D", "D8-16-C", "D8-16-B", "D6-A1-C", "D6-A1-D", "D6-BC-B", "D6-BB-C", "D6-BB-D", "D6-D6-B", "D2-4A-C", "D2-4B-B", "D2-30-D", "D2-30-C", "D2-31-B", "D2-16-D", "D2-16-C", "D2-17-B", "D0-6B-C", "D0-50-D", "D0-50-B", "D0-34-C", "D0-19-D", "D0-19-B", "D8-35-D", "D8-34-C", "D8-34-B", "D8-18-D", "D8-17-C", "D8-17-B", "D6-86-C", "D6-86-D", "D6-A1-B", "D6-A0-C", "D6-A0-D", "D6-BB-B", "D6-BA-C", "D2-66-B", "D2-4B-D", "D2-4B-C", "D2-4C-B", "D2-31-D", "D2-31-C", "D2-32-B", "D2-17-D", "D2-17-C", "D2-18-B", "D0-50-C", "D0-35-D", "D0-35-B", "D0-19-C", "D8-35-C", "D8-35-B", "D8-19-D", "D8-18-C", "D8-18-B", "D6-6B-C", "D6-6B-D", "D6-86-B", "D6-85-C", "D6-85-D", "D6-A0-B", "D6-9F-C", "D6-9F-D", "D6-BA-B", "D2-66-C", "D2-67-B", "D2-4C-D", "D2-4C-C", "D2-4D-B", "D2-32-D", "D2-32-C", "D2-33-B", "D2-18-D", "D2-18-C", "D2-19-B", "D0-35-C", "D0-1A-D", "D0-1A-B", "D8-1A-D", "D8-19-C", "D8-19-B", "D6-50-C", "D6-50-D", "D6-6B-B", "D6-6A-C", "D6-6A-D", "D6-85-B", "D6-84-C", "D6-84-D", "D6-9F-B", "D6-9E-C", "D2-82-B", "D2-67-D", "D2-67-C", "D2-68-B", "D2-4D-D", "D2-4D-C", "D2-4E-B", "D2-33-D", "D2-33-C", "D2-34-B", "D2-19-D", "D2-19-C", "D2-1A-B", "D0-1A-C", "D8-1A-C", "D8-1A-B", "D6-35-C", "D6-35-D", "D6-50-B", "D6-4F-C", "D6-4F-D", "D6-6A-B", "D6-69-C", "D6-69-D", "D6-84-B", "D6-83-C", "D6-83-D", "D6-9E-B", "D2-82-C", "D2-83-B", "D2-68-D", "D2-68-C", "D2-69-B", "D2-4E-D", "D2-4E-C", "D2-4F-B", "D2-34-D", "D2-34-C", "D2-35-B", "D2-1A-D", "D2-1A-C", "DA-0-B", "D6-1A-C", "D6-1A-D", "D6-35-B", "D6-34-C", "D6-34-D", "D6-4F-B", "D6-4E-C", "D6-4E-D", "D6-69-B", "D6-68-C", "D6-68-D", "D6-83-B", "D6-82-C", "D2-9E-B", "D2-83-D", "D2-83-C", "D2-84-B", "D2-69-D", "D2-69-C", "D2-6A-B", "D2-4F-D", "D2-4F-C", "D2-50-B", "D2-35-D", "D2-35-C", "D4-1A-B", "D4-1A-C", "D6-1A-B", "D6-19-C", "D6-19-D", "D6-34-B", "D6-33-C", "D6-33-D", "D6-4E-B", "D6-4D-C", "D6-4D-D", "D6-68-B", "D6-67-C", "D6-67-D", "D6-82-B", "D2-9E-C", "D2-9F-B", "D2-84-D", "D2-84-C", "D2-85-B", "D2-6A-D", "D2-6A-C", "D2-6B-B", "D2-50-D", "D2-50-C", "D4-19-B", "D4-19-C", "D4-1A-D", "D4-35-C", "D6-19-B", "D6-18-C", "D6-18-D", "D6-33-B", "D6-32-C", "D6-32-D", "D6-4D-B", "D6-4C-C", "D6-4C-D", "D6-67-B", "D6-66-C", "D2-BA-B", "D2-9F-D", "D2-9F-C", "D2-A0-B", "D2-85-D", "D2-85-C", "D2-86-B", "D2-6B-D", "D2-6B-C", "D4-18-B", "D4-18-C", "D4-19-D", "D4-35-B", "D4-35-D", "D4-50-C", "D6-18-B", "D6-17-C", "D6-17-D", "D6-32-B", "D6-31-C", "D6-31-D", "D6-4C-B", "D6-4B-C", "D6-4B-D", "D6-66-B", "D2-BA-C", "D2-BB-B", "D2-A0-D", "D2-A0-C", "D2-A1-B", "D2-86-D", "D2-86-C", "D4-17-B", "D4-17-C", "D4-18-D", "D4-34-B", "D4-34-C", "D4-50-B", "D4-50-D", "D4-6B-C", "D6-17-B", "D6-16-C", "D6-16-D", "D6-31-B", "D6-30-C", "D6-30-D", "D6-4B-B", "D6-4A-C", "D2-D6-B", "D2-BB-D", "D2-BB-C", "D2-BC-B", "D2-A1-D", "D2-A1-C", "D4-16-B", "D4-16-C", "D4-17-D", "D4-33-B", "D4-33-C", "D4-34-D", "D4-4F-C", "D4-6B-B", "D4-6B-D", "D4-86-C", "D6-16-B", "D6-15-C", "D6-15-D", "D6-30-B", "D6-2F-C", "D6-2F-D", "D6-4A-B", "D2-D6-C", "D2-D7-B", "D2-BC-D", "D2-BC-C", "D4-15-B", "D4-15-C", "D4-16-D", "D4-32-B", "D4-32-C", "D4-33-D", "D4-4F-B", "D4-4F-D", "D4-6A-C", "D4-86-B", "D4-86-D", "D4-A1-C", "D6-15-B", "D6-14-C", "D6-14-D", "D6-2F-B", "D6-2E-C", "D2-F2-B", "D2-D7-D", "D2-D7-C", "D4-14-B", "D4-14-C", "D4-15-D", "D4-31-B", "D4-31-C", "D4-32-D", "D4-4E-B", "D4-4E-C", "D4-6A-B", "D4-6A-D", "D4-85-C", "D4-A1-B", "D4-A1-D", "D4-BC-C", "D6-14-B", "D6-13-C", "D6-13-D", "D6-2E-B", "D2-F2-C", "D4-13-B", "D4-13-C", "D4-14-D", "D4-30-B", "D4-30-C", "D4-31-D", "D4-4D-B", "D4-4D-C", "D4-4E-D", "D4-69-C", "D4-85-B", "D4-85-D", "D4-A0-C", "D4-BC-B", "D4-BC-D", "D4-D7-C", "D6-13-B", "D6-12-C", "D4-12-B", "D4-12-C", "D4-13-D", "D4-2F-B", "D4-2F-C", "D4-30-D", "D4-4C-B", "D4-4C-C", "D4-4D-D", "D4-69-B", "D4-69-D", "D4-84-C", "D4-A0-B", "D4-A0-D", "D4-BB-C", "D4-D7-B", "D4-D7-D", "D4-F2-C", "D6-12-B", "D4-2E-B", "D4-2E-C", "D4-2F-D", "D4-4B-B", "D4-4B-C", "D4-4C-D", "D4-68-B", "D4-68-C", "D4-84-B", "D4-84-D", "D4-9F-C", "D4-BB-B", "D4-BB-D", "D4-D6-C", "D4-F2-B", "D4-4A-B", "D4-4A-C", "D4-4B-D", "D4-67-B", "D4-67-C", "D4-68-D", "D4-83-C", "D4-9F-B", "D4-9F-D", "D4-BA-C", "D4-D6-B", "D4-66-B", "D4-66-C", "D4-67-D", "D4-83-B", "D4-83-D", "D4-9E-C", "D4-BA-B", "D4-82-B", "D4-82-C", "D4-9E-B" ] } },
         // Variation #21: odd depths
         { 3, { [ "C2-6-A", "C0-1A-A", "C0-10-A", "C0-6-A", "C2-10-A", "C2-7-A", "C0-11-A", "C0-7-A", "C8-1A-A", "C2-1A-A", "C2-11-A", "C2-8-A", "C0-8-A", "C8-11-A", "C8-10-A", "C4-6-A", "C4-7-A", "C4-8-A", "CA-0-A", "C8-8-A", "C8-7-A", "C8-6-A", "C4-10-A", "C4-11-A", "C6-8-A", "C6-11-A", "C6-1A-A", "C4-1A-A", "C6-7-A", "C6-10-A", "C6-6-A" ] } },
         { 5, { [ "D2-12-A", "D0-F2-A", "D0-D6-A", "D0-BA-A", "D0-9E-A", "D0-82-A", "D0-66-A", "D0-4A-A", "D0-2E-A", "D0-12-A", "D2-2E-A", "D2-13-A", "D0-D7-A", "D0-BB-A", "D0-9F-A", "D0-83-A", "D0-67-A", "D0-4B-A", "D0-2F-A", "D0-13-A", "D8-F2-A", "D2-4A-A", "D2-2F-A", "D2-14-A", "D0-BC-A", "D0-A0-A", "D0-84-A", "D0-68-A", "D0-4C-A", "D0-30-A", "D0-14-A", "D8-D7-A", "D8-D6-A", "D2-66-A", "D2-4B-A", "D2-30-A", "D2-15-A", "D0-A1-A", "D0-85-A", "D0-69-A", "D0-4D-A", "D0-31-A", "D0-15-A", "D8-BC-A", "D8-BB-A", "D8-BA-A", "D2-82-A", "D2-67-A", "D2-4C-A", "D2-31-A", "D2-16-A", "D0-86-A", "D0-6A-A", "D0-4E-A", "D0-32-A", "D0-16-A", "D8-A1-A", "D8-A0-A", "D8-9F-A", "D8-9E-A", "D2-9E-A", "D2-83-A", "D2-68-A", "D2-4D-A", "D2-32-A", "D2-17-A", "D0-6B-A", "D0-4F-A", "D0-33-A", "D0-17-A", "D8-86-A", "D8-85-A", "D8-84-A", "D8-83-A", "D8-82-A", "D2-BA-A", "D2-9F-A", "D2-84-A", "D2-69-A", "D2-4E-A", "D2-33-A", "D2-18-A", "D0-50-A", "D0-34-A", "D0-18-A", "D8-6B-A", "D8-6A-A", "D8-69-A", "D8-68-A", "D8-67-A", "D8-66-A", "D2-D6-A", "D2-BB-A", "D2-A0-A", "D2-85-A", "D2-6A-A", "D2-4F-A", "D2-34-A", "D2-19-A", "D0-35-A", "D0-19-A", "D8-50-A", "D8-4F-A", "D8-4E-A", "D8-4D-A", "D8-4C-A", "D8-4B-A", "D8-4A-A", "D2-F2-A", "D2-D7-A", "D2-BC-A", "D2-A1-A", "D2-86-A", "D2-6B-A", "D2-50-A", "D2-35-A", "D2-1A-A", "D0-1A-A", "D8-35-A", "D8-34-A", "D8-33-A", "D8-32-A", "D8-31-A", "D8-30-A", "D8-2F-A", "D8-2E-A", "D4-12-A", "D4-13-A", "D4-14-A", "D4-15-A", "D4-16-A", "D4-17-A", "D4-18-A", "D4-19-A", "D4-1A-A", "DA-0-A", "D8-1A-A", "D8-19-A", "D8-18-A", "D8-17-A", "D8-16-A", "D8-15-A", "D8-14-A", "D8-13-A", "D8-12-A", "D4-2E-A", "D4-2F-A", "D4-30-A", "D4-31-A", "D4-32-A", "D4-33-A", "D4-34-A", "D4-35-A", "D6-1A-A", "D6-35-A", "D6-50-A", "D6-6B-A", "D6-86-A", "D6-A1-A", "D6-BC-A", "D6-D7-A", "D6-F2-A", "D4-4A-A", "D4-4B-A", "D4-4C-A", "D4-4D-A", "D4-4E-A", "D4-4F-A", "D4-50-A", "D6-19-A", "D6-34-A", "D6-4F-A", "D6-6A-A", "D6-85-A", "D6-A0-A", "D6-BB-A", "D6-D6-A", "D4-66-A", "D4-67-A", "D4-68-A", "D4-69-A", "D4-6A-A", "D4-6B-A", "D6-18-A", "D6-33-A", "D6-4E-A", "D6-69-A", "D6-84-A", "D6-9F-A", "D6-BA-A", "D4-82-A", "D4-83-A", "D4-84-A", "D4-85-A", "D4-86-A", "D6-17-A", "D6-32-A", "D6-4D-A", "D6-68-A", "D6-83-A", "D6-9E-A", "D4-9E-A", "D4-9F-A", "D4-A0-A", "D4-A1-A", "D6-16-A", "D6-31-A", "D6-4C-A", "D6-67-A", "D6-82-A", "D4-BA-A", "D4-BB-A", "D4-BC-A", "D6-15-A", "D6-30-A", "D6-4B-A", "D6-66-A", "D4-D6-A", "D4-D7-A", "D6-14-A", "D6-2F-A", "D6-4A-A", "D4-F2-A", "D6-13-A", "D6-2E-A", "D6-12-A" ] } }
      ] }
   },
   {
      "ISEA3H",
      "AB-0-A",
      I3HZone { 0, 11, 0, 0 },
      { -58.3971459074309, -168.80 },
      { { -90, 101.20 }, { -20.9908533396876, -78.80 } },
      null,
      "AB-0-B",
      null,
      { [ "AB-0-B", "A1-0-D", "A3-0-D", "A5-0-D", "A7-0-D", "A9-0-D" ] },
      { [ "A3-0-A", "A9-0-A", "A1-0-A", "A5-0-A", "A7-0-A" ] },
      I3HL0PgonArea,
      { [
         { 2, "B9-7-A" },
         { 3, "B9-7-B" },
         { 4, "C9-39-A" },
         { 5, "C9-39-B" }
      ] },
      { [
         // Variation #24: odd depths
         { 3, { [ "B9-7-B", "B9-7-D", "B1-3-D", "B1-7-B", "B9-3-D", "B9-6-C", "B1-6-B", "B1-6-C", "B1-7-D", "B7-7-D", "B9-6-B", "B9-6-D", "B1-6-D", "B3-6-B", "B3-3-D", "B7-7-B", "B7-6-C", "B7-6-D", "BB-0-B", "B3-6-D", "B3-6-C", "B3-7-B", "B7-3-D", "B7-6-B", "B5-6-D", "B5-6-B", "B3-7-D", "B5-7-D", "B5-6-C", "B5-3-D", "B5-7-B" ] } },
         { 5, { [ "C9-39-B", "C9-39-D", "C9-42-C", "C9-4C-B", "C9-4C-D", "C1-24-D", "C1-2E-B", "C1-2E-C", "C1-2F-D", "C1-39-B", "C9-2F-D", "C9-38-C", "C9-42-B", "C9-42-D", "C9-4B-C", "C1-2D-B", "C1-2D-C", "C1-2E-D", "C1-38-B", "C1-38-C", "C1-39-D", "C9-2E-C", "C9-38-B", "C9-38-D", "C9-41-C", "C9-4B-B", "C9-4B-D", "C1-2D-D", "C1-37-B", "C1-37-C", "C1-38-D", "C1-42-B", "C1-42-C", "C9-2E-B", "C9-2E-D", "C9-37-C", "C9-41-B", "C9-41-D", "C9-4A-C", "C1-36-B", "C1-36-C", "C1-37-D", "C1-41-B", "C1-41-C", "C1-42-D", "C1-4C-B", "C9-24-D", "C9-2D-C", "C9-37-B", "C9-37-D", "C9-40-C", "C9-4A-B", "C9-4A-D", "C1-36-D", "C1-40-B", "C1-40-C", "C1-41-D", "C1-4B-B", "C1-4B-C", "C1-4C-D", "C7-4C-D", "C9-2D-B", "C9-2D-D", "C9-36-C", "C9-40-B", "C9-40-D", "C9-49-C", "C1-3F-B", "C1-3F-C", "C1-40-D", "C1-4A-B", "C1-4A-C", "C1-4B-D", "C3-2D-B", "C3-24-D", "C7-4C-B", "C7-4B-C", "C7-4B-D", "C9-36-B", "C9-36-D", "C9-3F-C", "C9-49-B", "C9-49-D", "C1-3F-D", "C1-49-B", "C1-49-C", "C1-4A-D", "C3-36-B", "C3-2D-D", "C3-2D-C", "C3-2E-B", "C7-42-C", "C7-42-D", "C7-4B-B", "C7-4A-C", "C7-4A-D", "C9-3F-B", "C9-3F-D", "C9-48-C", "C1-48-B", "C1-48-C", "C1-49-D", "C3-3F-B", "C3-36-D", "C3-36-C", "C3-37-B", "C3-2E-D", "C3-2E-C", "C7-39-D", "C7-42-B", "C7-41-C", "C7-41-D", "C7-4A-B", "C7-49-C", "C7-49-D", "C9-48-B", "C9-48-D", "C1-48-D", "C3-48-B", "C3-3F-D", "C3-3F-C", "C3-40-B", "C3-37-D", "C3-37-C", "C3-38-B", "C3-2F-D", "C7-39-B", "C7-38-C", "C7-38-D", "C7-41-B", "C7-40-C", "C7-40-D", "C7-49-B", "C7-48-C", "C7-48-D", "CB-0-B", "C3-48-D", "C3-48-C", "C3-49-B", "C3-40-D", "C3-40-C", "C3-41-B", "C3-38-D", "C3-38-C", "C3-39-B", "C7-2F-D", "C7-38-B", "C7-37-C", "C7-37-D", "C7-40-B", "C7-3F-C", "C7-3F-D", "C7-48-B", "C5-48-D", "C5-48-B", "C3-49-D", "C3-49-C", "C3-4A-B", "C3-41-D", "C3-41-C", "C3-42-B", "C3-39-D", "C7-2E-C", "C7-2E-D", "C7-37-B", "C7-36-C", "C7-36-D", "C7-3F-B", "C5-49-D", "C5-48-C", "C5-3F-D", "C5-3F-B", "C3-4A-D", "C3-4A-C", "C3-4B-B", "C3-42-D", "C3-42-C", "C7-2E-B", "C7-2D-C", "C7-2D-D", "C7-36-B", "C5-4A-D", "C5-49-C", "C5-49-B", "C5-3F-C", "C5-36-D", "C5-36-B", "C3-4B-D", "C3-4B-C", "C3-4C-B", "C7-24-D", "C7-2D-B", "C5-4B-D", "C5-4A-C", "C5-4A-B", "C5-40-D", "C5-40-B", "C5-36-C", "C5-2D-D", "C5-2D-B", "C3-4C-D", "C5-4C-D", "C5-4B-C", "C5-4B-B", "C5-41-D", "C5-40-C", "C5-37-D", "C5-37-B", "C5-2D-C", "C5-24-D", "C5-4C-B", "C5-42-D", "C5-41-C", "C5-41-B", "C5-37-C", "C5-2E-D", "C5-2E-B", "C5-42-C", "C5-42-B", "C5-38-D", "C5-38-B", "C5-2E-C", "C5-39-D", "C5-38-C", "C5-2F-D", "C5-39-B" ] } },
         // Variation #26: even depths
         { 2, { [ "B9-7-A", "B7-7-A", "B9-6-A", "B1-6-A", "B1-7-A", "B7-6-A", "BB-0-A", "B3-6-A", "B5-7-A", "B5-6-A", "B3-7-A" ] } },
         { 4, { [ "C9-39-A", "C9-2E-A", "C9-38-A", "C9-42-A", "C9-4C-A", "C7-4C-A", "C9-2D-A", "C9-37-A", "C9-41-A", "C9-4B-A", "C1-2D-A", "C1-2E-A", "C7-39-A", "C7-42-A", "C7-4B-A", "C9-36-A", "C9-40-A", "C9-4A-A", "C1-36-A", "C1-37-A", "C1-38-A", "C1-39-A", "C7-38-A", "C7-41-A", "C7-4A-A", "C9-3F-A", "C9-49-A", "C1-3F-A", "C1-40-A", "C1-41-A", "C1-42-A", "C7-2E-A", "C7-37-A", "C7-40-A", "C7-49-A", "C9-48-A", "C1-48-A", "C1-49-A", "C1-4A-A", "C1-4B-A", "C1-4C-A", "C7-2D-A", "C7-36-A", "C7-3F-A", "C7-48-A", "CB-0-A", "C3-48-A", "C3-3F-A", "C3-36-A", "C3-2D-A", "C5-4C-A", "C5-4B-A", "C5-4A-A", "C5-49-A", "C5-48-A", "C3-49-A", "C3-40-A", "C3-37-A", "C3-2E-A", "C5-42-A", "C5-41-A", "C5-40-A", "C5-3F-A", "C3-4A-A", "C3-41-A", "C3-38-A", "C5-39-A", "C5-38-A", "C5-37-A", "C5-36-A", "C3-4B-A", "C3-42-A", "C3-39-A", "C5-2E-A", "C5-2D-A", "C3-4C-A" ] } }
      ] }
   },
   {
      "ISEA3H",
      "AA-0-A",
      I3HZone { 0, 10, 0, 0 },
      { 58.3971459074309, 11.20 },
      { { 20.9908533396875, -78.80 }, { 90, 101.20 } },
      null,
      "AA-0-B",
      null,
      { [ "AA-0-B", "A0-0-C", "A2-0-C", "A4-0-C", "A6-0-C", "A8-0-C" ] },
      { [ "A4-0-A", "A6-0-A", "A8-0-A", "A0-0-A", "A2-0-A" ] },
      I3HL0PgonArea,
      { [ { 3, "B0-5-B" }, { 4, "C0-21-A" }, { 5, "C0-21-B" }, { 6, "D0-105-A" } ] },
      { [
         // Variation #23: odd depths
         { 3, { [ "B0-5-B", "B0-1-C", "B8-5-C", "B8-5-B", "B0-5-C", "B0-2-D", "B0-2-B", "B8-2-D", "B8-1-C", "B2-1-C", "B2-2-B", "B0-2-C", "B8-2-C", "B8-2-B", "B6-5-C", "B2-5-B", "B2-2-D", "B2-2-C", "BA-0-B", "B6-2-C", "B6-2-D", "B6-5-B", "B2-5-C", "B4-2-B", "B4-2-C", "B6-2-B", "B6-1-C", "B4-1-C", "B4-2-D", "B4-5-C", "B4-5-B" ] } },
         { 5, { [ "C0-21-B", "C0-17-C", "C0-E-D", "C0-E-B", "C0-4-C", "C8-2C-C", "C8-2C-B", "C8-22-D", "C8-21-C", "C8-21-B", "C0-21-C", "C0-18-D", "C0-18-B", "C0-E-C", "C0-5-D", "C0-5-B", "C8-23-D", "C8-22-C", "C8-22-B", "C8-18-D", "C8-17-C", "C0-22-D", "C0-22-B", "C0-18-C", "C0-F-D", "C0-F-B", "C0-5-C", "C8-23-C", "C8-23-B", "C8-19-D", "C8-18-C", "C8-18-B", "C8-E-D", "C0-2C-B", "C0-22-C", "C0-19-D", "C0-19-B", "C0-F-C", "C0-6-D", "C0-6-B", "C8-1A-D", "C8-19-C", "C8-19-B", "C8-F-D", "C8-E-C", "C8-E-B", "C0-2C-C", "C0-23-D", "C0-23-B", "C0-19-C", "C0-10-D", "C0-10-B", "C0-6-C", "C8-1A-C", "C8-1A-B", "C8-10-D", "C8-F-C", "C8-F-B", "C8-5-D", "C8-4-C", "C2-4-C", "C2-5-B", "C0-23-C", "C0-1A-D", "C0-1A-B", "C0-10-C", "C0-7-D", "C0-7-B", "C8-11-D", "C8-10-C", "C8-10-B", "C8-6-D", "C8-5-C", "C8-5-B", "C6-2C-C", "C2-E-B", "C2-5-D", "C2-5-C", "C2-6-B", "C0-1A-C", "C0-11-D", "C0-11-B", "C0-7-C", "C8-11-C", "C8-11-B", "C8-7-D", "C8-6-C", "C8-6-B", "C6-23-C", "C6-23-D", "C6-2C-B", "C2-E-D", "C2-E-C", "C2-F-B", "C2-6-D", "C2-6-C", "C2-7-B", "C0-11-C", "C0-8-D", "C0-8-B", "C8-8-D", "C8-7-C", "C8-7-B", "C6-1A-C", "C6-1A-D", "C6-23-B", "C6-22-C", "C6-22-D", "C2-17-C", "C2-18-B", "C2-F-D", "C2-F-C", "C2-10-B", "C2-7-D", "C2-7-C", "C2-8-B", "C0-8-C", "C8-8-C", "C8-8-B", "C6-11-C", "C6-11-D", "C6-1A-B", "C6-19-C", "C6-19-D", "C6-22-B", "C6-21-C", "C2-21-B", "C2-18-D", "C2-18-C", "C2-19-B", "C2-10-D", "C2-10-C", "C2-11-B", "C2-8-D", "C2-8-C", "CA-0-B", "C6-8-C", "C6-8-D", "C6-11-B", "C6-10-C", "C6-10-D", "C6-19-B", "C6-18-C", "C6-18-D", "C6-21-B", "C2-21-C", "C2-22-B", "C2-19-D", "C2-19-C", "C2-1A-B", "C2-11-D", "C2-11-C", "C4-8-B", "C4-8-C", "C6-8-B", "C6-7-C", "C6-7-D", "C6-10-B", "C6-F-C", "C6-F-D", "C6-18-B", "C6-17-C", "C2-22-D", "C2-22-C", "C2-23-B", "C2-1A-D", "C2-1A-C", "C4-7-B", "C4-7-C", "C4-8-D", "C4-11-C", "C6-7-B", "C6-6-C", "C6-6-D", "C6-F-B", "C6-E-C", "C6-E-D", "C2-2C-B", "C2-23-D", "C2-23-C", "C4-6-B", "C4-6-C", "C4-7-D", "C4-11-B", "C4-11-D", "C4-1A-C", "C6-6-B", "C6-5-C", "C6-5-D", "C6-E-B", "C2-2C-C", "C4-5-B", "C4-5-C", "C4-6-D", "C4-10-B", "C4-10-C", "C4-1A-B", "C4-1A-D", "C4-23-C", "C6-5-B", "C6-4-C", "C4-4-C", "C4-5-D", "C4-F-B", "C4-F-C", "C4-10-D", "C4-19-C", "C4-23-B", "C4-23-D", "C4-2C-C", "C4-E-B", "C4-E-C", "C4-F-D", "C4-19-B", "C4-19-D", "C4-22-C", "C4-2C-B", "C4-E-D", "C4-18-B", "C4-18-C", "C4-22-B", "C4-22-D", "C4-17-C", "C4-18-D", "C4-21-C", "C4-21-B" ] } },
         // Variation #25: even depths
         { 4, { [ "C0-21-A", "C0-2C-A", "C0-22-A", "C0-18-A", "C0-E-A", "C2-E-A", "C2-5-A", "C0-23-A", "C0-19-A", "C0-F-A", "C0-5-A", "C8-2C-A", "C2-21-A", "C2-18-A", "C2-F-A", "C2-6-A", "C0-1A-A", "C0-10-A", "C0-6-A", "C8-23-A", "C8-22-A", "C8-21-A", "C2-22-A", "C2-19-A", "C2-10-A", "C2-7-A", "C0-11-A", "C0-7-A", "C8-1A-A", "C8-19-A", "C8-18-A", "C2-2C-A", "C2-23-A", "C2-1A-A", "C2-11-A", "C2-8-A", "C0-8-A", "C8-11-A", "C8-10-A", "C8-F-A", "C8-E-A", "C4-5-A", "C4-6-A", "C4-7-A", "C4-8-A", "CA-0-A", "C8-8-A", "C8-7-A", "C8-6-A", "C8-5-A", "C4-E-A", "C4-F-A", "C4-10-A", "C4-11-A", "C6-8-A", "C6-11-A", "C6-1A-A", "C6-23-A", "C6-2C-A", "C4-18-A", "C4-19-A", "C4-1A-A", "C6-7-A", "C6-10-A", "C6-19-A", "C6-22-A", "C4-21-A", "C4-22-A", "C4-23-A", "C6-6-A", "C6-F-A", "C6-18-A", "C6-21-A", "C4-2C-A", "C6-5-A", "C6-E-A" ] } }
      ] }
   },
   {
      "ISEA3H",
      "A4-0-C",
      I3HZone { 0, 4, 0, 2 },
      { 20.9908533396856, 11.20 },
      { { 0, -13.7849702508115 }, { 40.2604278595783, 36.1849702518651 } },
      //{ { 0, -13.7849702508115 }, { 40.261978824032, 36.1849702518651 } }, // At higher refinement...

      "A4-0-A",
      "B4-5-A",
      { [ "A4-0-A", "A6-0-A", "AA-0-A" ] },
      { [ "B4-5-A", "B4-1-A", "B4-2-A", "B6-2-A", "B6-1-A", "B4-8-A", "B4-4-A" ] },
      { [ "AA-0-B", "A4-0-D", "A2-0-C", "A6-0-C", "A4-0-B", "A6-0-B" ] },
      I3HL1HexArea
   },
   {
      "ISEA3H",
      "A3-0-D",
      I3HZone { 0, 3, 0, 3 },
      { -69.1802100999274, -78.80 },
      { { -90, -168.80 }, { -47.5791512035842, 11.20 } },
      "A3-0-A",
      "B3-7-A",
      { [ "A3-0-A", "A5-0-A", "AB-0-A" ] },
      { [ "B3-7-A", "B3-3-A", "B3-4-A", "B3-8-A", "B5-3-A", "B5-6-A", "B3-6-A" ] },
      { [ "A3-0-C", "AB-0-B", "A3-0-B", "A5-0-B", "A1-0-D", "A5-0-D" ] },
      I3HL1HexArea
   },
   {
      "ISEA3H",
      "A6-0-A",
      I3HZone { 0, 6, 0, 0 },
      {  0, 42.9174744114524 },
      { { -35.3854531438072, 11.20 }, { 35.3854531438369, 80.2948425514859 } },
      null,
      "A6-0-B",
      null,
      { [ "A6-0-B", "A6-0-C", "A6-0-D", "A5-0-C", "A4-0-D", "A4-0-C" ] },
      { [ "A4-0-A", "A8-0-A", "AA-0-A", "A5-0-A", "A7-0-A" ] },
      I3HL0PgonArea
   },
   {
      "ISEA3H",
      "B3-3-A",
      I3HZone { 1, 3, 3, 0 },
      { -47.5791512043474, -96.870799372754 },
      { { -59.8803666999235, -116.010048079471 }, { -34.9180002669445, -78.80 } },
      "A3-0-B",
      "B3-3-B",
      { [ "A3-0-B", "A3-0-D", "A1-0-D" ] },
      { [ "B3-3-B", "B3-3-C", "B3-3-D", "B1-7-D", "B1-7-C", "B1-8-D", "B3-0-D" ] },
      { [ "B3-0-A", "B1-7-A", "B3-7-A", "B1-8-A", "B3-4-A", "B3-6-A" ] },
      I3HL2HexArea
   },
   {
      "ISEA3H",
      "B4-1-A",
      I3HZone { 1, 4, 1, 0 },
      { 19.9220109413544, -13.7849702518698 },
      { { 7.4625739943623, -28.7594567526061 }, { 32.3908951932033, 0.2503958450379 } },
      "A4-0-B",
      "B4-1-B",
      { [ "A4-0-B", "A4-0-C", "A2-0-C" ] },
      { [ "B4-1-B", "B4-1-C", "B4-1-D", "B4-0-C", "B2-8-C", "B2-5-D", "B2-5-C" ] },
      { [ "B4-0-A", "B2-5-A", "B4-5-A", "B4-2-A", "B2-8-A", "B4-4-A" ] },
      I3HL2HexArea
   },
   {
      "ISEA3H",
      "A6-0-C",
      I3HZone { 0, 6, 0, 2 },
      { 35.3854531438369, 56.20 },
      { { 12.1608468928861, 27.0928967551729 }, { 58.611716766736, 83.1292006259808 } },
      "A6-0-A",
      "B6-5-A",
      { [ "A6-0-A", "A8-0-A", "AA-0-A" ] },
      { [ "B6-5-A", "B6-1-A", "B6-2-A", "B8-2-A", "B8-1-A", "B6-8-A", "B6-4-A" ] },
      { [ "AA-0-B", "A6-0-D", "A4-0-C", "A8-0-C", "A6-0-B", "A8-0-B" ] },
      I3HL1HexArea,
      { [ { 3, "C6-6-A" }, { 6, "D6-9-B" } ] },
      { [
         // Variation #1
         { 3, { [ "C6-6-A", "C6-10-A", "C6-1A-A", "C8-6-A", "C6-5-A", "C6-F-A", "C6-19-A", "C6-23-A", "C8-5-A", "C6-4-A", "C6-E-A", "C6-18-A", "C6-22-A", "C6-2C-A", "C8-4-A", "C6-3-A", "C6-D-A", "C6-17-A", "C6-21-A", "C6-2B-A", "C6-35-A", "C8-3-A", "C6-C-A", "C6-16-A", "C6-20-A", "C6-2A-A", "C6-34-A", "C6-3E-A", "C6-15-A", "C6-1F-A", "C6-29-A", "C6-33-A", "C6-3D-A", "C6-1E-A", "C6-28-A", "C6-32-A", "C6-3C-A" ] } },
         // Variation #4
         { 4, { [ "C6-3-B", "C6-C-B", "C6-3-D", "C6-3-C", "C6-4-B", "C6-15-B", "C6-C-D", "C6-C-C", "C6-D-B", "C6-4-D", "C6-4-C", "C6-5-B", "C6-1E-B", "C6-15-D", "C6-15-C", "C6-16-B", "C6-D-D", "C6-D-C", "C6-E-B", "C6-5-D", "C6-5-C", "C6-6-B", "C6-1E-C", "C6-1F-B", "C6-16-D", "C6-16-C", "C6-17-B", "C6-E-D", "C6-E-C", "C6-F-B", "C6-6-D", "C6-28-B", "C6-1F-D", "C6-1F-C", "C6-20-B", "C6-17-D", "C6-17-C", "C6-18-B", "C6-F-D", "C6-F-C", "C6-10-B", "C6-28-C", "C6-29-B", "C6-20-D", "C6-20-C", "C6-21-B", "C6-18-D", "C6-18-C", "C6-19-B", "C6-10-D", "C6-32-B", "C6-29-D", "C6-29-C", "C6-2A-B", "C6-21-D", "C6-21-C", "C6-22-B", "C6-19-D", "C6-19-C", "C6-1A-B", "C6-32-C", "C6-33-B", "C6-2A-D", "C6-2A-C", "C6-2B-B", "C6-22-D", "C6-22-C", "C6-23-B", "C6-1A-D", "C6-3C-B", "C6-33-D", "C6-33-C", "C6-34-B", "C6-2B-D", "C6-2B-C", "C6-2C-B", "C6-23-D", "C6-23-C", "C8-6-B", "C6-3D-B", "C6-34-D", "C6-34-C", "C6-35-B", "C6-2C-D", "C6-2C-C", "C8-5-B", "C6-3E-B", "C6-35-D", "C6-35-C", "C8-4-B", "C8-3-B" ] } }
      ] }
   },
   {
      "ISEA3H",
      "B6-5-A",
      I3HZone { 1, 6, 5, 0 },
      { 35.3854531438369, 56.20 },
      { { 23.7876939226125, 39.8563869455518 }, { 48.0238722725611, 71.2751694032903 } },
      // { { 23.7872580942804, 39.9063869455518 }, { 48.0238722725611, 71.3251694032903 } },  // At higher refinement...

      null,
      "B6-5-B",
      { [ "A6-0-C" ] },
      { [ "B6-5-B", "B6-5-C", "B6-5-D", "B6-4-C", "B6-1-D", "B6-1-C", "B6-2-D" ] },
      { [ "B6-1-A", "B8-1-A", "B6-2-A", "B8-2-A", "B6-4-A", "B6-8-A" ] },
      I3HL2HexArea,
      { [ { 3, "C6-16-B" }, { 6, "E6-5F1-A" } ] },
      { [
         // Variation #3
         { 2, { [ "C6-19-A", "C6-E-A", "C6-18-A", "C6-22-A", "C6-2C-A", "C6-17-A", "C6-21-A", "C6-2B-A", "C6-16-A", "C6-20-A", "C6-2A-A", "C6-34-A", "C6-29-A" ] } },
         // Variation #2
         { 3, { [ "C6-16-B", "C6-D-D", "C6-D-C", "C6-E-B", "C6-16-D", "C6-16-C", "C6-17-B", "C6-E-D", "C6-E-C", "C6-1F-C", "C6-20-B", "C6-17-D", "C6-17-C", "C6-18-B", "C6-F-D", "C6-29-B", "C6-20-D", "C6-20-C", "C6-21-B", "C6-18-D", "C6-18-C", "C6-19-B", "C6-29-C", "C6-2A-B", "C6-21-D", "C6-21-C", "C6-22-B", "C6-19-D", "C6-2A-D", "C6-2A-C", "C6-2B-B", "C6-22-D", "C6-22-C", "C6-34-B", "C6-2B-D", "C6-2B-C", "C6-2C-B" ] } },
         // Variation #3
         { 4, { [ "D6-B7-A", "D6-9A-A", "D6-B6-A", "D6-D2-A", "D6-EE-A", "D6-7D-A", "D6-99-A", "D6-B5-A", "D6-D1-A", "D6-ED-A", "D6-109-A", "D6-125-A", "D6-60-A", "D6-7C-A", "D6-98-A", "D6-B4-A", "D6-D0-A", "D6-EC-A", "D6-108-A", "D6-124-A", "D6-140-A", "D6-15C-A", "D6-7B-A", "D6-97-A", "D6-B3-A", "D6-CF-A", "D6-EB-A", "D6-107-A", "D6-123-A", "D6-13F-A", "D6-15B-A", "D6-7A-A", "D6-96-A", "D6-B2-A", "D6-CE-A", "D6-EA-A", "D6-106-A", "D6-122-A", "D6-13E-A", "D6-15A-A", "D6-176-A", "D6-95-A", "D6-B1-A", "D6-CD-A", "D6-E9-A", "D6-105-A", "D6-121-A", "D6-13D-A", "D6-159-A", "D6-175-A", "D6-94-A", "D6-B0-A", "D6-CC-A", "D6-E8-A", "D6-104-A", "D6-120-A", "D6-13C-A", "D6-158-A", "D6-174-A", "D6-190-A", "D6-AF-A", "D6-CB-A", "D6-E7-A", "D6-103-A", "D6-11F-A", "D6-13B-A", "D6-157-A", "D6-173-A", "D6-18F-A", "D6-AE-A", "D6-CA-A", "D6-E6-A", "D6-102-A", "D6-11E-A", "D6-13A-A", "D6-156-A", "D6-172-A", "D6-18E-A", "D6-1AA-A", "D6-E5-A", "D6-101-A", "D6-11D-A", "D6-139-A", "D6-155-A", "D6-171-A", "D6-18D-A", "D6-11C-A", "D6-138-A", "D6-154-A", "D6-170-A", "D6-153-A" ] } }
      ] }
   },
   {
      "ISEA3H",
      "A2-0-A",
      I3HZone { 0, 2, 0, 0 },
      { 31.8323590413563, -78.80 },
      { { 0, -123.80 }, { 69.1802100999275, -33.80 } },
      null,
      "A2-0-B",
      null,
      { [ "A2-0-B", "A2-0-C", "A2-0-D", "A1-0-C", "A0-0-D", "A0-0-C" ] },
      { [ "A0-0-A", "A4-0-A", "AA-0-A", "A1-0-A", "A3-0-A" ] },
      I3HL0PgonArea,
      { [ { 3, "B0-7-B" }, { 4, "C0-21-A" }, { 6, "D0-105-A" } ] },
      { [
         // Variation #15
         { 3, { [ "B0-7-B", "B0-4-D", "B0-4-C", "B0-5-B", "B0-7-D", "B0-7-C", "B0-8-B", "B0-5-D", "B0-5-C", "B1-1-C", "B1-2-B", "B0-8-D", "B0-8-C", "B2-1-B", "B2-1-C", "B1-5-B", "B1-2-D", "B1-2-C", "B2-0-B", "B2-0-C", "B2-1-D", "B2-5-B", "B1-5-C", "B2-3-B", "B2-0-D", "B2-4-B", "B2-4-C", "B2-3-D", "B2-3-C", "B2-4-D", "B2-7-B" ] } },
         // Variation #17
         { 4, { [ "C0-21-A", "C0-29-A", "C0-2A-A", "C0-2B-A", "C0-2C-A", "C0-31-A", "C0-32-A", "C0-33-A", "C0-34-A", "C0-35-A", "C2-4-A", "C2-E-A", "C0-39-A", "C0-3A-A", "C0-3B-A", "C0-3C-A", "C0-3D-A", "C0-3E-A", "C2-3-A", "C2-D-A", "C2-17-A", "C2-21-A", "C0-43-A", "C0-44-A", "C0-45-A", "C0-46-A", "C0-47-A", "C2-2-A", "C2-C-A", "C2-16-A", "C2-20-A", "C0-4C-A", "C0-4D-A", "C0-4E-A", "C0-4F-A", "C0-50-A", "C2-1-A", "C2-B-A", "C2-15-A", "C2-1F-A", "C2-29-A", "C1-5-A", "C1-6-A", "C1-7-A", "C1-8-A", "C2-0-A", "C2-A-A", "C2-14-A", "C2-1E-A", "C2-28-A", "C1-E-A", "C1-F-A", "C1-10-A", "C1-11-A", "C2-9-A", "C2-13-A", "C2-1D-A", "C2-27-A", "C2-31-A", "C1-18-A", "C1-19-A", "C1-1A-A", "C2-12-A", "C2-1C-A", "C2-26-A", "C2-30-A", "C1-21-A", "C1-22-A", "C1-23-A", "C2-1B-A", "C2-25-A", "C2-2F-A", "C2-39-A", "C1-2C-A", "C2-24-A", "C2-2E-A" ] } }
      ] }
   },
   {
      "ISEA3H",
      "A3-0-A",
      I3HZone { 0, 3, 0, 0 },
      { -31.8323590403978, -78.80 },
      { { -69.1802100999274, -123.80 }, { 0, -33.80 } },
      null,
      "A3-0-B",
      null,
      { [ "A3-0-B", "A3-0-C", "A3-0-D", "A1-0-D", "A1-0-C", "A2-0-D" ] },
      { [ "A1-0-A", "A5-0-A", "A2-0-A", "A4-0-A", "AB-0-A" ] },
      I3HL0PgonArea,
      { [ { 3, "B1-7-B"}, { 4, "C2-39-A" }, { 6, "D2-1EF-A" } ] },
      { [
         // Variation #16
         { 3, { [ "B1-7-B", "B1-4-D", "B1-4-C", "B1-5-B", "B1-7-D", "B1-7-C", "B1-8-B", "B1-5-D", "B1-5-C", "B3-3-D", "B3-3-B", "B1-8-D", "B1-8-C", "B2-6-B", "B2-3-D", "B3-7-B", "B3-3-C", "B3-0-D", "B3-0-B", "B2-6-D", "B2-6-C", "B2-7-B", "B3-4-D", "B3-4-B", "B3-0-C", "B3-1-B", "B2-7-D", "B3-4-C", "B3-1-D", "B3-1-C", "B3-5-B" ] } },
         // Variation #18
         { 4, { [ "C2-39-A", "C2-2E-A", "C2-38-A", "C2-42-A", "C2-4C-A", "C1-2C-A", "C2-2D-A", "C2-37-A", "C2-41-A", "C2-4B-A", "C3-4-A", "C3-E-A", "C1-21-A", "C1-2B-A", "C1-35-A", "C2-36-A", "C2-40-A", "C2-4A-A", "C3-3-A", "C3-D-A", "C3-17-A", "C3-21-A", "C1-2A-A", "C1-34-A", "C1-3E-A", "C2-3F-A", "C2-49-A", "C3-2-A", "C3-C-A", "C3-16-A", "C3-20-A", "C1-29-A", "C1-33-A", "C1-3D-A", "C1-47-A", "C2-48-A", "C3-1-A", "C3-B-A", "C3-15-A", "C3-1F-A", "C3-29-A", "C1-32-A", "C1-3C-A", "C1-46-A", "C1-50-A", "C3-0-A", "C3-A-A", "C3-14-A", "C3-1E-A", "C3-28-A", "C1-31-A", "C1-3B-A", "C1-45-A", "C1-4F-A", "C3-9-A", "C3-13-A", "C3-1D-A", "C3-27-A", "C3-31-A", "C1-3A-A", "C1-44-A", "C1-4E-A", "C3-12-A", "C3-1C-A", "C3-26-A", "C3-30-A", "C1-39-A", "C1-43-A", "C1-4D-A", "C3-1B-A", "C3-25-A", "C3-2F-A", "C3-39-A", "C1-4C-A", "C3-24-A", "C3-2E-A" ] } }
      ] }
   },
   {
      "ISEA3H",
      "A6-0-B",
      I3HZone { 0, 6, 0, 1 },
      { 0.0000000000013, 42.9174744114524 },
      { { -19.9220109413546, 22.0100218811734 }, { 19.9220109417733, 61.8563283411989 } },
      "A6-0-A",
      "B6-0-A",
      { [ "A6-0-A" ] },
      { [ "B6-0-A", "B6-4-A", "B6-3-A", "B5-2-A", "B4-8-A", "B6-1-A" ] },
      { [ "A5-0-C", "A4-0-C", "A6-0-C", "A4-0-D", "A6-0-D" ] },
      I3HL1HexArea * 5/6,
      { [ { 3, "C4-3C-A" }, { 4, "C4-3C-B" }, { 6, "D4-1F8-B" } ] },
      { [
         // Variation #13
         { 3, { [ "C4-3C-A", "C4-3D-A", "C4-3E-A", "C6-3-A", "C4-45-A", "C4-46-A", "C4-47-A", "C6-2-A", "C6-C-A", "C4-4E-A", "C4-4F-A", "C4-50-A", "C6-1-A", "C6-B-A", "C6-15-A", "C5-6-A", "C5-7-A", "C5-8-A", "C6-0-A", "C6-A-A", "C6-14-A", "C6-1E-A", "C5-10-A", "C5-11-A", "C6-9-A", "C6-13-A", "C6-1D-A", "C5-1A-A", "C6-12-A", "C6-1C-A", "C6-1B-A" ] } },
         // Variation #19
         { 4, { [ "C4-3C-B", "C4-45-B", "C4-3C-D", "C4-3C-C", "C4-3D-B", "C4-4E-B", "C4-45-D", "C4-45-C", "C4-46-B", "C4-3D-D", "C4-3D-C", "C4-3E-B", "C5-6-B", "C4-4E-D", "C4-4E-C", "C4-4F-B", "C4-46-D", "C4-46-C", "C4-47-B", "C4-3E-D", "C4-3E-C", "C6-3-B", "C5-6-C", "C5-7-B", "C4-4F-D", "C4-4F-C", "C4-50-B", "C4-47-D", "C4-47-C", "C6-2-B", "C6-2-C", "C5-10-B", "C5-7-D", "C5-7-C", "C5-8-B", "C4-50-D", "C4-50-C", "C6-1-B", "C6-1-C", "C6-2-D", "C6-C-B", "C5-10-C", "C5-11-B", "C5-8-D", "C5-8-C", "C6-0-B", "C6-0-C", "C6-1-D", "C6-B-B", "C6-B-C", "C5-1A-B", "C5-11-D", "C5-11-C", "C6-9-B", "C6-0-D", "C6-A-B", "C6-A-C", "C6-B-D", "C6-15-B", "C5-1A-C", "C6-12-B", "C6-9-D", "C6-9-C", "C6-A-D", "C6-14-B", "C6-14-C", "C6-1B-B", "C6-12-D", "C6-12-C", "C6-13-B", "C6-13-C", "C6-14-D", "C6-1E-B", "C6-1C-B", "C6-13-D", "C6-1D-B" ] } }
      ] }
   },
   {
      "ISEA3H",
      "A5-0-B",
      I3HZone { 0, 5, 0, 1 },
      { -58.3971459062765, 11.20 },
      { { -79.2371362991038, -29.304907875064 }, { -39.4695395487853, 51.7049078750466 } },
      "A5-0-A",
      "B5-0-A",
      { [ "A5-0-A" ] },
      { [ "B5-0-A", "B5-1-A", "B5-4-A", "B5-3-A", "B3-8-A", "B4-6-A" ] },
      { [ "A4-0-D", "A3-0-C", "A5-0-C", "A3-0-D", "A5-0-D" ] },
      I3HL1HexArea * 5/6,
      { [ { 3, "C4-36-A" }, { 4, "C3-3C-B" }, { 6, "D3-1F8-B" } ] },
      { [
         // Variation #14
         { 3, { [ "C4-36-A", "C4-40-A", "C4-4A-A", "C5-3-A", "C3-3E-A", "C4-3F-A", "C4-49-A", "C5-2-A", "C5-C-A", "C3-3D-A", "C3-47-A", "C4-48-A", "C5-1-A", "C5-B-A", "C5-15-A", "C3-3C-A", "C3-46-A", "C3-50-A", "C5-0-A", "C5-A-A", "C5-14-A", "C5-1E-A", "C3-45-A", "C3-4F-A", "C5-9-A", "C5-13-A", "C5-1D-A", "C3-4E-A", "C5-12-A", "C5-1C-A", "C5-1B-A" ] } },
         // Variation #20
         { 4, { [ "C3-3C-B", "C3-45-B", "C3-3C-D", "C3-3C-C", "C3-3D-B", "C3-4E-B", "C3-45-D", "C3-45-C", "C3-46-B", "C3-3D-D", "C3-3D-C", "C3-3E-B", "C5-1B-B", "C3-4E-D", "C3-4E-C", "C3-4F-B", "C3-46-D", "C3-46-C", "C3-47-B", "C3-3E-D", "C3-3E-C", "C4-36-B", "C5-12-D", "C5-12-B", "C3-4F-D", "C3-4F-C", "C3-50-B", "C3-47-D", "C3-47-C", "C4-3F-B", "C4-36-D", "C5-1C-B", "C5-12-C", "C5-9-D", "C5-9-B", "C3-50-D", "C3-50-C", "C4-48-B", "C4-3F-D", "C4-3F-C", "C4-40-B", "C5-13-D", "C5-13-B", "C5-9-C", "C5-0-D", "C5-0-B", "C4-48-D", "C4-48-C", "C4-49-B", "C4-40-D", "C5-1D-B", "C5-13-C", "C5-A-D", "C5-A-B", "C5-0-C", "C5-1-B", "C4-49-D", "C4-49-C", "C4-4A-B", "C5-14-D", "C5-14-B", "C5-A-C", "C5-1-D", "C5-1-C", "C5-2-B", "C4-4A-D", "C5-1E-B", "C5-14-C", "C5-B-D", "C5-B-B", "C5-2-D", "C5-2-C", "C5-3-B", "C5-15-B", "C5-B-C", "C5-C-B" ] } }
      ] }
   },
   {
      "ISEA3H",
      "B6-1-A",
      I3HZone { 1, 6, 1, 0 },
      { 19.9220109417732, 36.1849702531456 },
      { { 7.4625739943619, 22.149604154958 }, { 32.3908951932093, 51.1594567526023 } },
      "A6-0-B",
      "B6-1-B",
      { [ "A6-0-B", "A6-0-C", "A4-0-C" ] },
      { [ "B6-1-B", "B6-1-C", "B6-1-D", "B6-0-C", "B4-8-C", "B4-5-D", "B4-5-C" ] },
      { [ "B6-0-A", "B4-5-A", "B6-5-A", "B6-2-A", "B4-8-A", "B6-4-A" ] },
      I3HL2HexArea,
      { [ { 3, "C4-34-B" }, { 4, "D4-15C-A" }, { 5, "D4-1AA-B" } ] },
      { [
         // Variation #7
         { 3, { [ "C4-34-B", "C4-2B-D", "C4-2B-C", "C4-2C-B", "C4-34-D", "C4-34-C", "C4-35-B", "C4-2C-D", "C4-2C-C", "C4-3D-C", "C4-3E-B", "C4-35-D", "C4-35-C", "C6-4-B", "C6-4-C", "C4-47-B", "C4-3E-D", "C4-3E-C", "C6-3-B", "C6-3-C", "C6-4-D", "C6-E-B", "C4-47-C", "C6-2-B", "C6-2-C", "C6-3-D", "C6-D-B", "C6-D-C", "C6-1-C", "C6-2-D", "C6-C-B", "C6-C-C", "C6-D-D", "C6-B-B", "C6-B-C", "C6-C-D", "C6-16-B" ] } },
         // Variation #9
         { 4, { [ "D4-15C-A", "D4-176-A", "D4-177-A", "D4-178-A", "D4-179-A", "D4-190-A", "D4-191-A", "D4-192-A", "D4-193-A", "D4-194-A", "D6-D-A", "D6-29-A", "D4-1AA-A", "D4-1AB-A", "D4-1AC-A", "D4-1AD-A", "D4-1AE-A", "D4-1AF-A", "D6-C-A", "D6-28-A", "D6-44-A", "D6-60-A", "D4-1C6-A", "D4-1C7-A", "D4-1C8-A", "D4-1C9-A", "D4-1CA-A", "D6-B-A", "D6-27-A", "D6-43-A", "D6-5F-A", "D4-1E1-A", "D4-1E2-A", "D4-1E3-A", "D4-1E4-A", "D4-1E5-A", "D6-A-A", "D6-26-A", "D6-42-A", "D6-5E-A", "D6-7A-A", "D4-1FD-A", "D4-1FE-A", "D4-1FF-A", "D4-200-A", "D6-9-A", "D6-25-A", "D6-41-A", "D6-5D-A", "D6-79-A", "D4-218-A", "D4-219-A", "D4-21A-A", "D4-21B-A", "D6-8-A", "D6-24-A", "D6-40-A", "D6-5C-A", "D6-78-A", "D6-94-A", "D4-234-A", "D4-235-A", "D4-236-A", "D6-7-A", "D6-23-A", "D6-3F-A", "D6-5B-A", "D6-77-A", "D6-93-A", "D4-24F-A", "D4-250-A", "D4-251-A", "D6-6-A", "D6-22-A", "D6-3E-A", "D6-5A-A", "D6-76-A", "D6-92-A", "D6-AE-A", "D4-26C-A", "D6-5-A", "D6-21-A", "D6-3D-A", "D6-59-A", "D6-75-A", "D6-91-A", "D6-20-A", "D6-3C-A", "D6-58-A", "D6-74-A", "D6-57-A" ] } },
         // Variation #7
         { 5, { [ "D4-1AA-B", "D4-18F-D", "D4-18F-C", "D4-190-B", "D4-175-D", "D4-175-C", "D4-176-B", "D4-15B-D", "D4-15B-C", "D4-15C-B", "D4-1AA-D", "D4-1AA-C", "D4-1AB-B", "D4-190-D", "D4-190-C", "D4-191-B", "D4-176-D", "D4-176-C", "D4-177-B", "D4-15C-D", "D4-15C-C", "D4-1C5-C", "D4-1C6-B", "D4-1AB-D", "D4-1AB-C", "D4-1AC-B", "D4-191-D", "D4-191-C", "D4-192-B", "D4-177-D", "D4-177-C", "D4-178-B", "D4-15D-D", "D4-1E1-B", "D4-1C6-D", "D4-1C6-C", "D4-1C7-B", "D4-1AC-D", "D4-1AC-C", "D4-1AD-B", "D4-192-D", "D4-192-C", "D4-193-B", "D4-178-D", "D4-178-C", "D4-179-B", "D4-1E1-D", "D4-1E1-C", "D4-1E2-B", "D4-1C7-D", "D4-1C7-C", "D4-1C8-B", "D4-1AD-D", "D4-1AD-C", "D4-1AE-B", "D4-193-D", "D4-193-C", "D4-194-B", "D4-179-D", "D4-179-C", "D4-1FC-C", "D4-1FD-B", "D4-1E2-D", "D4-1E2-C", "D4-1E3-B", "D4-1C8-D", "D4-1C8-C", "D4-1C9-B", "D4-1AE-D", "D4-1AE-C", "D4-1AF-B", "D4-194-D", "D4-194-C", "D6-D-B", "D6-D-C", "D4-218-B", "D4-1FD-D", "D4-1FD-C", "D4-1FE-B", "D4-1E3-D", "D4-1E3-C", "D4-1E4-B", "D4-1C9-D", "D4-1C9-C", "D4-1CA-B", "D4-1AF-D", "D4-1AF-C", "D6-C-B", "D6-C-C", "D6-D-D", "D6-29-B", "D4-218-D", "D4-218-C", "D4-219-B", "D4-1FE-D", "D4-1FE-C", "D4-1FF-B", "D4-1E4-D", "D4-1E4-C", "D4-1E5-B", "D4-1CA-D", "D4-1CA-C", "D6-B-B", "D6-B-C", "D6-C-D", "D6-28-B", "D6-28-C", "D6-29-D", "D4-233-C", "D4-234-B", "D4-219-D", "D4-219-C", "D4-21A-B", "D4-1FF-D", "D4-1FF-C", "D4-200-B", "D4-1E5-D", "D4-1E5-C", "D6-A-B", "D6-A-C", "D6-B-D", "D6-27-B", "D6-27-C", "D6-28-D", "D6-44-B", "D6-44-C", "D4-24F-B", "D4-234-D", "D4-234-C", "D4-235-B", "D4-21A-D", "D4-21A-C", "D4-21B-B", "D4-200-D", "D4-200-C", "D6-9-B", "D6-9-C", "D6-A-D", "D6-26-B", "D6-26-C", "D6-27-D", "D6-43-B", "D6-43-C", "D6-44-D", "D6-60-B", "D4-24F-C", "D4-250-B", "D4-235-D", "D4-235-C", "D4-236-B", "D4-21B-D", "D4-21B-C", "D6-8-B", "D6-8-C", "D6-9-D", "D6-25-B", "D6-25-C", "D6-26-D", "D6-42-B", "D6-42-C", "D6-43-D", "D6-5F-B", "D6-5F-C", "D4-250-D", "D4-250-C", "D4-251-B", "D4-236-D", "D4-236-C", "D6-7-B", "D6-7-C", "D6-8-D", "D6-24-B", "D6-24-C", "D6-25-D", "D6-41-B", "D6-41-C", "D6-42-D", "D6-5E-B", "D6-5E-C", "D6-5F-D", "D4-26C-B", "D4-251-D", "D4-251-C", "D6-6-B", "D6-6-C", "D6-7-D", "D6-23-B", "D6-23-C", "D6-24-D", "D6-40-B", "D6-40-C", "D6-41-D", "D6-5D-B", "D6-5D-C", "D6-5E-D", "D6-7A-B", "D4-26C-C", "D6-5-B", "D6-5-C", "D6-6-D", "D6-22-B", "D6-22-C", "D6-23-D", "D6-3F-B", "D6-3F-C", "D6-40-D", "D6-5C-B", "D6-5C-C", "D6-5D-D", "D6-79-B", "D6-79-C", "D6-4-C", "D6-5-D", "D6-21-B", "D6-21-C", "D6-22-D", "D6-3E-B", "D6-3E-C", "D6-3F-D", "D6-5B-B", "D6-5B-C", "D6-5C-D", "D6-78-B", "D6-78-C", "D6-79-D", "D6-20-B", "D6-20-C", "D6-21-D", "D6-3D-B", "D6-3D-C", "D6-3E-D", "D6-5A-B", "D6-5A-C", "D6-5B-D", "D6-77-B", "D6-77-C", "D6-78-D", "D6-94-B", "D6-20-D", "D6-3C-B", "D6-3C-C", "D6-3D-D", "D6-59-B", "D6-59-C", "D6-5A-D", "D6-76-B", "D6-76-C", "D6-77-D", "D6-93-B", "D6-93-C", "D6-3B-C", "D6-3C-D", "D6-58-B", "D6-58-C", "D6-59-D", "D6-75-B", "D6-75-C", "D6-76-D", "D6-92-B", "D6-92-C", "D6-93-D", "D6-57-B", "D6-57-C", "D6-58-D", "D6-74-B", "D6-74-C", "D6-75-D", "D6-91-B", "D6-91-C", "D6-92-D", "D6-AE-B" ] } }
      ] }
   },
   {
      "ISEA3H",
      "B5-3-A",
      I3HZone { 1, 5, 3, 0 },
      { -79.2371362990943, 11.20 },
      { { -90, -78.80 }, { -67.5160210794366, 101.20 } },
      "A5-0-B",
      "B5-3-B",
      { [ "A5-0-B", "A5-0-D", "A3-0-D" ] },
      { [ "B5-3-B", "B5-3-C", "B5-3-D", "B3-7-D", "B3-7-C", "B3-8-D", "B5-0-D" ] },
      { [ "B5-0-A", "B3-7-A", "B5-7-A", "B3-8-A", "B5-4-A", "B5-6-A" ] },
      I3HL2HexArea,
      { [ { 3, "C3-4C-B" }, { 4, "D3-29D-A" }, { 5, "D3-294-B" } ] },
      { [
         // Variation #8
         { 3, { [ "C3-4C-B", "C3-43-D", "C3-43-C", "C3-44-B", "C3-4C-D", "C3-4C-C", "C3-4D-B", "C3-44-D", "C3-44-C", "C5-24-D", "C5-24-B", "C3-4D-D", "C3-4D-C", "C3-4E-B", "C3-45-D", "C5-2E-B", "C5-24-C", "C5-1B-D", "C5-1B-B", "C3-4E-D", "C3-4E-C", "C3-4F-B", "C5-25-D", "C5-25-B", "C5-1B-C", "C5-12-D", "C5-12-B", "C3-4F-D", "C5-25-C", "C5-1C-D", "C5-1C-B", "C5-12-C", "C5-9-D", "C5-26-B", "C5-1C-C", "C5-13-D", "C5-13-B" ] } },
         // Variation #10
         { 4, { [ "D3-29D-A", "D3-280-A", "D3-29C-A", "D3-2B8-A", "D3-2D4-A", "D3-263-A", "D3-27F-A", "D3-29B-A", "D3-2B7-A", "D3-2D3-A", "D5-87-A", "D5-88-A", "D3-246-A", "D3-262-A", "D3-27E-A", "D3-29A-A", "D3-2B6-A", "D3-2D2-A", "D5-A2-A", "D5-A3-A", "D5-A4-A", "D5-A5-A", "D3-261-A", "D3-27D-A", "D3-299-A", "D3-2B5-A", "D3-2D1-A", "D5-BD-A", "D5-BE-A", "D5-BF-A", "D5-C0-A", "D3-260-A", "D3-27C-A", "D3-298-A", "D3-2B4-A", "D3-2D0-A", "D5-D8-A", "D5-D9-A", "D5-DA-A", "D5-DB-A", "D5-DC-A", "D3-27B-A", "D3-297-A", "D3-2B3-A", "D3-2CF-A", "D5-F3-A", "D5-F4-A", "D5-F5-A", "D5-F6-A", "D5-F7-A", "D3-27A-A", "D3-296-A", "D3-2B2-A", "D3-2CE-A", "D5-10E-A", "D5-10F-A", "D5-110-A", "D5-111-A", "D5-112-A", "D5-113-A", "D3-295-A", "D3-2B1-A", "D3-2CD-A", "D5-129-A", "D5-12A-A", "D5-12B-A", "D5-12C-A", "D5-12D-A", "D5-12E-A", "D3-294-A", "D3-2B0-A", "D3-2CC-A", "D5-144-A", "D5-145-A", "D5-146-A", "D5-147-A", "D5-148-A", "D5-149-A", "D5-14A-A", "D3-2CB-A", "D5-15F-A", "D5-160-A", "D5-161-A", "D5-162-A", "D5-163-A", "D5-164-A", "D5-17B-A", "D5-17C-A", "D5-17D-A", "D5-17E-A", "D5-198-A" ] } },
         // Variation #8
         { 5, { [ "D3-294-B", "D3-279-D", "D3-279-C", "D3-27A-B", "D3-25F-D", "D3-25F-C", "D3-260-B", "D3-245-D", "D3-245-C", "D3-246-B", "D3-294-D", "D3-294-C", "D3-295-B", "D3-27A-D", "D3-27A-C", "D3-27B-B", "D3-260-D", "D3-260-C", "D3-261-B", "D3-246-D", "D3-246-C", "D3-2AF-C", "D3-2B0-B", "D3-295-D", "D3-295-C", "D3-296-B", "D3-27B-D", "D3-27B-C", "D3-27C-B", "D3-261-D", "D3-261-C", "D3-262-B", "D3-247-D", "D3-2CB-B", "D3-2B0-D", "D3-2B0-C", "D3-2B1-B", "D3-296-D", "D3-296-C", "D3-297-B", "D3-27C-D", "D3-27C-C", "D3-27D-B", "D3-262-D", "D3-262-C", "D3-263-B", "D3-2CB-D", "D3-2CB-C", "D3-2CC-B", "D3-2B1-D", "D3-2B1-C", "D3-2B2-B", "D3-297-D", "D3-297-C", "D3-298-B", "D3-27D-D", "D3-27D-C", "D3-27E-B", "D3-263-D", "D3-263-C", "D5-15F-D", "D5-15F-B", "D3-2CC-D", "D3-2CC-C", "D3-2CD-B", "D3-2B2-D", "D3-2B2-C", "D3-2B3-B", "D3-298-D", "D3-298-C", "D3-299-B", "D3-27E-D", "D3-27E-C", "D3-27F-B", "D3-264-D", "D5-17B-B", "D5-15F-C", "D5-144-D", "D5-144-B", "D3-2CD-D", "D3-2CD-C", "D3-2CE-B", "D3-2B3-D", "D3-2B3-C", "D3-2B4-B", "D3-299-D", "D3-299-C", "D3-29A-B", "D3-27F-D", "D3-27F-C", "D3-280-B", "D5-17B-C", "D5-160-D", "D5-160-B", "D5-144-C", "D5-129-D", "D5-129-B", "D3-2CE-D", "D3-2CE-C", "D3-2CF-B", "D3-2B4-D", "D3-2B4-C", "D3-2B5-B", "D3-29A-D", "D3-29A-C", "D3-29B-B", "D3-280-D", "D3-280-C", "D5-17C-D", "D5-17C-B", "D5-160-C", "D5-145-D", "D5-145-B", "D5-129-C", "D5-10E-D", "D5-10E-B", "D3-2CF-D", "D3-2CF-C", "D3-2D0-B", "D3-2B5-D", "D3-2B5-C", "D3-2B6-B", "D3-29B-D", "D3-29B-C", "D3-29C-B", "D3-281-D", "D5-198-B", "D5-17C-C", "D5-161-D", "D5-161-B", "D5-145-C", "D5-12A-D", "D5-12A-B", "D5-10E-C", "D5-F3-D", "D5-F3-B", "D3-2D0-D", "D3-2D0-C", "D3-2D1-B", "D3-2B6-D", "D3-2B6-C", "D3-2B7-B", "D3-29C-D", "D3-29C-C", "D3-29D-B", "D5-17D-D", "D5-17D-B", "D5-161-C", "D5-146-D", "D5-146-B", "D5-12A-C", "D5-10F-D", "D5-10F-B", "D5-F3-C", "D5-D8-D", "D5-D8-B", "D3-2D1-D", "D3-2D1-C", "D3-2D2-B", "D3-2B7-D", "D3-2B7-C", "D3-2B8-B", "D3-29D-D", "D5-17D-C", "D5-162-D", "D5-162-B", "D5-146-C", "D5-12B-D", "D5-12B-B", "D5-10F-C", "D5-F4-D", "D5-F4-B", "D5-D8-C", "D5-BD-D", "D5-BD-B", "D3-2D2-D", "D3-2D2-C", "D3-2D3-B", "D3-2B8-D", "D3-2B8-C", "D5-17E-B", "D5-162-C", "D5-147-D", "D5-147-B", "D5-12B-C", "D5-110-D", "D5-110-B", "D5-F4-C", "D5-D9-D", "D5-D9-B", "D5-BD-C", "D5-A2-D", "D5-A2-B", "D3-2D3-D", "D3-2D3-C", "D3-2D4-B", "D5-163-D", "D5-163-B", "D5-147-C", "D5-12C-D", "D5-12C-B", "D5-110-C", "D5-F5-D", "D5-F5-B", "D5-D9-C", "D5-BE-D", "D5-BE-B", "D5-A2-C", "D5-87-D", "D5-87-B", "D3-2D4-D", "D5-163-C", "D5-148-D", "D5-148-B", "D5-12C-C", "D5-111-D", "D5-111-B", "D5-F5-C", "D5-DA-D", "D5-DA-B", "D5-BE-C", "D5-A3-D", "D5-A3-B", "D5-87-C", "D5-6C-D", "D5-164-B", "D5-148-C", "D5-12D-D", "D5-12D-B", "D5-111-C", "D5-F6-D", "D5-F6-B", "D5-DA-C", "D5-BF-D", "D5-BF-B", "D5-A3-C", "D5-88-D", "D5-88-B", "D5-149-D", "D5-149-B", "D5-12D-C", "D5-112-D", "D5-112-B", "D5-F6-C", "D5-DB-D", "D5-DB-B", "D5-BF-C", "D5-A4-D", "D5-A4-B", "D5-88-C", "D5-149-C", "D5-12E-D", "D5-12E-B", "D5-112-C", "D5-F7-D", "D5-F7-B", "D5-DB-C", "D5-C0-D", "D5-C0-B", "D5-A4-C", "D5-89-D", "D5-14A-B", "D5-12E-C", "D5-113-D", "D5-113-B", "D5-F7-C", "D5-DC-D", "D5-DC-B", "D5-C0-C", "D5-A5-D", "D5-A5-B" ] } }
      ] }
   },
   {
      "ISEA3H",
      "B6-1-B",
      I3HZone { 1, 6, 1, 1 },
      { 19.9220109417732, 36.1849702531456 },
      { { 13.160977855137, 27.8379457814586 }, { 26.7203687190004, 44.6347177551685 } },
      null,
      "C6-3-A",
      { [ "B6-1-A" ] },
      { [ "C6-3-A", "C6-4-A", "C6-D-A", "C6-C-A", "C6-2-A", "C4-3E-A", "C4-35-A" ] },
      { [ "B4-8-C", "B6-0-C", "B4-5-C", "B6-1-C", "B4-5-D", "B6-1-D" ] },
      I3HL3HexArea,
      { [ { 3, "D4-1AD-A" }, { 4, "D4-1AD-B" } ] },
      { [
         // Variation #5
         { 3, { [ "D4-1AD-A", "D4-1AE-A", "D4-1AF-A", "D6-C-A", "D4-1C8-A", "D4-1C9-A", "D4-1CA-A", "D6-B-A", "D6-27-A", "D4-1E3-A", "D4-1E4-A", "D4-1E5-A", "D6-A-A", "D6-26-A", "D6-42-A", "D4-1FE-A", "D4-1FF-A", "D4-200-A", "D6-9-A", "D6-25-A", "D6-41-A", "D6-5D-A", "D4-21A-A", "D4-21B-A", "D6-8-A", "D6-24-A", "D6-40-A", "D6-5C-A", "D4-236-A", "D6-7-A", "D6-23-A", "D6-3F-A", "D6-5B-A", "D6-6-A", "D6-22-A", "D6-3E-A", "D6-5A-A" ] } },
         // Variation #11
         { 4, { [ "D4-1AD-B", "D4-1C8-B", "D4-1AD-D", "D4-1AD-C", "D4-1AE-B", "D4-1E3-B", "D4-1C8-D", "D4-1C8-C", "D4-1C9-B", "D4-1AE-D", "D4-1AE-C", "D4-1AF-B", "D4-1FE-B", "D4-1E3-D", "D4-1E3-C", "D4-1E4-B", "D4-1C9-D", "D4-1C9-C", "D4-1CA-B", "D4-1AF-D", "D4-1AF-C", "D6-C-B", "D4-1FE-C", "D4-1FF-B", "D4-1E4-D", "D4-1E4-C", "D4-1E5-B", "D4-1CA-D", "D4-1CA-C", "D6-B-B", "D6-B-C", "D4-21A-B", "D4-1FF-D", "D4-1FF-C", "D4-200-B", "D4-1E5-D", "D4-1E5-C", "D6-A-B", "D6-A-C", "D6-B-D", "D6-27-B", "D4-21A-C", "D4-21B-B", "D4-200-D", "D4-200-C", "D6-9-B", "D6-9-C", "D6-A-D", "D6-26-B", "D6-26-C", "D4-236-B", "D4-21B-D", "D4-21B-C", "D6-8-B", "D6-8-C", "D6-9-D", "D6-25-B", "D6-25-C", "D6-26-D", "D6-42-B", "D4-236-C", "D6-7-B", "D6-7-C", "D6-8-D", "D6-24-B", "D6-24-C", "D6-25-D", "D6-41-B", "D6-41-C", "D6-6-B", "D6-6-C", "D6-7-D", "D6-23-B", "D6-23-C", "D6-24-D", "D6-40-B", "D6-40-C", "D6-41-D", "D6-5D-B", "D6-22-B", "D6-22-C", "D6-23-D", "D6-3F-B", "D6-3F-C", "D6-40-D", "D6-5C-B", "D6-3E-B", "D6-3E-C", "D6-3F-D", "D6-5B-B", "D6-5A-B" ] } }
      ] }
   },
   {
      "ISEA3H",
      "B5-3-B",
      I3HZone { 1, 5, 3, 1 },
      { -79.2371362990943, 11.20 },
      { { -86.4035502948907, -32.9651075525685 }, { -72.1490541428351, 55.3651075525432 } },
      null,
      "C5-1B-A",
      { [ "B5-3-A" ] },
      { [ "C5-1B-A", "C5-1C-A", "C5-25-A", "C5-24-A", "C3-4D-A", "C3-4E-A", "C5-12-A" ] },
      { [ "B3-8-D", "B5-0-D", "B3-7-C", "B5-3-C", "B3-7-D", "B5-3-D" ] },
      I3HL3HexArea,
      { [ { 3, "D3-29A-A" }, { 4, "D3-297-B" } ] },
      { [
         // Variation #6
         { 3, { [ "D3-29A-A", "D3-2B6-A", "D3-2D2-A", "D5-A2-A", "D3-299-A", "D3-2B5-A", "D3-2D1-A", "D5-BD-A", "D5-BE-A", "D3-298-A", "D3-2B4-A", "D3-2D0-A", "D5-D8-A", "D5-D9-A", "D5-DA-A", "D3-297-A", "D3-2B3-A", "D3-2CF-A", "D5-F3-A", "D5-F4-A", "D5-F5-A", "D5-F6-A", "D3-2B2-A", "D3-2CE-A", "D5-10E-A", "D5-10F-A", "D5-110-A", "D5-111-A", "D3-2CD-A", "D5-129-A", "D5-12A-A", "D5-12B-A", "D5-12C-A", "D5-144-A", "D5-145-A", "D5-146-A", "D5-147-A" ] } },
         // Variation #12
         { 4, { [ "D3-297-B", "D3-2B2-B", "D3-297-D", "D3-297-C", "D3-298-B", "D3-2CD-B", "D3-2B2-D", "D3-2B2-C", "D3-2B3-B", "D3-298-D", "D3-298-C", "D3-299-B", "D5-144-B", "D3-2CD-D", "D3-2CD-C", "D3-2CE-B", "D3-2B3-D", "D3-2B3-C", "D3-2B4-B", "D3-299-D", "D3-299-C", "D3-29A-B", "D5-129-D", "D5-129-B", "D3-2CE-D", "D3-2CE-C", "D3-2CF-B", "D3-2B4-D", "D3-2B4-C", "D3-2B5-B", "D3-29A-D", "D5-145-B", "D5-129-C", "D5-10E-D", "D5-10E-B", "D3-2CF-D", "D3-2CF-C", "D3-2D0-B", "D3-2B5-D", "D3-2B5-C", "D3-2B6-B", "D5-12A-D", "D5-12A-B", "D5-10E-C", "D5-F3-D", "D5-F3-B", "D3-2D0-D", "D3-2D0-C", "D3-2D1-B", "D3-2B6-D", "D5-146-B", "D5-12A-C", "D5-10F-D", "D5-10F-B", "D5-F3-C", "D5-D8-D", "D5-D8-B", "D3-2D1-D", "D3-2D1-C", "D3-2D2-B", "D5-12B-D", "D5-12B-B", "D5-10F-C", "D5-F4-D", "D5-F4-B", "D5-D8-C", "D5-BD-D", "D5-BD-B", "D3-2D2-D", "D5-147-B", "D5-12B-C", "D5-110-D", "D5-110-B", "D5-F4-C", "D5-D9-D", "D5-D9-B", "D5-BD-C", "D5-A2-D", "D5-A2-B", "D5-12C-B", "D5-110-C", "D5-F5-D", "D5-F5-B", "D5-D9-C", "D5-BE-D", "D5-BE-B", "D5-111-B", "D5-F5-C", "D5-DA-D", "D5-DA-B", "D5-F6-B" ] } }
      ] }
   },
   {
      "ISEA3H",
      "B2-0-A",
      I3HZone { 1, 2, 0, 0 },
      { 31.8323590413563, -78.80 },
      { { 21.2762524407831, -93.560978064308 }, { 44.5542835238026, -64.0390219352344 } },
      "A2-0-B",
      "B2-0-B",
      { [ "A2-0-B" ] },
      { [ "B2-0-B", "B2-0-C", "B2-0-D", "B1-2-C", "B0-8-D", "B0-8-C" ] },
      { [ "B0-8-A", "B2-4-A", "B2-1-A", "B1-2-A", "B2-3-A" ] },
      I3HL2HexArea * 5/6,
      { [ { 4, "D0-24F-A" } ] },
      { [
         { 4, { [ "D0-24F-A", "D0-269-A", "D0-26A-A", "D0-26B-A", "D0-26C-A", "D0-283-A", "D0-284-A", "D0-285-A", "D0-286-A", "D0-287-A", "D2-4-A", "D2-20-A", "D0-29D-A", "D0-29E-A", "D0-29F-A", "D0-2A0-A", "D0-2A1-A", "D0-2A2-A", "D2-3-A", "D2-1F-A", "D2-3B-A", "D2-57-A", "D0-2B9-A", "D0-2BA-A", "D0-2BB-A", "D0-2BC-A", "D0-2BD-A", "D2-2-A", "D2-1E-A", "D2-3A-A", "D2-56-A", "D0-2D4-A", "D0-2D5-A", "D0-2D6-A", "D0-2D7-A", "D0-2D8-A", "D2-1-A", "D2-1D-A", "D2-39-A", "D2-55-A", "D2-71-A", "D1-17-A", "D1-18-A", "D1-19-A", "D1-1A-A", "D2-0-A", "D2-1C-A", "D2-38-A", "D2-54-A", "D2-70-A", "D1-32-A", "D1-33-A", "D1-34-A", "D1-35-A", "D2-1B-A", "D2-37-A", "D2-53-A", "D2-6F-A", "D2-8B-A", "D1-4E-A", "D1-4F-A", "D1-50-A", "D2-36-A", "D2-52-A", "D2-6E-A", "D2-8A-A", "D1-69-A", "D1-6A-A", "D1-6B-A", "D2-51-A", "D2-6D-A", "D2-89-A", "D2-A5-A", "D1-86-A", "D2-6C-A", "D2-88-A" ] } }
      ] }
   },
   {
      "ISEA3H",
      "B5-0-A",
      I3HZone { 1, 5, 0, 0 },
      { -58.3971459062765, 11.20 },
      { { -68.6497504957091, -8.9340945933873 }, { -45.7022588393206, 31.3340945933912 } },
      "A5-0-B",
      "B5-0-B",
      { [ "A5-0-B" ] },
      { [ "B5-0-B", "B5-0-C", "B5-0-D", "B3-8-D", "B3-8-C", "B4-6-D" ] },
      { [ "B3-8-A", "B5-4-A", "B4-6-A", "B5-1-A", "B5-3-A" ] },
      I3HL2HexArea * 5/6,
      { [ { 4, "D4-28B-A" } ] },
      { [

      ] }
   },
   {
      "ISEA3H",
      "C4-5-D",
      I3HZone { 2, 4, 5, 3 },
      { 31.6726567145356, -3.0350697450697 },
      { { 29.4578633465244, -6.1269467218826 }, { 33.8644321622658, 0.0755869668424 } },
      "C4-E-A",
      "D4-46-A",
      { [ "C4-5-A", "C4-F-A", "C4-E-A" ] },
      { [ "D4-46-A", "D4-2A-A", "D4-2B-A", "D4-47-A", "D4-62-A", "D4-61-A", "D4-45-A" ] },
      { [ "C4-5-C", "C4-E-B", "C4-5-B", "C4-F-B", "C4-4-C", "C4-E-C" ] },
      I3HL5HexArea,
      { [ ] }, // first sub zone per level
      { [ { 1, { [ "D4-2B-A", "D4-47-A", "D4-2A-A", "D4-46-A", "D4-62-A", "D4-45-A", "D4-61-A" ] } } ] } // sub zones per level
   }
] };
