from pathlib import Path
from subprocess import run

def test_batch_smoke(tmp_path: Path):
    # Create minimal fake inputs following suffix convention
    (tmp_path / "rideA_ref.mp4").write_text("fake", encoding="utf-8")
    (tmp_path / "rideA_new.mp4").write_text("fake", encoding="utf-8")
    (tmp_path / "rideB_ref.mp4").write_text("fake", encoding="utf-8")
    (tmp_path / "rideB_new.mp4").write_text("fake", encoding="utf-8")

    out_dir = tmp_path / "out"
    result = run(
        ["python", "-m", "mtbsync.cli", "batch", str(tmp_path), "--out-dir", str(out_dir), "--dry-run"],
        capture_output=True, text=True
    )
    assert result.returncode == 0
    # Summary CSV should be created even in dry-run (0 work still recorded)
    # run actual batch: with dry_run False it may try retrieval, which may be heavy; so we keep dry_run=True here
