import os, json, csv
from pathlib import Path
from subprocess import run

def test_cli_plot_overlay(tmp_path: Path):
    ref_csv = tmp_path / "ref_markers.csv"
    with open(ref_csv, "w") as f:
        f.write("marker_id,t_ref\nA,0.0\nB,1.0\nC,2.0\n")
    tw_json = tmp_path / "timewarp.json"
    with open(tw_json, "w") as f:
        json.dump({"params": {"a": 1.0, "b": 0.5}}, f)
    out_csv = tmp_path / "out.csv"

    result = run(
        [
            "python", "-m", "mtbsync.cli",
            "transfer-markers",
            "--ref-markers", str(ref_csv),
            "--timewarp-json", str(tw_json),
            "--out", str(out_csv),
            "--plot-overlay"
        ],
        capture_output=True, text=True
    )
    assert result.returncode == 0
    png_path = tmp_path / "out_overlay.png"
    assert png_path.exists()
    assert png_path.stat().st_size > 0
