import csv, json, tempfile
from pathlib import Path
from subprocess import run

def test_cli_transfer_markers(tmp_path: Path):
    ref_csv = tmp_path / "ref_markers.csv"
    with open(ref_csv, "w") as f:
        f.write("marker_id,t_ref,label\nA,0.0,start\nB,1.0,mid\nC,2.0,end\n")
    tw_json = tmp_path / "timewarp.json"
    with open(tw_json, "w") as f:
        json.dump({"params": {"a": 1.001, "b": 0.5}}, f)
    out_csv = tmp_path / "out.csv"

    result = run(
        ["python", "-m", "mtbsync.cli", "transfer-markers", "--ref-markers", str(ref_csv), "--timewarp-json", str(tw_json), "--out", str(out_csv)],
        capture_output=True, text=True
    )
    assert result.returncode == 0
    assert out_csv.exists()
    rows = list(csv.DictReader(open(out_csv)))
    assert len(rows) == 3
    for r in rows:
        t_ref, t_new = float(r["t_ref"]), float(r["t_new_est"])
        assert abs(t_ref - (1.001 * t_new + 0.5)) < 1e-6
