import csv, json, socket, threading, time
from pathlib import Path
from urllib.request import urlopen

from mtbsync.dashboard import run_dashboard

def _free_port():
    s = socket.socket()
    s.bind(("127.0.0.1", 0))
    addr, port = s.getsockname()
    s.close()
    return port

def test_dashboard_json_endpoints(tmp_path: Path):
    # Create minimal artefacts
    (tmp_path / "timewarp.json").write_text(json.dumps({"ok": True, "params": {"a": 1.0, "b": 0.5}}), encoding="utf-8")
    (tmp_path / "new_markers.csv").write_text("marker_id,t_ref,t_new_est\nA,0.0,0.5\nB,1.0,1.5\n", encoding="utf-8")
    (tmp_path / "batch_summary.csv").write_text("ref_video,new_video,out_dir,ok\nr,n,.,True\n", encoding="utf-8")

    port = _free_port()
    thr = threading.Thread(target=run_dashboard, kwargs={"root": tmp_path, "host": "127.0.0.1", "port": port, "open_browser": False}, daemon=True)
    thr.start()
    time.sleep(0.6)

    # Hit endpoints
    def _json(url):
        with urlopen(url) as r:
            return json.loads(r.read().decode("utf-8"))

    base = f"http://127.0.0.1:{port}"
    tw = _json(base + "/api/timewarp")
    ba = _json(base + "/api/batch")
    mk = _json(base + "/api/markers")
    fl = _json(base + "/api/files")

    assert tw.get("ok") is True
    assert isinstance(ba.get("rows"), list)
    assert isinstance(mk.get("rows"), list)
    assert isinstance(fl.get("items"), list)
