import csv, json, tempfile
from pathlib import Path
from mtbsync.match.marker_transfer import transfer_markers

def test_marker_transfer_basic(tmp_path: Path):
    # Create fake ref markers
    ref_csv = tmp_path / "ref_markers.csv"
    with open(ref_csv, "w", newline="") as f:
        f.write("marker_id,t_ref\nA,0.0\nB,1.0\nC,2.0\n")

    # Create fake timewarp.json
    warp_data = {"params": {"a": 1.001, "b": 0.5}}
    tw_json = tmp_path / "timewarp.json"
    with open(tw_json, "w") as f:
        json.dump(warp_data, f)

    out_csv = tmp_path / "new_markers.csv"
    transfer_markers(ref_csv, tw_json, out_csv)

    rows = list(csv.DictReader(open(out_csv)))
    assert len(rows) == 3
    # Verify mapping roughly consistent
    for r in rows:
        t_ref = float(r["t_ref"])
        t_new = float(r["t_new_est"])
        assert abs(t_ref - (1.001 * t_new + 0.5)) < 1e-6
