import csv, json
from pathlib import Path
from mtbsync.match.marker_transfer import transfer_markers, plot_marker_overlay

def test_plot_marker_overlay(tmp_path: Path):
    ref_csv = tmp_path / "ref.csv"
    with open(ref_csv, "w") as f:
        f.write("marker_id,t_ref\nA,0.0\nB,1.0\nC,2.0\n")
    tw_json = tmp_path / "timewarp.json"
    json.dump({"params": {"a": 1.0, "b": 0.5}}, open(tw_json, "w"))
    new_csv = tmp_path / "new.csv"
    transfer_markers(ref_csv, tw_json, new_csv)
    out_png = tmp_path / "overlay.png"
    plot_marker_overlay(ref_csv, new_csv, out_png)
    assert out_png.exists()
    assert out_png.stat().st_size > 0
