import json
from pathlib import Path
from subprocess import run

def test_viewer_headless_overlay(tmp_path: Path):
    # Prepare minimal inputs
    ref_csv = tmp_path / "ref_markers.csv"
    ref_csv.write_text("marker_id,t_ref\nA,0.0\nB,1.0\nC,2.0\n", encoding="utf-8")
    tw_json = tmp_path / "timewarp.json"
    tw_json.write_text(json.dumps({"params": {"a": 1.0, "b": 0.5}}), encoding="utf-8")
    out_png = tmp_path / "overlay.png"

    # Call CLI headless mode (no Tk required)
    result = run([
        "python", "-m", "mtbsync.cli", "viewer",
        "--ref-markers", str(ref_csv),
        "--timewarp-json", str(tw_json),
        "--out-png", str(out_png),
        "--headless"
    ], capture_output=True, text=True)
    assert result.returncode == 0, result.stderr
    assert out_png.exists()
    assert out_png.stat().st_size > 0
