# mypy-boto3-groundstation

Type annotations for
[boto3.GroundStation 1.10.45](https://boto3.amazonaws.com/v1/documentation/api/1.10.45/reference/services/groundstation.html#GroundStation) service
compatible with [mypy](https://github.com/python/mypy), [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/) and other tools.

More information can be found [here](https://vemel.github.io/mypy_boto3/).

- [mypy-boto3-groundstation](#mypy-boto3-groundstation)
  - [How to use](#how-to-use)
    - [Type checking](#type-checking)
    - [Code auto-complete](#code-auto-complete)
  - [How it works](#how-it-works)

## How to use

### Type checking

Make sure you have [mypy](https://github.com/python/mypy) installed and activated in your IDE.

Install `boto3-stubs` for `GroundStation` service.

```bash
python -m pip install boto3-stubs[mypy-boto3-groundstation]
```

Use `boto3` with `mypy_boto3` in your project and enjoy type checking and auto-complete.

```python
import boto3

from mypy_boto3 import groundstation
# alternative import if you do not want to install mypy_boto3 package
# import mypy_boto3_groundstation as groundstation

# Use this client as usual, now mypy can check if your code is valid.
# Check if your IDE supports function overloads,
# you probably do not need explicit type annotations
# client = boto3.client("groundstation")
client: groundstation.GroundStationClient = boto3.client("groundstation")

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: groundstation.GroundStationClient = session.client("groundstation")


# Paginators need type annotation on creation
list_configs_paginator: groundstation.ListConfigsPaginator = client.get_paginator("list_configs")
list_contacts_paginator: groundstation.ListContactsPaginator = client.get_paginator("list_contacts")
list_dataflow_endpoint_groups_paginator: groundstation.ListDataflowEndpointGroupsPaginator = client.get_paginator("list_dataflow_endpoint_groups")
list_ground_stations_paginator: groundstation.ListGroundStationsPaginator = client.get_paginator("list_ground_stations")
list_mission_profiles_paginator: groundstation.ListMissionProfilesPaginator = client.get_paginator("list_mission_profiles")
list_satellites_paginator: groundstation.ListSatellitesPaginator = client.get_paginator("list_satellites")
```

## How it works

Fully automated [builder](https://github.com/vemel/mypy_boto3) carefully generates
type annotations for each service, patiently waiting for `boto3` updates. It delivers
a drop-in type annotations for you and makes sure that:

- All available `boto3` services are covered.
- Each public class and method of every `boto3` service gets valid type annotations
  extracted from the documentation (blame `botocore` docs if types are incorrect).
- Type annotations include up-to-date documentation.
- Link to documentation is provided for every method.
- Code is processed by [black](https://github.com/psf/black) for readability.