import json
EXAMPLES = json.loads(r'''[{"data":{"phi":{"nelect":48,"phi":4.73414095269429,"scf_vbm":-1.6519,"scf_cbm":-1.6472,"Ef":-1.97822464,"scf_gap":0,"avg_max":2.7559163126942896,"scf_dir":false},"atoms":{"lattice_mat":[[3.353617811446221,0,0],[0,6.273423021773385,0],[0,0,33.313518]],"coords":[[0,0.6004615456553349,0.2002745956304112],[0.5,0.9651745521229684,0.205389889617873],[0,0.8600702878546368,0.2642586539633663],[0.5,0.3508476059345406,0.2471701152668883],[0.5,0.7055702442093444,0.1414059027438078],[0,0.2147957642231673,0.1584938427776558]],"elements":["Mo","Mo","Te","Te","Te","Te"],"abc":[3.35362,6.27342,33.31352],"angles":[90,90,90],"cartesian":false,"props":["","","","","",""]},"jid":"JVASP-677"},"path":"apse/db/nist_jarvis/2024.3.13/db_entry"},{"data":{"&CONTROL":{"calculation":"scf","title":"","verbosity":"low","restart_mode":"from_scratch","wf_collect":true,"tstress":true,"tprnfor":true,"outdir":"{{ JOB_WORK_DIR }}/outdir","wfcdir":"{{ JOB_WORK_DIR }}/outdir","prefix":"__prefix__","pseudo_dir":"{{ JOB_WORK_DIR }}/pseudo"},"&SYSTEM":{"ibrav":0,"nat":2,"ntyp":2,"ecutwfc":40,"ecutrho":200,"occupations":"smearing","degauss":0.005,"starting_magnetization":[0.01,0.02],"Hubbard_occ":[[1,1,0],[1,2,0.02]]},"&ELECTRONS":{"diagonalization":"david","diago_david_ndim":4,"diago_full_acc":true,"mixing_beta":0.3,"startingwfc":"atomic+random"},"&IONS":null,"&CELL":null,"ATOMIC_SPECIES":{"values":[{"X":"Cs","Mass_X":132.90543,"PseudoPot_X":"Cs.upf"},{"X":"Cl","Mass_X":35.4527,"PseudoPot_X":"Cl.upf"}]},"CELL_PARAMETERS":{"card_option":"angstrom","values":{"v1":[4.324582724,0,2.496799],"v2":[1.441527575,4.077255694,2.496799],"v3":[0,0,4.993598]}},"K_POINTS":{"card_option":"automatic","values":{"nk1":2,"nk2":2,"nk3":2,"sk1":0,"sk2":0,"sk3":0}}},"path":"apse/file/applications/espresso/7.2/pw.x"},{"data":{"min_vacuum_size":0,"in_unit_planes":true,"reorient_lattice":true,"symmetrize":false},"path":"apse/materials/builders/slab/pymatgen/parameters"},{"data":{"xDataArray":[0,1,2],"yDataSeries":[[0,0.5,1],[0,2.5,5]]},"path":"core/abstract/2d_data"},{"data":{"xAxis":{"label":"kpoint index"},"xDataArray":[0,1,2],"yAxis":{"label":"eigenvalues","units":"eV"},"yDataSeries":[[0,0.5,1],[0,2.5,5]]},"path":"core/abstract/2d_plot"},{"data":{"dimensions":[2,2,2],"shifts":[0,0,0]},"path":"core/abstract/3d_grid"},{"data":[0,5.5,0],"path":"core/abstract/coordinate_3d"},{"data":[[1,0,0],[0,1,0],[0,0,1]],"path":"core/abstract/matrix_3x3"},{"data":[1,0],"path":"core/abstract/vector_2d"},{"data":[1,0,0],"path":"core/abstract/vector_3d"},{"data":[true,false,false],"path":"core/abstract/vector_boolean_3d"},{"data":[[0,0.5,1],[0,2.5,5]],"path":"core/primitive/1d_data_series"},{"data":[true,false,false],"path":"core/primitive/array_of_3_booleans"},{"data":[1,0,0],"path":"core/primitive/array_of_3_numbers"},{"data":[{"id":1},{"id":2}],"path":"core/primitive/array_of_ids"},{"data":{"label":"energy","units":"eV"},"path":"core/primitive/axis"},{"data":{"value":0.1},"path":"core/primitive/scalar"},{"data":{"value":"example string"},"path":"core/primitive/string"},{"data":{"name":"pressure","scalar":[{"value":"1.2"},{"value":"3.3"}],"units":"kbar"},"path":"core/reference/experiment/condition"},{"data":{"latitude":24.3423424,"longitude":43.234232},"path":"core/reference/experiment/location"},{"data":{"authors":[{"affiliation":"Exabyte Inc.","first":"John","last":"Doe"}],"conditions":[{"name":"pressure","scalar":[{"value":"1.2"},{"value":"3.3"}],"units":"kbar"}],"method":"DFT","references":[{"authors":[{"affiliation":"Exabyte Inc.","first":"John","last":"Doe"}],"doi":"10.1000/xyz123"}],"timestamp":141182979832,"title":"Experiment 1"},"path":"core/reference/experiment"},{"data":{"affiliation":"Exabyte Inc.","first":"John","last":"Doe"},"path":"core/reference/literature/name"},{"data":{"end":"2","start":"1"},"path":"core/reference/literature/pages"},{"data":{"authors":[{"affiliation":"Exabyte Inc.","first":"John","last":"Doe"}],"doi":"10.1000/xyz123"},"path":"core/reference/literature"},{"data":{"_id":"nDAavgjrT5ezwFgod","owner":{"_id":"HtxACY2wX4b2hS8Rv","cls":"Account","slug":"exabyte"},"title":"My Calculation"},"path":"core/reference/modeling/exabyte"},{"data":{"_id":"nDAavgjrT5ezwFgod","owner":{"_id":"HtxACY2wX4b2hS8Rv","cls":"Account","slug":"exabyte"},"title":"My Calculation"},"path":"core/reference/modeling"},{"data":{"_id":"nDAavgjrT5ezwFgod","owner":{"_id":"HtxACY2wX4b2hS8Rv","cls":"Account","slug":"exabyte"},"title":"My Calculation"},"path":"core/reference"},{"data":[{"id":1,"value":[0,0,0]},{"id":2,"value":[0.25,0.25,0.25]}],"path":"core/reusable/atomic_vectors"},{"data":{"kpointConduction":[0,0,0],"kpointValence":[0,0,0],"name":"band_gap","type":"direct","units":"Ry","value":0.0947},"path":"core/reusable/band_gap"},{"data":{"shape":"box","min_coordinate":[0,0,0],"max_coordinate":[0.5,0.5,0.5]},"path":"core/reusable/coordinate_conditions/box"},{"data":{"shape":"cylinder","radius":0.25,"min_z":0,"max_z":1},"path":"core/reusable/coordinate_conditions/cylinder"},{"data":{"shape":"plane","plane_normal":[0,0,1],"plane_point_coordinate":[0,0,0.5]},"path":"core/reusable/coordinate_conditions/plane"},{"data":{"shape":"sphere","radius":0.25},"path":"core/reusable/coordinate_conditions/sphere"},{"data":{"shape":"triangular_prism","position_on_surface_1":[0.25,0.25],"position_on_surface_2":[0.75,0.25],"position_on_surface_3":[0.5,0.75],"min_z":0,"max_z":1},"path":"core/reusable/coordinate_conditions/triangular_prism"},{"data":{"name":"zero_point_energy","units":"eV","value":-0.0634},"path":"core/reusable/energy"},{"data":{"pathname":"/path/to/file/","basename":"some_file.png","filetype":"image"},"path":"core/reusable/file_metadata"},{"data":{"CONTAINER":"production-20160630-cluster-001","NAME":"/cluster-001-home/jrd101/data/jrd101-default/kernel-train-Cxmkj97aXKZeaRZov/Cxmkj97aXKZeaRZov.json","PROVIDER":"aws","REGION":"us-east-1","SIZE":6582,"TIMESTAMP":"1614217411"},"path":"core/reusable/object_storage_container_data"},{"data":{"properties":[{"name":"atomic_radius","value":4},{"name":"electronegativity","value":1.1},{"name":"ionization_potential","value":7.7}],"symbol":"Si"},"path":"element"},{"data":{"arguments":{"nband":1,"npools":1,"ntg":1},"cluster":{"fqdn":"master-1-staging.exabyte.io","jid":"1234.master-1-staging.exabyte.io"},"email":"demo@exabyte.io","errors":[{"domain":"rupy","message":"File Not Found: /home/demo/data/project1/job-123/job-config.json","reason":"FileNotFound"}],"excludeFilesPattern":"^.*.txt$","maxCPU":36,"nodes":1,"notify":"abe","ppn":1,"queue":"OF","timeLimit":"00:05:00"},"path":"job/compute"},{"data":{"_id":"FPjAaKfuYAL7tiHbm","_material":{"_id":"HtxACY2wX4b2hS8Rv","cls":"Material","slug":"silicon-fcc"},"_project":{"_id":"HtxACY2wX4b2hS8Rv","cls":"Project","slug":"project-default"},"compute":{"arguments":{"nband":1,"npools":1,"ntg":1},"cluster":{"fqdn":"master-1-staging.exabyte.io","jid":"1234.master-1-staging.exabyte.io"},"email":"demo@exabyte.io","errors":[{"domain":"rupy","message":"File Not Found: /home/demo/data/project1/job-123/job-config.json","reason":"FileNotFound"}],"excludeFilesPattern":"^.*.txt$","maxCPU":36,"nodes":1,"notify":"abe","ppn":1,"queue":"OF","timeLimit":"00:05:00"},"createdAt":"2018-11-19 06:41:46.877Z","creator":{"_id":"HtxACY2wX4b2hS8Rv","cls":"User","slug":"exadmin"},"name":"job","owner":{"_id":"HtxACY2wX4b2hS8Rv","cls":"Account","slug":"exabyte"},"schemaVersion":"0.2.0","slug":"job","status":"pre-submission","workflow":{"_id":"FPjAaKfuYAL7tiHbm","createdAt":"2018-11-19 06:41:46.877Z","creator":{"_id":"HtxACY2wX4b2hS8Rv","cls":"User","slug":"exadmin"},"exabyteId":"qKtTzu9utCo6ac4n7","hash":"f4fd707d2e47c15f8d786cf159040954","isDefault":true,"name":"workflow","owner":{"_id":"HtxACY2wX4b2hS8Rv","cls":"Account","slug":"exabyte"},"properties":["band_structure"],"schemaVersion":"0.2.0","slug":"workflow","subworkflows":[{"_id":"LCthJ6E2QabYCZqf4","application":{"name":"espresso","shortName":"qe","summary":"Quantum Espresso","version":"5.1.1","hasAdvancedComputeOptions":true},"model":{"method":{"data":{"pseudo":[]},"subtype":"us","type":"pseudopotential"},"subtype":"gga","type":"dft"},"name":"Band Structure","properties":["band_structure"],"units":[{"application":{"name":"espresso","shortName":"qe","summary":"Quantum Espresso","version":"5.1.1","hasAdvancedComputeOptions":true},"compute":null,"executable":{"advancedComputeOptions":true,"applicationId":["eaJepm4AWfqpaCw59"],"isDefault":true,"monitors":[{"name":"standard_output"}],"name":"pw.x","postProcessors":[],"preProcessors":[],"results":[{"name":"atomic_forces"}]},"flavor":{"executableId":"4987JFJ3kKbwvFSG7","input":[{"templateId":"dJ7HYz5pQ4AuN5qc9"}],"name":"pw_scf"},"flowchartId":"execution","head":true,"input":[{"content":"K_POINTS automatic\n2 2 2 0 0 0","name":"pw_scf.in"}],"monitors":[{"name":"scf_accuracy"},{"name":"standard_output"}],"name":"execution","next":"pw-bands","postProcessors":[],"preProcessors":[],"results":[{"name":"harris_foulkes_estimate"}],"status":"idle","type":"execution"}]}],"tags":["workflow"],"units":[{"_id":"LCthJ6E2QabYCZqf4","flowchartId":"05c362dc27ff1bb98d16fd60","type":"subworkflow","name":"subworkflow unit"}]}},"path":"job"},{"data":{"_id":"LCthJ6E2QabYCZqf3","basis":{"coordinates":[{"id":1,"value":[0,0,0]},{"id":2,"value":[0.25,0.25,0.25]}],"elements":[{"id":1,"value":"Si"},{"id":2,"value":"Si"}],"name":"basis","units":"crystal"},"createdAt":"2016-04-03T05:25:37.430Z","creator":{"_id":"HtxACY2wX4b2hS8Rv","cls":"User","slug":"exadmin"},"derivedProperties":[{"name":"volume","units":"angstrom^3","value":131.1},{"name":"density","units":"g/cm^3","value":2.33},{"name":"symmetry","spaceGroupSymbol":"Fd-3m","tolerance":{"units":"angstrom","value":0.3}},{"degree":10,"name":"p-norm","value":0.71},{"element":"Si","name":"elemental_ratio","value":0.71},{"name":"inchi","value":""},{"name":"inchi_key","value":""}],"exabyteId":"RKiswuxHKkF3uvLyA","formula":"Si","hash":"4ac3fa057e3530628eb1295c77110eaa","isDefault":false,"isNonPeriodic":false,"lattice":{"name":"lattice","a":5.14,"alpha":90,"b":5.14,"beta":90,"c":5.14,"gamma":90,"type":"CUB","units":{"angle":"degree","length":"angstrom"},"vectors":{"a":[5,0.000121312,0.000131415],"alat":1,"b":[0.000121312,5,0.000121314],"c":[0.000121313,0.000121312,5],"units":"angstrom"}},"name":"Silicon FCC","owner":{"_id":"HtxACY2wX4b2hS8Rv","cls":"Account","slug":"exabyte"},"scaledHash":"5bd4eb168e3530628eb1295d88221cbb","schemaVersion":"0.2.0","slug":"silicon-fcc","unitCellFormula":"Si2","updatedAt":"2016-04-04T17:58:42.867Z"},"path":"material"},{"data":{"stack_components":[{"stack_components":[{"crystal":{"_id":"LCthJ6E2QabYCZqf3","basis":{"coordinates":[{"id":1,"value":[0,0,0]},{"id":2,"value":[0.25,0.25,0.25]}],"elements":[{"id":1,"value":"Si"},{"id":2,"value":"Si"}],"name":"basis","units":"crystal"},"createdAt":"2016-04-03T05:25:37.430Z","creator":{"_id":"HtxACY2wX4b2hS8Rv","cls":"User","slug":"exadmin"},"derivedProperties":[{"name":"volume","units":"angstrom^3","value":131.1},{"name":"density","units":"g/cm^3","value":2.33},{"name":"symmetry","spaceGroupSymbol":"Fd-3m","tolerance":{"units":"angstrom","value":0.3}},{"degree":10,"name":"p-norm","value":0.71},{"element":"Si","name":"elemental_ratio","value":0.71},{"name":"inchi","value":""},{"name":"inchi_key","value":""}],"exabyteId":"RKiswuxHKkF3uvLyA","formula":"Si","hash":"4ac3fa057e3530628eb1295c77110eaa","isDefault":false,"isNonPeriodic":false,"lattice":{"name":"lattice","a":5.14,"alpha":90,"b":5.14,"beta":90,"c":5.14,"gamma":90,"type":"CUB","units":{"angle":"degree","length":"angstrom"},"vectors":{"a":[5,0.000121312,0.000131415],"alat":1,"b":[0.000121312,5,0.000121314],"c":[0.000121313,0.000121312,5],"units":"angstrom"}},"name":"Silicon FCC","owner":{"_id":"HtxACY2wX4b2hS8Rv","cls":"Account","slug":"exabyte"},"scaledHash":"5bd4eb168e3530628eb1295d88221cbb","schemaVersion":"0.2.0","slug":"silicon-fcc","unitCellFormula":"Si2","updatedAt":"2016-04-04T17:58:42.867Z"},"miller_indices":[0,0,1],"use_conventional_cell":true,"termination_top":{"chemical_elements":"Si","space_group_symmetry_label":"P4/mmm_2"},"number_of_repetitions":5},{"direction":"z","size":10,"crystal":{"_id":"LCthJ6E2QabYCZqf3","basis":{"coordinates":[{"id":1,"value":[0,0,0]},{"id":2,"value":[0.25,0.25,0.25]}],"elements":[{"id":1,"value":"Si"},{"id":2,"value":"Si"}],"name":"basis","units":"crystal"},"createdAt":"2016-04-03T05:25:37.430Z","creator":{"_id":"HtxACY2wX4b2hS8Rv","cls":"User","slug":"exadmin"},"derivedProperties":[{"name":"volume","units":"angstrom^3","value":131.1},{"name":"density","units":"g/cm^3","value":2.33},{"name":"symmetry","spaceGroupSymbol":"Fd-3m","tolerance":{"units":"angstrom","value":0.3}},{"degree":10,"name":"p-norm","value":0.71},{"element":"Si","name":"elemental_ratio","value":0.71},{"name":"inchi","value":""},{"name":"inchi_key","value":""}],"exabyteId":"RKiswuxHKkF3uvLyA","formula":"Si","hash":"4ac3fa057e3530628eb1295c77110eaa","isDefault":false,"isNonPeriodic":false,"lattice":{"name":"lattice","a":5.14,"alpha":90,"b":5.14,"beta":90,"c":5.14,"gamma":90,"type":"CUB","units":{"angle":"degree","length":"angstrom"},"vectors":{"a":[5,0.000121312,0.000131415],"alat":1,"b":[0.000121312,5,0.000121314],"c":[0.000121313,0.000121312,5],"units":"angstrom"}},"name":"Silicon FCC","owner":{"_id":"HtxACY2wX4b2hS8Rv","cls":"Account","slug":"exabyte"},"scaledHash":"5bd4eb168e3530628eb1295d88221cbb","schemaVersion":"0.2.0","slug":"silicon-fcc","unitCellFormula":"Si2","updatedAt":"2016-04-04T17:58:42.867Z"}}],"direction":"z"},{"stack_components":[{"crystal":{"_id":"LCthJ6E2QabYCZqf3","basis":{"coordinates":[{"id":1,"value":[0,0,0]},{"id":2,"value":[0.25,0.25,0.25]}],"elements":[{"id":1,"value":"Si"},{"id":2,"value":"Si"}],"name":"basis","units":"crystal"},"createdAt":"2016-04-03T05:25:37.430Z","creator":{"_id":"HtxACY2wX4b2hS8Rv","cls":"User","slug":"exadmin"},"derivedProperties":[{"name":"volume","units":"angstrom^3","value":131.1},{"name":"density","units":"g/cm^3","value":2.33},{"name":"symmetry","spaceGroupSymbol":"Fd-3m","tolerance":{"units":"angstrom","value":0.3}},{"degree":10,"name":"p-norm","value":0.71},{"element":"Si","name":"elemental_ratio","value":0.71},{"name":"inchi","value":""},{"name":"inchi_key","value":""}],"exabyteId":"RKiswuxHKkF3uvLyA","formula":"Si","hash":"4ac3fa057e3530628eb1295c77110eaa","isDefault":false,"isNonPeriodic":false,"lattice":{"name":"lattice","a":5.14,"alpha":90,"b":5.14,"beta":90,"c":5.14,"gamma":90,"type":"CUB","units":{"angle":"degree","length":"angstrom"},"vectors":{"a":[5,0.000121312,0.000131415],"alat":1,"b":[0.000121312,5,0.000121314],"c":[0.000121313,0.000121312,5],"units":"angstrom"}},"name":"Silicon FCC","owner":{"_id":"HtxACY2wX4b2hS8Rv","cls":"Account","slug":"exabyte"},"scaledHash":"5bd4eb168e3530628eb1295d88221cbb","schemaVersion":"0.2.0","slug":"silicon-fcc","unitCellFormula":"Si2","updatedAt":"2016-04-04T17:58:42.867Z"},"miller_indices":[0,0,1],"use_conventional_cell":true,"termination_top":{"chemical_elements":"Si","space_group_symmetry_label":"P4/mmm_2"},"number_of_repetitions":5},{"direction":"z","size":10,"crystal":{"_id":"LCthJ6E2QabYCZqf3","basis":{"coordinates":[{"id":1,"value":[0,0,0]},{"id":2,"value":[0.25,0.25,0.25]}],"elements":[{"id":1,"value":"Si"},{"id":2,"value":"Si"}],"name":"basis","units":"crystal"},"createdAt":"2016-04-03T05:25:37.430Z","creator":{"_id":"HtxACY2wX4b2hS8Rv","cls":"User","slug":"exadmin"},"derivedProperties":[{"name":"volume","units":"angstrom^3","value":131.1},{"name":"density","units":"g/cm^3","value":2.33},{"name":"symmetry","spaceGroupSymbol":"Fd-3m","tolerance":{"units":"angstrom","value":0.3}},{"degree":10,"name":"p-norm","value":0.71},{"element":"Si","name":"elemental_ratio","value":0.71},{"name":"inchi","value":""},{"name":"inchi_key","value":""}],"exabyteId":"RKiswuxHKkF3uvLyA","formula":"Si","hash":"4ac3fa057e3530628eb1295c77110eaa","isDefault":false,"isNonPeriodic":false,"lattice":{"name":"lattice","a":5.14,"alpha":90,"b":5.14,"beta":90,"c":5.14,"gamma":90,"type":"CUB","units":{"angle":"degree","length":"angstrom"},"vectors":{"a":[5,0.000121312,0.000131415],"alat":1,"b":[0.000121312,5,0.000121314],"c":[0.000121313,0.000121312,5],"units":"angstrom"}},"name":"Silicon FCC","owner":{"_id":"HtxACY2wX4b2hS8Rv","cls":"Account","slug":"exabyte"},"scaledHash":"5bd4eb168e3530628eb1295d88221cbb","schemaVersion":"0.2.0","slug":"silicon-fcc","unitCellFormula":"Si2","updatedAt":"2016-04-04T17:58:42.867Z"}}],"direction":"z"},{"direction":"z","size":20,"crystal":{"_id":"LCthJ6E2QabYCZqf3","basis":{"coordinates":[{"id":1,"value":[0,0,0]},{"id":2,"value":[0.25,0.25,0.25]}],"elements":[{"id":1,"value":"Si"},{"id":2,"value":"Si"}],"name":"basis","units":"crystal"},"createdAt":"2016-04-03T05:25:37.430Z","creator":{"_id":"HtxACY2wX4b2hS8Rv","cls":"User","slug":"exadmin"},"derivedProperties":[{"name":"volume","units":"angstrom^3","value":131.1},{"name":"density","units":"g/cm^3","value":2.33},{"name":"symmetry","spaceGroupSymbol":"Fd-3m","tolerance":{"units":"angstrom","value":0.3}},{"degree":10,"name":"p-norm","value":0.71},{"element":"Si","name":"elemental_ratio","value":0.71},{"name":"inchi","value":""},{"name":"inchi_key","value":""}],"exabyteId":"RKiswuxHKkF3uvLyA","formula":"Si","hash":"4ac3fa057e3530628eb1295c77110eaa","isDefault":false,"isNonPeriodic":false,"lattice":{"name":"lattice","a":5.14,"alpha":90,"b":5.14,"beta":90,"c":5.14,"gamma":90,"type":"CUB","units":{"angle":"degree","length":"angstrom"},"vectors":{"a":[5,0.000121312,0.000131415],"alat":1,"b":[0.000121312,5,0.000121314],"c":[0.000121313,0.000121312,5],"units":"angstrom"}},"name":"Silicon FCC","owner":{"_id":"HtxACY2wX4b2hS8Rv","cls":"Account","slug":"exabyte"},"scaledHash":"5bd4eb168e3530628eb1295d88221cbb","schemaVersion":"0.2.0","slug":"silicon-fcc","unitCellFormula":"Si2","updatedAt":"2016-04-04T17:58:42.867Z"}}],"direction":"z"},"path":"materials_category/compound_pristine_structures/two-dimensional/interface/configuration"},{"data":{"stack_components":[{"stack_components":[{"crystal":{"_id":"LCthJ6E2QabYCZqf3","basis":{"coordinates":[{"id":1,"value":[0,0,0]},{"id":2,"value":[0.25,0.25,0.25]}],"elements":[{"id":1,"value":"Si"},{"id":2,"value":"Si"}],"name":"basis","units":"crystal"},"createdAt":"2016-04-03T05:25:37.430Z","creator":{"_id":"HtxACY2wX4b2hS8Rv","cls":"User","slug":"exadmin"},"derivedProperties":[{"name":"volume","units":"angstrom^3","value":131.1},{"name":"density","units":"g/cm^3","value":2.33},{"name":"symmetry","spaceGroupSymbol":"Fd-3m","tolerance":{"units":"angstrom","value":0.3}},{"degree":10,"name":"p-norm","value":0.71},{"element":"Si","name":"elemental_ratio","value":0.71},{"name":"inchi","value":""},{"name":"inchi_key","value":""}],"exabyteId":"RKiswuxHKkF3uvLyA","formula":"Si","hash":"4ac3fa057e3530628eb1295c77110eaa","isDefault":false,"isNonPeriodic":false,"lattice":{"name":"lattice","a":5.14,"alpha":90,"b":5.14,"beta":90,"c":5.14,"gamma":90,"type":"CUB","units":{"angle":"degree","length":"angstrom"},"vectors":{"a":[5,0.000121312,0.000131415],"alat":1,"b":[0.000121312,5,0.000121314],"c":[0.000121313,0.000121312,5],"units":"angstrom"}},"name":"Silicon FCC","owner":{"_id":"HtxACY2wX4b2hS8Rv","cls":"Account","slug":"exabyte"},"scaledHash":"5bd4eb168e3530628eb1295d88221cbb","schemaVersion":"0.2.0","slug":"silicon-fcc","unitCellFormula":"Si2","updatedAt":"2016-04-04T17:58:42.867Z"},"miller_indices":[0,0,1],"use_conventional_cell":true,"termination_top":{"chemical_elements":"Si","space_group_symmetry_label":"P4/mmm_2"},"number_of_repetitions":5},{"direction":"z","size":10,"crystal":{"_id":"LCthJ6E2QabYCZqf3","basis":{"coordinates":[{"id":1,"value":[0,0,0]},{"id":2,"value":[0.25,0.25,0.25]}],"elements":[{"id":1,"value":"Si"},{"id":2,"value":"Si"}],"name":"basis","units":"crystal"},"createdAt":"2016-04-03T05:25:37.430Z","creator":{"_id":"HtxACY2wX4b2hS8Rv","cls":"User","slug":"exadmin"},"derivedProperties":[{"name":"volume","units":"angstrom^3","value":131.1},{"name":"density","units":"g/cm^3","value":2.33},{"name":"symmetry","spaceGroupSymbol":"Fd-3m","tolerance":{"units":"angstrom","value":0.3}},{"degree":10,"name":"p-norm","value":0.71},{"element":"Si","name":"elemental_ratio","value":0.71},{"name":"inchi","value":""},{"name":"inchi_key","value":""}],"exabyteId":"RKiswuxHKkF3uvLyA","formula":"Si","hash":"4ac3fa057e3530628eb1295c77110eaa","isDefault":false,"isNonPeriodic":false,"lattice":{"name":"lattice","a":5.14,"alpha":90,"b":5.14,"beta":90,"c":5.14,"gamma":90,"type":"CUB","units":{"angle":"degree","length":"angstrom"},"vectors":{"a":[5,0.000121312,0.000131415],"alat":1,"b":[0.000121312,5,0.000121314],"c":[0.000121313,0.000121312,5],"units":"angstrom"}},"name":"Silicon FCC","owner":{"_id":"HtxACY2wX4b2hS8Rv","cls":"Account","slug":"exabyte"},"scaledHash":"5bd4eb168e3530628eb1295d88221cbb","schemaVersion":"0.2.0","slug":"silicon-fcc","unitCellFormula":"Si2","updatedAt":"2016-04-04T17:58:42.867Z"}}],"direction":"z"},{"stack_components":[{"crystal":{"_id":"LCthJ6E2QabYCZqf3","basis":{"coordinates":[{"id":1,"value":[0,0,0]},{"id":2,"value":[0.25,0.25,0.25]}],"elements":[{"id":1,"value":"Si"},{"id":2,"value":"Si"}],"name":"basis","units":"crystal"},"createdAt":"2016-04-03T05:25:37.430Z","creator":{"_id":"HtxACY2wX4b2hS8Rv","cls":"User","slug":"exadmin"},"derivedProperties":[{"name":"volume","units":"angstrom^3","value":131.1},{"name":"density","units":"g/cm^3","value":2.33},{"name":"symmetry","spaceGroupSymbol":"Fd-3m","tolerance":{"units":"angstrom","value":0.3}},{"degree":10,"name":"p-norm","value":0.71},{"element":"Si","name":"elemental_ratio","value":0.71},{"name":"inchi","value":""},{"name":"inchi_key","value":""}],"exabyteId":"RKiswuxHKkF3uvLyA","formula":"Si","hash":"4ac3fa057e3530628eb1295c77110eaa","isDefault":false,"isNonPeriodic":false,"lattice":{"name":"lattice","a":5.14,"alpha":90,"b":5.14,"beta":90,"c":5.14,"gamma":90,"type":"CUB","units":{"angle":"degree","length":"angstrom"},"vectors":{"a":[5,0.000121312,0.000131415],"alat":1,"b":[0.000121312,5,0.000121314],"c":[0.000121313,0.000121312,5],"units":"angstrom"}},"name":"Silicon FCC","owner":{"_id":"HtxACY2wX4b2hS8Rv","cls":"Account","slug":"exabyte"},"scaledHash":"5bd4eb168e3530628eb1295d88221cbb","schemaVersion":"0.2.0","slug":"silicon-fcc","unitCellFormula":"Si2","updatedAt":"2016-04-04T17:58:42.867Z"},"miller_indices":[0,0,1],"use_conventional_cell":true,"termination_top":{"chemical_elements":"Si","space_group_symmetry_label":"P4/mmm_2"},"number_of_repetitions":5},{"direction":"z","size":10,"crystal":{"_id":"LCthJ6E2QabYCZqf3","basis":{"coordinates":[{"id":1,"value":[0,0,0]},{"id":2,"value":[0.25,0.25,0.25]}],"elements":[{"id":1,"value":"Si"},{"id":2,"value":"Si"}],"name":"basis","units":"crystal"},"createdAt":"2016-04-03T05:25:37.430Z","creator":{"_id":"HtxACY2wX4b2hS8Rv","cls":"User","slug":"exadmin"},"derivedProperties":[{"name":"volume","units":"angstrom^3","value":131.1},{"name":"density","units":"g/cm^3","value":2.33},{"name":"symmetry","spaceGroupSymbol":"Fd-3m","tolerance":{"units":"angstrom","value":0.3}},{"degree":10,"name":"p-norm","value":0.71},{"element":"Si","name":"elemental_ratio","value":0.71},{"name":"inchi","value":""},{"name":"inchi_key","value":""}],"exabyteId":"RKiswuxHKkF3uvLyA","formula":"Si","hash":"4ac3fa057e3530628eb1295c77110eaa","isDefault":false,"isNonPeriodic":false,"lattice":{"name":"lattice","a":5.14,"alpha":90,"b":5.14,"beta":90,"c":5.14,"gamma":90,"type":"CUB","units":{"angle":"degree","length":"angstrom"},"vectors":{"a":[5,0.000121312,0.000131415],"alat":1,"b":[0.000121312,5,0.000121314],"c":[0.000121313,0.000121312,5],"units":"angstrom"}},"name":"Silicon FCC","owner":{"_id":"HtxACY2wX4b2hS8Rv","cls":"Account","slug":"exabyte"},"scaledHash":"5bd4eb168e3530628eb1295d88221cbb","schemaVersion":"0.2.0","slug":"silicon-fcc","unitCellFormula":"Si2","updatedAt":"2016-04-04T17:58:42.867Z"}}],"direction":"z"}],"direction":"x","actual_angle":45,"xy_shift":[0,0]},"path":"materials_category/defective_structures/one-dimensional/grain_boundary_linear/configuration"},{"data":{"stack_components":[{"stack_components":[{"crystal":{"_id":"LCthJ6E2QabYCZqf3","basis":{"coordinates":[{"id":1,"value":[0,0,0]},{"id":2,"value":[0.25,0.25,0.25]}],"elements":[{"id":1,"value":"Si"},{"id":2,"value":"Si"}],"name":"basis","units":"crystal"},"createdAt":"2016-04-03T05:25:37.430Z","creator":{"_id":"HtxACY2wX4b2hS8Rv","cls":"User","slug":"exadmin"},"derivedProperties":[{"name":"volume","units":"angstrom^3","value":131.1},{"name":"density","units":"g/cm^3","value":2.33},{"name":"symmetry","spaceGroupSymbol":"Fd-3m","tolerance":{"units":"angstrom","value":0.3}},{"degree":10,"name":"p-norm","value":0.71},{"element":"Si","name":"elemental_ratio","value":0.71},{"name":"inchi","value":""},{"name":"inchi_key","value":""}],"exabyteId":"RKiswuxHKkF3uvLyA","formula":"Si","hash":"4ac3fa057e3530628eb1295c77110eaa","isDefault":false,"isNonPeriodic":false,"lattice":{"name":"lattice","a":5.14,"alpha":90,"b":5.14,"beta":90,"c":5.14,"gamma":90,"type":"CUB","units":{"angle":"degree","length":"angstrom"},"vectors":{"a":[5,0.000121312,0.000131415],"alat":1,"b":[0.000121312,5,0.000121314],"c":[0.000121313,0.000121312,5],"units":"angstrom"}},"name":"Silicon FCC","owner":{"_id":"HtxACY2wX4b2hS8Rv","cls":"Account","slug":"exabyte"},"scaledHash":"5bd4eb168e3530628eb1295d88221cbb","schemaVersion":"0.2.0","slug":"silicon-fcc","unitCellFormula":"Si2","updatedAt":"2016-04-04T17:58:42.867Z"},"miller_indices":[0,0,1],"use_conventional_cell":true,"termination_top":{"chemical_elements":"Si","space_group_symmetry_label":"P4/mmm_2"},"number_of_repetitions":5},{"direction":"z","size":10,"crystal":{"_id":"LCthJ6E2QabYCZqf3","basis":{"coordinates":[{"id":1,"value":[0,0,0]},{"id":2,"value":[0.25,0.25,0.25]}],"elements":[{"id":1,"value":"Si"},{"id":2,"value":"Si"}],"name":"basis","units":"crystal"},"createdAt":"2016-04-03T05:25:37.430Z","creator":{"_id":"HtxACY2wX4b2hS8Rv","cls":"User","slug":"exadmin"},"derivedProperties":[{"name":"volume","units":"angstrom^3","value":131.1},{"name":"density","units":"g/cm^3","value":2.33},{"name":"symmetry","spaceGroupSymbol":"Fd-3m","tolerance":{"units":"angstrom","value":0.3}},{"degree":10,"name":"p-norm","value":0.71},{"element":"Si","name":"elemental_ratio","value":0.71},{"name":"inchi","value":""},{"name":"inchi_key","value":""}],"exabyteId":"RKiswuxHKkF3uvLyA","formula":"Si","hash":"4ac3fa057e3530628eb1295c77110eaa","isDefault":false,"isNonPeriodic":false,"lattice":{"name":"lattice","a":5.14,"alpha":90,"b":5.14,"beta":90,"c":5.14,"gamma":90,"type":"CUB","units":{"angle":"degree","length":"angstrom"},"vectors":{"a":[5,0.000121312,0.000131415],"alat":1,"b":[0.000121312,5,0.000121314],"c":[0.000121313,0.000121312,5],"units":"angstrom"}},"name":"Silicon FCC","owner":{"_id":"HtxACY2wX4b2hS8Rv","cls":"Account","slug":"exabyte"},"scaledHash":"5bd4eb168e3530628eb1295d88221cbb","schemaVersion":"0.2.0","slug":"silicon-fcc","unitCellFormula":"Si2","updatedAt":"2016-04-04T17:58:42.867Z"}}],"direction":"z"},{"crystal":{"_id":"LCthJ6E2QabYCZqf3","basis":{"coordinates":[{"id":1,"value":[0,0,0]},{"id":2,"value":[0.25,0.25,0.25]}],"elements":[{"id":1,"value":"Si"},{"id":2,"value":"Si"}],"name":"basis","units":"crystal"},"createdAt":"2016-04-03T05:25:37.430Z","creator":{"_id":"HtxACY2wX4b2hS8Rv","cls":"User","slug":"exadmin"},"derivedProperties":[{"name":"volume","units":"angstrom^3","value":131.1},{"name":"density","units":"g/cm^3","value":2.33},{"name":"symmetry","spaceGroupSymbol":"Fd-3m","tolerance":{"units":"angstrom","value":0.3}},{"degree":10,"name":"p-norm","value":0.71},{"element":"Si","name":"elemental_ratio","value":0.71},{"name":"inchi","value":""},{"name":"inchi_key","value":""}],"exabyteId":"RKiswuxHKkF3uvLyA","formula":"Si","hash":"4ac3fa057e3530628eb1295c77110eaa","isDefault":false,"isNonPeriodic":false,"lattice":{"name":"lattice","a":5.14,"alpha":90,"b":5.14,"beta":90,"c":5.14,"gamma":90,"type":"CUB","units":{"angle":"degree","length":"angstrom"},"vectors":{"a":[5,0.000121312,0.000131415],"alat":1,"b":[0.000121312,5,0.000121314],"c":[0.000121313,0.000121312,5],"units":"angstrom"}},"name":"Silicon FCC","owner":{"_id":"HtxACY2wX4b2hS8Rv","cls":"Account","slug":"exabyte"},"scaledHash":"5bd4eb168e3530628eb1295d88221cbb","schemaVersion":"0.2.0","slug":"silicon-fcc","unitCellFormula":"Si2","updatedAt":"2016-04-04T17:58:42.867Z"},"coordinate":[0.5,0.5,1.1],"element":{"chemical_element":"B"}},{"direction":"z","size":10,"crystal":{"_id":"LCthJ6E2QabYCZqf3","basis":{"coordinates":[{"id":1,"value":[0,0,0]},{"id":2,"value":[0.25,0.25,0.25]}],"elements":[{"id":1,"value":"Si"},{"id":2,"value":"Si"}],"name":"basis","units":"crystal"},"createdAt":"2016-04-03T05:25:37.430Z","creator":{"_id":"HtxACY2wX4b2hS8Rv","cls":"User","slug":"exadmin"},"derivedProperties":[{"name":"volume","units":"angstrom^3","value":131.1},{"name":"density","units":"g/cm^3","value":2.33},{"name":"symmetry","spaceGroupSymbol":"Fd-3m","tolerance":{"units":"angstrom","value":0.3}},{"degree":10,"name":"p-norm","value":0.71},{"element":"Si","name":"elemental_ratio","value":0.71},{"name":"inchi","value":""},{"name":"inchi_key","value":""}],"exabyteId":"RKiswuxHKkF3uvLyA","formula":"Si","hash":"4ac3fa057e3530628eb1295c77110eaa","isDefault":false,"isNonPeriodic":false,"lattice":{"name":"lattice","a":5.14,"alpha":90,"b":5.14,"beta":90,"c":5.14,"gamma":90,"type":"CUB","units":{"angle":"degree","length":"angstrom"},"vectors":{"a":[5,0.000121312,0.000131415],"alat":1,"b":[0.000121312,5,0.000121314],"c":[0.000121313,0.000121312,5],"units":"angstrom"}},"name":"Silicon FCC","owner":{"_id":"HtxACY2wX4b2hS8Rv","cls":"Account","slug":"exabyte"},"scaledHash":"5bd4eb168e3530628eb1295d88221cbb","schemaVersion":"0.2.0","slug":"silicon-fcc","unitCellFormula":"Si2","updatedAt":"2016-04-04T17:58:42.867Z"}}],"direction":"z"},"path":"materials_category/defective_structures/two-dimensional/adatom/configuration"},{"data":{"stack_components":[{"stack_components":[{"crystal":{"_id":"LCthJ6E2QabYCZqf3","basis":{"coordinates":[{"id":1,"value":[0,0,0]},{"id":2,"value":[0.25,0.25,0.25]}],"elements":[{"id":1,"value":"Si"},{"id":2,"value":"Si"}],"name":"basis","units":"crystal"},"createdAt":"2016-04-03T05:25:37.430Z","creator":{"_id":"HtxACY2wX4b2hS8Rv","cls":"User","slug":"exadmin"},"derivedProperties":[{"name":"volume","units":"angstrom^3","value":131.1},{"name":"density","units":"g/cm^3","value":2.33},{"name":"symmetry","spaceGroupSymbol":"Fd-3m","tolerance":{"units":"angstrom","value":0.3}},{"degree":10,"name":"p-norm","value":0.71},{"element":"Si","name":"elemental_ratio","value":0.71},{"name":"inchi","value":""},{"name":"inchi_key","value":""}],"exabyteId":"RKiswuxHKkF3uvLyA","formula":"Si","hash":"4ac3fa057e3530628eb1295c77110eaa","isDefault":false,"isNonPeriodic":false,"lattice":{"name":"lattice","a":5.14,"alpha":90,"b":5.14,"beta":90,"c":5.14,"gamma":90,"type":"CUB","units":{"angle":"degree","length":"angstrom"},"vectors":{"a":[5,0.000121312,0.000131415],"alat":1,"b":[0.000121312,5,0.000121314],"c":[0.000121313,0.000121312,5],"units":"angstrom"}},"name":"Silicon FCC","owner":{"_id":"HtxACY2wX4b2hS8Rv","cls":"Account","slug":"exabyte"},"scaledHash":"5bd4eb168e3530628eb1295d88221cbb","schemaVersion":"0.2.0","slug":"silicon-fcc","unitCellFormula":"Si2","updatedAt":"2016-04-04T17:58:42.867Z"},"miller_indices":[0,0,1],"use_conventional_cell":true,"termination_top":{"chemical_elements":"Si","space_group_symmetry_label":"P4/mmm_2"},"number_of_repetitions":5},{"direction":"z","size":10,"crystal":{"_id":"LCthJ6E2QabYCZqf3","basis":{"coordinates":[{"id":1,"value":[0,0,0]},{"id":2,"value":[0.25,0.25,0.25]}],"elements":[{"id":1,"value":"Si"},{"id":2,"value":"Si"}],"name":"basis","units":"crystal"},"createdAt":"2016-04-03T05:25:37.430Z","creator":{"_id":"HtxACY2wX4b2hS8Rv","cls":"User","slug":"exadmin"},"derivedProperties":[{"name":"volume","units":"angstrom^3","value":131.1},{"name":"density","units":"g/cm^3","value":2.33},{"name":"symmetry","spaceGroupSymbol":"Fd-3m","tolerance":{"units":"angstrom","value":0.3}},{"degree":10,"name":"p-norm","value":0.71},{"element":"Si","name":"elemental_ratio","value":0.71},{"name":"inchi","value":""},{"name":"inchi_key","value":""}],"exabyteId":"RKiswuxHKkF3uvLyA","formula":"Si","hash":"4ac3fa057e3530628eb1295c77110eaa","isDefault":false,"isNonPeriodic":false,"lattice":{"name":"lattice","a":5.14,"alpha":90,"b":5.14,"beta":90,"c":5.14,"gamma":90,"type":"CUB","units":{"angle":"degree","length":"angstrom"},"vectors":{"a":[5,0.000121312,0.000131415],"alat":1,"b":[0.000121312,5,0.000121314],"c":[0.000121313,0.000121312,5],"units":"angstrom"}},"name":"Silicon FCC","owner":{"_id":"HtxACY2wX4b2hS8Rv","cls":"Account","slug":"exabyte"},"scaledHash":"5bd4eb168e3530628eb1295d88221cbb","schemaVersion":"0.2.0","slug":"silicon-fcc","unitCellFormula":"Si2","updatedAt":"2016-04-04T17:58:42.867Z"}}],"direction":"z"},{"stack_components":[{"crystal":{"_id":"LCthJ6E2QabYCZqf3","basis":{"coordinates":[{"id":1,"value":[0,0,0]},{"id":2,"value":[0.25,0.25,0.25]}],"elements":[{"id":1,"value":"Si"},{"id":2,"value":"Si"}],"name":"basis","units":"crystal"},"createdAt":"2016-04-03T05:25:37.430Z","creator":{"_id":"HtxACY2wX4b2hS8Rv","cls":"User","slug":"exadmin"},"derivedProperties":[{"name":"volume","units":"angstrom^3","value":131.1},{"name":"density","units":"g/cm^3","value":2.33},{"name":"symmetry","spaceGroupSymbol":"Fd-3m","tolerance":{"units":"angstrom","value":0.3}},{"degree":10,"name":"p-norm","value":0.71},{"element":"Si","name":"elemental_ratio","value":0.71},{"name":"inchi","value":""},{"name":"inchi_key","value":""}],"exabyteId":"RKiswuxHKkF3uvLyA","formula":"Si","hash":"4ac3fa057e3530628eb1295c77110eaa","isDefault":false,"isNonPeriodic":false,"lattice":{"name":"lattice","a":5.14,"alpha":90,"b":5.14,"beta":90,"c":5.14,"gamma":90,"type":"CUB","units":{"angle":"degree","length":"angstrom"},"vectors":{"a":[5,0.000121312,0.000131415],"alat":1,"b":[0.000121312,5,0.000121314],"c":[0.000121313,0.000121312,5],"units":"angstrom"}},"name":"Silicon FCC","owner":{"_id":"HtxACY2wX4b2hS8Rv","cls":"Account","slug":"exabyte"},"scaledHash":"5bd4eb168e3530628eb1295d88221cbb","schemaVersion":"0.2.0","slug":"silicon-fcc","unitCellFormula":"Si2","updatedAt":"2016-04-04T17:58:42.867Z"},"miller_indices":[0,0,1],"use_conventional_cell":true,"termination_top":{"chemical_elements":"Si","space_group_symmetry_label":"P4/mmm_2"},"number_of_repetitions":5},{"direction":"z","size":10,"crystal":{"_id":"LCthJ6E2QabYCZqf3","basis":{"coordinates":[{"id":1,"value":[0,0,0]},{"id":2,"value":[0.25,0.25,0.25]}],"elements":[{"id":1,"value":"Si"},{"id":2,"value":"Si"}],"name":"basis","units":"crystal"},"createdAt":"2016-04-03T05:25:37.430Z","creator":{"_id":"HtxACY2wX4b2hS8Rv","cls":"User","slug":"exadmin"},"derivedProperties":[{"name":"volume","units":"angstrom^3","value":131.1},{"name":"density","units":"g/cm^3","value":2.33},{"name":"symmetry","spaceGroupSymbol":"Fd-3m","tolerance":{"units":"angstrom","value":0.3}},{"degree":10,"name":"p-norm","value":0.71},{"element":"Si","name":"elemental_ratio","value":0.71},{"name":"inchi","value":""},{"name":"inchi_key","value":""}],"exabyteId":"RKiswuxHKkF3uvLyA","formula":"Si","hash":"4ac3fa057e3530628eb1295c77110eaa","isDefault":false,"isNonPeriodic":false,"lattice":{"name":"lattice","a":5.14,"alpha":90,"b":5.14,"beta":90,"c":5.14,"gamma":90,"type":"CUB","units":{"angle":"degree","length":"angstrom"},"vectors":{"a":[5,0.000121312,0.000131415],"alat":1,"b":[0.000121312,5,0.000121314],"c":[0.000121313,0.000121312,5],"units":"angstrom"}},"name":"Silicon FCC","owner":{"_id":"HtxACY2wX4b2hS8Rv","cls":"Account","slug":"exabyte"},"scaledHash":"5bd4eb168e3530628eb1295d88221cbb","schemaVersion":"0.2.0","slug":"silicon-fcc","unitCellFormula":"Si2","updatedAt":"2016-04-04T17:58:42.867Z"}}],"direction":"z"},{"direction":"z","size":20,"crystal":{"_id":"LCthJ6E2QabYCZqf3","basis":{"coordinates":[{"id":1,"value":[0,0,0]},{"id":2,"value":[0.25,0.25,0.25]}],"elements":[{"id":1,"value":"Si"},{"id":2,"value":"Si"}],"name":"basis","units":"crystal"},"createdAt":"2016-04-03T05:25:37.430Z","creator":{"_id":"HtxACY2wX4b2hS8Rv","cls":"User","slug":"exadmin"},"derivedProperties":[{"name":"volume","units":"angstrom^3","value":131.1},{"name":"density","units":"g/cm^3","value":2.33},{"name":"symmetry","spaceGroupSymbol":"Fd-3m","tolerance":{"units":"angstrom","value":0.3}},{"degree":10,"name":"p-norm","value":0.71},{"element":"Si","name":"elemental_ratio","value":0.71},{"name":"inchi","value":""},{"name":"inchi_key","value":""}],"exabyteId":"RKiswuxHKkF3uvLyA","formula":"Si","hash":"4ac3fa057e3530628eb1295c77110eaa","isDefault":false,"isNonPeriodic":false,"lattice":{"name":"lattice","a":5.14,"alpha":90,"b":5.14,"beta":90,"c":5.14,"gamma":90,"type":"CUB","units":{"angle":"degree","length":"angstrom"},"vectors":{"a":[5,0.000121312,0.000131415],"alat":1,"b":[0.000121312,5,0.000121314],"c":[0.000121313,0.000121312,5],"units":"angstrom"}},"name":"Silicon FCC","owner":{"_id":"HtxACY2wX4b2hS8Rv","cls":"Account","slug":"exabyte"},"scaledHash":"5bd4eb168e3530628eb1295d88221cbb","schemaVersion":"0.2.0","slug":"silicon-fcc","unitCellFormula":"Si2","updatedAt":"2016-04-04T17:58:42.867Z"}}],"direction":"z"},"path":"materials_category/defective_structures/two-dimensional/grain_boundary_planar/configuration"},{"data":{"stack_components":[{"stack_components":[{"crystal":{"_id":"LCthJ6E2QabYCZqf3","basis":{"coordinates":[{"id":1,"value":[0,0,0]},{"id":2,"value":[0.25,0.25,0.25]}],"elements":[{"id":1,"value":"Si"},{"id":2,"value":"Si"}],"name":"basis","units":"crystal"},"createdAt":"2016-04-03T05:25:37.430Z","creator":{"_id":"HtxACY2wX4b2hS8Rv","cls":"User","slug":"exadmin"},"derivedProperties":[{"name":"volume","units":"angstrom^3","value":131.1},{"name":"density","units":"g/cm^3","value":2.33},{"name":"symmetry","spaceGroupSymbol":"Fd-3m","tolerance":{"units":"angstrom","value":0.3}},{"degree":10,"name":"p-norm","value":0.71},{"element":"Si","name":"elemental_ratio","value":0.71},{"name":"inchi","value":""},{"name":"inchi_key","value":""}],"exabyteId":"RKiswuxHKkF3uvLyA","formula":"Si","hash":"4ac3fa057e3530628eb1295c77110eaa","isDefault":false,"isNonPeriodic":false,"lattice":{"name":"lattice","a":5.14,"alpha":90,"b":5.14,"beta":90,"c":5.14,"gamma":90,"type":"CUB","units":{"angle":"degree","length":"angstrom"},"vectors":{"a":[5,0.000121312,0.000131415],"alat":1,"b":[0.000121312,5,0.000121314],"c":[0.000121313,0.000121312,5],"units":"angstrom"}},"name":"Silicon FCC","owner":{"_id":"HtxACY2wX4b2hS8Rv","cls":"Account","slug":"exabyte"},"scaledHash":"5bd4eb168e3530628eb1295d88221cbb","schemaVersion":"0.2.0","slug":"silicon-fcc","unitCellFormula":"Si2","updatedAt":"2016-04-04T17:58:42.867Z"},"miller_indices":[0,0,1],"use_conventional_cell":true,"termination_top":{"chemical_elements":"Si","space_group_symmetry_label":"P4/mmm_2"},"number_of_repetitions":5},{"direction":"z","size":10,"crystal":{"_id":"LCthJ6E2QabYCZqf3","basis":{"coordinates":[{"id":1,"value":[0,0,0]},{"id":2,"value":[0.25,0.25,0.25]}],"elements":[{"id":1,"value":"Si"},{"id":2,"value":"Si"}],"name":"basis","units":"crystal"},"createdAt":"2016-04-03T05:25:37.430Z","creator":{"_id":"HtxACY2wX4b2hS8Rv","cls":"User","slug":"exadmin"},"derivedProperties":[{"name":"volume","units":"angstrom^3","value":131.1},{"name":"density","units":"g/cm^3","value":2.33},{"name":"symmetry","spaceGroupSymbol":"Fd-3m","tolerance":{"units":"angstrom","value":0.3}},{"degree":10,"name":"p-norm","value":0.71},{"element":"Si","name":"elemental_ratio","value":0.71},{"name":"inchi","value":""},{"name":"inchi_key","value":""}],"exabyteId":"RKiswuxHKkF3uvLyA","formula":"Si","hash":"4ac3fa057e3530628eb1295c77110eaa","isDefault":false,"isNonPeriodic":false,"lattice":{"name":"lattice","a":5.14,"alpha":90,"b":5.14,"beta":90,"c":5.14,"gamma":90,"type":"CUB","units":{"angle":"degree","length":"angstrom"},"vectors":{"a":[5,0.000121312,0.000131415],"alat":1,"b":[0.000121312,5,0.000121314],"c":[0.000121313,0.000121312,5],"units":"angstrom"}},"name":"Silicon FCC","owner":{"_id":"HtxACY2wX4b2hS8Rv","cls":"Account","slug":"exabyte"},"scaledHash":"5bd4eb168e3530628eb1295d88221cbb","schemaVersion":"0.2.0","slug":"silicon-fcc","unitCellFormula":"Si2","updatedAt":"2016-04-04T17:58:42.867Z"}}],"direction":"z"},{"merge_components":[{"stack_components":[{"crystal":{"_id":"LCthJ6E2QabYCZqf3","basis":{"coordinates":[{"id":1,"value":[0,0,0]},{"id":2,"value":[0.25,0.25,0.25]}],"elements":[{"id":1,"value":"Si"},{"id":2,"value":"Si"}],"name":"basis","units":"crystal"},"createdAt":"2016-04-03T05:25:37.430Z","creator":{"_id":"HtxACY2wX4b2hS8Rv","cls":"User","slug":"exadmin"},"derivedProperties":[{"name":"volume","units":"angstrom^3","value":131.1},{"name":"density","units":"g/cm^3","value":2.33},{"name":"symmetry","spaceGroupSymbol":"Fd-3m","tolerance":{"units":"angstrom","value":0.3}},{"degree":10,"name":"p-norm","value":0.71},{"element":"Si","name":"elemental_ratio","value":0.71},{"name":"inchi","value":""},{"name":"inchi_key","value":""}],"exabyteId":"RKiswuxHKkF3uvLyA","formula":"Si","hash":"4ac3fa057e3530628eb1295c77110eaa","isDefault":false,"isNonPeriodic":false,"lattice":{"name":"lattice","a":5.14,"alpha":90,"b":5.14,"beta":90,"c":5.14,"gamma":90,"type":"CUB","units":{"angle":"degree","length":"angstrom"},"vectors":{"a":[5,0.000121312,0.000131415],"alat":1,"b":[0.000121312,5,0.000121314],"c":[0.000121313,0.000121312,5],"units":"angstrom"}},"name":"Silicon FCC","owner":{"_id":"HtxACY2wX4b2hS8Rv","cls":"Account","slug":"exabyte"},"scaledHash":"5bd4eb168e3530628eb1295d88221cbb","schemaVersion":"0.2.0","slug":"silicon-fcc","unitCellFormula":"Si2","updatedAt":"2016-04-04T17:58:42.867Z"},"miller_indices":[0,0,1],"use_conventional_cell":true,"termination_top":{"chemical_elements":"Si","space_group_symmetry_label":"P4/mmm_2"},"number_of_repetitions":5},{"direction":"z","size":10,"crystal":{"_id":"LCthJ6E2QabYCZqf3","basis":{"coordinates":[{"id":1,"value":[0,0,0]},{"id":2,"value":[0.25,0.25,0.25]}],"elements":[{"id":1,"value":"Si"},{"id":2,"value":"Si"}],"name":"basis","units":"crystal"},"createdAt":"2016-04-03T05:25:37.430Z","creator":{"_id":"HtxACY2wX4b2hS8Rv","cls":"User","slug":"exadmin"},"derivedProperties":[{"name":"volume","units":"angstrom^3","value":131.1},{"name":"density","units":"g/cm^3","value":2.33},{"name":"symmetry","spaceGroupSymbol":"Fd-3m","tolerance":{"units":"angstrom","value":0.3}},{"degree":10,"name":"p-norm","value":0.71},{"element":"Si","name":"elemental_ratio","value":0.71},{"name":"inchi","value":""},{"name":"inchi_key","value":""}],"exabyteId":"RKiswuxHKkF3uvLyA","formula":"Si","hash":"4ac3fa057e3530628eb1295c77110eaa","isDefault":false,"isNonPeriodic":false,"lattice":{"name":"lattice","a":5.14,"alpha":90,"b":5.14,"beta":90,"c":5.14,"gamma":90,"type":"CUB","units":{"angle":"degree","length":"angstrom"},"vectors":{"a":[5,0.000121312,0.000131415],"alat":1,"b":[0.000121312,5,0.000121314],"c":[0.000121313,0.000121312,5],"units":"angstrom"}},"name":"Silicon FCC","owner":{"_id":"HtxACY2wX4b2hS8Rv","cls":"Account","slug":"exabyte"},"scaledHash":"5bd4eb168e3530628eb1295d88221cbb","schemaVersion":"0.2.0","slug":"silicon-fcc","unitCellFormula":"Si2","updatedAt":"2016-04-04T17:58:42.867Z"}}],"direction":"z"},{"crystal":{"_id":"LCthJ6E2QabYCZqf3","basis":{"coordinates":[{"id":1,"value":[0,0,0]},{"id":2,"value":[0.25,0.25,0.25]}],"elements":[{"id":1,"value":"Si"},{"id":2,"value":"Si"}],"name":"basis","units":"crystal"},"createdAt":"2016-04-03T05:25:37.430Z","creator":{"_id":"HtxACY2wX4b2hS8Rv","cls":"User","slug":"exadmin"},"derivedProperties":[{"name":"volume","units":"angstrom^3","value":131.1},{"name":"density","units":"g/cm^3","value":2.33},{"name":"symmetry","spaceGroupSymbol":"Fd-3m","tolerance":{"units":"angstrom","value":0.3}},{"degree":10,"name":"p-norm","value":0.71},{"element":"Si","name":"elemental_ratio","value":0.71},{"name":"inchi","value":""},{"name":"inchi_key","value":""}],"exabyteId":"RKiswuxHKkF3uvLyA","formula":"Si","hash":"4ac3fa057e3530628eb1295c77110eaa","isDefault":false,"isNonPeriodic":false,"lattice":{"name":"lattice","a":5.14,"alpha":90,"b":5.14,"beta":90,"c":5.14,"gamma":90,"type":"CUB","units":{"angle":"degree","length":"angstrom"},"vectors":{"a":[5,0.000121312,0.000131415],"alat":1,"b":[0.000121312,5,0.000121314],"c":[0.000121313,0.000121312,5],"units":"angstrom"}},"name":"Silicon FCC","owner":{"_id":"HtxACY2wX4b2hS8Rv","cls":"Account","slug":"exabyte"},"scaledHash":"5bd4eb168e3530628eb1295d88221cbb","schemaVersion":"0.2.0","slug":"silicon-fcc","unitCellFormula":"Si2","updatedAt":"2016-04-04T17:58:42.867Z"},"coordinate_condition":{"shape":"box","min_coordinate":[0.3,0.3,0.3],"max_coordinate":[0.7,0.7,0.7]}}],"merge_method":"REPLACE"},{"direction":"z","size":10,"crystal":{"_id":"LCthJ6E2QabYCZqf3","basis":{"coordinates":[{"id":1,"value":[0,0,0]},{"id":2,"value":[0.25,0.25,0.25]}],"elements":[{"id":1,"value":"Si"},{"id":2,"value":"Si"}],"name":"basis","units":"crystal"},"createdAt":"2016-04-03T05:25:37.430Z","creator":{"_id":"HtxACY2wX4b2hS8Rv","cls":"User","slug":"exadmin"},"derivedProperties":[{"name":"volume","units":"angstrom^3","value":131.1},{"name":"density","units":"g/cm^3","value":2.33},{"name":"symmetry","spaceGroupSymbol":"Fd-3m","tolerance":{"units":"angstrom","value":0.3}},{"degree":10,"name":"p-norm","value":0.71},{"element":"Si","name":"elemental_ratio","value":0.71},{"name":"inchi","value":""},{"name":"inchi_key","value":""}],"exabyteId":"RKiswuxHKkF3uvLyA","formula":"Si","hash":"4ac3fa057e3530628eb1295c77110eaa","isDefault":false,"isNonPeriodic":false,"lattice":{"name":"lattice","a":5.14,"alpha":90,"b":5.14,"beta":90,"c":5.14,"gamma":90,"type":"CUB","units":{"angle":"degree","length":"angstrom"},"vectors":{"a":[5,0.000121312,0.000131415],"alat":1,"b":[0.000121312,5,0.000121314],"c":[0.000121313,0.000121312,5],"units":"angstrom"}},"name":"Silicon FCC","owner":{"_id":"HtxACY2wX4b2hS8Rv","cls":"Account","slug":"exabyte"},"scaledHash":"5bd4eb168e3530628eb1295d88221cbb","schemaVersion":"0.2.0","slug":"silicon-fcc","unitCellFormula":"Si2","updatedAt":"2016-04-04T17:58:42.867Z"}}],"direction":"z"},"path":"materials_category/defective_structures/two-dimensional/island/configuration"},{"data":{"stack_components":[{"stack_components":[{"crystal":{"_id":"LCthJ6E2QabYCZqf3","basis":{"coordinates":[{"id":1,"value":[0,0,0]},{"id":2,"value":[0.25,0.25,0.25]}],"elements":[{"id":1,"value":"Si"},{"id":2,"value":"Si"}],"name":"basis","units":"crystal"},"createdAt":"2016-04-03T05:25:37.430Z","creator":{"_id":"HtxACY2wX4b2hS8Rv","cls":"User","slug":"exadmin"},"derivedProperties":[{"name":"volume","units":"angstrom^3","value":131.1},{"name":"density","units":"g/cm^3","value":2.33},{"name":"symmetry","spaceGroupSymbol":"Fd-3m","tolerance":{"units":"angstrom","value":0.3}},{"degree":10,"name":"p-norm","value":0.71},{"element":"Si","name":"elemental_ratio","value":0.71},{"name":"inchi","value":""},{"name":"inchi_key","value":""}],"exabyteId":"RKiswuxHKkF3uvLyA","formula":"Si","hash":"4ac3fa057e3530628eb1295c77110eaa","isDefault":false,"isNonPeriodic":false,"lattice":{"name":"lattice","a":5.14,"alpha":90,"b":5.14,"beta":90,"c":5.14,"gamma":90,"type":"CUB","units":{"angle":"degree","length":"angstrom"},"vectors":{"a":[5,0.000121312,0.000131415],"alat":1,"b":[0.000121312,5,0.000121314],"c":[0.000121313,0.000121312,5],"units":"angstrom"}},"name":"Silicon FCC","owner":{"_id":"HtxACY2wX4b2hS8Rv","cls":"Account","slug":"exabyte"},"scaledHash":"5bd4eb168e3530628eb1295d88221cbb","schemaVersion":"0.2.0","slug":"silicon-fcc","unitCellFormula":"Si2","updatedAt":"2016-04-04T17:58:42.867Z"},"miller_indices":[0,0,1],"use_conventional_cell":true,"termination_top":{"chemical_elements":"Si","space_group_symmetry_label":"P4/mmm_2"},"number_of_repetitions":5},{"direction":"z","size":10,"crystal":{"_id":"LCthJ6E2QabYCZqf3","basis":{"coordinates":[{"id":1,"value":[0,0,0]},{"id":2,"value":[0.25,0.25,0.25]}],"elements":[{"id":1,"value":"Si"},{"id":2,"value":"Si"}],"name":"basis","units":"crystal"},"createdAt":"2016-04-03T05:25:37.430Z","creator":{"_id":"HtxACY2wX4b2hS8Rv","cls":"User","slug":"exadmin"},"derivedProperties":[{"name":"volume","units":"angstrom^3","value":131.1},{"name":"density","units":"g/cm^3","value":2.33},{"name":"symmetry","spaceGroupSymbol":"Fd-3m","tolerance":{"units":"angstrom","value":0.3}},{"degree":10,"name":"p-norm","value":0.71},{"element":"Si","name":"elemental_ratio","value":0.71},{"name":"inchi","value":""},{"name":"inchi_key","value":""}],"exabyteId":"RKiswuxHKkF3uvLyA","formula":"Si","hash":"4ac3fa057e3530628eb1295c77110eaa","isDefault":false,"isNonPeriodic":false,"lattice":{"name":"lattice","a":5.14,"alpha":90,"b":5.14,"beta":90,"c":5.14,"gamma":90,"type":"CUB","units":{"angle":"degree","length":"angstrom"},"vectors":{"a":[5,0.000121312,0.000131415],"alat":1,"b":[0.000121312,5,0.000121314],"c":[0.000121313,0.000121312,5],"units":"angstrom"}},"name":"Silicon FCC","owner":{"_id":"HtxACY2wX4b2hS8Rv","cls":"Account","slug":"exabyte"},"scaledHash":"5bd4eb168e3530628eb1295d88221cbb","schemaVersion":"0.2.0","slug":"silicon-fcc","unitCellFormula":"Si2","updatedAt":"2016-04-04T17:58:42.867Z"}}],"direction":"z"},{"merge_components":[{"stack_components":[{"crystal":{"_id":"LCthJ6E2QabYCZqf3","basis":{"coordinates":[{"id":1,"value":[0,0,0]},{"id":2,"value":[0.25,0.25,0.25]}],"elements":[{"id":1,"value":"Si"},{"id":2,"value":"Si"}],"name":"basis","units":"crystal"},"createdAt":"2016-04-03T05:25:37.430Z","creator":{"_id":"HtxACY2wX4b2hS8Rv","cls":"User","slug":"exadmin"},"derivedProperties":[{"name":"volume","units":"angstrom^3","value":131.1},{"name":"density","units":"g/cm^3","value":2.33},{"name":"symmetry","spaceGroupSymbol":"Fd-3m","tolerance":{"units":"angstrom","value":0.3}},{"degree":10,"name":"p-norm","value":0.71},{"element":"Si","name":"elemental_ratio","value":0.71},{"name":"inchi","value":""},{"name":"inchi_key","value":""}],"exabyteId":"RKiswuxHKkF3uvLyA","formula":"Si","hash":"4ac3fa057e3530628eb1295c77110eaa","isDefault":false,"isNonPeriodic":false,"lattice":{"name":"lattice","a":5.14,"alpha":90,"b":5.14,"beta":90,"c":5.14,"gamma":90,"type":"CUB","units":{"angle":"degree","length":"angstrom"},"vectors":{"a":[5,0.000121312,0.000131415],"alat":1,"b":[0.000121312,5,0.000121314],"c":[0.000121313,0.000121312,5],"units":"angstrom"}},"name":"Silicon FCC","owner":{"_id":"HtxACY2wX4b2hS8Rv","cls":"Account","slug":"exabyte"},"scaledHash":"5bd4eb168e3530628eb1295d88221cbb","schemaVersion":"0.2.0","slug":"silicon-fcc","unitCellFormula":"Si2","updatedAt":"2016-04-04T17:58:42.867Z"},"miller_indices":[0,0,1],"use_conventional_cell":true,"termination_top":{"chemical_elements":"Si","space_group_symmetry_label":"P4/mmm_2"},"number_of_repetitions":5},{"direction":"z","size":10,"crystal":{"_id":"LCthJ6E2QabYCZqf3","basis":{"coordinates":[{"id":1,"value":[0,0,0]},{"id":2,"value":[0.25,0.25,0.25]}],"elements":[{"id":1,"value":"Si"},{"id":2,"value":"Si"}],"name":"basis","units":"crystal"},"createdAt":"2016-04-03T05:25:37.430Z","creator":{"_id":"HtxACY2wX4b2hS8Rv","cls":"User","slug":"exadmin"},"derivedProperties":[{"name":"volume","units":"angstrom^3","value":131.1},{"name":"density","units":"g/cm^3","value":2.33},{"name":"symmetry","spaceGroupSymbol":"Fd-3m","tolerance":{"units":"angstrom","value":0.3}},{"degree":10,"name":"p-norm","value":0.71},{"element":"Si","name":"elemental_ratio","value":0.71},{"name":"inchi","value":""},{"name":"inchi_key","value":""}],"exabyteId":"RKiswuxHKkF3uvLyA","formula":"Si","hash":"4ac3fa057e3530628eb1295c77110eaa","isDefault":false,"isNonPeriodic":false,"lattice":{"name":"lattice","a":5.14,"alpha":90,"b":5.14,"beta":90,"c":5.14,"gamma":90,"type":"CUB","units":{"angle":"degree","length":"angstrom"},"vectors":{"a":[5,0.000121312,0.000131415],"alat":1,"b":[0.000121312,5,0.000121314],"c":[0.000121313,0.000121312,5],"units":"angstrom"}},"name":"Silicon FCC","owner":{"_id":"HtxACY2wX4b2hS8Rv","cls":"Account","slug":"exabyte"},"scaledHash":"5bd4eb168e3530628eb1295d88221cbb","schemaVersion":"0.2.0","slug":"silicon-fcc","unitCellFormula":"Si2","updatedAt":"2016-04-04T17:58:42.867Z"}}],"direction":"z"},{"crystal":{"_id":"LCthJ6E2QabYCZqf3","basis":{"coordinates":[{"id":1,"value":[0,0,0]},{"id":2,"value":[0.25,0.25,0.25]}],"elements":[{"id":1,"value":"Si"},{"id":2,"value":"Si"}],"name":"basis","units":"crystal"},"createdAt":"2016-04-03T05:25:37.430Z","creator":{"_id":"HtxACY2wX4b2hS8Rv","cls":"User","slug":"exadmin"},"derivedProperties":[{"name":"volume","units":"angstrom^3","value":131.1},{"name":"density","units":"g/cm^3","value":2.33},{"name":"symmetry","spaceGroupSymbol":"Fd-3m","tolerance":{"units":"angstrom","value":0.3}},{"degree":10,"name":"p-norm","value":0.71},{"element":"Si","name":"elemental_ratio","value":0.71},{"name":"inchi","value":""},{"name":"inchi_key","value":""}],"exabyteId":"RKiswuxHKkF3uvLyA","formula":"Si","hash":"4ac3fa057e3530628eb1295c77110eaa","isDefault":false,"isNonPeriodic":false,"lattice":{"name":"lattice","a":5.14,"alpha":90,"b":5.14,"beta":90,"c":5.14,"gamma":90,"type":"CUB","units":{"angle":"degree","length":"angstrom"},"vectors":{"a":[5,0.000121312,0.000131415],"alat":1,"b":[0.000121312,5,0.000121314],"c":[0.000121313,0.000121312,5],"units":"angstrom"}},"name":"Silicon FCC","owner":{"_id":"HtxACY2wX4b2hS8Rv","cls":"Account","slug":"exabyte"},"scaledHash":"5bd4eb168e3530628eb1295d88221cbb","schemaVersion":"0.2.0","slug":"silicon-fcc","unitCellFormula":"Si2","updatedAt":"2016-04-04T17:58:42.867Z"},"coordinate_condition":{"shape":"box","min_coordinate":[0,0,0],"max_coordinate":[0.7,0.7,0.7]}}],"merge_method":"REPLACE"},{"direction":"z","size":10,"crystal":{"_id":"LCthJ6E2QabYCZqf3","basis":{"coordinates":[{"id":1,"value":[0,0,0]},{"id":2,"value":[0.25,0.25,0.25]}],"elements":[{"id":1,"value":"Si"},{"id":2,"value":"Si"}],"name":"basis","units":"crystal"},"createdAt":"2016-04-03T05:25:37.430Z","creator":{"_id":"HtxACY2wX4b2hS8Rv","cls":"User","slug":"exadmin"},"derivedProperties":[{"name":"volume","units":"angstrom^3","value":131.1},{"name":"density","units":"g/cm^3","value":2.33},{"name":"symmetry","spaceGroupSymbol":"Fd-3m","tolerance":{"units":"angstrom","value":0.3}},{"degree":10,"name":"p-norm","value":0.71},{"element":"Si","name":"elemental_ratio","value":0.71},{"name":"inchi","value":""},{"name":"inchi_key","value":""}],"exabyteId":"RKiswuxHKkF3uvLyA","formula":"Si","hash":"4ac3fa057e3530628eb1295c77110eaa","isDefault":false,"isNonPeriodic":false,"lattice":{"name":"lattice","a":5.14,"alpha":90,"b":5.14,"beta":90,"c":5.14,"gamma":90,"type":"CUB","units":{"angle":"degree","length":"angstrom"},"vectors":{"a":[5,0.000121312,0.000131415],"alat":1,"b":[0.000121312,5,0.000121314],"c":[0.000121313,0.000121312,5],"units":"angstrom"}},"name":"Silicon FCC","owner":{"_id":"HtxACY2wX4b2hS8Rv","cls":"Account","slug":"exabyte"},"scaledHash":"5bd4eb168e3530628eb1295d88221cbb","schemaVersion":"0.2.0","slug":"silicon-fcc","unitCellFormula":"Si2","updatedAt":"2016-04-04T17:58:42.867Z"}}],"direction":"z","cut_direction":[0,1,0]},"path":"materials_category/defective_structures/two-dimensional/terrace/configuration"},{"data":{"merge_components":[{"_id":"LCthJ6E2QabYCZqf3","basis":{"coordinates":[{"id":1,"value":[0,0,0]},{"id":2,"value":[0.25,0.25,0.25]}],"elements":[{"id":1,"value":"Si"},{"id":2,"value":"Si"}],"name":"basis","units":"crystal"},"createdAt":"2016-04-03T05:25:37.430Z","creator":{"_id":"HtxACY2wX4b2hS8Rv","cls":"User","slug":"exadmin"},"derivedProperties":[{"name":"volume","units":"angstrom^3","value":131.1},{"name":"density","units":"g/cm^3","value":2.33},{"name":"symmetry","spaceGroupSymbol":"Fd-3m","tolerance":{"units":"angstrom","value":0.3}},{"degree":10,"name":"p-norm","value":0.71},{"element":"Si","name":"elemental_ratio","value":0.71},{"name":"inchi","value":""},{"name":"inchi_key","value":""}],"exabyteId":"RKiswuxHKkF3uvLyA","formula":"Si","hash":"4ac3fa057e3530628eb1295c77110eaa","isDefault":false,"isNonPeriodic":false,"lattice":{"name":"lattice","a":5.14,"alpha":90,"b":5.14,"beta":90,"c":5.14,"gamma":90,"type":"CUB","units":{"angle":"degree","length":"angstrom"},"vectors":{"a":[5,0.000121312,0.000131415],"alat":1,"b":[0.000121312,5,0.000121314],"c":[0.000121313,0.000121312,5],"units":"angstrom"}},"name":"Silicon FCC","owner":{"_id":"HtxACY2wX4b2hS8Rv","cls":"Account","slug":"exabyte"},"scaledHash":"5bd4eb168e3530628eb1295d88221cbb","schemaVersion":"0.2.0","slug":"silicon-fcc","unitCellFormula":"Si2","updatedAt":"2016-04-04T17:58:42.867Z"},{"crystal":{"_id":"LCthJ6E2QabYCZqf3","basis":{"coordinates":[{"id":1,"value":[0,0,0]},{"id":2,"value":[0.25,0.25,0.25]}],"elements":[{"id":1,"value":"Si"},{"id":2,"value":"Si"}],"name":"basis","units":"crystal"},"createdAt":"2016-04-03T05:25:37.430Z","creator":{"_id":"HtxACY2wX4b2hS8Rv","cls":"User","slug":"exadmin"},"derivedProperties":[{"name":"volume","units":"angstrom^3","value":131.1},{"name":"density","units":"g/cm^3","value":2.33},{"name":"symmetry","spaceGroupSymbol":"Fd-3m","tolerance":{"units":"angstrom","value":0.3}},{"degree":10,"name":"p-norm","value":0.71},{"element":"Si","name":"elemental_ratio","value":0.71},{"name":"inchi","value":""},{"name":"inchi_key","value":""}],"exabyteId":"RKiswuxHKkF3uvLyA","formula":"Si","hash":"4ac3fa057e3530628eb1295c77110eaa","isDefault":false,"isNonPeriodic":false,"lattice":{"name":"lattice","a":5.14,"alpha":90,"b":5.14,"beta":90,"c":5.14,"gamma":90,"type":"CUB","units":{"angle":"degree","length":"angstrom"},"vectors":{"a":[5,0.000121312,0.000131415],"alat":1,"b":[0.000121312,5,0.000121314],"c":[0.000121313,0.000121312,5],"units":"angstrom"}},"name":"Silicon FCC","owner":{"_id":"HtxACY2wX4b2hS8Rv","cls":"Account","slug":"exabyte"},"scaledHash":"5bd4eb168e3530628eb1295d88221cbb","schemaVersion":"0.2.0","slug":"silicon-fcc","unitCellFormula":"Si2","updatedAt":"2016-04-04T17:58:42.867Z"},"coordinate":[0.25,0.25,0.25],"element":{"chemical_element":"B"}}],"merge_method":"REPLACE"},"path":"materials_category/defective_structures/zero-dimensional/point_defect/base_configuration"},{"data":{"merge_components":[{"_id":"LCthJ6E2QabYCZqf3","basis":{"coordinates":[{"id":1,"value":[0,0,0]},{"id":2,"value":[0.25,0.25,0.25]}],"elements":[{"id":1,"value":"Si"},{"id":2,"value":"Si"}],"name":"basis","units":"crystal"},"createdAt":"2016-04-03T05:25:37.430Z","creator":{"_id":"HtxACY2wX4b2hS8Rv","cls":"User","slug":"exadmin"},"derivedProperties":[{"name":"volume","units":"angstrom^3","value":131.1},{"name":"density","units":"g/cm^3","value":2.33},{"name":"symmetry","spaceGroupSymbol":"Fd-3m","tolerance":{"units":"angstrom","value":0.3}},{"degree":10,"name":"p-norm","value":0.71},{"element":"Si","name":"elemental_ratio","value":0.71},{"name":"inchi","value":""},{"name":"inchi_key","value":""}],"exabyteId":"RKiswuxHKkF3uvLyA","formula":"Si","hash":"4ac3fa057e3530628eb1295c77110eaa","isDefault":false,"isNonPeriodic":false,"lattice":{"name":"lattice","a":5.14,"alpha":90,"b":5.14,"beta":90,"c":5.14,"gamma":90,"type":"CUB","units":{"angle":"degree","length":"angstrom"},"vectors":{"a":[5,0.000121312,0.000131415],"alat":1,"b":[0.000121312,5,0.000121314],"c":[0.000121313,0.000121312,5],"units":"angstrom"}},"name":"Silicon FCC","owner":{"_id":"HtxACY2wX4b2hS8Rv","cls":"Account","slug":"exabyte"},"scaledHash":"5bd4eb168e3530628eb1295d88221cbb","schemaVersion":"0.2.0","slug":"silicon-fcc","unitCellFormula":"Si2","updatedAt":"2016-04-04T17:58:42.867Z"},{"crystal":{"_id":"LCthJ6E2QabYCZqf3","basis":{"coordinates":[{"id":1,"value":[0,0,0]},{"id":2,"value":[0.25,0.25,0.25]}],"elements":[{"id":1,"value":"Si"},{"id":2,"value":"Si"}],"name":"basis","units":"crystal"},"createdAt":"2016-04-03T05:25:37.430Z","creator":{"_id":"HtxACY2wX4b2hS8Rv","cls":"User","slug":"exadmin"},"derivedProperties":[{"name":"volume","units":"angstrom^3","value":131.1},{"name":"density","units":"g/cm^3","value":2.33},{"name":"symmetry","spaceGroupSymbol":"Fd-3m","tolerance":{"units":"angstrom","value":0.3}},{"degree":10,"name":"p-norm","value":0.71},{"element":"Si","name":"elemental_ratio","value":0.71},{"name":"inchi","value":""},{"name":"inchi_key","value":""}],"exabyteId":"RKiswuxHKkF3uvLyA","formula":"Si","hash":"4ac3fa057e3530628eb1295c77110eaa","isDefault":false,"isNonPeriodic":false,"lattice":{"name":"lattice","a":5.14,"alpha":90,"b":5.14,"beta":90,"c":5.14,"gamma":90,"type":"CUB","units":{"angle":"degree","length":"angstrom"},"vectors":{"a":[5,0.000121312,0.000131415],"alat":1,"b":[0.000121312,5,0.000121314],"c":[0.000121313,0.000121312,5],"units":"angstrom"}},"name":"Silicon FCC","owner":{"_id":"HtxACY2wX4b2hS8Rv","cls":"Account","slug":"exabyte"},"scaledHash":"5bd4eb168e3530628eb1295d88221cbb","schemaVersion":"0.2.0","slug":"silicon-fcc","unitCellFormula":"Si2","updatedAt":"2016-04-04T17:58:42.867Z"},"coordinate":[0.5,0.5,0.5],"element":{"chemical_element":"B"}}],"merge_method":"REPLACE"},"path":"materials_category/defective_structures/zero-dimensional/point_defect/interstitial"},{"data":{"merge_components":[{"_id":"LCthJ6E2QabYCZqf3","basis":{"coordinates":[{"id":1,"value":[0,0,0]},{"id":2,"value":[0.25,0.25,0.25]}],"elements":[{"id":1,"value":"Si"},{"id":2,"value":"Si"}],"name":"basis","units":"crystal"},"createdAt":"2016-04-03T05:25:37.430Z","creator":{"_id":"HtxACY2wX4b2hS8Rv","cls":"User","slug":"exadmin"},"derivedProperties":[{"name":"volume","units":"angstrom^3","value":131.1},{"name":"density","units":"g/cm^3","value":2.33},{"name":"symmetry","spaceGroupSymbol":"Fd-3m","tolerance":{"units":"angstrom","value":0.3}},{"degree":10,"name":"p-norm","value":0.71},{"element":"Si","name":"elemental_ratio","value":0.71},{"name":"inchi","value":""},{"name":"inchi_key","value":""}],"exabyteId":"RKiswuxHKkF3uvLyA","formula":"Si","hash":"4ac3fa057e3530628eb1295c77110eaa","isDefault":false,"isNonPeriodic":false,"lattice":{"name":"lattice","a":5.14,"alpha":90,"b":5.14,"beta":90,"c":5.14,"gamma":90,"type":"CUB","units":{"angle":"degree","length":"angstrom"},"vectors":{"a":[5,0.000121312,0.000131415],"alat":1,"b":[0.000121312,5,0.000121314],"c":[0.000121313,0.000121312,5],"units":"angstrom"}},"name":"Silicon FCC","owner":{"_id":"HtxACY2wX4b2hS8Rv","cls":"Account","slug":"exabyte"},"scaledHash":"5bd4eb168e3530628eb1295d88221cbb","schemaVersion":"0.2.0","slug":"silicon-fcc","unitCellFormula":"Si2","updatedAt":"2016-04-04T17:58:42.867Z"},{"crystal":{"_id":"LCthJ6E2QabYCZqf3","basis":{"coordinates":[{"id":1,"value":[0,0,0]},{"id":2,"value":[0.25,0.25,0.25]}],"elements":[{"id":1,"value":"Si"},{"id":2,"value":"Si"}],"name":"basis","units":"crystal"},"createdAt":"2016-04-03T05:25:37.430Z","creator":{"_id":"HtxACY2wX4b2hS8Rv","cls":"User","slug":"exadmin"},"derivedProperties":[{"name":"volume","units":"angstrom^3","value":131.1},{"name":"density","units":"g/cm^3","value":2.33},{"name":"symmetry","spaceGroupSymbol":"Fd-3m","tolerance":{"units":"angstrom","value":0.3}},{"degree":10,"name":"p-norm","value":0.71},{"element":"Si","name":"elemental_ratio","value":0.71},{"name":"inchi","value":""},{"name":"inchi_key","value":""}],"exabyteId":"RKiswuxHKkF3uvLyA","formula":"Si","hash":"4ac3fa057e3530628eb1295c77110eaa","isDefault":false,"isNonPeriodic":false,"lattice":{"name":"lattice","a":5.14,"alpha":90,"b":5.14,"beta":90,"c":5.14,"gamma":90,"type":"CUB","units":{"angle":"degree","length":"angstrom"},"vectors":{"a":[5,0.000121312,0.000131415],"alat":1,"b":[0.000121312,5,0.000121314],"c":[0.000121313,0.000121312,5],"units":"angstrom"}},"name":"Silicon FCC","owner":{"_id":"HtxACY2wX4b2hS8Rv","cls":"Account","slug":"exabyte"},"scaledHash":"5bd4eb168e3530628eb1295d88221cbb","schemaVersion":"0.2.0","slug":"silicon-fcc","unitCellFormula":"Si2","updatedAt":"2016-04-04T17:58:42.867Z"},"coordinate":[0.25,0.25,0.25],"element":{"chemical_element":"B"}}],"merge_method":"REPLACE"},"path":"materials_category/defective_structures/zero-dimensional/point_defect/substitutional"},{"data":{"merge_components":[{"_id":"LCthJ6E2QabYCZqf3","basis":{"coordinates":[{"id":1,"value":[0,0,0]},{"id":2,"value":[0.25,0.25,0.25]}],"elements":[{"id":1,"value":"Si"},{"id":2,"value":"Si"}],"name":"basis","units":"crystal"},"createdAt":"2016-04-03T05:25:37.430Z","creator":{"_id":"HtxACY2wX4b2hS8Rv","cls":"User","slug":"exadmin"},"derivedProperties":[{"name":"volume","units":"angstrom^3","value":131.1},{"name":"density","units":"g/cm^3","value":2.33},{"name":"symmetry","spaceGroupSymbol":"Fd-3m","tolerance":{"units":"angstrom","value":0.3}},{"degree":10,"name":"p-norm","value":0.71},{"element":"Si","name":"elemental_ratio","value":0.71},{"name":"inchi","value":""},{"name":"inchi_key","value":""}],"exabyteId":"RKiswuxHKkF3uvLyA","formula":"Si","hash":"4ac3fa057e3530628eb1295c77110eaa","isDefault":false,"isNonPeriodic":false,"lattice":{"name":"lattice","a":5.14,"alpha":90,"b":5.14,"beta":90,"c":5.14,"gamma":90,"type":"CUB","units":{"angle":"degree","length":"angstrom"},"vectors":{"a":[5,0.000121312,0.000131415],"alat":1,"b":[0.000121312,5,0.000121314],"c":[0.000121313,0.000121312,5],"units":"angstrom"}},"name":"Silicon FCC","owner":{"_id":"HtxACY2wX4b2hS8Rv","cls":"Account","slug":"exabyte"},"scaledHash":"5bd4eb168e3530628eb1295d88221cbb","schemaVersion":"0.2.0","slug":"silicon-fcc","unitCellFormula":"Si2","updatedAt":"2016-04-04T17:58:42.867Z"},{"chemical_element":"Vac"}],"merge_method":"REPLACE"},"path":"materials_category/defective_structures/zero-dimensional/point_defect/vacancy"},{"data":{"stack_components":[{"stack_components":[{"crystal":{"_id":"LCthJ6E2QabYCZqf3","basis":{"coordinates":[{"id":1,"value":[0,0,0]},{"id":2,"value":[0.25,0.25,0.25]}],"elements":[{"id":1,"value":"Si"},{"id":2,"value":"Si"}],"name":"basis","units":"crystal"},"createdAt":"2016-04-03T05:25:37.430Z","creator":{"_id":"HtxACY2wX4b2hS8Rv","cls":"User","slug":"exadmin"},"derivedProperties":[{"name":"volume","units":"angstrom^3","value":131.1},{"name":"density","units":"g/cm^3","value":2.33},{"name":"symmetry","spaceGroupSymbol":"Fd-3m","tolerance":{"units":"angstrom","value":0.3}},{"degree":10,"name":"p-norm","value":0.71},{"element":"Si","name":"elemental_ratio","value":0.71},{"name":"inchi","value":""},{"name":"inchi_key","value":""}],"exabyteId":"RKiswuxHKkF3uvLyA","formula":"Si","hash":"4ac3fa057e3530628eb1295c77110eaa","isDefault":false,"isNonPeriodic":false,"lattice":{"name":"lattice","a":5.14,"alpha":90,"b":5.14,"beta":90,"c":5.14,"gamma":90,"type":"CUB","units":{"angle":"degree","length":"angstrom"},"vectors":{"a":[5,0.000121312,0.000131415],"alat":1,"b":[0.000121312,5,0.000121314],"c":[0.000121313,0.000121312,5],"units":"angstrom"}},"name":"Silicon FCC","owner":{"_id":"HtxACY2wX4b2hS8Rv","cls":"Account","slug":"exabyte"},"scaledHash":"5bd4eb168e3530628eb1295d88221cbb","schemaVersion":"0.2.0","slug":"silicon-fcc","unitCellFormula":"Si2","updatedAt":"2016-04-04T17:58:42.867Z"},"miller_indices_2d":[1,1],"use_conventional_cell":true,"termination_top":{"chemical_elements":"Si","space_group_symmetry_label":"p1"},"termination_bottom":{"chemical_elements":"Si","space_group_symmetry_label":"p1"},"number_of_repetitions_width":3,"number_of_repetitions_length":5},{"direction":"y","size":15,"crystal":{"_id":"LCthJ6E2QabYCZqf3","basis":{"coordinates":[{"id":1,"value":[0,0,0]},{"id":2,"value":[0.25,0.25,0.25]}],"elements":[{"id":1,"value":"Si"},{"id":2,"value":"Si"}],"name":"basis","units":"crystal"},"createdAt":"2016-04-03T05:25:37.430Z","creator":{"_id":"HtxACY2wX4b2hS8Rv","cls":"User","slug":"exadmin"},"derivedProperties":[{"name":"volume","units":"angstrom^3","value":131.1},{"name":"density","units":"g/cm^3","value":2.33},{"name":"symmetry","spaceGroupSymbol":"Fd-3m","tolerance":{"units":"angstrom","value":0.3}},{"degree":10,"name":"p-norm","value":0.71},{"element":"Si","name":"elemental_ratio","value":0.71},{"name":"inchi","value":""},{"name":"inchi_key","value":""}],"exabyteId":"RKiswuxHKkF3uvLyA","formula":"Si","hash":"4ac3fa057e3530628eb1295c77110eaa","isDefault":false,"isNonPeriodic":false,"lattice":{"name":"lattice","a":5.14,"alpha":90,"b":5.14,"beta":90,"c":5.14,"gamma":90,"type":"CUB","units":{"angle":"degree","length":"angstrom"},"vectors":{"a":[5,0.000121312,0.000131415],"alat":1,"b":[0.000121312,5,0.000121314],"c":[0.000121313,0.000121312,5],"units":"angstrom"}},"name":"Silicon FCC","owner":{"_id":"HtxACY2wX4b2hS8Rv","cls":"Account","slug":"exabyte"},"scaledHash":"5bd4eb168e3530628eb1295d88221cbb","schemaVersion":"0.2.0","slug":"silicon-fcc","unitCellFormula":"Si2","updatedAt":"2016-04-04T17:58:42.867Z"}}],"direction":"y"},{"direction":"x","size":20,"crystal":{"_id":"LCthJ6E2QabYCZqf3","basis":{"coordinates":[{"id":1,"value":[0,0,0]},{"id":2,"value":[0.25,0.25,0.25]}],"elements":[{"id":1,"value":"Si"},{"id":2,"value":"Si"}],"name":"basis","units":"crystal"},"createdAt":"2016-04-03T05:25:37.430Z","creator":{"_id":"HtxACY2wX4b2hS8Rv","cls":"User","slug":"exadmin"},"derivedProperties":[{"name":"volume","units":"angstrom^3","value":131.1},{"name":"density","units":"g/cm^3","value":2.33},{"name":"symmetry","spaceGroupSymbol":"Fd-3m","tolerance":{"units":"angstrom","value":0.3}},{"degree":10,"name":"p-norm","value":0.71},{"element":"Si","name":"elemental_ratio","value":0.71},{"name":"inchi","value":""},{"name":"inchi_key","value":""}],"exabyteId":"RKiswuxHKkF3uvLyA","formula":"Si","hash":"4ac3fa057e3530628eb1295c77110eaa","isDefault":false,"isNonPeriodic":false,"lattice":{"name":"lattice","a":5.14,"alpha":90,"b":5.14,"beta":90,"c":5.14,"gamma":90,"type":"CUB","units":{"angle":"degree","length":"angstrom"},"vectors":{"a":[5,0.000121312,0.000131415],"alat":1,"b":[0.000121312,5,0.000121314],"c":[0.000121313,0.000121312,5],"units":"angstrom"}},"name":"Silicon FCC","owner":{"_id":"HtxACY2wX4b2hS8Rv","cls":"Account","slug":"exabyte"},"scaledHash":"5bd4eb168e3530628eb1295d88221cbb","schemaVersion":"0.2.0","slug":"silicon-fcc","unitCellFormula":"Si2","updatedAt":"2016-04-04T17:58:42.867Z"}}],"direction":"x"},"path":"materials_category/pristine_structures/two-dimensional/nanoribbon"},{"data":{"stack_components":[{"crystal":{"_id":"LCthJ6E2QabYCZqf3","basis":{"coordinates":[{"id":1,"value":[0,0,0]},{"id":2,"value":[0.25,0.25,0.25]}],"elements":[{"id":1,"value":"Si"},{"id":2,"value":"Si"}],"name":"basis","units":"crystal"},"createdAt":"2016-04-03T05:25:37.430Z","creator":{"_id":"HtxACY2wX4b2hS8Rv","cls":"User","slug":"exadmin"},"derivedProperties":[{"name":"volume","units":"angstrom^3","value":131.1},{"name":"density","units":"g/cm^3","value":2.33},{"name":"symmetry","spaceGroupSymbol":"Fd-3m","tolerance":{"units":"angstrom","value":0.3}},{"degree":10,"name":"p-norm","value":0.71},{"element":"Si","name":"elemental_ratio","value":0.71},{"name":"inchi","value":""},{"name":"inchi_key","value":""}],"exabyteId":"RKiswuxHKkF3uvLyA","formula":"Si","hash":"4ac3fa057e3530628eb1295c77110eaa","isDefault":false,"isNonPeriodic":false,"lattice":{"name":"lattice","a":5.14,"alpha":90,"b":5.14,"beta":90,"c":5.14,"gamma":90,"type":"CUB","units":{"angle":"degree","length":"angstrom"},"vectors":{"a":[5,0.000121312,0.000131415],"alat":1,"b":[0.000121312,5,0.000121314],"c":[0.000121313,0.000121312,5],"units":"angstrom"}},"name":"Silicon FCC","owner":{"_id":"HtxACY2wX4b2hS8Rv","cls":"Account","slug":"exabyte"},"scaledHash":"5bd4eb168e3530628eb1295d88221cbb","schemaVersion":"0.2.0","slug":"silicon-fcc","unitCellFormula":"Si2","updatedAt":"2016-04-04T17:58:42.867Z"},"miller_indices_2d":[1,1],"use_conventional_cell":true,"termination_top":{"chemical_elements":"Si","space_group_symmetry_label":"p1"},"termination_bottom":{"chemical_elements":"Si","space_group_symmetry_label":"p1"},"number_of_repetitions_width":3,"number_of_repetitions_length":5},{"direction":"y","size":15,"crystal":{"_id":"LCthJ6E2QabYCZqf3","basis":{"coordinates":[{"id":1,"value":[0,0,0]},{"id":2,"value":[0.25,0.25,0.25]}],"elements":[{"id":1,"value":"Si"},{"id":2,"value":"Si"}],"name":"basis","units":"crystal"},"createdAt":"2016-04-03T05:25:37.430Z","creator":{"_id":"HtxACY2wX4b2hS8Rv","cls":"User","slug":"exadmin"},"derivedProperties":[{"name":"volume","units":"angstrom^3","value":131.1},{"name":"density","units":"g/cm^3","value":2.33},{"name":"symmetry","spaceGroupSymbol":"Fd-3m","tolerance":{"units":"angstrom","value":0.3}},{"degree":10,"name":"p-norm","value":0.71},{"element":"Si","name":"elemental_ratio","value":0.71},{"name":"inchi","value":""},{"name":"inchi_key","value":""}],"exabyteId":"RKiswuxHKkF3uvLyA","formula":"Si","hash":"4ac3fa057e3530628eb1295c77110eaa","isDefault":false,"isNonPeriodic":false,"lattice":{"name":"lattice","a":5.14,"alpha":90,"b":5.14,"beta":90,"c":5.14,"gamma":90,"type":"CUB","units":{"angle":"degree","length":"angstrom"},"vectors":{"a":[5,0.000121312,0.000131415],"alat":1,"b":[0.000121312,5,0.000121314],"c":[0.000121313,0.000121312,5],"units":"angstrom"}},"name":"Silicon FCC","owner":{"_id":"HtxACY2wX4b2hS8Rv","cls":"Account","slug":"exabyte"},"scaledHash":"5bd4eb168e3530628eb1295d88221cbb","schemaVersion":"0.2.0","slug":"silicon-fcc","unitCellFormula":"Si2","updatedAt":"2016-04-04T17:58:42.867Z"}}],"direction":"y"},"path":"materials_category/pristine_structures/two-dimensional/nanotape"},{"data":{"stack_components":[{"crystal":{"_id":"LCthJ6E2QabYCZqf3","basis":{"coordinates":[{"id":1,"value":[0,0,0]},{"id":2,"value":[0.25,0.25,0.25]}],"elements":[{"id":1,"value":"Si"},{"id":2,"value":"Si"}],"name":"basis","units":"crystal"},"createdAt":"2016-04-03T05:25:37.430Z","creator":{"_id":"HtxACY2wX4b2hS8Rv","cls":"User","slug":"exadmin"},"derivedProperties":[{"name":"volume","units":"angstrom^3","value":131.1},{"name":"density","units":"g/cm^3","value":2.33},{"name":"symmetry","spaceGroupSymbol":"Fd-3m","tolerance":{"units":"angstrom","value":0.3}},{"degree":10,"name":"p-norm","value":0.71},{"element":"Si","name":"elemental_ratio","value":0.71},{"name":"inchi","value":""},{"name":"inchi_key","value":""}],"exabyteId":"RKiswuxHKkF3uvLyA","formula":"Si","hash":"4ac3fa057e3530628eb1295c77110eaa","isDefault":false,"isNonPeriodic":false,"lattice":{"name":"lattice","a":5.14,"alpha":90,"b":5.14,"beta":90,"c":5.14,"gamma":90,"type":"CUB","units":{"angle":"degree","length":"angstrom"},"vectors":{"a":[5,0.000121312,0.000131415],"alat":1,"b":[0.000121312,5,0.000121314],"c":[0.000121313,0.000121312,5],"units":"angstrom"}},"name":"Silicon FCC","owner":{"_id":"HtxACY2wX4b2hS8Rv","cls":"Account","slug":"exabyte"},"scaledHash":"5bd4eb168e3530628eb1295d88221cbb","schemaVersion":"0.2.0","slug":"silicon-fcc","unitCellFormula":"Si2","updatedAt":"2016-04-04T17:58:42.867Z"},"miller_indices":[0,0,1],"use_conventional_cell":true,"termination_top":{"chemical_elements":"Si","space_group_symmetry_label":"P4/mmm_2"},"number_of_repetitions":5},{"direction":"z","size":10,"crystal":{"_id":"LCthJ6E2QabYCZqf3","basis":{"coordinates":[{"id":1,"value":[0,0,0]},{"id":2,"value":[0.25,0.25,0.25]}],"elements":[{"id":1,"value":"Si"},{"id":2,"value":"Si"}],"name":"basis","units":"crystal"},"createdAt":"2016-04-03T05:25:37.430Z","creator":{"_id":"HtxACY2wX4b2hS8Rv","cls":"User","slug":"exadmin"},"derivedProperties":[{"name":"volume","units":"angstrom^3","value":131.1},{"name":"density","units":"g/cm^3","value":2.33},{"name":"symmetry","spaceGroupSymbol":"Fd-3m","tolerance":{"units":"angstrom","value":0.3}},{"degree":10,"name":"p-norm","value":0.71},{"element":"Si","name":"elemental_ratio","value":0.71},{"name":"inchi","value":""},{"name":"inchi_key","value":""}],"exabyteId":"RKiswuxHKkF3uvLyA","formula":"Si","hash":"4ac3fa057e3530628eb1295c77110eaa","isDefault":false,"isNonPeriodic":false,"lattice":{"name":"lattice","a":5.14,"alpha":90,"b":5.14,"beta":90,"c":5.14,"gamma":90,"type":"CUB","units":{"angle":"degree","length":"angstrom"},"vectors":{"a":[5,0.000121312,0.000131415],"alat":1,"b":[0.000121312,5,0.000121314],"c":[0.000121313,0.000121312,5],"units":"angstrom"}},"name":"Silicon FCC","owner":{"_id":"HtxACY2wX4b2hS8Rv","cls":"Account","slug":"exabyte"},"scaledHash":"5bd4eb168e3530628eb1295d88221cbb","schemaVersion":"0.2.0","slug":"silicon-fcc","unitCellFormula":"Si2","updatedAt":"2016-04-04T17:58:42.867Z"}}],"direction":"z"},"path":"materials_category/pristine_structures/two-dimensional/slab"},{"data":{"stack_components":[{"crystal":{"_id":"LCthJ6E2QabYCZqf3","basis":{"coordinates":[{"id":1,"value":[0,0,0]},{"id":2,"value":[0.25,0.25,0.25]}],"elements":[{"id":1,"value":"Si"},{"id":2,"value":"Si"}],"name":"basis","units":"crystal"},"createdAt":"2016-04-03T05:25:37.430Z","creator":{"_id":"HtxACY2wX4b2hS8Rv","cls":"User","slug":"exadmin"},"derivedProperties":[{"name":"volume","units":"angstrom^3","value":131.1},{"name":"density","units":"g/cm^3","value":2.33},{"name":"symmetry","spaceGroupSymbol":"Fd-3m","tolerance":{"units":"angstrom","value":0.3}},{"degree":10,"name":"p-norm","value":0.71},{"element":"Si","name":"elemental_ratio","value":0.71},{"name":"inchi","value":""},{"name":"inchi_key","value":""}],"exabyteId":"RKiswuxHKkF3uvLyA","formula":"Si","hash":"4ac3fa057e3530628eb1295c77110eaa","isDefault":false,"isNonPeriodic":false,"lattice":{"name":"lattice","a":5.14,"alpha":90,"b":5.14,"beta":90,"c":5.14,"gamma":90,"type":"CUB","units":{"angle":"degree","length":"angstrom"},"vectors":{"a":[5,0.000121312,0.000131415],"alat":1,"b":[0.000121312,5,0.000121314],"c":[0.000121313,0.000121312,5],"units":"angstrom"}},"name":"Silicon FCC","owner":{"_id":"HtxACY2wX4b2hS8Rv","cls":"Account","slug":"exabyte"},"scaledHash":"5bd4eb168e3530628eb1295d88221cbb","schemaVersion":"0.2.0","slug":"silicon-fcc","unitCellFormula":"Si2","updatedAt":"2016-04-04T17:58:42.867Z"},"miller_indices":[0,0,1],"use_conventional_cell":true,"termination_top":{"chemical_elements":"Si","space_group_symmetry_label":"P4/mmm_2"},"number_of_repetitions":5},{"direction":"z","size":10,"crystal":{"_id":"LCthJ6E2QabYCZqf3","basis":{"coordinates":[{"id":1,"value":[0,0,0]},{"id":2,"value":[0.25,0.25,0.25]}],"elements":[{"id":1,"value":"Si"},{"id":2,"value":"Si"}],"name":"basis","units":"crystal"},"createdAt":"2016-04-03T05:25:37.430Z","creator":{"_id":"HtxACY2wX4b2hS8Rv","cls":"User","slug":"exadmin"},"derivedProperties":[{"name":"volume","units":"angstrom^3","value":131.1},{"name":"density","units":"g/cm^3","value":2.33},{"name":"symmetry","spaceGroupSymbol":"Fd-3m","tolerance":{"units":"angstrom","value":0.3}},{"degree":10,"name":"p-norm","value":0.71},{"element":"Si","name":"elemental_ratio","value":0.71},{"name":"inchi","value":""},{"name":"inchi_key","value":""}],"exabyteId":"RKiswuxHKkF3uvLyA","formula":"Si","hash":"4ac3fa057e3530628eb1295c77110eaa","isDefault":false,"isNonPeriodic":false,"lattice":{"name":"lattice","a":5.14,"alpha":90,"b":5.14,"beta":90,"c":5.14,"gamma":90,"type":"CUB","units":{"angle":"degree","length":"angstrom"},"vectors":{"a":[5,0.000121312,0.000131415],"alat":1,"b":[0.000121312,5,0.000121314],"c":[0.000121313,0.000121312,5],"units":"angstrom"}},"name":"Silicon FCC","owner":{"_id":"HtxACY2wX4b2hS8Rv","cls":"Account","slug":"exabyte"},"scaledHash":"5bd4eb168e3530628eb1295d88221cbb","schemaVersion":"0.2.0","slug":"silicon-fcc","unitCellFormula":"Si2","updatedAt":"2016-04-04T17:58:42.867Z"}}],"direction":"z","xy_supercell_matrix":[[2,0],[0,2]],"strain_matrix":[[1.02,0,0],[0,1.02,0],[0,0,1]]},"path":"materials_category/pristine_structures/two-dimensional/slab_strained_supercell"},{"data":{"merge_components":[{"_id":"LCthJ6E2QabYCZqf3","basis":{"coordinates":[{"id":1,"value":[0,0,0]},{"id":2,"value":[0.25,0.25,0.25]}],"elements":[{"id":1,"value":"Si"},{"id":2,"value":"Si"}],"name":"basis","units":"crystal"},"createdAt":"2016-04-03T05:25:37.430Z","creator":{"_id":"HtxACY2wX4b2hS8Rv","cls":"User","slug":"exadmin"},"derivedProperties":[{"name":"volume","units":"angstrom^3","value":131.1},{"name":"density","units":"g/cm^3","value":2.33},{"name":"symmetry","spaceGroupSymbol":"Fd-3m","tolerance":{"units":"angstrom","value":0.3}},{"degree":10,"name":"p-norm","value":0.71},{"element":"Si","name":"elemental_ratio","value":0.71},{"name":"inchi","value":""},{"name":"inchi_key","value":""}],"exabyteId":"RKiswuxHKkF3uvLyA","formula":"Si","hash":"4ac3fa057e3530628eb1295c77110eaa","isDefault":false,"isNonPeriodic":false,"lattice":{"name":"lattice","a":5.14,"alpha":90,"b":5.14,"beta":90,"c":5.14,"gamma":90,"type":"CUB","units":{"angle":"degree","length":"angstrom"},"vectors":{"a":[5,0.000121312,0.000131415],"alat":1,"b":[0.000121312,5,0.000121314],"c":[0.000121313,0.000121312,5],"units":"angstrom"}},"name":"Silicon FCC","owner":{"_id":"HtxACY2wX4b2hS8Rv","cls":"Account","slug":"exabyte"},"scaledHash":"5bd4eb168e3530628eb1295d88221cbb","schemaVersion":"0.2.0","slug":"silicon-fcc","unitCellFormula":"Si2","updatedAt":"2016-04-04T17:58:42.867Z"},{"crystal":{"_id":"LCthJ6E2QabYCZqf3","basis":{"coordinates":[{"id":1,"value":[0,0,0]},{"id":2,"value":[0.25,0.25,0.25]}],"elements":[{"id":1,"value":"Si"},{"id":2,"value":"Si"}],"name":"basis","units":"crystal"},"createdAt":"2016-04-03T05:25:37.430Z","creator":{"_id":"HtxACY2wX4b2hS8Rv","cls":"User","slug":"exadmin"},"derivedProperties":[{"name":"volume","units":"angstrom^3","value":131.1},{"name":"density","units":"g/cm^3","value":2.33},{"name":"symmetry","spaceGroupSymbol":"Fd-3m","tolerance":{"units":"angstrom","value":0.3}},{"degree":10,"name":"p-norm","value":0.71},{"element":"Si","name":"elemental_ratio","value":0.71},{"name":"inchi","value":""},{"name":"inchi_key","value":""}],"exabyteId":"RKiswuxHKkF3uvLyA","formula":"Si","hash":"4ac3fa057e3530628eb1295c77110eaa","isDefault":false,"isNonPeriodic":false,"lattice":{"name":"lattice","a":5.14,"alpha":90,"b":5.14,"beta":90,"c":5.14,"gamma":90,"type":"CUB","units":{"angle":"degree","length":"angstrom"},"vectors":{"a":[5,0.000121312,0.000131415],"alat":1,"b":[0.000121312,5,0.000121314],"c":[0.000121313,0.000121312,5],"units":"angstrom"}},"name":"Silicon FCC","owner":{"_id":"HtxACY2wX4b2hS8Rv","cls":"Account","slug":"exabyte"},"scaledHash":"5bd4eb168e3530628eb1295d88221cbb","schemaVersion":"0.2.0","slug":"silicon-fcc","unitCellFormula":"Si2","updatedAt":"2016-04-04T17:58:42.867Z"},"coordinate":[0.5,0.5,1.1],"element":{"chemical_element":"H"}},{"crystal":{"_id":"LCthJ6E2QabYCZqf3","basis":{"coordinates":[{"id":1,"value":[0,0,0]},{"id":2,"value":[0.25,0.25,0.25]}],"elements":[{"id":1,"value":"Si"},{"id":2,"value":"Si"}],"name":"basis","units":"crystal"},"createdAt":"2016-04-03T05:25:37.430Z","creator":{"_id":"HtxACY2wX4b2hS8Rv","cls":"User","slug":"exadmin"},"derivedProperties":[{"name":"volume","units":"angstrom^3","value":131.1},{"name":"density","units":"g/cm^3","value":2.33},{"name":"symmetry","spaceGroupSymbol":"Fd-3m","tolerance":{"units":"angstrom","value":0.3}},{"degree":10,"name":"p-norm","value":0.71},{"element":"Si","name":"elemental_ratio","value":0.71},{"name":"inchi","value":""},{"name":"inchi_key","value":""}],"exabyteId":"RKiswuxHKkF3uvLyA","formula":"Si","hash":"4ac3fa057e3530628eb1295c77110eaa","isDefault":false,"isNonPeriodic":false,"lattice":{"name":"lattice","a":5.14,"alpha":90,"b":5.14,"beta":90,"c":5.14,"gamma":90,"type":"CUB","units":{"angle":"degree","length":"angstrom"},"vectors":{"a":[5,0.000121312,0.000131415],"alat":1,"b":[0.000121312,5,0.000121314],"c":[0.000121313,0.000121312,5],"units":"angstrom"}},"name":"Silicon FCC","owner":{"_id":"HtxACY2wX4b2hS8Rv","cls":"Account","slug":"exabyte"},"scaledHash":"5bd4eb168e3530628eb1295d88221cbb","schemaVersion":"0.2.0","slug":"silicon-fcc","unitCellFormula":"Si2","updatedAt":"2016-04-04T17:58:42.867Z"},"coordinate":[0.3,0.7,1.1],"element":{"chemical_element":"H"}},{"crystal":{"_id":"LCthJ6E2QabYCZqf3","basis":{"coordinates":[{"id":1,"value":[0,0,0]},{"id":2,"value":[0.25,0.25,0.25]}],"elements":[{"id":1,"value":"Si"},{"id":2,"value":"Si"}],"name":"basis","units":"crystal"},"createdAt":"2016-04-03T05:25:37.430Z","creator":{"_id":"HtxACY2wX4b2hS8Rv","cls":"User","slug":"exadmin"},"derivedProperties":[{"name":"volume","units":"angstrom^3","value":131.1},{"name":"density","units":"g/cm^3","value":2.33},{"name":"symmetry","spaceGroupSymbol":"Fd-3m","tolerance":{"units":"angstrom","value":0.3}},{"degree":10,"name":"p-norm","value":0.71},{"element":"Si","name":"elemental_ratio","value":0.71},{"name":"inchi","value":""},{"name":"inchi_key","value":""}],"exabyteId":"RKiswuxHKkF3uvLyA","formula":"Si","hash":"4ac3fa057e3530628eb1295c77110eaa","isDefault":false,"isNonPeriodic":false,"lattice":{"name":"lattice","a":5.14,"alpha":90,"b":5.14,"beta":90,"c":5.14,"gamma":90,"type":"CUB","units":{"angle":"degree","length":"angstrom"},"vectors":{"a":[5,0.000121312,0.000131415],"alat":1,"b":[0.000121312,5,0.000121314],"c":[0.000121313,0.000121312,5],"units":"angstrom"}},"name":"Silicon FCC","owner":{"_id":"HtxACY2wX4b2hS8Rv","cls":"Account","slug":"exabyte"},"scaledHash":"5bd4eb168e3530628eb1295d88221cbb","schemaVersion":"0.2.0","slug":"silicon-fcc","unitCellFormula":"Si2","updatedAt":"2016-04-04T17:58:42.867Z"},"coordinate":[0.7,0.3,1.1],"element":{"chemical_element":"H"}}],"merge_method":"ADD","passivant":{"chemical_element":"H"},"bond_length":1},"path":"materials_category/processed_structures/two-dimensional/passivation/configuration"},{"data":[1,1],"path":"materials_category_components/entities/auxiliary/one-dimensional/miller_indices_2d"},{"data":[[2,0,0],[0,2,0],[0,0,2]],"path":"materials_category_components/entities/auxiliary/three-dimensional/supercell_matrix_3d"},{"data":[0,0,1],"path":"materials_category_components/entities/auxiliary/two-dimensional/miller_indices"},{"data":[[2,0],[0,2]],"path":"materials_category_components/entities/auxiliary/two-dimensional/supercell_matrix_2d"},{"data":{"chemical_elements":"Si","space_group_symmetry_label":"P4/mmm_2"},"path":"materials_category_components/entities/auxiliary/two-dimensional/termination"},{"data":{"crystal":{"_id":"LCthJ6E2QabYCZqf3","basis":{"coordinates":[{"id":1,"value":[0,0,0]},{"id":2,"value":[0.25,0.25,0.25]}],"elements":[{"id":1,"value":"Si"},{"id":2,"value":"Si"}],"name":"basis","units":"crystal"},"createdAt":"2016-04-03T05:25:37.430Z","creator":{"_id":"HtxACY2wX4b2hS8Rv","cls":"User","slug":"exadmin"},"derivedProperties":[{"name":"volume","units":"angstrom^3","value":131.1},{"name":"density","units":"g/cm^3","value":2.33},{"name":"symmetry","spaceGroupSymbol":"Fd-3m","tolerance":{"units":"angstrom","value":0.3}},{"degree":10,"name":"p-norm","value":0.71},{"element":"Si","name":"elemental_ratio","value":0.71},{"name":"inchi","value":""},{"name":"inchi_key","value":""}],"exabyteId":"RKiswuxHKkF3uvLyA","formula":"Si","hash":"4ac3fa057e3530628eb1295c77110eaa","isDefault":false,"isNonPeriodic":false,"lattice":{"name":"lattice","a":5.14,"alpha":90,"b":5.14,"beta":90,"c":5.14,"gamma":90,"type":"CUB","units":{"angle":"degree","length":"angstrom"},"vectors":{"a":[5,0.000121312,0.000131415],"alat":1,"b":[0.000121312,5,0.000121314],"c":[0.000121313,0.000121312,5],"units":"angstrom"}},"name":"Silicon FCC","owner":{"_id":"HtxACY2wX4b2hS8Rv","cls":"Account","slug":"exabyte"},"scaledHash":"5bd4eb168e3530628eb1295d88221cbb","schemaVersion":"0.2.0","slug":"silicon-fcc","unitCellFormula":"Si2","updatedAt":"2016-04-04T17:58:42.867Z"},"coordinate":[0.25,0.25,0.25]},"path":"materials_category_components/entities/auxiliary/zero-dimensional/crystal_site"},{"data":{"crystal":{"_id":"LCthJ6E2QabYCZqf3","basis":{"coordinates":[{"id":1,"value":[0,0,0]},{"id":2,"value":[0.25,0.25,0.25]}],"elements":[{"id":1,"value":"Si"},{"id":2,"value":"Si"}],"name":"basis","units":"crystal"},"createdAt":"2016-04-03T05:25:37.430Z","creator":{"_id":"HtxACY2wX4b2hS8Rv","cls":"User","slug":"exadmin"},"derivedProperties":[{"name":"volume","units":"angstrom^3","value":131.1},{"name":"density","units":"g/cm^3","value":2.33},{"name":"symmetry","spaceGroupSymbol":"Fd-3m","tolerance":{"units":"angstrom","value":0.3}},{"degree":10,"name":"p-norm","value":0.71},{"element":"Si","name":"elemental_ratio","value":0.71},{"name":"inchi","value":""},{"name":"inchi_key","value":""}],"exabyteId":"RKiswuxHKkF3uvLyA","formula":"Si","hash":"4ac3fa057e3530628eb1295c77110eaa","isDefault":false,"isNonPeriodic":false,"lattice":{"name":"lattice","a":5.14,"alpha":90,"b":5.14,"beta":90,"c":5.14,"gamma":90,"type":"CUB","units":{"angle":"degree","length":"angstrom"},"vectors":{"a":[5,0.000121312,0.000131415],"alat":1,"b":[0.000121312,5,0.000121314],"c":[0.000121313,0.000121312,5],"units":"angstrom"}},"name":"Silicon FCC","owner":{"_id":"HtxACY2wX4b2hS8Rv","cls":"Account","slug":"exabyte"},"scaledHash":"5bd4eb168e3530628eb1295d88221cbb","schemaVersion":"0.2.0","slug":"silicon-fcc","unitCellFormula":"Si2","updatedAt":"2016-04-04T17:58:42.867Z"},"coordinate":[0.25,0.25,0.25],"element":{"chemical_element":"B"}},"path":"materials_category_components/entities/auxiliary/zero-dimensional/point_defect_site"},{"data":{"_id":"LCthJ6E2QabYCZqf3","basis":{"coordinates":[{"id":1,"value":[0,0,0]},{"id":2,"value":[0.25,0.25,0.25]}],"elements":[{"id":1,"value":"Si"},{"id":2,"value":"Si"}],"name":"basis","units":"crystal"},"createdAt":"2016-04-03T05:25:37.430Z","creator":{"_id":"HtxACY2wX4b2hS8Rv","cls":"User","slug":"exadmin"},"derivedProperties":[{"name":"volume","units":"angstrom^3","value":131.1},{"name":"density","units":"g/cm^3","value":2.33},{"name":"symmetry","spaceGroupSymbol":"Fd-3m","tolerance":{"units":"angstrom","value":0.3}},{"degree":10,"name":"p-norm","value":0.71},{"element":"Si","name":"elemental_ratio","value":0.71},{"name":"inchi","value":""},{"name":"inchi_key","value":""}],"exabyteId":"RKiswuxHKkF3uvLyA","formula":"Si","hash":"4ac3fa057e3530628eb1295c77110eaa","isDefault":false,"isNonPeriodic":false,"lattice":{"name":"lattice","a":5.14,"alpha":90,"b":5.14,"beta":90,"c":5.14,"gamma":90,"type":"CUB","units":{"angle":"degree","length":"angstrom"},"vectors":{"a":[5,0.000121312,0.000131415],"alat":1,"b":[0.000121312,5,0.000121314],"c":[0.000121313,0.000121312,5],"units":"angstrom"}},"name":"Silicon FCC","owner":{"_id":"HtxACY2wX4b2hS8Rv","cls":"Account","slug":"exabyte"},"scaledHash":"5bd4eb168e3530628eb1295d88221cbb","schemaVersion":"0.2.0","slug":"silicon-fcc","unitCellFormula":"Si2","updatedAt":"2016-04-04T17:58:42.867Z"},"path":"materials_category_components/entities/core/three-dimensional/crystal"},{"data":{"center_coordinate":[0.5,0.5,0.5],"shape":{"shape":"box","min_coordinate":[0,0,0],"max_coordinate":[0.5,0.5,0.5]}},"path":"materials_category_components/entities/core/three-dimensional/void"},{"data":{"direction":"z","size":10,"crystal":{"_id":"LCthJ6E2QabYCZqf3","basis":{"coordinates":[{"id":1,"value":[0,0,0]},{"id":2,"value":[0.25,0.25,0.25]}],"elements":[{"id":1,"value":"Si"},{"id":2,"value":"Si"}],"name":"basis","units":"crystal"},"createdAt":"2016-04-03T05:25:37.430Z","creator":{"_id":"HtxACY2wX4b2hS8Rv","cls":"User","slug":"exadmin"},"derivedProperties":[{"name":"volume","units":"angstrom^3","value":131.1},{"name":"density","units":"g/cm^3","value":2.33},{"name":"symmetry","spaceGroupSymbol":"Fd-3m","tolerance":{"units":"angstrom","value":0.3}},{"degree":10,"name":"p-norm","value":0.71},{"element":"Si","name":"elemental_ratio","value":0.71},{"name":"inchi","value":""},{"name":"inchi_key","value":""}],"exabyteId":"RKiswuxHKkF3uvLyA","formula":"Si","hash":"4ac3fa057e3530628eb1295c77110eaa","isDefault":false,"isNonPeriodic":false,"lattice":{"name":"lattice","a":5.14,"alpha":90,"b":5.14,"beta":90,"c":5.14,"gamma":90,"type":"CUB","units":{"angle":"degree","length":"angstrom"},"vectors":{"a":[5,0.000121312,0.000131415],"alat":1,"b":[0.000121312,5,0.000121314],"c":[0.000121313,0.000121312,5],"units":"angstrom"}},"name":"Silicon FCC","owner":{"_id":"HtxACY2wX4b2hS8Rv","cls":"Account","slug":"exabyte"},"scaledHash":"5bd4eb168e3530628eb1295d88221cbb","schemaVersion":"0.2.0","slug":"silicon-fcc","unitCellFormula":"Si2","updatedAt":"2016-04-04T17:58:42.867Z"}},"path":"materials_category_components/entities/core/two-dimensional/vacuum"},{"data":{"chemical_element":"Si"},"path":"materials_category_components/entities/core/zero-dimensional/atom"},{"data":{"crystal":{"_id":"LCthJ6E2QabYCZqf3","basis":{"coordinates":[{"id":1,"value":[0,0,0]},{"id":2,"value":[0.25,0.25,0.25]}],"elements":[{"id":1,"value":"Si"},{"id":2,"value":"Si"}],"name":"basis","units":"crystal"},"createdAt":"2016-04-03T05:25:37.430Z","creator":{"_id":"HtxACY2wX4b2hS8Rv","cls":"User","slug":"exadmin"},"derivedProperties":[{"name":"volume","units":"angstrom^3","value":131.1},{"name":"density","units":"g/cm^3","value":2.33},{"name":"symmetry","spaceGroupSymbol":"Fd-3m","tolerance":{"units":"angstrom","value":0.3}},{"degree":10,"name":"p-norm","value":0.71},{"element":"Si","name":"elemental_ratio","value":0.71},{"name":"inchi","value":""},{"name":"inchi_key","value":""}],"exabyteId":"RKiswuxHKkF3uvLyA","formula":"Si","hash":"4ac3fa057e3530628eb1295c77110eaa","isDefault":false,"isNonPeriodic":false,"lattice":{"name":"lattice","a":5.14,"alpha":90,"b":5.14,"beta":90,"c":5.14,"gamma":90,"type":"CUB","units":{"angle":"degree","length":"angstrom"},"vectors":{"a":[5,0.000121312,0.000131415],"alat":1,"b":[0.000121312,5,0.000121314],"c":[0.000121313,0.000121312,5],"units":"angstrom"}},"name":"Silicon FCC","owner":{"_id":"HtxACY2wX4b2hS8Rv","cls":"Account","slug":"exabyte"},"scaledHash":"5bd4eb168e3530628eb1295d88221cbb","schemaVersion":"0.2.0","slug":"silicon-fcc","unitCellFormula":"Si2","updatedAt":"2016-04-04T17:58:42.867Z"},"miller_indices_2d":[1,1],"use_conventional_cell":true},"path":"materials_category_components/entities/reusable/one-dimensional/crystal_lattice_lines"},{"data":{"crystal":{"_id":"LCthJ6E2QabYCZqf3","basis":{"coordinates":[{"id":1,"value":[0,0,0]},{"id":2,"value":[0.25,0.25,0.25]}],"elements":[{"id":1,"value":"Si"},{"id":2,"value":"Si"}],"name":"basis","units":"crystal"},"createdAt":"2016-04-03T05:25:37.430Z","creator":{"_id":"HtxACY2wX4b2hS8Rv","cls":"User","slug":"exadmin"},"derivedProperties":[{"name":"volume","units":"angstrom^3","value":131.1},{"name":"density","units":"g/cm^3","value":2.33},{"name":"symmetry","spaceGroupSymbol":"Fd-3m","tolerance":{"units":"angstrom","value":0.3}},{"degree":10,"name":"p-norm","value":0.71},{"element":"Si","name":"elemental_ratio","value":0.71},{"name":"inchi","value":""},{"name":"inchi_key","value":""}],"exabyteId":"RKiswuxHKkF3uvLyA","formula":"Si","hash":"4ac3fa057e3530628eb1295c77110eaa","isDefault":false,"isNonPeriodic":false,"lattice":{"name":"lattice","a":5.14,"alpha":90,"b":5.14,"beta":90,"c":5.14,"gamma":90,"type":"CUB","units":{"angle":"degree","length":"angstrom"},"vectors":{"a":[5,0.000121312,0.000131415],"alat":1,"b":[0.000121312,5,0.000121314],"c":[0.000121313,0.000121312,5],"units":"angstrom"}},"name":"Silicon FCC","owner":{"_id":"HtxACY2wX4b2hS8Rv","cls":"Account","slug":"exabyte"},"scaledHash":"5bd4eb168e3530628eb1295d88221cbb","schemaVersion":"0.2.0","slug":"silicon-fcc","unitCellFormula":"Si2","updatedAt":"2016-04-04T17:58:42.867Z"},"miller_indices_2d":[1,1],"use_conventional_cell":true,"termination_top":{"chemical_elements":"Si","space_group_symmetry_label":"p1"},"termination_bottom":{"chemical_elements":"Si","space_group_symmetry_label":"p1"},"number_of_repetitions_width":3,"number_of_repetitions_length":5},"path":"materials_category_components/entities/reusable/one-dimensional/crystal_lattice_lines_unique_repeated"},{"data":[2,2,1],"path":"materials_category_components/entities/reusable/three-dimensional/repetitions"},{"data":{"stack_components":[{"stack_components":[{"crystal":{"_id":"LCthJ6E2QabYCZqf3","basis":{"coordinates":[{"id":1,"value":[0,0,0]},{"id":2,"value":[0.25,0.25,0.25]}],"elements":[{"id":1,"value":"Si"},{"id":2,"value":"Si"}],"name":"basis","units":"crystal"},"createdAt":"2016-04-03T05:25:37.430Z","creator":{"_id":"HtxACY2wX4b2hS8Rv","cls":"User","slug":"exadmin"},"derivedProperties":[{"name":"volume","units":"angstrom^3","value":131.1},{"name":"density","units":"g/cm^3","value":2.33},{"name":"symmetry","spaceGroupSymbol":"Fd-3m","tolerance":{"units":"angstrom","value":0.3}},{"degree":10,"name":"p-norm","value":0.71},{"element":"Si","name":"elemental_ratio","value":0.71},{"name":"inchi","value":""},{"name":"inchi_key","value":""}],"exabyteId":"RKiswuxHKkF3uvLyA","formula":"Si","hash":"4ac3fa057e3530628eb1295c77110eaa","isDefault":false,"isNonPeriodic":false,"lattice":{"name":"lattice","a":5.14,"alpha":90,"b":5.14,"beta":90,"c":5.14,"gamma":90,"type":"CUB","units":{"angle":"degree","length":"angstrom"},"vectors":{"a":[5,0.000121312,0.000131415],"alat":1,"b":[0.000121312,5,0.000121314],"c":[0.000121313,0.000121312,5],"units":"angstrom"}},"name":"Silicon FCC","owner":{"_id":"HtxACY2wX4b2hS8Rv","cls":"Account","slug":"exabyte"},"scaledHash":"5bd4eb168e3530628eb1295d88221cbb","schemaVersion":"0.2.0","slug":"silicon-fcc","unitCellFormula":"Si2","updatedAt":"2016-04-04T17:58:42.867Z"},"miller_indices":[0,0,1],"use_conventional_cell":true,"termination_top":{"chemical_elements":"Si","space_group_symmetry_label":"P4/mmm_2"},"number_of_repetitions":5},{"direction":"z","size":10,"crystal":{"_id":"LCthJ6E2QabYCZqf3","basis":{"coordinates":[{"id":1,"value":[0,0,0]},{"id":2,"value":[0.25,0.25,0.25]}],"elements":[{"id":1,"value":"Si"},{"id":2,"value":"Si"}],"name":"basis","units":"crystal"},"createdAt":"2016-04-03T05:25:37.430Z","creator":{"_id":"HtxACY2wX4b2hS8Rv","cls":"User","slug":"exadmin"},"derivedProperties":[{"name":"volume","units":"angstrom^3","value":131.1},{"name":"density","units":"g/cm^3","value":2.33},{"name":"symmetry","spaceGroupSymbol":"Fd-3m","tolerance":{"units":"angstrom","value":0.3}},{"degree":10,"name":"p-norm","value":0.71},{"element":"Si","name":"elemental_ratio","value":0.71},{"name":"inchi","value":""},{"name":"inchi_key","value":""}],"exabyteId":"RKiswuxHKkF3uvLyA","formula":"Si","hash":"4ac3fa057e3530628eb1295c77110eaa","isDefault":false,"isNonPeriodic":false,"lattice":{"name":"lattice","a":5.14,"alpha":90,"b":5.14,"beta":90,"c":5.14,"gamma":90,"type":"CUB","units":{"angle":"degree","length":"angstrom"},"vectors":{"a":[5,0.000121312,0.000131415],"alat":1,"b":[0.000121312,5,0.000121314],"c":[0.000121313,0.000121312,5],"units":"angstrom"}},"name":"Silicon FCC","owner":{"_id":"HtxACY2wX4b2hS8Rv","cls":"Account","slug":"exabyte"},"scaledHash":"5bd4eb168e3530628eb1295d88221cbb","schemaVersion":"0.2.0","slug":"silicon-fcc","unitCellFormula":"Si2","updatedAt":"2016-04-04T17:58:42.867Z"}}],"direction":"z"},{"direction":"z","size":10,"crystal":{"_id":"LCthJ6E2QabYCZqf3","basis":{"coordinates":[{"id":1,"value":[0,0,0]},{"id":2,"value":[0.25,0.25,0.25]}],"elements":[{"id":1,"value":"Si"},{"id":2,"value":"Si"}],"name":"basis","units":"crystal"},"createdAt":"2016-04-03T05:25:37.430Z","creator":{"_id":"HtxACY2wX4b2hS8Rv","cls":"User","slug":"exadmin"},"derivedProperties":[{"name":"volume","units":"angstrom^3","value":131.1},{"name":"density","units":"g/cm^3","value":2.33},{"name":"symmetry","spaceGroupSymbol":"Fd-3m","tolerance":{"units":"angstrom","value":0.3}},{"degree":10,"name":"p-norm","value":0.71},{"element":"Si","name":"elemental_ratio","value":0.71},{"name":"inchi","value":""},{"name":"inchi_key","value":""}],"exabyteId":"RKiswuxHKkF3uvLyA","formula":"Si","hash":"4ac3fa057e3530628eb1295c77110eaa","isDefault":false,"isNonPeriodic":false,"lattice":{"name":"lattice","a":5.14,"alpha":90,"b":5.14,"beta":90,"c":5.14,"gamma":90,"type":"CUB","units":{"angle":"degree","length":"angstrom"},"vectors":{"a":[5,0.000121312,0.000131415],"alat":1,"b":[0.000121312,5,0.000121314],"c":[0.000121313,0.000121312,5],"units":"angstrom"}},"name":"Silicon FCC","owner":{"_id":"HtxACY2wX4b2hS8Rv","cls":"Account","slug":"exabyte"},"scaledHash":"5bd4eb168e3530628eb1295d88221cbb","schemaVersion":"0.2.0","slug":"silicon-fcc","unitCellFormula":"Si2","updatedAt":"2016-04-04T17:58:42.867Z"}},{"direction":"z","size":10,"crystal":{"_id":"LCthJ6E2QabYCZqf3","basis":{"coordinates":[{"id":1,"value":[0,0,0]},{"id":2,"value":[0.25,0.25,0.25]}],"elements":[{"id":1,"value":"Si"},{"id":2,"value":"Si"}],"name":"basis","units":"crystal"},"createdAt":"2016-04-03T05:25:37.430Z","creator":{"_id":"HtxACY2wX4b2hS8Rv","cls":"User","slug":"exadmin"},"derivedProperties":[{"name":"volume","units":"angstrom^3","value":131.1},{"name":"density","units":"g/cm^3","value":2.33},{"name":"symmetry","spaceGroupSymbol":"Fd-3m","tolerance":{"units":"angstrom","value":0.3}},{"degree":10,"name":"p-norm","value":0.71},{"element":"Si","name":"elemental_ratio","value":0.71},{"name":"inchi","value":""},{"name":"inchi_key","value":""}],"exabyteId":"RKiswuxHKkF3uvLyA","formula":"Si","hash":"4ac3fa057e3530628eb1295c77110eaa","isDefault":false,"isNonPeriodic":false,"lattice":{"name":"lattice","a":5.14,"alpha":90,"b":5.14,"beta":90,"c":5.14,"gamma":90,"type":"CUB","units":{"angle":"degree","length":"angstrom"},"vectors":{"a":[5,0.000121312,0.000131415],"alat":1,"b":[0.000121312,5,0.000121314],"c":[0.000121313,0.000121312,5],"units":"angstrom"}},"name":"Silicon FCC","owner":{"_id":"HtxACY2wX4b2hS8Rv","cls":"Account","slug":"exabyte"},"scaledHash":"5bd4eb168e3530628eb1295d88221cbb","schemaVersion":"0.2.0","slug":"silicon-fcc","unitCellFormula":"Si2","updatedAt":"2016-04-04T17:58:42.867Z"}}],"direction":"z"},"path":"materials_category_components/entities/reusable/two-dimensional/slab_stack_configuration"},{"data":{"merge_components":[{"_id":"LCthJ6E2QabYCZqf3","basis":{"coordinates":[{"id":1,"value":[0,0,0]},{"id":2,"value":[0.25,0.25,0.25]}],"elements":[{"id":1,"value":"Si"},{"id":2,"value":"Si"}],"name":"basis","units":"crystal"},"createdAt":"2016-04-03T05:25:37.430Z","creator":{"_id":"HtxACY2wX4b2hS8Rv","cls":"User","slug":"exadmin"},"derivedProperties":[{"name":"volume","units":"angstrom^3","value":131.1},{"name":"density","units":"g/cm^3","value":2.33},{"name":"symmetry","spaceGroupSymbol":"Fd-3m","tolerance":{"units":"angstrom","value":0.3}},{"degree":10,"name":"p-norm","value":0.71},{"element":"Si","name":"elemental_ratio","value":0.71},{"name":"inchi","value":""},{"name":"inchi_key","value":""}],"exabyteId":"RKiswuxHKkF3uvLyA","formula":"Si","hash":"4ac3fa057e3530628eb1295c77110eaa","isDefault":false,"isNonPeriodic":false,"lattice":{"name":"lattice","a":5.14,"alpha":90,"b":5.14,"beta":90,"c":5.14,"gamma":90,"type":"CUB","units":{"angle":"degree","length":"angstrom"},"vectors":{"a":[5,0.000121312,0.000131415],"alat":1,"b":[0.000121312,5,0.000121314],"c":[0.000121313,0.000121312,5],"units":"angstrom"}},"name":"Silicon FCC","owner":{"_id":"HtxACY2wX4b2hS8Rv","cls":"Account","slug":"exabyte"},"scaledHash":"5bd4eb168e3530628eb1295d88221cbb","schemaVersion":"0.2.0","slug":"silicon-fcc","unitCellFormula":"Si2","updatedAt":"2016-04-04T17:58:42.867Z"},{"direction":"z","size":10,"crystal":{"_id":"LCthJ6E2QabYCZqf3","basis":{"coordinates":[{"id":1,"value":[0,0,0]},{"id":2,"value":[0.25,0.25,0.25]}],"elements":[{"id":1,"value":"Si"},{"id":2,"value":"Si"}],"name":"basis","units":"crystal"},"createdAt":"2016-04-03T05:25:37.430Z","creator":{"_id":"HtxACY2wX4b2hS8Rv","cls":"User","slug":"exadmin"},"derivedProperties":[{"name":"volume","units":"angstrom^3","value":131.1},{"name":"density","units":"g/cm^3","value":2.33},{"name":"symmetry","spaceGroupSymbol":"Fd-3m","tolerance":{"units":"angstrom","value":0.3}},{"degree":10,"name":"p-norm","value":0.71},{"element":"Si","name":"elemental_ratio","value":0.71},{"name":"inchi","value":""},{"name":"inchi_key","value":""}],"exabyteId":"RKiswuxHKkF3uvLyA","formula":"Si","hash":"4ac3fa057e3530628eb1295c77110eaa","isDefault":false,"isNonPeriodic":false,"lattice":{"name":"lattice","a":5.14,"alpha":90,"b":5.14,"beta":90,"c":5.14,"gamma":90,"type":"CUB","units":{"angle":"degree","length":"angstrom"},"vectors":{"a":[5,0.000121312,0.000131415],"alat":1,"b":[0.000121312,5,0.000121314],"c":[0.000121313,0.000121312,5],"units":"angstrom"}},"name":"Silicon FCC","owner":{"_id":"HtxACY2wX4b2hS8Rv","cls":"Account","slug":"exabyte"},"scaledHash":"5bd4eb168e3530628eb1295d88221cbb","schemaVersion":"0.2.0","slug":"silicon-fcc","unitCellFormula":"Si2","updatedAt":"2016-04-04T17:58:42.867Z"}}],"merge_method":"ADD"},"path":"materials_category_components/operations/core/combinations/merge"},{"data":{"stack_components":[{"_id":"LCthJ6E2QabYCZqf3","basis":{"coordinates":[{"id":1,"value":[0,0,0]},{"id":2,"value":[0.25,0.25,0.25]}],"elements":[{"id":1,"value":"Si"},{"id":2,"value":"Si"}],"name":"basis","units":"crystal"},"createdAt":"2016-04-03T05:25:37.430Z","creator":{"_id":"HtxACY2wX4b2hS8Rv","cls":"User","slug":"exadmin"},"derivedProperties":[{"name":"volume","units":"angstrom^3","value":131.1},{"name":"density","units":"g/cm^3","value":2.33},{"name":"symmetry","spaceGroupSymbol":"Fd-3m","tolerance":{"units":"angstrom","value":0.3}},{"degree":10,"name":"p-norm","value":0.71},{"element":"Si","name":"elemental_ratio","value":0.71},{"name":"inchi","value":""},{"name":"inchi_key","value":""}],"exabyteId":"RKiswuxHKkF3uvLyA","formula":"Si","hash":"4ac3fa057e3530628eb1295c77110eaa","isDefault":false,"isNonPeriodic":false,"lattice":{"name":"lattice","a":5.14,"alpha":90,"b":5.14,"beta":90,"c":5.14,"gamma":90,"type":"CUB","units":{"angle":"degree","length":"angstrom"},"vectors":{"a":[5,0.000121312,0.000131415],"alat":1,"b":[0.000121312,5,0.000121314],"c":[0.000121313,0.000121312,5],"units":"angstrom"}},"name":"Silicon FCC","owner":{"_id":"HtxACY2wX4b2hS8Rv","cls":"Account","slug":"exabyte"},"scaledHash":"5bd4eb168e3530628eb1295d88221cbb","schemaVersion":"0.2.0","slug":"silicon-fcc","unitCellFormula":"Si2","updatedAt":"2016-04-04T17:58:42.867Z"},{"direction":"z","size":10,"crystal":{"_id":"LCthJ6E2QabYCZqf3","basis":{"coordinates":[{"id":1,"value":[0,0,0]},{"id":2,"value":[0.25,0.25,0.25]}],"elements":[{"id":1,"value":"Si"},{"id":2,"value":"Si"}],"name":"basis","units":"crystal"},"createdAt":"2016-04-03T05:25:37.430Z","creator":{"_id":"HtxACY2wX4b2hS8Rv","cls":"User","slug":"exadmin"},"derivedProperties":[{"name":"volume","units":"angstrom^3","value":131.1},{"name":"density","units":"g/cm^3","value":2.33},{"name":"symmetry","spaceGroupSymbol":"Fd-3m","tolerance":{"units":"angstrom","value":0.3}},{"degree":10,"name":"p-norm","value":0.71},{"element":"Si","name":"elemental_ratio","value":0.71},{"name":"inchi","value":""},{"name":"inchi_key","value":""}],"exabyteId":"RKiswuxHKkF3uvLyA","formula":"Si","hash":"4ac3fa057e3530628eb1295c77110eaa","isDefault":false,"isNonPeriodic":false,"lattice":{"name":"lattice","a":5.14,"alpha":90,"b":5.14,"beta":90,"c":5.14,"gamma":90,"type":"CUB","units":{"angle":"degree","length":"angstrom"},"vectors":{"a":[5,0.000121312,0.000131415],"alat":1,"b":[0.000121312,5,0.000121314],"c":[0.000121313,0.000121312,5],"units":"angstrom"}},"name":"Silicon FCC","owner":{"_id":"HtxACY2wX4b2hS8Rv","cls":"Account","slug":"exabyte"},"scaledHash":"5bd4eb168e3530628eb1295d88221cbb","schemaVersion":"0.2.0","slug":"silicon-fcc","unitCellFormula":"Si2","updatedAt":"2016-04-04T17:58:42.867Z"}}],"direction":"z","gaps":[{"id":0,"value":2.5},{"id":1,"value":3}]},"path":"materials_category_components/operations/core/combinations/stack"},{"data":{"material":{"_id":"LCthJ6E2QabYCZqf3","basis":{"coordinates":[{"id":1,"value":[0,0,0]},{"id":2,"value":[0.25,0.25,0.25]}],"elements":[{"id":1,"value":"Si"},{"id":2,"value":"Si"}],"name":"basis","units":"crystal"},"createdAt":"2016-04-03T05:25:37.430Z","creator":{"_id":"HtxACY2wX4b2hS8Rv","cls":"User","slug":"exadmin"},"derivedProperties":[{"name":"volume","units":"angstrom^3","value":131.1},{"name":"density","units":"g/cm^3","value":2.33},{"name":"symmetry","spaceGroupSymbol":"Fd-3m","tolerance":{"units":"angstrom","value":0.3}},{"degree":10,"name":"p-norm","value":0.71},{"element":"Si","name":"elemental_ratio","value":0.71},{"name":"inchi","value":""},{"name":"inchi_key","value":""}],"exabyteId":"RKiswuxHKkF3uvLyA","formula":"Si","hash":"4ac3fa057e3530628eb1295c77110eaa","isDefault":false,"isNonPeriodic":false,"lattice":{"name":"lattice","a":5.14,"alpha":90,"b":5.14,"beta":90,"c":5.14,"gamma":90,"type":"CUB","units":{"angle":"degree","length":"angstrom"},"vectors":{"a":[5,0.000121312,0.000131415],"alat":1,"b":[0.000121312,5,0.000121314],"c":[0.000121313,0.000121312,5],"units":"angstrom"}},"name":"Silicon FCC","owner":{"_id":"HtxACY2wX4b2hS8Rv","cls":"Account","slug":"exabyte"},"scaledHash":"5bd4eb168e3530628eb1295d88221cbb","schemaVersion":"0.2.0","slug":"silicon-fcc","unitCellFormula":"Si2","updatedAt":"2016-04-04T17:58:42.867Z"},"perturbation_function":"0.1*sin(x) + 0.1*cos(y)"},"path":"materials_category_components/operations/core/modifications/perturb"},{"data":{"matrix":[[2,0,0],[0,2,0],[0,0,2]]},"path":"materials_category_components/operations/core/modifications/repeat"},{"data":{"matrix":[[1.02,0,0],[0,1.02,0],[0,0,0.98]]},"path":"materials_category_components/operations/core/modifications/strain"},{"data":{"name":"PW-NCPP (Davidson Diagonalization, Gaussian Smearing)","path":"/qm/wf/pw:/qm/wf/psp/nc?functional=pbe:/qm/wf/smearing/gaussian:/linalg/diag/davidson","units":[{"name":"Plane-wave","path":"/qm/wf/pw","categories":{"tier1":"qm","tier2":"wf","type":"pw"}},{"name":"Norm-conserving PSP","path":"/qm/wf/psp/nc?functional=pbe","categories":{"tier1":"qm","tier2":"wf","type":"psp","subtype":"nc"},"parameters":{"functional":"pbe"}},{"name":"Gaussian Smearing method","path":"/qm/wf/smearing/gaussian","categories":{"tier1":"qm","tier2":"wf","type":"smearing","subtype":"gaussian"}},{"name":"Davidson Diagonalization","path":"/linalg/diag/davidson","categories":{"tier1":"linalg","tier2":"diag","type":"davidson"}}]},"path":"method/categorized_method"},{"data":{"basisSlug":"6-311G"},"path":"method/method_parameters"},{"data":{"data":{"pseudo":[]},"subtype":"us","type":"pseudopotential"},"path":"method"},{"data":{"type":"localorbital","subtype":"pople"},"path":"methods_directory/legacy/localorbital"},{"data":{"type":"pseudopotential","subtype":"us"},"path":"methods_directory/legacy/pseudopotential"},{"data":{"data":{"dataSet":{"exabyteIds":["LCthJ6E2QabYCZqf4","LCthJ6E2QabYCZqf5","LCthJ6E2QabYCZqf6","LCthJ6E2QabYCZqf7","LCthJ6E2QabYCZqf8","LCthJ6E2QabYCZqf9","LCthJ6E2QabYCZq10","LCthJ6E2QabYCZq11"],"extra":{}},"perProperty":[{"intercept":0.363,"name":"band_gaps:direct","perFeature":[{"coefficient":0.015,"importance":0.134,"name":"atomic_radius:Ge"},{"coefficient":0.016,"importance":0.135,"name":"atomic_radius:Si"}]},{"intercept":0.364,"name":"band_gaps:indirect","perFeature":[{"coefficient":0.016,"importance":0.135,"name":"atomic_radius:Ge"},{"coefficient":0.017,"importance":0.136,"name":"atomic_radius:Si"}]}]},"precision":{"perProperty":[{"score":0.8,"trainingError":0.002}]},"subtype":"least_squares","type":"linear"},"path":"methods_directory/legacy/regression"},{"data":{"type":"unknown","subtype":"unknown"},"path":"methods_directory/legacy/unknown"},{"data":{"name":"Conjugate gradient method","path":"/opt/diff/ordern/cg","categories":{"tier1":"opt","tier2":"diff","tier3":"ordern","type":"cg"}},"path":"methods_directory/mathematical/cg"},{"data":{"data":{"dataSet":{"exabyteIds":["LCthJ6E2QabYCZqf4","LCthJ6E2QabYCZqf5","LCthJ6E2QabYCZqf6","LCthJ6E2QabYCZqf7","LCthJ6E2QabYCZqf8","LCthJ6E2QabYCZqf9","LCthJ6E2QabYCZq10","LCthJ6E2QabYCZq11"],"extra":{}},"perProperty":[{"intercept":0.363,"name":"band_gaps:direct","perFeature":[{"coefficient":0.015,"importance":0.134,"name":"atomic_radius:Ge"},{"coefficient":0.016,"importance":0.135,"name":"atomic_radius:Si"}]},{"intercept":0.364,"name":"band_gaps:indirect","perFeature":[{"coefficient":0.016,"importance":0.135,"name":"atomic_radius:Ge"},{"coefficient":0.017,"importance":0.136,"name":"atomic_radius:Si"}]}]},"precision":{"perProperty":[{"score":0.8,"trainingError":0.002}]},"categories":{"type":"linear","subtype":"least_squares"},"name":"Linear least squares regression","path":"/linear/leastsq"},"path":"methods_directory/mathematical/regression"},{"data":{"name":"cc-pVTZ basis set","path":"/qm/wf/ao/dunning?basisSlug=cc-pvtz","categories":{"tier1":"qm","tier2":"wf","type":"ao","subtype":"dunning"},"parameters":{"basisSlug":"cc-pvtz"}},"path":"methods_directory/physical/ao/dunning"},{"data":{"slug":"pseudopotential","source":{"info":{},"type":"exabyte"},"data":{"element":"Ru","hash":"3349af97451e04faae570056fb6a110b","filename":"ru_pbe_dojo-oncv_0.4.upf","path":"/export/share/pseudo/ru/gga/pbe/dojo-oncv/0.4/nc/ru_pbe_dojo-oncv_0.4.upf","valenceConfiguration":[{"orbitalName":"4S","orbitalIndex":1,"principalNumber":4,"angularMomentum":0,"occupation":2},{"orbitalName":"4P","orbitalIndex":2,"principalNumber":4,"angularMomentum":1,"occupation":6},{"orbitalName":"4D","orbitalIndex":3,"principalNumber":4,"angularMomentum":2,"occupation":7},{"orbitalName":"5S","orbitalIndex":4,"principalNumber":5,"angularMomentum":0,"occupation":1}],"apps":["espresso"],"exchangeCorrelation":{"functional":"pbe","approximation":"gga"},"name":"pseudopotential","source":"dojo-oncv","type":"nc","version":"0.4","cutoffs":{"wavefunction":[{"accuracy_level":"standard","value":42,"unit":"Ry"},{"accuracy_level":"high","value":50,"unit":"Ry"},{"accuracy_level":"low","value":38,"unit":"Ry"}]}}},"path":"methods_directory/physical/psp/file"},{"data":{"name":"PAW Pseudopotential method","path":"/qm/wf/psp/paw","slug":"pseudopotential","categories":{"tier1":"qm","tier2":"wf","type":"psp","subtype":"paw"},"data":[{"slug":"pseudopotential","source":{"info":{},"type":"exabyte"},"data":{"element":"Ru","hash":"3349af97451e04faae570056fb6a110b","filename":"ru_pbe_dojo-oncv_0.4.upf","path":"/export/share/pseudo/ru/gga/pbe/dojo-oncv/0.4/nc/ru_pbe_dojo-oncv_0.4.upf","valenceConfiguration":[{"orbitalName":"4S","orbitalIndex":1,"principalNumber":4,"angularMomentum":0,"occupation":2},{"orbitalName":"4P","orbitalIndex":2,"principalNumber":4,"angularMomentum":1,"occupation":6},{"orbitalName":"4D","orbitalIndex":3,"principalNumber":4,"angularMomentum":2,"occupation":7},{"orbitalName":"5S","orbitalIndex":4,"principalNumber":5,"angularMomentum":0,"occupation":1}],"apps":["espresso"],"exchangeCorrelation":{"functional":"pbe","approximation":"gga"},"name":"pseudopotential","source":"dojo-oncv","type":"nc","version":"0.4","cutoffs":{"wavefunction":[{"accuracy_level":"standard","value":42,"unit":"Ry"},{"accuracy_level":"high","value":50,"unit":"Ry"},{"accuracy_level":"low","value":38,"unit":"Ry"}]}}}]},"path":"methods_directory/physical/psp"},{"data":{"name":"Plane wave basis","path":"/qm/wf/pw","categories":{"tier1":"qm","tier2":"wf","type":"pw"}},"path":"methods_directory/physical/pw"},{"data":{"name":"Methfessel-Paxton smearing","path":"/qm/wf/smearing/methfessel-paxton","categories":{"tier1":"qm","tier2":"wf","type":"smearing","subtype":"methfessel-paxton"}},"path":"methods_directory/physical/smearing"},{"data":{"name":"Optimized Tetrahedron method (Kawamura)","path":"/qm/wf/tetrahedron/optimized","categories":{"tier1":"qm","tier2":"wf","type":"tetrahedron","subtype":"optimized"}},"path":"methods_directory/physical/tetrahedron"},{"data":{"name":"PZ+U (magnetism)","categories":{"tier1":{"name":"physics-based","slug":"pb"},"tier2":{"name":"quantum-mechanical","slug":"qm"},"tier3":{"name":"density functional theory","slug":"dft"},"type":{"name":"Kohn-Sham DFT","slug":"ksdft"},"subtype":{"name":"Local Density Approximation","slug":"lda"}},"parameters":{"functional":"pz","spinPolarization":"collinear","hubbardType":"U"},"method":{"name":"PW-NCPP (Davidson Diagonalization, Gaussian Smearing)","path":"/qm/wf/pw:/qm/wf/psp/nc?functional=pbe:/qm/wf/smearing/gaussian:/linalg/diag/davidson","units":[{"name":"Plane-wave","path":"/qm/wf/pw","categories":{"tier1":"qm","tier2":"wf","type":"pw"}},{"name":"Norm-conserving PSP","path":"/qm/wf/psp/nc?functional=pbe","categories":{"tier1":"qm","tier2":"wf","type":"psp","subtype":"nc"},"parameters":{"functional":"pbe"}},{"name":"Gaussian Smearing method","path":"/qm/wf/smearing/gaussian","categories":{"tier1":"qm","tier2":"wf","type":"smearing","subtype":"gaussian"}},{"name":"Davidson Diagonalization","path":"/linalg/diag/davidson","categories":{"tier1":"linalg","tier2":"diag","type":"davidson"}}]}},"path":"model/categorized_model"},{"data":{"functional":"pbe","dispersionCorrection":"dft-d3","hubbardType":"u","spinPolarization":"collinear","spinOrbitCoupling":true},"path":"model/model_parameters"},{"data":{"method":{"data":{"pseudo":[]},"subtype":"us","type":"pseudopotential"},"subtype":"gga","type":"dft"},"path":"model"},{"data":{"tier1":"pb","tier2":"qm","tier3":"abin","type":"gw","subtype":"evgw"},"path":"models_category/pb/qm/abin/gw"},{"data":{"tier1":"pb","tier2":"qm","tier3":"dft","type":"ksdft"},"path":"models_category/pb/qm/dft/ksdft"},{"data":{"tier1":"pb","tier2":"qm","tier3":"semp"},"path":"models_category/pb/qm/semp"},{"data":{"name":"PBE-D3 (SOC)","categories":{"tier1":"pb","tier2":"qm","tier3":"dft","type":"ksdft","subtype":"gga"},"parameters":{"functional":"pbe","spinOrbitCoupling":true,"dispersionCorrection":"DFT-D3"}},"path":"models_directory/gga"},{"data":{"name":"G0W0@PBE (SOC)","categories":{"tier1":"pb","tier2":"qm","tier3":"abin","type":"gw","subtype":"g0w0"},"parameters":{"functional":"pbe","require":"/pb/qm/dft/ksdft/gga","spinOrbitCoupling":true}},"path":"models_directory/gw"},{"data":{"name":"HSE06 (SOC)","categories":{"tier1":"pb","tier2":"qm","tier3":"dft","type":"ksdft","subtype":"hybrid"},"parameters":{"functional":"hse06","spinOrbitCoupling":true,"spinPolarization":"non-collinear"}},"path":"models_directory/hybrid"},{"data":{"name":"PZ+U (magnetism)","categories":{"tier1":"pb","tier2":"qm","tier3":"dft","type":"ksdft","subtype":"lda"},"parameters":{"functional":"pz","spinPolarization":"collinear","hubbardType":"U"}},"path":"models_directory/lda"},{"data":{"type":"dft","subtype":"gga","functional":"pbe","method":{"data":{"pseudo":[]},"subtype":"us","type":"pseudopotential"}},"path":"models_directory/legacy/dft"},{"data":{"type":"ml","subtype":"re","method":{"data":{"pseudo":[]},"subtype":"us","type":"pseudopotential"}},"path":"models_directory/legacy/ml"},{"data":{"type":"unknown","subtype":"unknown","method":{"data":{"pseudo":[]},"subtype":"us","type":"pseudopotential"}},"path":"models_directory/legacy/unknown"},{"data":{"name":"regression","categories":{"tier1":"st","tier2":"det","tier3":"ml","type":"re"},"parameters":{}},"path":"models_directory/re"},{"data":{"_id":"tvFyik5699io8khi8","chargeRate":{"rate":2},"createdAt":"2019-01-03T23:52:26.809Z","creator":{"_id":"HtxACY2wX4b2hS8Rv","cls":"User","slug":"exadmin"},"description":"Default project","gid":3000000,"isDefault":true,"name":"Default","owner":{"_id":"HtxACY2wX4b2hS8Rv","cls":"Account","slug":"exabyte"},"schemaVersion":"0.2.0","slug":"exadmin-default","tags":[],"updatedAt":"2019-01-04T00:12:37.316Z"},"path":"project"},{"data":{"charge":0,"multiplicity":1},"path":"properties_directory/electronic_configuration"},{"data":{"name":"atomic_radius","value":4},"path":"properties_directory/elemental/atomic_radius"},{"data":{"name":"electronegativity","value":1.1},"path":"properties_directory/elemental/electronegativity"},{"data":{"name":"ionization_potential","value":7.7},"path":"properties_directory/elemental/ionization_potential"},{"data":{"name":"band_gaps","values":[{"kpointConduction":[0,0,0],"kpointValence":[0,0,0],"type":"direct","units":"Ry","value":0.0947},{"type":"indirect","units":"Ry","value":0}]},"path":"properties_directory/non-scalar/band_gaps"},{"data":{"name":"band_structure","spin":[0.5,0.5,0.5,0.5],"xAxis":{"label":"kpoints","units":"crystal"},"xDataArray":[[0,0,0],[0.5,0.5,0.5]],"yAxis":{"label":"energy","units":"eV"},"yDataSeries":[[12.1,12.5],[11.1,11.5],[10.1,10.5],[9.5,8.5]]},"path":"properties_directory/non-scalar/band_structure"},{"data":{"name":"charge_density_profile","xAxis":{"label":"z coordinate"},"xDataArray":[-4.89,-4.78,-4.67],"yAxis":{"label":"charge density","units":"e/A"},"yDataSeries":[[2.3697,2.1422,2.0006]]},"path":"properties_directory/non-scalar/charge_density_profile"},{"data":{"legend":[{"electronicState":"2s","element":"C","index":1,"spin":0.5},{"electronicState":"2p","element":"C","index":2,"spin":0.5}],"name":"density_of_states","xAxis":{"label":"energy","units":"eV"},"xDataArray":[[0,0,0],[0.5,0.5,0.5]],"yAxis":{"label":"density of states","units":"states/unitcell"},"yDataSeries":[[12.1,12.5],[11.1,11.5],[10.1,10.5],[9.5,8.5]]},"path":"properties_directory/non-scalar/density_of_states"},{"data":{"name":"dielectric_tensor","values":[{"part":"real","spin":0.5,"frequencies":[0,0.06012024,0.120240481,0.180360721],"components":[[0,0,0],[0.019862988,0.019862988,0.019862987],[0.039813564,0.039813565,0.039813563],[0.059940387,0.059940389,0.059940385]]},{"part":"imaginary","spin":0.5,"frequencies":[0,0.06012024,0.120240481,0.180360721],"components":[[0,0,0],[0.019862988,0.019862988,0.019862987],[0.039813564,0.039813565,0.039813563],[0.059940387,0.059940389,0.059940385]]},{"part":"real","spin":-0.5,"frequencies":[0,0.06012024,0.120240481,0.180360721],"components":[[0,0,0],[0.019862988,0.019862988,0.019862987],[0.039813564,0.039813565,0.039813563],[0.059940387,0.059940389,0.059940385]]},{"part":"imaginary","spin":-0.5,"frequencies":[0,0.06012024,0.120240481,0.180360721],"components":[[0,0,0],[0.019862988,0.019862988,0.019862987],[0.039813564,0.039813565,0.039813563],[0.059940387,0.059940389,0.059940385]]}]},"path":"properties_directory/non-scalar/dielectric_tensor"},{"data":{"name":"file_content","basename":"my_json.json","filetype":"text","objectData":{"CONTAINER":"production-20160630-cluster-001","NAME":"/cluster-001-home/jrd101/data/jrd101-default/kernel-train-Cxmkj97aXKZeaRZov/Cxmkj97aXKZeaRZov.json","PROVIDER":"aws","REGION":"us-east-1","SIZE":6582,"TIMESTAMP":"1614217411"}},"path":"properties_directory/non-scalar/file_content"},{"data":{"name":"hubbard_u","units":"eV","values":[{"id":1,"atomicSpecies":"Co1","orbitalName":"3d","value":6.7553},{"id":2,"atomicSpecies":"Co2","orbitalName":"3d","value":6.7553},{"id":3,"atomicSpecies":"O","orbitalName":"3p","value":2.2438}]},"path":"properties_directory/non-scalar/hubbard_u"},{"data":{"name":"hubbard_v","units":"eV","values":[{"id":1,"atomicSpecies":"Co","id2":1,"atomicSpecies2":"Co","distance":0,"value":7.7514},{"id":1,"atomicSpecies":"Co","id2":19,"atomicSpecies2":"O","distance":3.630748,"value":0.7573}]},"path":"properties_directory/non-scalar/hubbard_v"},{"data":{"name":"hubbard_v_nn","units":"eV","values":[{"id":1,"atomicSpecies":"Co","orbitalName":"3d","id2":1,"atomicSpecies2":"Co","orbitalName2":"3d","value":7.7514},{"id":1,"atomicSpecies":"Co","orbitalName":"3d","id2":19,"atomicSpecies2":"O","orbitalName2":"2p","value":0.7573}]},"path":"properties_directory/non-scalar/hubbard_v_nn"},{"data":{"name":"phonon_dispersions","xAxis":{"label":"qpoints","units":"crystal"},"xDataArray":[[0,0,0],[0.5,0.05,0.05]],"yAxis":{"label":"frequency","units":"cm-1"},"yDataSeries":[[-0.000006,-0.000006,-0.000005,734.596987,734.618837,734.618837],[-6.859784,-6.859784,36.443014,730.782803,731.143013,731.143013]]},"path":"properties_directory/non-scalar/phonon_dispersions"},{"data":{"name":"phonon_dos","xAxis":{"label":"frequency","units":"cm-1"},"xDataArray":[[565,566,567,568,569,570,571,572,573]],"yAxis":{"label":"Phonon DOS","units":"states/cm-1"},"yDataSeries":[[0.0001433,0.00011382,0.000087721,0.00006502,0.000045713,0.000029799,0.000017279,0.0000081527,0.0000024197]]},"path":"properties_directory/non-scalar/phonon_dos"},{"data":{"name":"potential_profile","xAxis":{"label":"z coordinate"},"xDataArray":[-4.89,-4.78,-4.67],"yAxis":{"label":"energy","units":"eV"},"yDataSeries":[[-6.5847438,-7.0900648,-7.5601238],[6.4872255,8.2828137,10.1322914],[-0.0975183,1.192749,2.5721676]]},"path":"properties_directory/non-scalar/potential_profile"},{"data":{"name":"reaction_energy_profile","xAxis":{"label":"reaction coordinate"},"xDataArray":[0,0.1932731666,0.3596118308,0.4999998753,0.640387977,0.8067267116,1],"yAxis":{"label":"energy","units":"eV"},"yDataSeries":[[0,0.0336637211,0.1282952413,0.2032895454,0.1282953846,0.0336637671,-5.3e-9]]},"path":"properties_directory/non-scalar/reaction_energy_profile"},{"data":{"name":"stress_tensor","units":"kbar","value":[[3,0,0],[0,3,0],[0,0,3]]},"path":"properties_directory/non-scalar/stress_tensor"},{"data":{"PAWDoubleCounting2":{"name":"PAW_double-counting_correction_2","value":12658.30538857},"PAWDoubleCounting3":{"name":"PAW_double-counting_correction_3","value":-12074.85364512},"alphaZ":{"name":"alphaZ","value":1056.91493097},"atomicEnergy":{"name":"atomic_energy","value":15740.5725788},"eigenvalues":{"name":"eigenvalues","value":-577.80127102},"ewald":{"name":"ewald","value":128376.45871064},"exchange":{"name":"exchange","value":0},"exchangeCorrelation":{"name":"exchange_correlation","value":41.63693035},"hartree":{"name":"hartree","value":-145344.66902862},"name":"total_energy_contributions","temperatureEntropy":{"name":"temperature_entropy","value":-0.00032545},"units":"eV"},"path":"properties_directory/non-scalar/total_energy_contributions"},{"data":{"name":"vibrational_spectrum","xAxis":{"label":"wavenumber","units":"cm-1"},"xDataArray":[[1625.972,3631.832,3735.535]],"yAxis":{"label":"Absorption coefficient","units":"km/mol"},"yDataSeries":[[46.681,1.139,14.281]]},"path":"properties_directory/non-scalar/vibrational_spectrum"},{"data":{"name":"electron_affinity","units":"eV","value":2.5},"path":"properties_directory/scalar/electron_affinity"},{"data":{"name":"fermi_energy","units":"eV","value":-1.2},"path":"properties_directory/scalar/fermi_energy"},{"data":{"name":"formation_energy","units":"eV","value":-123.43573079},"path":"properties_directory/scalar/formation_energy"},{"data":{"name":"ionization_potential","units":"eV","value":14},"path":"properties_directory/scalar/ionization_potential"},{"data":{"name":"pressure","units":"kbar","value":-27.345},"path":"properties_directory/scalar/pressure"},{"data":{"name":"reaction_energy_barrier","units":"eV","value":-123.43573079},"path":"properties_directory/scalar/reaction_energy_barrier"},{"data":{"name":"surface_energy","units":"eV/A^2","value":0.02},"path":"properties_directory/scalar/surface_energy"},{"data":{"name":"total_energy","units":"eV","value":-123.43573079},"path":"properties_directory/scalar/total_energy"},{"data":{"name":"total_force","units":"eV/angstrom","value":0.000001},"path":"properties_directory/scalar/total_force"},{"data":{"name":"valence_band_offset","units":"eV","value":0.245},"path":"properties_directory/scalar/valence_band_offset"},{"data":{"name":"zero_point_energy","units":"eV","value":-123.43573079},"path":"properties_directory/scalar/zero_point_energy"},{"data":{"name":"atomic_forces","units":"eV/bohr","values":[{"id":1,"value":[-3.9e-7,-2.4e-7,0]},{"id":2,"value":[3.9e-7,2.4e-7,0]}]},"path":"properties_directory/structural/atomic_forces"},{"data":{"name":"atomic_constraints","values":[{"id":1,"value":[true,false,true]},{"id":2,"value":[false,false,true]}]},"path":"properties_directory/structural/basis/atomic_constraints_property"},{"data":{"id":1,"value":[0,0,0]},"path":"properties_directory/structural/basis/atomic_coordinate"},{"data":[{"id":1,"value":[0,0,0]},{"id":2,"value":[0.25,0.25,0.25]}],"path":"properties_directory/structural/basis/atomic_coordinates"},{"data":{"id":1,"value":"Si"},"path":"properties_directory/structural/basis/atomic_element"},{"data":[{"id":0,"value":"Si"},{"id":1,"value":"Si"}],"path":"properties_directory/structural/basis/atomic_elements"},{"data":{"id":0,"value":3},"path":"properties_directory/structural/basis/atomic_label"},{"data":[{"id":0,"value":"1"},{"id":1,"value":2}],"path":"properties_directory/structural/basis/atomic_labels"},{"data":[{"atomPair":[{"id":1},{"id":2}],"bondType":"single"},{"atomPair":[{"id":3},{"id":4}],"bondType":"double"}],"path":"properties_directory/structural/basis/bonds"},{"data":{"bonds":[{"0":{"atomPair":[{"id":1},{"id":2}],"bondType":"single"},"1":{"atomPair":[{"id":3},{"id":4}],"bondType":"double"}}],"coordinates":[{"id":1,"value":[0,0,0]}],"elements":[{"id":1,"value":"Si"}],"name":"basis","units":"crystal"},"path":"properties_directory/structural/basis"},{"data":{"name":"density","units":"g/cm^3","value":2.33},"path":"properties_directory/structural/density"},{"data":{"element":"Si","name":"elemental_ratio","value":0.71},"path":"properties_directory/structural/elemental_ratio"},{"data":{"name":"inchi","value":"1S/C6H6/c1-2-4-6-5-3-1/h1-6H"},"path":"properties_directory/structural/inchi"},{"data":{"name":"inchi_key","value":"UHOVQNZJYSORNB-UHFFFAOYSA-N"},"path":"properties_directory/structural/inchi_key"},{"data":{"a":[5,0.000121312,0.000131415],"alat":1,"b":[0.000121312,5,0.000121314],"c":[0.000121313,0.000121312,5],"units":"angstrom"},"path":"properties_directory/structural/lattice/vectors"},{"data":{"name":"lattice","a":5.14,"alpha":90,"b":5.14,"beta":90,"c":5.14,"gamma":90,"type":"CUB","units":{"angle":"degree","length":"angstrom"},"vectors":{"a":[5,0.000121312,0.000131415],"alat":1,"b":[0.000121312,5,0.000121314],"c":[0.000121313,0.000121312,5],"units":"angstrom"}},"path":"properties_directory/structural/lattice"},{"data":{"name":"magnetic_moments","units":"uB","values":[{"id":1,"value":[0,0,1.235]},{"id":2,"value":[0,0,-1.235]}]},"path":"properties_directory/structural/magnetic_moments"},{"data":[{"SMARTS":"[O&D1]-C(=O)[#6X3]","atoms":[{"id":1,"isConnector":false},{"id":2,"isConnector":false},{"id":3,"isConnector":false},{"id":4,"isConnector":true}],"name":"functional_group"},{"atoms":[{"id":1,"isConnector":true},{"id":2,"isConnector":false},{"id":3,"isConnector":true}],"name":"special_bond"},{"atoms":[{"id":1,"isConnector":false},{"id":2,"isConnector":false},{"id":3,"isConnector":false},{"id":4,"isConnector":false},{"id":5,"isConnector":false},{"id":6,"isConnector":true}],"isAromatic":true,"name":"ring"}],"path":"properties_directory/structural/molecular_pattern"},{"data":{"degree":10,"name":"p-norm","value":0.71},"path":"properties_directory/structural/p-norm"},{"data":{"name":"symmetry","pointGroupSymbol":"C2v","spaceGroupSymbol":"Fd-3m","tolerance":{"units":"angstrom","value":0.3}},"path":"properties_directory/structural/symmetry"},{"data":{"name":"volume","units":"angstrom^3","value":131.1},"path":"properties_directory/structural/volume"},{"data":{"data":[[-123.45678,-12.345678,-1.2345678,-0.1234567,-0.0123456,-0.0012345,-0.0001234]],"tolerance":0.001,"units":"Ry"},"path":"properties_directory/workflow/convergence/electronic"},{"data":{"data":[{"electronic":{"data":[0.10303193,0.04365779,0.00051472,0.00007496,0.00000309,5.6e-7],"units":"eV"},"energy":-123.45678}],"tolerance":0.001,"units":"eV"},"path":"properties_directory/workflow/convergence/ionic"},{"data":{"data":[{"grid":{"dimensions":[1,1,1],"shifts":[0,0,0]},"value":"-123.45678"}],"property":"total_energy","tolerance":0.001,"units":"eV"},"path":"properties_directory/workflow/convergence/kpoint"},{"data":{"_id":"K3McGkqXh28HJ775m","createdAt":"2018-11-19 06:41:46.877Z","creator":{"_id":"HtxACY2wX4b2hS8Rv","cls":"User","slug":"exadmin"},"data":{"name":"pressure","units":"kbar","value":-149.03},"group":"qe:dft:gga:pbe","owner":{"_id":"HtxACY2wX4b2hS8Rv","cls":"Account","slug":"exabyte"},"schemaVersion":"0.2.0","slug":"pressure","source":{"_id":"nDAavgjrT5ezwFgod","owner":{"_id":"HtxACY2wX4b2hS8Rv","cls":"Account","slug":"exabyte"},"title":"My Calculation"}},"path":"property/base"},{"data":{"name":"espresso","shortName":"qe","summary":"Quantum Espresso","version":"5.1.1","hasAdvancedComputeOptions":true},"path":"software/application"},{"data":{"advancedComputeOptions":true,"applicationId":["eaJepm4AWfqpaCw59"],"isDefault":true,"monitors":[{"name":"standard_output"}],"name":"pw.x","postProcessors":[],"preProcessors":[],"results":[{"name":"atomic_forces"}]},"path":"software/executable"},{"data":{"executableId":"4987JFJ3kKbwvFSG7","input":[{"templateId":"dJ7HYz5pQ4AuN5qc9"}],"name":"pw_scf"},"path":"software/flavor"},{"data":{"applicationName":"espresso","applicationVersions":["6.0"],"content":"K_POINTS automatic\n{{nkx}} {{nky}} {{nkz}} 0 0 0","rendered":"K_POINTS automatic\n10 10 10 0 0 0","contextProviders":[{"name":"KGridManagerMixin"}],"executableName":"pw.x","name":"kpoints_grid"},"path":"software/template"},{"data":{"name":"exabyteml","shortName":"ml","summary":"exabyte machine learning engine","version":"0.2.0"},"path":"software_directory/ml/exabyteml"},{"data":{"application":{"name":"exabyteml","shortName":"ml","summary":"exabyte machine learning engine","version":"0.2.0"},"flavor":{"executableId":"4987JFJ3kKbwvFSG7","name":"cross-validate"},"flowchartId":"evaluate","head":true,"input":{"nSplits":3},"name":"evaluate","status":"idle","type":"execution"},"path":"software_directory/ml/unit/execution/evaluate/cross-validate"},{"data":{"application":{"name":"exabyteml","shortName":"ml","summary":"exabyte machine learning engine","version":"0.2.0"},"flavor":{"executableId":"4987JFJ3kKbwvFSG7","name":"initialize"},"flowchartId":"initialize","head":true,"input":{"targets":["band_gaps:indirect","band_gaps:direct"]},"name":"initialize","status":"idle","type":"execution"},"path":"software_directory/ml/unit/execution/initialize"},{"data":{"application":{"name":"exabyteml","shortName":"ml","summary":"exabyte machine learning engine","version":"0.2.0"},"flavor":{"executableId":"4987JFJ3kKbwvFSG7","name":"score"},"flowchartId":"score","head":true,"input":{},"name":"score","status":"idle","type":"execution"},"path":"software_directory/ml/unit/execution/score"},{"data":{"application":{"name":"exabyteml","shortName":"ml","summary":"exabyte machine learning engine","version":"0.2.0"},"flavor":{"executableId":"4987JFJ3kKbwvFSG7","name":"train"},"flowchartId":"train","head":true,"input":{"features":["elemental_ratio:Si","elemental_ratio:Ge","ionization_potential:Ge","ionization_potential:Si"],"targets":["band_gaps:indirect","band_gaps:direct"]},"name":"train","status":"idle","type":"execution"},"path":"software_directory/ml/unit/execution/train"},{"data":{"flowchartId":"data_transformation","head":true,"inputData":{"cleanMissingData":true,"removeDuplicateRows":true,"replaceNoneValuesWith":0},"name":"data_transformation","operation":"data_transformation","operationType":"manipulation","status":"idle","type":"processing"},"path":"software_directory/ml/unit/processing/data_transformation/manipulation"},{"data":{"flowchartId":"data_transformation","head":true,"inputData":{"perFeature":[{"mean":0.156,"name":"atomic_radius:Ge","scale":1.5,"variance":0.1},{"mean":0.155,"name":"atomic_radius:Si","scale":1.4,"variance":0.11}],"scaler":"standard_scaler"},"name":"data_transformation","operation":"data_transformation","operationType":"scale_and_reduce","status":"idle","type":"processing"},"path":"software_directory/ml/unit/processing/data_transformation/scale_and_reduce"},{"data":{"flowchartId":"feature_selection","head":true,"inputData":{"algorithm":"f_regression","nFeatures":100},"name":"feature_selection","operation":"feature_selection","operationType":"filter_based","status":"idle","type":"processing"},"path":"software_directory/ml/unit/processing/feature_selection/filter_based"},{"data":{"nband":1,"npools":1,"ntg":1},"path":"software_directory/modeling/espresso/arguments"},{"data":{"name":"espresso","shortName":"qe","summary":"Quantum Espresso","version":"7.2"},"path":"software_directory/modeling/espresso"},{"data":{"name":"NWChem","summary":"NWChem: a comprehensive and scalable open-source solution for large scale molecular simulations","version":"6.6","exec":"nwchem"},"path":"software_directory/modeling/nwchem"},{"data":{"application":{"name":"espresso","shortName":"qe","summary":"Quantum Espresso","version":"7.2"},"flowchartId":"modeling","head":true,"input":[{"applicationName":"espresso","applicationVersions":["6.0"],"content":"K_POINTS automatic\n{{nkx}} {{nky}} {{nkz}} 0 0 0","rendered":"K_POINTS automatic\n10 10 10 0 0 0","contextProviders":[{"name":"KGridManagerMixin"}],"executableName":"pw.x","name":"kpoints_grid"}],"name":"modeling","status":"idle","type":"execution"},"path":"software_directory/modeling/unit/execution"},{"data":{"name":"vasp","shortName":"vasp","summary":"vienna ab-initio simulation package","version":"5.3.5"},"path":"software_directory/modeling/vasp"},{"data":{"exec":"jupyter","flavor":"notebook","name":"jupyterLab","shortName":"jl","summary":"Jupyter Lab","version":"0.33.12"},"path":"software_directory/scripting/jupyter-lab"},{"data":{"exec":"python","flavor":"python2","name":"python","shortName":"py","summary":"Python Script","version":"2.7.5"},"path":"software_directory/scripting/python"},{"data":{"exec":"sh","flavor":"sh","name":"shell","shortName":"sh","summary":"Shell Script","version":"4.2.46"},"path":"software_directory/scripting/shell"},{"data":{"application":{"exec":"python","flavor":"python2","name":"python","shortName":"py","summary":"Python Script","version":"2.7.5"},"compute":null,"flowchartId":"scripting","head":true,"input":[{"applicationName":"espresso","applicationVersions":["6.0"],"content":"K_POINTS automatic\n{{nkx}} {{nky}} {{nkz}} 0 0 0","rendered":"K_POINTS automatic\n10 10 10 0 0 0","contextProviders":[{"name":"KGridManagerMixin"}],"executableName":"pw.x","name":"kpoints_grid"}],"name":"scripting","status":"idle","type":"execution"},"path":"software_directory/scripting/unit/execution"},{"data":{"_id":"HtxACY2wX4b2hS8Rv","cls":"Material","slug":"silicon-fcc"},"path":"system/_material"},{"data":{"_id":"HtxACY2wX4b2hS8Rv","cls":"Job","slug":"parent-job"},"path":"system/_parent_job"},{"data":{"_id":"HtxACY2wX4b2hS8Rv","cls":"Project","slug":"project-default"},"path":"system/_project"},{"data":{"key":"basis.coordinates.0","name":"atomsTooClose","severity":"warning","message":"Atom 0 is too close to atom X"},"path":"system/consistency_check"},{"data":{"_id":"HtxACY2wX4b2hS8Rv","cls":"User","slug":"exadmin"},"path":"system/creator"},{"data":{"_id":"HtxACY2wX4b2hS8Rv","cls":"Class","slug":"Slug"},"path":"system/entity_reference"},{"data":{"extension":"poscar","filename":"POSCAR.mp-546794_SiO2.poscar","text":"Si4 O8\n1.0\n5.073173 0.000000 0.000000\n0.000000 5.073173 0.000000\n0.000000 0.000000 7.359653\nSi O\n4 8\ndirect\n0.000000 0.500000 0.250000 Si\n0.500000 0.500000 0.500000 Si\n0.500000 0.000000 0.750000 Si\n0.000000 0.000000 0.000000 Si\n0.750000 0.584672 0.375000 O\n0.915328 0.250000 0.125000 O\n0.084672 0.750000 0.125000 O\n0.250000 0.415328 0.375000 O\n0.250000 0.084672 0.875000 O\n0.415328 0.750000 0.625000 O\n0.584672 0.250000 0.625000 O\n0.750000 0.915328 0.875000 O","hash":"fce4c03798763a9ed8bf64d762c7fbfd"},"path":"system/file_source"},{"data":{"type":"from-iframe-to-host","action":"set-data","payload":{"property":{"name":"material"}}},"path":"system/iframe_message"},{"data":{"header":{"entity":{"_id":"FPjAaKfuYAL7tiHbm","flowchartId":"pw_scf","name":"unit"},"timestamp":1234923492.12,"version":"0.2.0"},"payload":{"name":"total_energy","units":"eV","value":-123.43573079}},"path":"system/message"},{"data":{"_id":"HtxACY2wX4b2hS8Rv","cls":"Account","slug":"exabyte"},"path":"system/owner"},{"data":{"_id":"LCthJ6E2QabYCZqf4","application":{"name":"espresso","shortName":"qe","summary":"Quantum Espresso","version":"5.1.1","hasAdvancedComputeOptions":true},"model":{"method":{"data":{"pseudo":[]},"subtype":"us","type":"pseudopotential"},"subtype":"gga","type":"dft"},"name":"Band Structure","properties":["band_structure"],"units":[{"application":{"name":"espresso","shortName":"qe","summary":"Quantum Espresso","version":"5.1.1","hasAdvancedComputeOptions":true},"compute":null,"executable":{"advancedComputeOptions":true,"applicationId":["eaJepm4AWfqpaCw59"],"isDefault":true,"monitors":[{"name":"standard_output"}],"name":"pw.x","postProcessors":[],"preProcessors":[],"results":[{"name":"atomic_forces"}]},"flavor":{"executableId":"4987JFJ3kKbwvFSG7","input":[{"templateId":"dJ7HYz5pQ4AuN5qc9"}],"name":"pw_scf"},"flowchartId":"execution","head":true,"input":[{"content":"K_POINTS automatic\n2 2 2 0 0 0","name":"pw_scf.in"}],"monitors":[{"name":"scf_accuracy"},{"name":"standard_output"}],"name":"execution","next":"pw-bands","postProcessors":[],"preProcessors":[],"results":[{"name":"harris_foulkes_estimate"}],"status":"idle","type":"execution"}]},"path":"workflow/subworkflow"},{"data":{"flowchartId":"assignment","head":true,"input":[{"name":"N_K_x","scope":"global"},{"name":"N_K_y","scope":"global"}],"name":"assignment","operand":"N_K_x","status":"idle","type":"assignment","value":"N_K_x+N_K_y+1"},"path":"workflow/unit/assignment"},{"data":{"else":"sample_id_6","flowchartId":"condition","head":true,"input":[{"name":"x","scope":"global"},{"name":"total_energy","scope":"sample_id_2"}],"maxOccurrences":100,"name":"condition","statement":"abs(x-total_energy) < 1e-5","status":"idle","then":"sample_id_4","throwException":true,"type":"condition"},"path":"workflow/unit/condition"},{"data":{"application":{"name":"espresso","shortName":"qe","summary":"Quantum Espresso","version":"5.1.1","hasAdvancedComputeOptions":true},"compute":null,"executable":{"advancedComputeOptions":true,"applicationId":["eaJepm4AWfqpaCw59"],"isDefault":true,"monitors":[{"name":"standard_output"}],"name":"pw.x","postProcessors":[],"preProcessors":[],"results":[{"name":"atomic_forces"}]},"flavor":{"executableId":"4987JFJ3kKbwvFSG7","input":[{"templateId":"dJ7HYz5pQ4AuN5qc9"}],"name":"pw_scf"},"flowchartId":"execution","head":true,"input":[{"content":"K_POINTS automatic\n2 2 2 0 0 0","name":"pw_scf.in"}],"monitors":[{"name":"scf_accuracy"},{"name":"standard_output"}],"name":"execution","next":"pw-bands","postProcessors":[],"preProcessors":[],"results":[{"name":"harris_foulkes_estimate"}],"status":"idle","type":"execution"},"path":"workflow/unit/execution"},{"data":{"name":"N_K_y","scope":"global"},"path":"workflow/unit/input/_inputItemScope"},{"data":{"endpoint":"data-frame","endpoint_options":{"data":{"features":["elemental_ratio:Si","elemental_ratio:Ge","ionization_potential:Ge","ionization_potential:Si"],"ids":["KuAsBRwofzGfHPWiT"],"targets":["band_gaps:indirect","band_gaps:direct"]},"headers":{"X-Auth-Token":"","X-User-Id":""},"method":"POST","params":{"query":{"formula":"SiGe"}}},"name":"DATA"},"path":"workflow/unit/io/api"},{"data":{"features":["elemental_ratio:Si","elemental_ratio:Ge","ionization_potential:Ge","ionization_potential:Si"],"ids":["KuAsBRwofzGfHPWiT"],"targets":["band_gaps:indirect","band_gaps:direct"]},"path":"workflow/unit/io/db"},{"data":{"basename":"index.html","overwrite":true,"objectData":{"CONTAINER":"production-20160630-cluster-001","NAME":"/cluster-001-home/jrd101/data/jrd101-default/kernel-train-Cxmkj97aXKZeaRZov/Cxmkj97aXKZeaRZov.json","PROVIDER":"aws","REGION":"us-east-1","SIZE":6582,"TIMESTAMP":"1614217411"}},"path":"workflow/unit/io/object_storage"},{"data":{"flowchartId":"io","head":true,"input":[{"endpoint":"data-frame","endpoint_options":{"data":{"features":["elemental_ratio:Si","elemental_ratio:Ge","ionization_potential:Ge","ionization_potential:Si"],"ids":["KuAsBRwofzGfHPWiT"],"targets":["band_gaps:indirect","band_gaps:direct"]},"headers":{"X-Auth-Token":"","X-User-Id":""},"method":"POST","params":{"query":{"formula":"SiGe"}}}}],"name":"io","source":"api","status":"idle","subtype":"input","type":"io"},"path":"workflow/unit/io"},{"data":{"flowchartId":"map","head":true,"input":{"target":"MAP_K_POINTS_1","values":["2 2 2 0 0 0","3 3 3 0 0 0","4 4 4 0 0 0"]},"name":"map","status":"idle","type":"map","workflowId":"zxjhEiaQvwWwvB3oM"},"path":"workflow/unit/map"},{"data":{"flowchartId":"data_transformation_manipulation","inputData":{"cleanMissingData":true,"removeDuplicateRows":true,"replaceNoneValuesWith":0},"name":"data_transformation_manipulation","operation":"data_transformation","operationType":"manipulation","status":"idle","type":"processing"},"path":"workflow/unit/processing"},{"data":{"flowchartId":"reduce","head":true,"input":[{"arguments":["band_gaps"],"operation":"aggregate"}],"mapFlowchartId":"1","name":"reduce","status":"idle","type":"reduce"},"path":"workflow/unit/reduce"},{"data":{"monitors":[{"name":"standard_output"}],"postProcessors":[],"preProcessors":[],"results":[{"name":"atomic_forces"}]},"path":"workflow/unit/runtime/runtime_items"},{"data":{"_id":"FPjAaKfuYAL7tiHbm","createdAt":"2018-11-19 06:41:46.877Z","creator":{"_id":"HtxACY2wX4b2hS8Rv","cls":"User","slug":"exadmin"},"exabyteId":"qKtTzu9utCo6ac4n7","hash":"f4fd707d2e47c15f8d786cf159040954","isDefault":true,"name":"workflow","owner":{"_id":"HtxACY2wX4b2hS8Rv","cls":"Account","slug":"exabyte"},"properties":["band_structure"],"schemaVersion":"0.2.0","slug":"workflow","subworkflows":[{"_id":"LCthJ6E2QabYCZqf4","application":{"name":"espresso","shortName":"qe","summary":"Quantum Espresso","version":"5.1.1","hasAdvancedComputeOptions":true},"model":{"method":{"data":{"pseudo":[]},"subtype":"us","type":"pseudopotential"},"subtype":"gga","type":"dft"},"name":"Band Structure","properties":["band_structure"],"units":[{"application":{"name":"espresso","shortName":"qe","summary":"Quantum Espresso","version":"5.1.1","hasAdvancedComputeOptions":true},"compute":null,"executable":{"advancedComputeOptions":true,"applicationId":["eaJepm4AWfqpaCw59"],"isDefault":true,"monitors":[{"name":"standard_output"}],"name":"pw.x","postProcessors":[],"preProcessors":[],"results":[{"name":"atomic_forces"}]},"flavor":{"executableId":"4987JFJ3kKbwvFSG7","input":[{"templateId":"dJ7HYz5pQ4AuN5qc9"}],"name":"pw_scf"},"flowchartId":"execution","head":true,"input":[{"content":"K_POINTS automatic\n2 2 2 0 0 0","name":"pw_scf.in"}],"monitors":[{"name":"scf_accuracy"},{"name":"standard_output"}],"name":"execution","next":"pw-bands","postProcessors":[],"preProcessors":[],"results":[{"name":"harris_foulkes_estimate"}],"status":"idle","type":"execution"}]}],"tags":["workflow"],"units":[{"_id":"LCthJ6E2QabYCZqf4","flowchartId":"05c362dc27ff1bb98d16fd60","type":"subworkflow","name":"subworkflow unit"}]},"path":"workflow"}]''')