# generated by datamodel-codegen:
#   filename:  apse/file/applications/espresso/7.2/pw.x/cell.json
#   version:   0.28.5

from __future__ import annotations

from enum import Enum
from typing import Optional, Union

from pydantic import BaseModel, ConfigDict, Field, RootModel


class CellDofree(Enum):
    all = "all"
    ibrav = "ibrav"
    a = "a"
    b = "b"
    c = "c"
    fixa = "fixa"
    fixb = "fixb"
    fixc = "fixc"
    x = "x"
    y = "y"
    xy = "xy"
    xz = "xz"
    xyz = "xyz"
    shape = "shape"
    volume = "volume"
    field_2Dxy = "2Dxy"
    field_2Dshape = "2Dshape"
    epitaxial_ab = "epitaxial_ab"
    epitaxial_ac = "epitaxial_ac"
    epitaxial_bc = "epitaxial_bc"


class CellDynamics(Enum):
    none = "none"
    sd = "sd"
    damp_pr = "damp-pr"
    damp_w = "damp-w"
    bfgs = "bfgs"


class CellSchema(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    press: Optional[float] = 0
    """
    Target pressure [KBar] in a variable-cell md or relaxation run.
    """
    wmass: Optional[float] = None
    """
    Fictitious cell mass [amu] for variable-cell simulations (both 'vc-md' and 'vc-relax'). Default: 0.75*Tot_Mass/pi**2 for Parrinello-Rahman MD; 0.75*Tot_Mass/pi**2/Omega**(2/3) for Wentzcovitch MD
    """
    cell_factor: Optional[float] = None
    """
    Used in the construction of the pseudopotential tables. It should exceed the maximum linear contraction of the cell during a simulation. Default: 2.0 for variable-cell calculations, 1.0 otherwise
    """
    press_conv_thr: Optional[float] = 0.5
    """
    Convergence threshold on the pressure for variable cell relaxation ('vc-relax' : note that the other convergence thresholds for ionic relaxation apply as well).
    """
    cell_dofree: Optional[CellDofree] = "all"
    """
    Select which of the cell parameters should be moved
    """
    cell_dynamics: Optional[CellDynamics] = "bfgs"
    """
    CASE ( calculation == 'vc-relax' )
    """


class CellDynamics1(Enum):
    none = "none"
    pr = "pr"
    w = "w"


class CellSchema1(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    press: Optional[float] = 0
    """
    Target pressure [KBar] in a variable-cell md or relaxation run.
    """
    wmass: Optional[float] = None
    """
    Fictitious cell mass [amu] for variable-cell simulations (both 'vc-md' and 'vc-relax'). Default: 0.75*Tot_Mass/pi**2 for Parrinello-Rahman MD; 0.75*Tot_Mass/pi**2/Omega**(2/3) for Wentzcovitch MD
    """
    cell_factor: Optional[float] = None
    """
    Used in the construction of the pseudopotential tables. It should exceed the maximum linear contraction of the cell during a simulation. Default: 2.0 for variable-cell calculations, 1.0 otherwise
    """
    press_conv_thr: Optional[float] = 0.5
    """
    Convergence threshold on the pressure for variable cell relaxation ('vc-relax' : note that the other convergence thresholds for ionic relaxation apply as well).
    """
    cell_dofree: Optional[CellDofree] = "all"
    """
    Select which of the cell parameters should be moved
    """
    cell_dynamics: Optional[CellDynamics1] = None
    """
    CASE ( calculation == 'vc-md' )
    """


class ESSE(RootModel[Union[CellSchema, CellSchema1]]):
    root: Union[CellSchema, CellSchema1] = Field(..., title="cell schema")
