# generated by datamodel-codegen:
#   filename:  apse/file/applications/espresso/7.2/pw.x/control.json
#   version:   0.28.5

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import BaseModel, ConfigDict


class Calculation(Enum):
    scf = "scf"
    nscf = "nscf"
    bands = "bands"
    relax = "relax"
    md = "md"
    vc_relax = "vc-relax"
    vc_md = "vc-md"


class Verbosity(Enum):
    high = "high"
    low = "low"
    debug = "debug"
    medium = "medium"
    minimal = "minimal"
    default = "default"


class RestartMode(Enum):
    from_scratch = "from_scratch"
    restart = "restart"


class DiskIo(Enum):
    high = "high"
    medium = "medium"
    low = "low"
    nowf = "nowf"
    none = "none"


class ControlSchema(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    calculation: Optional[Calculation] = "scf"
    """
    A string describing the task to be performed
    """
    title: Optional[str] = ""
    """
    reprinted on output.
    """
    verbosity: Optional[Verbosity] = "low"
    """
    Currently two verbosity levels are implemented: high, low. 'debug' and 'medium' have the same effect as 'high'; 'default' and 'minimal' as 'low'
    """
    restart_mode: Optional[RestartMode] = "from_scratch"
    wf_collect: Optional[bool] = None
    """
    OBSOLETE - NO LONGER IMPLEMENTED
    """
    nstep: Optional[float] = 1
    """
    Default: 1 if calculation == 'scf', 'nscf', 'bands'; 50 for the other cases; Number of molecular-dynamics or structural optimization steps performed in this run. If set to 0, the code performs a quick "dry run", stopping just after initialization. This is useful to check for input correctness and to have the summary printed. NOTE: in MD calculations, the code will perform "nstep" steps even if restarting from a previously interrupted calculation.
    """
    iprint: Optional[float] = None
    """
    band energies are written every iprint iterations
    """
    tstress: Optional[bool] = False
    """
    calculate stress. It is set to .TRUE. automatically if calculation == 'vc-md' or 'vc-relax'
    """
    tprnfor: Optional[bool] = None
    """
    calculate forces. It is set to .TRUE. automatically if calculation == 'relax','md','vc-md'
    """
    dt: Optional[float] = 20
    """
    time step for molecular dynamics, in Rydberg atomic units (1 a.u.=4.8378 * 10^-17 s : beware, the CP code uses Hartree atomic units, half that much!!!)
    """
    outdir: Optional[str] = None
    """
    input, temporary, output files are found in this directory, see also wfcdir
    """
    wfcdir: Optional[str] = None
    """
    This directory specifies where to store files generated by each processor (*.wfc{N}, *.igk{N}, etc.). Useful for machines without a parallel file system: set wfcdir to a local file system, while outdir should be a parallel or network file system, visible to all processors. Beware: in order to restart from interrupted runs, or to perform further calculations using the produced data files, you may need to copy files to outdir. Works only for pw.x.
    """
    prefix: Optional[str] = "pwscf"
    """
    prepended to input/output filenames: prefix.wfc, prefix.rho, etc.
    """
    lkpoint_dir: Optional[bool] = None
    """
    OBSOLETE - NO LONGER IMPLEMENTED
    """
    max_seconds: Optional[float] = 10000000
    """
    Jobs stops after max_seconds CPU time. Use this option in conjunction with option restart_mode if you need to split a job too long to complete into shorter jobs that fit into your batch queues.
    """
    etot_conv_thr: Optional[float] = 0.0001
    """
    Convergence threshold on total energy (a.u) for ionic minimization: the convergence criterion is satisfied when the total energy changes less than etot_conv_thr between two consecutive scf steps. Note that etot_conv_thr is extensive, like the total energy. See also forc_conv_thr - both criteria must be satisfied
    """
    forc_conv_thr: Optional[float] = 0.001
    """
    Convergence threshold on forces (a.u) for ionic minimization: the convergence criterion is satisfied when all components of all forces are smaller than forc_conv_thr. See also etot_conv_thr - both criteria must be satisfied
    """
    disk_io: Optional[DiskIo] = None
    """
    Specifies the amount of disk I/O activity: (only for binary files and xml data file in data directory; other files printed at each molecular dynamics / structural optimization step are not controlled by this option )
    """
    pseudo_dir: Optional[str] = None
    """
    directory containing pseudopotential files. Default: value of the $ESPRESSO_PSEUDO environment variable if set; '$HOME/espresso/pseudo/' otherwise
    """
    tefield: Optional[bool] = False
    """
    If .TRUE. a saw-like potential simulating an electric field is added to the bare ionic potential. See variables edir, eamp, emaxpos, eopreg for the form and size of the added potential.
    """
    dipfield: Optional[bool] = False
    """
    If .TRUE. and tefield==.TRUE. a dipole correction is also added to the bare ionic potential - implements the recipe of L. Bengtsson, PRB 59, 12301 (1999). See variables edir, emaxpos, eopreg for the form of the correction. Must be used ONLY in a slab geometry, for surface calculations, with the discontinuity FALLING IN THE EMPTY SPACE.
    """
    lelfield: Optional[bool] = False
    """
    If .TRUE. a homogeneous finite electric field described through the modern theory of the polarization is applied. This is different from tefield == .true. !
    """
    nberrycyc: Optional[int] = 1
    """
    In the case of a finite electric field  ( lelfield == .TRUE. ) it defines the number of iterations for converging the wavefunctions in the electric field Hamiltonian, for each external iteration on the charge density
    """
    lorbm: Optional[bool] = False
    """
    If .TRUE. perform orbital magnetization calculation.
    """
    lberry: Optional[bool] = False
    """
    If .TRUE. perform a Berry phase calculation. See the header of PW/src/bp_c_phase.f90 for documentation
    """
    gdir: Optional[float] = None
    """
    For Berry phase calculation: direction of the k-point strings in reciprocal space. Allowed values: 1, 2, 3 1=first, 2=second, 3=third reciprocal lattice vector For calculations with finite electric fields (lelfield==.true.) "gdir" is the direction of the field.
    """
    nppstr: Optional[float] = None
    """
    For Berry phase calculation: number of k-points to be calculated along each symmetry-reduced string. The same for calculation with finite electric fields (lelfield==.true.).
    """
    gate: Optional[bool] = False
    """
    In the case of charged cells (tot_charge .ne. 0) setting gate = .TRUE. represents the counter charge (i.e. -tot_charge) not by a homogeneous background charge but with a charged plate, which is placed at zgate (see below). Details of the gate potential can be found in T. Brumme, M. Calandra, F. Mauri; PRB 89, 245406 (2014). Note, that in systems which are not symmetric with respect to the plate, one needs to enable the dipole correction! (dipfield=.true.). Currently, symmetry can be used with gate=.true. but carefully check that no symmetry is included which maps z to -z even if in principle one could still use them for symmetric systems (i.e. no dipole correction). For nosym=.false. verbosity is set to 'high'. Note: this option was called "monopole" in v6.0 and 6.1 of pw.x
    """
    twochem: Optional[bool] = False
    """
    IF .TRUE. , a two chemical potential calculation for the simulation of photoexcited systems is performed, constraining a fraction of the electrons in the conduction manifold.
    """
    lfcp: Optional[bool] = False
    """
    If .TRUE. perform a constant bias potential (constant-mu) calculation for a system with ESM method. See the header of PW/src/fcp_module.f90 for documentation. To perform the calculation, you must set a namelist FCP.
    """
    trism: Optional[bool] = False
    """
    If .TRUE. perform a 3D-RISM-SCF calculation [for details see H.Sato et al., JCP 112, 9463 (2000), doi:10.1063/1.481564]. The solvent's distributions are calculated by 3D-RISM, though solute is treated as SCF. The charge density and the atomic positions are optimized, simultaneously with the solvents. To perform the calculation, you must set a namelist RISM and a card SOLVENTS. If assume_isolated = 'esm' and esm_bc = 'bc1', Laue-RISM is calculated instead of 3D-RISM and coupled with ESM method (i.e. ESM-RISM). [for details see S.Nishihara and M.Otani, PRB 96, 115429 (2017)]. The default of mixing_beta is 0.2 for both 3D-RISM and Laue-RISM. For structural relaxation with BFGS, ignore_wolfe is always .TRUE. .
    """
