# generated by datamodel-codegen:
#   filename:  apse/file/applications/espresso/7.2/pw.x/hubbard.json
#   version:   0.28.5

from __future__ import annotations

from enum import Enum
from typing import List, Optional, Union

from pydantic import BaseModel, ConfigDict, Field


class CardOption(Enum):
    atomic = "atomic"
    ortho_atomic = "ortho-atomic"
    norm_atomic = "norm-atomic"
    wf = "wf"
    pseudo = "pseudo"


class U(Enum):
    U = "U"


class Values(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    U_1: Optional[U] = Field(None, alias="U")
    """
    string constant "U"; indicates the specs for the U parameter will be given
    """
    label: Optional[str] = None
    """
    label of the atom (as defined in ATOMIC_SPECIES)
    """
    manifold: Optional[str] = None
    """
    specs of the manifold (e.g., 3d, 2p...)
    """
    u_val: Optional[float] = None
    """
    value of the U parameter (in eV)
    """


class J0(Enum):
    J0 = "J0"


class Values2(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    J0_1: Optional[J0] = Field(None, alias="J0")
    """
    string constant "J0"; indicates the specs for the J0 parameter will be given
    """
    label: Optional[str] = None
    """
    label of the atom (as defined in ATOMIC_SPECIES)
    """
    manifold: Optional[str] = None
    """
    specs of the manifold (e.g., 3d, 2p...)
    """
    j0_val: Optional[float] = None
    """
    value of the J0 parameter (in eV)
    """


class ParamType(Enum):
    U = "U"
    J = "J"
    B = "B"
    E2 = "E2"
    E3 = "E3"


class Value(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    paramType: Optional[ParamType] = None
    """
    character describing the type of Hubbard parameter allowed values: U, J and either B (for d-orbitals) or E2 and E3 (for f-orbitals)
    """
    label: Optional[str] = None
    """
    label of the atom (as defined in ATOMIC_SPECIES)
    """
    manifold: Optional[str] = None
    """
    specs of the manifold (e.g., 3d, 2p...)
    """
    paramValue: Optional[float] = None
    """
    value of the J0 parameter (in eV)
    """


class Values3(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    U_1: Optional[U] = Field(None, alias="U")
    """
    string constant "U"; indicates the specs for the U parameter will be given
    """
    label: Optional[str] = None
    """
    label of the atom (as defined in ATOMIC_SPECIES)
    """
    manifold: Optional[str] = None
    """
    specs of the manifold (e.g., 3d, 2p...)
    """
    u_val: Optional[float] = None
    """
    value of the U parameter (in eV)
    """


class Values4(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    J0_1: Optional[J0] = Field(None, alias="J0")
    """
    string constant "J0"; indicates the specs for the J0 parameter will be given
    """
    label: Optional[str] = None
    """
    label of the atom (as defined in ATOMIC_SPECIES)
    """
    manifold: Optional[str] = None
    """
    specs of the manifold (e.g., 3d, 2p...)
    """
    j0_val: Optional[float] = None
    """
    value of the J0 parameter (in eV)
    """


class V(Enum):
    V = "V"


class Values5(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    V_1: Optional[V] = Field(None, alias="V")
    """
    string constant "V"; indicates the specs for the V parameter will be given
    """
    label_I_: Optional[str] = Field(None, alias="label(I)")
    """
    label of the atom I (as defined in ATOMIC_SPECIES)
    """
    manifold_I_: Optional[str] = Field(None, alias="manifold(I)")
    """
    specs of the manifold for atom I (e.g., 3d, 2p...)
    """
    label_J_: Optional[str] = Field(None, alias="label(J)")
    """
    label of the atom J (as defined in ATOMIC_SPECIES)
    """
    manifold_J_: Optional[str] = Field(None, alias="manifold(J)")
    """
    specs of the manifold for atom J (e.g., 3d, 2p...)
    """
    I: Optional[int] = None
    """
    index of the atom I
    """
    J: Optional[int] = None
    """
    index of the atom J
    """
    v_val_I_J_: Optional[float] = Field(None, alias="v_val(I,J)")
    """
    value of the V parameter for the atom pair I,J (in eV)
    """


class HubbardSchema(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    card_option: Optional[CardOption] = None
    values: Optional[Union[List[Union[Values, Values2]], List[Value], List[Union[Values3, Values4, Values5]]]] = None
