# generated by datamodel-codegen:
#   filename:  apse/file/applications/espresso/7.2/pw.x/ions.json
#   version:   0.28.5

from __future__ import annotations

from enum import Enum
from typing import Optional, Union

from pydantic import BaseModel, ConfigDict, Field, RootModel


class IonPositions(Enum):
    default = "default"
    from_input = "from_input"


class IonVelocities(Enum):
    default = "default"
    from_input = "from_input"


class PotExtrapolation(Enum):
    none = "none"
    atomic = "atomic"
    first_order = "first_order"
    second_order = "second_order"


class WfcExtrapolation(Enum):
    none = "none"
    first_order = "first_order"
    second_order = "second_order"


class IonTemperature(Enum):
    rescaling = "rescaling"
    rescale_v = "rescale-v"
    rescale_T = "rescale-T"
    reduce_T = "reduce-T"
    berendsen = "berendsen"
    andersen = "andersen"
    svr = "svr"
    initial = "initial"
    not_controlled = "not_controlled"


class IonDynamics(Enum):
    bfgs = "bfgs"
    damp = "damp"
    fire = "fire"


class IonsSchema(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    ion_positions: Optional[IonPositions] = "default"
    ion_velocities: Optional[IonVelocities] = "default"
    pot_extrapolation: Optional[PotExtrapolation] = "atomic"
    """
    Used to extrapolate the potential from preceding ionic steps.
    """
    wfc_extrapolation: Optional[WfcExtrapolation] = "none"
    """
    Used to extrapolate the wavefunctions from preceding ionic steps.
    """
    remove_rigid_rot: Optional[bool] = False
    """
    This keyword is useful when simulating the dynamics and/or the thermodynamics of an isolated system. If set to true the total torque of the internal forces is set to zero by adding new forces that compensate the spurious interaction with the periodic images. This allows for the use of smaller supercells.
    """
    ion_temperature: Optional[IonTemperature] = "not_controlled"
    tempw: Optional[float] = 300
    """
    Starting temperature (Kelvin) in MD runs target temperature for most thermostats.
    """
    tolp: Optional[float] = 100
    """
    Tolerance for velocity rescaling. Velocities are rescaled if the run-averaged and target temperature differ more than tolp.
    """
    delta_t: Optional[float] = 1
    nraise: Optional[int] = 1
    refold_pos: Optional[bool] = False
    """
    This keyword applies only in the case of molecular dynamics or damped dynamics. If true the ions are refolded at each step into the supercell.
    """
    upscale: Optional[float] = 100
    """
    Max reduction factor for conv_thr during structural optimization conv_thr is automatically reduced when the relaxation approaches convergence so that forces are still accurate, but conv_thr will not be reduced to less that conv_thr / upscale.
    """
    bfgs_ndim: Optional[int] = 1
    """
    Number of old forces and displacements vectors used in the PULAY mixing of the residual vectors obtained on the basis of the inverse hessian matrix given by the BFGS algorithm.
    """
    trust_radius_max: Optional[float] = 0.8
    """
    Maximum ionic displacement in the structural relaxation. (bfgs only)
    """
    trust_radius_min: Optional[float] = 0.001
    """
    Minimum ionic displacement in the structural relaxation BFGS is reset when trust_radius < trust_radius_min. (bfgs only)
    """
    trust_radius_ini: Optional[float] = 0.5
    """
    Initial ionic displacement in the structural relaxation. (bfgs only)
    """
    w_1: Optional[float] = 0.01
    w_2: Optional[float] = 0.5
    """
    Parameters used in line search based on the Wolfe conditions. (bfgs only)
    """
    fire_alpha_init: Optional[float] = 0.2
    """
    Initial value of the alpha mixing factor in the FIRE minimization scheme; recommended values are between 0.1 and 0.3
    """
    fire_falpha: Optional[float] = 0.99
    """
    Scaling of the alpha mixing parameter for steps with P > 0;
    """
    fire_nmin: Optional[int] = 5
    """
    Minimum number of steps with P > 0 before increase of dt
    """
    fire_f_inc: Optional[float] = 1.1
    """
    Factor for increasing dt
    """
    fire_f_dec: Optional[float] = 0.5
    """
    Factor for decreasing dt
    """
    fire_dtmax: Optional[float] = 10
    """
    Determines the maximum value of dt in the FIRE minimization; dtmax = fire_dtmax*dt
    """
    ion_dynamics: Optional[IonDynamics] = "bfgs"
    """
    CASE: calculation == 'relax'
    """


class IonDynamics1(Enum):
    verlet = "verlet"
    langevin = "langevin"
    langevin_smc = "langevin-smc"


class IonsSchema1(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    ion_positions: Optional[IonPositions] = "default"
    ion_velocities: Optional[IonVelocities] = "default"
    pot_extrapolation: Optional[PotExtrapolation] = "atomic"
    """
    Used to extrapolate the potential from preceding ionic steps.
    """
    wfc_extrapolation: Optional[WfcExtrapolation] = "none"
    """
    Used to extrapolate the wavefunctions from preceding ionic steps.
    """
    remove_rigid_rot: Optional[bool] = False
    """
    This keyword is useful when simulating the dynamics and/or the thermodynamics of an isolated system. If set to true the total torque of the internal forces is set to zero by adding new forces that compensate the spurious interaction with the periodic images. This allows for the use of smaller supercells.
    """
    ion_temperature: Optional[IonTemperature] = "not_controlled"
    tempw: Optional[float] = 300
    """
    Starting temperature (Kelvin) in MD runs target temperature for most thermostats.
    """
    tolp: Optional[float] = 100
    """
    Tolerance for velocity rescaling. Velocities are rescaled if the run-averaged and target temperature differ more than tolp.
    """
    delta_t: Optional[float] = 1
    nraise: Optional[int] = 1
    refold_pos: Optional[bool] = False
    """
    This keyword applies only in the case of molecular dynamics or damped dynamics. If true the ions are refolded at each step into the supercell.
    """
    upscale: Optional[float] = 100
    """
    Max reduction factor for conv_thr during structural optimization conv_thr is automatically reduced when the relaxation approaches convergence so that forces are still accurate, but conv_thr will not be reduced to less that conv_thr / upscale.
    """
    bfgs_ndim: Optional[int] = 1
    """
    Number of old forces and displacements vectors used in the PULAY mixing of the residual vectors obtained on the basis of the inverse hessian matrix given by the BFGS algorithm.
    """
    trust_radius_max: Optional[float] = 0.8
    """
    Maximum ionic displacement in the structural relaxation. (bfgs only)
    """
    trust_radius_min: Optional[float] = 0.001
    """
    Minimum ionic displacement in the structural relaxation BFGS is reset when trust_radius < trust_radius_min. (bfgs only)
    """
    trust_radius_ini: Optional[float] = 0.5
    """
    Initial ionic displacement in the structural relaxation. (bfgs only)
    """
    w_1: Optional[float] = 0.01
    w_2: Optional[float] = 0.5
    """
    Parameters used in line search based on the Wolfe conditions. (bfgs only)
    """
    fire_alpha_init: Optional[float] = 0.2
    """
    Initial value of the alpha mixing factor in the FIRE minimization scheme; recommended values are between 0.1 and 0.3
    """
    fire_falpha: Optional[float] = 0.99
    """
    Scaling of the alpha mixing parameter for steps with P > 0;
    """
    fire_nmin: Optional[int] = 5
    """
    Minimum number of steps with P > 0 before increase of dt
    """
    fire_f_inc: Optional[float] = 1.1
    """
    Factor for increasing dt
    """
    fire_f_dec: Optional[float] = 0.5
    """
    Factor for decreasing dt
    """
    fire_dtmax: Optional[float] = 10
    """
    Determines the maximum value of dt in the FIRE minimization; dtmax = fire_dtmax*dt
    """
    ion_dynamics: Optional[IonDynamics1] = "verlet"
    """
    CASE: calculation == 'md'
    """


class IonDynamics2(Enum):
    bfgs = "bfgs"
    damp = "damp"


class IonsSchema2(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    ion_positions: Optional[IonPositions] = "default"
    ion_velocities: Optional[IonVelocities] = "default"
    pot_extrapolation: Optional[PotExtrapolation] = "atomic"
    """
    Used to extrapolate the potential from preceding ionic steps.
    """
    wfc_extrapolation: Optional[WfcExtrapolation] = "none"
    """
    Used to extrapolate the wavefunctions from preceding ionic steps.
    """
    remove_rigid_rot: Optional[bool] = False
    """
    This keyword is useful when simulating the dynamics and/or the thermodynamics of an isolated system. If set to true the total torque of the internal forces is set to zero by adding new forces that compensate the spurious interaction with the periodic images. This allows for the use of smaller supercells.
    """
    ion_temperature: Optional[IonTemperature] = "not_controlled"
    tempw: Optional[float] = 300
    """
    Starting temperature (Kelvin) in MD runs target temperature for most thermostats.
    """
    tolp: Optional[float] = 100
    """
    Tolerance for velocity rescaling. Velocities are rescaled if the run-averaged and target temperature differ more than tolp.
    """
    delta_t: Optional[float] = 1
    nraise: Optional[int] = 1
    refold_pos: Optional[bool] = False
    """
    This keyword applies only in the case of molecular dynamics or damped dynamics. If true the ions are refolded at each step into the supercell.
    """
    upscale: Optional[float] = 100
    """
    Max reduction factor for conv_thr during structural optimization conv_thr is automatically reduced when the relaxation approaches convergence so that forces are still accurate, but conv_thr will not be reduced to less that conv_thr / upscale.
    """
    bfgs_ndim: Optional[int] = 1
    """
    Number of old forces and displacements vectors used in the PULAY mixing of the residual vectors obtained on the basis of the inverse hessian matrix given by the BFGS algorithm.
    """
    trust_radius_max: Optional[float] = 0.8
    """
    Maximum ionic displacement in the structural relaxation. (bfgs only)
    """
    trust_radius_min: Optional[float] = 0.001
    """
    Minimum ionic displacement in the structural relaxation BFGS is reset when trust_radius < trust_radius_min. (bfgs only)
    """
    trust_radius_ini: Optional[float] = 0.5
    """
    Initial ionic displacement in the structural relaxation. (bfgs only)
    """
    w_1: Optional[float] = 0.01
    w_2: Optional[float] = 0.5
    """
    Parameters used in line search based on the Wolfe conditions. (bfgs only)
    """
    fire_alpha_init: Optional[float] = 0.2
    """
    Initial value of the alpha mixing factor in the FIRE minimization scheme; recommended values are between 0.1 and 0.3
    """
    fire_falpha: Optional[float] = 0.99
    """
    Scaling of the alpha mixing parameter for steps with P > 0;
    """
    fire_nmin: Optional[int] = 5
    """
    Minimum number of steps with P > 0 before increase of dt
    """
    fire_f_inc: Optional[float] = 1.1
    """
    Factor for increasing dt
    """
    fire_f_dec: Optional[float] = 0.5
    """
    Factor for decreasing dt
    """
    fire_dtmax: Optional[float] = 10
    """
    Determines the maximum value of dt in the FIRE minimization; dtmax = fire_dtmax*dt
    """
    ion_dynamics: Optional[IonDynamics2] = "bfgs"
    """
    CASE: calculation == 'vc-relax'
    """


class IonDynamics3(Enum):
    beeman = "beeman"


class IonsSchema3(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    ion_positions: Optional[IonPositions] = "default"
    ion_velocities: Optional[IonVelocities] = "default"
    pot_extrapolation: Optional[PotExtrapolation] = "atomic"
    """
    Used to extrapolate the potential from preceding ionic steps.
    """
    wfc_extrapolation: Optional[WfcExtrapolation] = "none"
    """
    Used to extrapolate the wavefunctions from preceding ionic steps.
    """
    remove_rigid_rot: Optional[bool] = False
    """
    This keyword is useful when simulating the dynamics and/or the thermodynamics of an isolated system. If set to true the total torque of the internal forces is set to zero by adding new forces that compensate the spurious interaction with the periodic images. This allows for the use of smaller supercells.
    """
    ion_temperature: Optional[IonTemperature] = "not_controlled"
    tempw: Optional[float] = 300
    """
    Starting temperature (Kelvin) in MD runs target temperature for most thermostats.
    """
    tolp: Optional[float] = 100
    """
    Tolerance for velocity rescaling. Velocities are rescaled if the run-averaged and target temperature differ more than tolp.
    """
    delta_t: Optional[float] = 1
    nraise: Optional[int] = 1
    refold_pos: Optional[bool] = False
    """
    This keyword applies only in the case of molecular dynamics or damped dynamics. If true the ions are refolded at each step into the supercell.
    """
    upscale: Optional[float] = 100
    """
    Max reduction factor for conv_thr during structural optimization conv_thr is automatically reduced when the relaxation approaches convergence so that forces are still accurate, but conv_thr will not be reduced to less that conv_thr / upscale.
    """
    bfgs_ndim: Optional[int] = 1
    """
    Number of old forces and displacements vectors used in the PULAY mixing of the residual vectors obtained on the basis of the inverse hessian matrix given by the BFGS algorithm.
    """
    trust_radius_max: Optional[float] = 0.8
    """
    Maximum ionic displacement in the structural relaxation. (bfgs only)
    """
    trust_radius_min: Optional[float] = 0.001
    """
    Minimum ionic displacement in the structural relaxation BFGS is reset when trust_radius < trust_radius_min. (bfgs only)
    """
    trust_radius_ini: Optional[float] = 0.5
    """
    Initial ionic displacement in the structural relaxation. (bfgs only)
    """
    w_1: Optional[float] = 0.01
    w_2: Optional[float] = 0.5
    """
    Parameters used in line search based on the Wolfe conditions. (bfgs only)
    """
    fire_alpha_init: Optional[float] = 0.2
    """
    Initial value of the alpha mixing factor in the FIRE minimization scheme; recommended values are between 0.1 and 0.3
    """
    fire_falpha: Optional[float] = 0.99
    """
    Scaling of the alpha mixing parameter for steps with P > 0;
    """
    fire_nmin: Optional[int] = 5
    """
    Minimum number of steps with P > 0 before increase of dt
    """
    fire_f_inc: Optional[float] = 1.1
    """
    Factor for increasing dt
    """
    fire_f_dec: Optional[float] = 0.5
    """
    Factor for decreasing dt
    """
    fire_dtmax: Optional[float] = 10
    """
    Determines the maximum value of dt in the FIRE minimization; dtmax = fire_dtmax*dt
    """
    ion_dynamics: Optional[IonDynamics3] = "beeman"
    """
    CASE: calculation == 'vc-md'
    """


class ESSE(RootModel[Union[IonsSchema, IonsSchema1, IonsSchema2, IonsSchema3]]):
    root: Union[IonsSchema, IonsSchema1, IonsSchema2, IonsSchema3] = Field(..., title="ions schema")
