# generated by datamodel-codegen:
#   filename:  apse/file/applications/espresso/7.2/pw.x/system.json
#   version:   0.28.5

from __future__ import annotations

from enum import Enum
from typing import List, Optional, Union

from pydantic import BaseModel, ConfigDict, Field, RootModel, confloat, conint


class Occupations(Enum):
    smearing = "smearing"
    tetrahedra = "tetrahedra"
    tetrahedra_lin = "tetrahedra_lin"
    tetrahedra_opt = "tetrahedra_opt"
    fixed = "fixed"
    from_input = "from_input"


class Smearing(Enum):
    gaussian = "gaussian"
    gauss = "gauss"
    methfessel_paxton = "methfessel-paxton"
    m_p = "m-p"
    mp = "mp"
    marzari_vanderbilt = "marzari-vanderbilt"
    cold = "cold"
    m_v = "m-v"
    mv = "mv"
    fermi_dirac = "fermi-dirac"
    f_d = "f-d"
    fd = "fd"


class PolType(Enum):
    e = "e"
    h = "h"


class ExxdivTreatment(Enum):
    gygi_baldereschi = "gygi-baldereschi"
    vcut_spherical = "vcut_spherical"
    vcut_ws = "vcut_ws"
    none = "none"


class HubbardOccItem(RootModel[conint(ge=1)]):
    root: conint(ge=1)


class HubbardOccItem5(RootModel[conint(ge=1, le=3)]):
    root: conint(ge=1, le=3)


class ConstrainedMagnetization(Enum):
    none = "none"
    total = "total"
    atomic = "atomic"
    total_direction = "total direction"
    atomic_direction = "atomic direction"


class AssumeIsolated(Enum):
    none = "none"
    makov_payne = "makov-payne"
    m_p = "m-p"
    mp = "mp"
    martyna_tuckerman = "martyna-tuckerman"
    m_t = "m-t"
    mt = "mt"
    esm = "esm"
    field_2D = "2D"


class EsmBc(Enum):
    pbc = "pbc"
    bc1 = "bc1"
    bc2 = "bc2"
    bc3 = "bc3"


class VdwCorr(Enum):
    none = "none"
    grimme_d2 = "grimme-d2"
    Grimme_D2 = "Grimme-D2"
    DFT_D = "DFT-D"
    dft_d = "dft-d"
    grimme_d3 = "grimme-d3"
    Grimme_D3 = "Grimme-D3"
    DFT_D3 = "DFT-D3"
    dft_d3 = "dft-d3"
    TS = "TS"
    ts = "ts"
    ts_vdw = "ts-vdw"
    ts_vdW = "ts-vdW"
    tkatchenko_scheffler = "tkatchenko-scheffler"
    MBD = "MBD"
    mbd = "mbd"
    many_body_dispersion = "many-body-dispersion"
    mbd_vdw = "mbd_vdw"
    XDM = "XDM"
    xdm = "xdm"


class SystemSchema(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    ibrav: int
    nat: int
    """
    number of atoms in the unit cell (ALL atoms, except if space_group is set, in which case, INEQUIVALENT atoms)
    """
    ntyp: int
    """
    number of types of atoms in the unit cell
    """
    nbnd: Optional[int] = None
    """
    Default: for an insulator, nbnd = number of valence bands (nbnd = # of electrons /2); for a metal, 20% more (minimum 4 more)
    """
    nbnd_cond: Optional[int] = None
    """
    Default: nbnd_cond = nbnd - # of electrons / 2 in the collinear case; nbnd_cond = nbnd - # of electrons in the noncollinear case.
    """
    tot_charge: Optional[float] = 0
    starting_charge: Optional[float] = 0
    """
    starting charge on atomic type 'i', to create starting potential with startingpot = 'atomic'.
    """
    tot_magnetization: Optional[float] = -10000
    """
    Total majority spin charge - minority spin charge. Used to impose a specific total electronic magnetization. If unspecified then tot_magnetization variable is ignored and the amount of electronic magnetization is determined during the self-consistent cycle.
    """
    starting_magnetization: Optional[List[confloat(ge=-1.0, le=1.0)]] = None
    ecutwfc: float
    """
    kinetic energy cutoff (Ry) for wavefunctions
    """
    ecutrho: Optional[float] = None
    """
    Kinetic energy cutoff (Ry) for charge density and potential For norm-conserving pseudopotential you should stick to the default value, you can reduce it by a little but it will introduce noise especially on forces and stress. Default: 4 * ecutwfc
    """
    ecutfock: Optional[float] = None
    """
    Kinetic energy cutoff (Ry) for the exact exchange operator in EXX type calculations. By default this is the same as ecutrho but in some EXX calculations, a significant speed-up can be obtained by reducing ecutfock, at the expense of some loss in accuracy. Must be .gt. ecutwfc. Not implemented for stress calculation and for US-PP and PAW pseudopotentials.
    """
    nr1: Optional[int] = None
    """
    Three-dimensional FFT mesh (hard grid) for charge density (and scf potential). If not specified the grid is calculated based on the cutoff for charge density (see also ecutrho)
    """
    nr2: Optional[int] = None
    """
    Three-dimensional FFT mesh (hard grid) for charge density (and scf potential). If not specified the grid is calculated based on the cutoff for charge density (see also ecutrho)
    """
    nr3: Optional[int] = None
    """
    Three-dimensional FFT mesh (hard grid) for charge density (and scf potential). If not specified the grid is calculated based on the cutoff for charge density (see also ecutrho)
    """
    nr1s: Optional[int] = None
    """
    Three-dimensional mesh for wavefunction FFT and for the smooth part of charge density ( smooth grid ). Coincides with nr1, nr2, nr3 if ecutrho = 4 * ecutwfc ( default )
    """
    nr2s: Optional[int] = None
    """
    Three-dimensional mesh for wavefunction FFT and for the smooth part of charge density ( smooth grid ). Coincides with nr1, nr2, nr3 if ecutrho = 4 * ecutwfc ( default )
    """
    nr3s: Optional[int] = None
    """
    Three-dimensional mesh for wavefunction FFT and for the smooth part of charge density ( smooth grid ). Coincides with nr1, nr2, nr3 if ecutrho = 4 * ecutwfc ( default )
    """
    nosym: Optional[bool] = False
    nosym_evc: Optional[bool] = False
    noinv: Optional[bool] = False
    """
    if (.TRUE.) disable the usage of k => -k symmetry (time reversal) in k-point generation
    """
    no_t_rev: Optional[bool] = False
    """
    if (.TRUE.) disable the usage of magnetic symmetry operations that consist in a rotation + time reversal.
    """
    force_symmorphic: Optional[bool] = False
    """
    if (.TRUE.) force the symmetry group to be symmorphic by disabling symmetry operations having an associated fractionary translation
    """
    use_all_frac: Optional[bool] = False
    occupations: Optional[Occupations] = None
    one_atom_occupations: Optional[bool] = False
    starting_spin_angle: Optional[bool] = False
    degauss_cond: Optional[float] = 0
    """
    value of the gaussian spreading (Ry) for brillouin-zone integration in the conduction manifold in a two-chemical potential calculation (twochem=.true.).
    """
    nelec_cond: Optional[float] = 0
    """
    Number of electrons placed in the conduction manifold in a two-chemical potential calculation (twochem=.true.). Of the total # of electrons nelec, nelec-nelec_cond will occupy the valence manifold and nelec_cond will be constrained in the conduction manifold.
    """
    degauss: Optional[float] = 0
    """
    value of the gaussian spreading (Ry) for brillouin-zone integration in metals.
    """
    smearing: Optional[Smearing] = "gaussian"
    nspin: Optional[int] = 1
    sic_gamma: Optional[float] = 0
    """
    Strength of the gammaDFT potential.
    """
    pol_type: Optional[PolType] = None
    """
    Type of polaron in gammaDFT.
    """
    sic_energy: Optional[bool] = False
    """
    Enable the calculation of the total energy in gammaDFT. When .true., a preliminary calculation is performed to calculate the electron density in the absence of the polaron. When .false., the total energy printed in output should not be considered. For structural relaxations, it is recommended to use .false. to avoid doubling the computational cost.
    """
    sci_vb: Optional[float] = 0
    """
    Valence band shift (in eV) through self-consistent scissor operator. When performing gammaDFT calculations of polarons, the polaron level is not shifted.
    """
    sci_cb: Optional[float] = 0
    """
    Conduction band band shift (in eV) through self-consistent scissor operator. When performing gammaDFT calculations of polarons, the polaron level is not shifted.
    """
    noncolin: Optional[bool] = False
    """
    if .true. the program will perform a noncollinear calculation.
    """
    ecfixed: Optional[float] = 0
    qcutz: Optional[float] = 0
    q2sigma: Optional[float] = 0.1
    input_dft: Optional[str] = None
    """
    Exchange-correlation functional: eg 'PBE', 'BLYP' etc See Modules/funct.f90 for allowed values. Overrides the value read from pseudopotential files. Use with care and if you know what you are doing!
    """
    ace: Optional[bool] = True
    """
    Use Adaptively Compressed Exchange operator as in Lin Lin, J. Chem. Theory Comput. 2016, 12, 2242--2249, doi:10.1021/acs.jctc.6b00092
    """
    exx_fraction: Optional[float] = None
    """
    Fraction of EXX for hybrid functional calculations. In the case of input_dft='PBE0', the default value is 0.25, while for input_dft='B3LYP' the exx_fraction default value is 0.20.
    """
    screening_parameter: Optional[float] = 0.106
    """
    screening_parameter for HSE like hybrid functionals.
    """
    exxdiv_treatment: Optional[ExxdivTreatment] = "gygi-baldereschi"
    x_gamma_extrapolation: Optional[bool] = True
    """
    Specific for EXX. If .true., extrapolate the G=0 term of the potential
    """
    ecutvcut: Optional[float] = None
    """
    Reciprocal space cutoff for correcting Coulomb potential divergencies at small q vectors.
    """
    nqx1: Optional[int] = 0
    """
    Three-dimensional mesh for q (k1-k2) sampling of the Fock operator (EXX). Can be smaller than the number of k-points.
    """
    nqx2: Optional[int] = None
    """
    Three-dimensional mesh for q (k1-k2) sampling of the Fock operator (EXX). Can be smaller than the number of k-points.
    """
    nqx3: Optional[int] = None
    """
    Three-dimensional mesh for q (k1-k2) sampling of the Fock operator (EXX). Can be smaller than the number of k-points.
    """
    localization_thr: Optional[float] = 0
    """
    Overlap threshold over which the exchange integral over a pair of localized orbitals is included in the evaluation of EXX operator. Any value greater than 0.0 triggers the SCDM localization and the evaluation on EXX using the localized orbitals. Very small value of the threshold should yield the same result as the default EXX evaluation
    """
    Hubbard_occ: Optional[List[List[Union[HubbardOccItem, HubbardOccItem5, float]]]] = None
    Hubbard_alpha: Optional[List[float]] = None
    Hubbard_beta: Optional[List[float]] = None
    starting_ns_eigenvalue: Optional[List[List[List[float]]]] = None
    dmft: Optional[bool] = False
    """
    If true, nscf calculation will exit in restart mode, scf calculation will restart from there if DMFT updates are provided as hdf5 archive. Scf calculation should be used only with electron_maxstep = 1.
    """
    dmft_prefix: Optional[str] = None
    """
    prepended to hdf5 archive: dmft_prefix.h5
    """
    ensemble_energies: Optional[bool] = False
    """
    If ensemble_energies = .true., an ensemble of xc energies is calculated non-selfconsistently for perturbed exchange-enhancement factors and LDA vs. PBE correlation ratios after each converged electronic ground state calculation.
    """
    edir: Optional[int] = None
    """
    The direction of the electric field or dipole correction is parallel to the bg(:,edir) reciprocal lattice vector, so the potential is constant in planes defined by FFT grid points; edir = 1, 2 or 3. Used only if tefield is .TRUE.
    """
    emaxpos: Optional[float] = 0.5
    """
    Position of the maximum of the saw-like potential along crystal axis edir, within the  unit cell (see below), 0 < emaxpos < 1 Used only if tefield is .TRUE.
    """
    eopreg: Optional[float] = 0.1
    """
    Zone in the unit cell where the saw-like potential decreases. ( see below, 0 < eopreg < 1 ). Used only if tefield is .TRUE.
    """
    eamp: Optional[float] = 0.001
    angle1: Optional[List[float]] = Field(None, max_length=1, min_length=1)
    """
    The angle expressed in degrees between the initial magnetization and the z-axis. For noncollinear calculations only; index i runs over the atom types.
    """
    angle2: Optional[List[float]] = Field(None, max_length=1, min_length=1)
    """
    The angle expressed in degrees between the projection of the initial magnetization on x-y plane and the x-axis. For noncollinear calculations only.
    """
    lforcet: Optional[bool] = None
    """
    When starting a non collinear calculation using an existing density file from a collinear lsda calculation assumes previous density points in z direction and rotates it in the direction described by angle1 and angle2 variables for atomic type 1
    """
    constrained_magnetization: Optional[ConstrainedMagnetization] = "none"
    """
    Used to perform constrained calculations in magnetic systems.
    """
    fixed_magnetization: Optional[List[float]] = Field(None, max_length=3, min_length=3)
    lambda_: Optional[float] = Field(1, alias="lambda")
    """
    parameter used for constrained_magnetization calculations N.B.: if the scf calculation does not converge, try to reduce lambda to obtain convergence, then restart the run with a larger lambda
    """
    report: Optional[int] = -1
    """
    determines when atomic magnetic moments are printed on output
    """
    lspinorb: Optional[bool] = None
    """
    if .TRUE. the noncollinear code can use a pseudopotential with spin-orbit.
    """
    assume_isolated: Optional[AssumeIsolated] = "none"
    """
    Used to perform calculation assuming the system to be isolated (a molecule or a cluster in a 3D supercell)
    """
    esm_bc: Optional[EsmBc] = "pbc"
    """
    If assume_isolated = 'esm', determines the boundary conditions used for either side of the slab.
    """
    esm_w: Optional[float] = 0
    """
    If assume_isolated = 'esm', determines the position offset [in a.u.] of the start of the effective screening region, measured relative to the cell edge. (ESM region begins at z = +/- [L_z/2 + esm_w] ).
    """
    esm_efield: Optional[float] = 0
    """
    If assume_isolated = 'esm' and esm_bc = 'bc2', gives the magnitude of the electric field [Ry/a.u.] to be applied between semi-infinite ESM electrodes.
    """
    esm_nfit: Optional[int] = 4
    """
    If assume_isolated = 'esm', gives the number of z-grid points for the polynomial fit along the cell edge.
    """
    lgcscf: Optional[bool] = False
    """
    If .TRUE. perform a constant bias potential (constant-mu) calculation with Grand-Canonical SCF.
    """
    gcscf_mu: Optional[float] = None
    """
    The target Fermi energy (eV) of GC-SCF. One can start with appropriate total charge of the system by giving tot_charge
    """
    gcscf_conv_thr: Optional[float] = 0.01
    """
    Convergence threshold of Fermi energy (eV) for GC-SCF.
    """
    gcscf_beta: Optional[float] = 0.05
    """
    Mixing factor for GC-SCF. Larger values are recommended, if systems with small DOS on Fermi surface as graphite.
    """
    vdw_corr: Optional[VdwCorr] = "none"
    """
    Type of Van der Waals correction
    """
    london: Optional[bool] = False
    """
    OBSOLESCENT, same as vdw_corr='DFT-D'
    """
    london_s6: Optional[float] = 0.75
    """
    global scaling parameter for DFT-D. Default is good for PBE.
    """
    london_c6: Optional[float] = None
    """
    atomic C6 coefficient of each atom type
    """
    london_rvdw: Optional[float] = None
    """
    atomic vdw radii of each atom type
    """
    london_rcut: Optional[float] = 200
    """
    cutoff radius (a.u.) for dispersion interactions
    """
    dftd3_version: Optional[conint(ge=2, le=6)] = 3
    """
    Version of Grimme implementation of Grimme-D3
    """
    dftd3_threebody: Optional[bool] = True
    """
    Turn three-body terms in Grimme-D3 on. If .false. two-body contributions only are computed, using two-body parameters of Grimme-D3. If dftd3_version=2, three-body contribution is always disabled.
    """
    ts_vdw_econv_thr: Optional[float] = 1e-06
    """
    Optional: controls the convergence of the vdW energy (and forces). The default value is a safe choice, likely too safe, but you do not gain much in increasing it
    """
    ts_vdw_isolated: Optional[bool] = False
    """
    Optional: set it to .TRUE. when computing the Tkatchenko-Scheffler vdW energy or the Many-Body dispersion (MBD) energy for an isolated (non-periodic) system.
    """
    xdm: Optional[bool] = False
    """
    OBSOLESCENT, same as vdw_corr='xdm'
    """
    xdm_a1: Optional[float] = 0.6836
    """
    Damping function parameter a1 (adimensional)
    """
    xdm_a2: Optional[float] = 1.5045
    """
    Damping function parameter a2 (angstrom)
    """
    space_group: Optional[int] = 0
    """
    The number of the space group of the crystal, as given in the International Tables of Crystallography A (ITA)
    """
    uniqueb: Optional[bool] = False
    """
    Used only for monoclinic lattices
    """
    origin_choice: Optional[int] = 1
    """
    Used only for space groups that in the ITA allow the use of two different origins
    """
    rhombohedral: Optional[bool] = True
    """
    Used only for rhombohedral space groups.
    """
    zgate: Optional[float] = 0.5
    """
    used only if gate = .TRUE.
    """
    relaxz: Optional[bool] = False
    """
    used only if gate = .TRUE.
    """
    block: Optional[bool] = False
    """
    used only if gate = .TRUE.
    """
    block_1: Optional[float] = 0.45
    """
    used only if gate = .TRUE. and block = .TRUE.
    """
    block_2: Optional[float] = 0.55
    """
    used only if gate = .TRUE. and block = .TRUE.
    """
    block_height: Optional[float] = 0.1
    """
    used only if gate = .TRUE. and block = .TRUE.
    """
    nextffield: Optional[int] = 0
    """
    Number of activated external ionic force fields.
    """
    celldm: Optional[List[float]] = Field(None, max_length=6, min_length=6)


class HubbardOccItem6(RootModel[conint(ge=1)]):
    root: conint(ge=1)


class HubbardOccItem7(RootModel[conint(ge=1, le=3)]):
    root: conint(ge=1, le=3)


class SystemSchema3(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    ibrav: int
    nat: int
    """
    number of atoms in the unit cell (ALL atoms, except if space_group is set, in which case, INEQUIVALENT atoms)
    """
    ntyp: int
    """
    number of types of atoms in the unit cell
    """
    nbnd: Optional[int] = None
    """
    Default: for an insulator, nbnd = number of valence bands (nbnd = # of electrons /2); for a metal, 20% more (minimum 4 more)
    """
    nbnd_cond: Optional[int] = None
    """
    Default: nbnd_cond = nbnd - # of electrons / 2 in the collinear case; nbnd_cond = nbnd - # of electrons in the noncollinear case.
    """
    tot_charge: Optional[float] = 0
    starting_charge: Optional[float] = 0
    """
    starting charge on atomic type 'i', to create starting potential with startingpot = 'atomic'.
    """
    tot_magnetization: Optional[float] = -10000
    """
    Total majority spin charge - minority spin charge. Used to impose a specific total electronic magnetization. If unspecified then tot_magnetization variable is ignored and the amount of electronic magnetization is determined during the self-consistent cycle.
    """
    starting_magnetization: Optional[List[confloat(ge=-1.0, le=1.0)]] = None
    ecutwfc: float
    """
    kinetic energy cutoff (Ry) for wavefunctions
    """
    ecutrho: Optional[float] = None
    """
    Kinetic energy cutoff (Ry) for charge density and potential For norm-conserving pseudopotential you should stick to the default value, you can reduce it by a little but it will introduce noise especially on forces and stress. Default: 4 * ecutwfc
    """
    ecutfock: Optional[float] = None
    """
    Kinetic energy cutoff (Ry) for the exact exchange operator in EXX type calculations. By default this is the same as ecutrho but in some EXX calculations, a significant speed-up can be obtained by reducing ecutfock, at the expense of some loss in accuracy. Must be .gt. ecutwfc. Not implemented for stress calculation and for US-PP and PAW pseudopotentials.
    """
    nr1: Optional[int] = None
    """
    Three-dimensional FFT mesh (hard grid) for charge density (and scf potential). If not specified the grid is calculated based on the cutoff for charge density (see also ecutrho)
    """
    nr2: Optional[int] = None
    """
    Three-dimensional FFT mesh (hard grid) for charge density (and scf potential). If not specified the grid is calculated based on the cutoff for charge density (see also ecutrho)
    """
    nr3: Optional[int] = None
    """
    Three-dimensional FFT mesh (hard grid) for charge density (and scf potential). If not specified the grid is calculated based on the cutoff for charge density (see also ecutrho)
    """
    nr1s: Optional[int] = None
    """
    Three-dimensional mesh for wavefunction FFT and for the smooth part of charge density ( smooth grid ). Coincides with nr1, nr2, nr3 if ecutrho = 4 * ecutwfc ( default )
    """
    nr2s: Optional[int] = None
    """
    Three-dimensional mesh for wavefunction FFT and for the smooth part of charge density ( smooth grid ). Coincides with nr1, nr2, nr3 if ecutrho = 4 * ecutwfc ( default )
    """
    nr3s: Optional[int] = None
    """
    Three-dimensional mesh for wavefunction FFT and for the smooth part of charge density ( smooth grid ). Coincides with nr1, nr2, nr3 if ecutrho = 4 * ecutwfc ( default )
    """
    nosym: Optional[bool] = False
    nosym_evc: Optional[bool] = False
    noinv: Optional[bool] = False
    """
    if (.TRUE.) disable the usage of k => -k symmetry (time reversal) in k-point generation
    """
    no_t_rev: Optional[bool] = False
    """
    if (.TRUE.) disable the usage of magnetic symmetry operations that consist in a rotation + time reversal.
    """
    force_symmorphic: Optional[bool] = False
    """
    if (.TRUE.) force the symmetry group to be symmorphic by disabling symmetry operations having an associated fractionary translation
    """
    use_all_frac: Optional[bool] = False
    occupations: Optional[Occupations] = None
    one_atom_occupations: Optional[bool] = False
    starting_spin_angle: Optional[bool] = False
    degauss_cond: Optional[float] = 0
    """
    value of the gaussian spreading (Ry) for brillouin-zone integration in the conduction manifold in a two-chemical potential calculation (twochem=.true.).
    """
    nelec_cond: Optional[float] = 0
    """
    Number of electrons placed in the conduction manifold in a two-chemical potential calculation (twochem=.true.). Of the total # of electrons nelec, nelec-nelec_cond will occupy the valence manifold and nelec_cond will be constrained in the conduction manifold.
    """
    degauss: Optional[float] = 0
    """
    value of the gaussian spreading (Ry) for brillouin-zone integration in metals.
    """
    smearing: Optional[Smearing] = "gaussian"
    nspin: Optional[int] = 1
    sic_gamma: Optional[float] = 0
    """
    Strength of the gammaDFT potential.
    """
    pol_type: Optional[PolType] = None
    """
    Type of polaron in gammaDFT.
    """
    sic_energy: Optional[bool] = False
    """
    Enable the calculation of the total energy in gammaDFT. When .true., a preliminary calculation is performed to calculate the electron density in the absence of the polaron. When .false., the total energy printed in output should not be considered. For structural relaxations, it is recommended to use .false. to avoid doubling the computational cost.
    """
    sci_vb: Optional[float] = 0
    """
    Valence band shift (in eV) through self-consistent scissor operator. When performing gammaDFT calculations of polarons, the polaron level is not shifted.
    """
    sci_cb: Optional[float] = 0
    """
    Conduction band band shift (in eV) through self-consistent scissor operator. When performing gammaDFT calculations of polarons, the polaron level is not shifted.
    """
    noncolin: Optional[bool] = False
    """
    if .true. the program will perform a noncollinear calculation.
    """
    ecfixed: Optional[float] = 0
    qcutz: Optional[float] = 0
    q2sigma: Optional[float] = 0.1
    input_dft: Optional[str] = None
    """
    Exchange-correlation functional: eg 'PBE', 'BLYP' etc See Modules/funct.f90 for allowed values. Overrides the value read from pseudopotential files. Use with care and if you know what you are doing!
    """
    ace: Optional[bool] = True
    """
    Use Adaptively Compressed Exchange operator as in Lin Lin, J. Chem. Theory Comput. 2016, 12, 2242--2249, doi:10.1021/acs.jctc.6b00092
    """
    exx_fraction: Optional[float] = None
    """
    Fraction of EXX for hybrid functional calculations. In the case of input_dft='PBE0', the default value is 0.25, while for input_dft='B3LYP' the exx_fraction default value is 0.20.
    """
    screening_parameter: Optional[float] = 0.106
    """
    screening_parameter for HSE like hybrid functionals.
    """
    exxdiv_treatment: Optional[ExxdivTreatment] = "gygi-baldereschi"
    x_gamma_extrapolation: Optional[bool] = True
    """
    Specific for EXX. If .true., extrapolate the G=0 term of the potential
    """
    ecutvcut: Optional[float] = None
    """
    Reciprocal space cutoff for correcting Coulomb potential divergencies at small q vectors.
    """
    nqx1: Optional[int] = 0
    """
    Three-dimensional mesh for q (k1-k2) sampling of the Fock operator (EXX). Can be smaller than the number of k-points.
    """
    nqx2: Optional[int] = None
    """
    Three-dimensional mesh for q (k1-k2) sampling of the Fock operator (EXX). Can be smaller than the number of k-points.
    """
    nqx3: Optional[int] = None
    """
    Three-dimensional mesh for q (k1-k2) sampling of the Fock operator (EXX). Can be smaller than the number of k-points.
    """
    localization_thr: Optional[float] = 0
    """
    Overlap threshold over which the exchange integral over a pair of localized orbitals is included in the evaluation of EXX operator. Any value greater than 0.0 triggers the SCDM localization and the evaluation on EXX using the localized orbitals. Very small value of the threshold should yield the same result as the default EXX evaluation
    """
    Hubbard_occ: Optional[List[List[Union[HubbardOccItem6, HubbardOccItem7, float]]]] = None
    Hubbard_alpha: Optional[List[float]] = None
    Hubbard_beta: Optional[List[float]] = None
    starting_ns_eigenvalue: Optional[List[List[List[float]]]] = None
    dmft: Optional[bool] = False
    """
    If true, nscf calculation will exit in restart mode, scf calculation will restart from there if DMFT updates are provided as hdf5 archive. Scf calculation should be used only with electron_maxstep = 1.
    """
    dmft_prefix: Optional[str] = None
    """
    prepended to hdf5 archive: dmft_prefix.h5
    """
    ensemble_energies: Optional[bool] = False
    """
    If ensemble_energies = .true., an ensemble of xc energies is calculated non-selfconsistently for perturbed exchange-enhancement factors and LDA vs. PBE correlation ratios after each converged electronic ground state calculation.
    """
    edir: Optional[int] = None
    """
    The direction of the electric field or dipole correction is parallel to the bg(:,edir) reciprocal lattice vector, so the potential is constant in planes defined by FFT grid points; edir = 1, 2 or 3. Used only if tefield is .TRUE.
    """
    emaxpos: Optional[float] = 0.5
    """
    Position of the maximum of the saw-like potential along crystal axis edir, within the  unit cell (see below), 0 < emaxpos < 1 Used only if tefield is .TRUE.
    """
    eopreg: Optional[float] = 0.1
    """
    Zone in the unit cell where the saw-like potential decreases. ( see below, 0 < eopreg < 1 ). Used only if tefield is .TRUE.
    """
    eamp: Optional[float] = 0.001
    angle1: Optional[List[float]] = Field(None, max_length=1, min_length=1)
    """
    The angle expressed in degrees between the initial magnetization and the z-axis. For noncollinear calculations only; index i runs over the atom types.
    """
    angle2: Optional[List[float]] = Field(None, max_length=1, min_length=1)
    """
    The angle expressed in degrees between the projection of the initial magnetization on x-y plane and the x-axis. For noncollinear calculations only.
    """
    lforcet: Optional[bool] = None
    """
    When starting a non collinear calculation using an existing density file from a collinear lsda calculation assumes previous density points in z direction and rotates it in the direction described by angle1 and angle2 variables for atomic type 1
    """
    constrained_magnetization: Optional[ConstrainedMagnetization] = "none"
    """
    Used to perform constrained calculations in magnetic systems.
    """
    fixed_magnetization: Optional[List[float]] = Field(None, max_length=3, min_length=3)
    lambda_: Optional[float] = Field(1, alias="lambda")
    """
    parameter used for constrained_magnetization calculations N.B.: if the scf calculation does not converge, try to reduce lambda to obtain convergence, then restart the run with a larger lambda
    """
    report: Optional[int] = -1
    """
    determines when atomic magnetic moments are printed on output
    """
    lspinorb: Optional[bool] = None
    """
    if .TRUE. the noncollinear code can use a pseudopotential with spin-orbit.
    """
    assume_isolated: Optional[AssumeIsolated] = "none"
    """
    Used to perform calculation assuming the system to be isolated (a molecule or a cluster in a 3D supercell)
    """
    esm_bc: Optional[EsmBc] = "pbc"
    """
    If assume_isolated = 'esm', determines the boundary conditions used for either side of the slab.
    """
    esm_w: Optional[float] = 0
    """
    If assume_isolated = 'esm', determines the position offset [in a.u.] of the start of the effective screening region, measured relative to the cell edge. (ESM region begins at z = +/- [L_z/2 + esm_w] ).
    """
    esm_efield: Optional[float] = 0
    """
    If assume_isolated = 'esm' and esm_bc = 'bc2', gives the magnitude of the electric field [Ry/a.u.] to be applied between semi-infinite ESM electrodes.
    """
    esm_nfit: Optional[int] = 4
    """
    If assume_isolated = 'esm', gives the number of z-grid points for the polynomial fit along the cell edge.
    """
    lgcscf: Optional[bool] = False
    """
    If .TRUE. perform a constant bias potential (constant-mu) calculation with Grand-Canonical SCF.
    """
    gcscf_mu: Optional[float] = None
    """
    The target Fermi energy (eV) of GC-SCF. One can start with appropriate total charge of the system by giving tot_charge
    """
    gcscf_conv_thr: Optional[float] = 0.01
    """
    Convergence threshold of Fermi energy (eV) for GC-SCF.
    """
    gcscf_beta: Optional[float] = 0.05
    """
    Mixing factor for GC-SCF. Larger values are recommended, if systems with small DOS on Fermi surface as graphite.
    """
    vdw_corr: Optional[VdwCorr] = "none"
    """
    Type of Van der Waals correction
    """
    london: Optional[bool] = False
    """
    OBSOLESCENT, same as vdw_corr='DFT-D'
    """
    london_s6: Optional[float] = 0.75
    """
    global scaling parameter for DFT-D. Default is good for PBE.
    """
    london_c6: Optional[float] = None
    """
    atomic C6 coefficient of each atom type
    """
    london_rvdw: Optional[float] = None
    """
    atomic vdw radii of each atom type
    """
    london_rcut: Optional[float] = 200
    """
    cutoff radius (a.u.) for dispersion interactions
    """
    dftd3_version: Optional[conint(ge=2, le=6)] = 3
    """
    Version of Grimme implementation of Grimme-D3
    """
    dftd3_threebody: Optional[bool] = True
    """
    Turn three-body terms in Grimme-D3 on. If .false. two-body contributions only are computed, using two-body parameters of Grimme-D3. If dftd3_version=2, three-body contribution is always disabled.
    """
    ts_vdw_econv_thr: Optional[float] = 1e-06
    """
    Optional: controls the convergence of the vdW energy (and forces). The default value is a safe choice, likely too safe, but you do not gain much in increasing it
    """
    ts_vdw_isolated: Optional[bool] = False
    """
    Optional: set it to .TRUE. when computing the Tkatchenko-Scheffler vdW energy or the Many-Body dispersion (MBD) energy for an isolated (non-periodic) system.
    """
    xdm: Optional[bool] = False
    """
    OBSOLESCENT, same as vdw_corr='xdm'
    """
    xdm_a1: Optional[float] = 0.6836
    """
    Damping function parameter a1 (adimensional)
    """
    xdm_a2: Optional[float] = 1.5045
    """
    Damping function parameter a2 (angstrom)
    """
    space_group: Optional[int] = 0
    """
    The number of the space group of the crystal, as given in the International Tables of Crystallography A (ITA)
    """
    uniqueb: Optional[bool] = False
    """
    Used only for monoclinic lattices
    """
    origin_choice: Optional[int] = 1
    """
    Used only for space groups that in the ITA allow the use of two different origins
    """
    rhombohedral: Optional[bool] = True
    """
    Used only for rhombohedral space groups.
    """
    zgate: Optional[float] = 0.5
    """
    used only if gate = .TRUE.
    """
    relaxz: Optional[bool] = False
    """
    used only if gate = .TRUE.
    """
    block: Optional[bool] = False
    """
    used only if gate = .TRUE.
    """
    block_1: Optional[float] = 0.45
    """
    used only if gate = .TRUE. and block = .TRUE.
    """
    block_2: Optional[float] = 0.55
    """
    used only if gate = .TRUE. and block = .TRUE.
    """
    block_height: Optional[float] = 0.1
    """
    used only if gate = .TRUE. and block = .TRUE.
    """
    nextffield: Optional[int] = 0
    """
    Number of activated external ionic force fields.
    """
    A: Optional[float] = None
    B: Optional[float] = None
    C: Optional[float] = None
    cosAB: Optional[float] = None
    cosAC: Optional[float] = None
    cosBC: Optional[float] = None


class ESSE(RootModel[Union[SystemSchema, SystemSchema3]]):
    root: Union[SystemSchema, SystemSchema3] = Field(..., title="system schema")
