# generated by datamodel-codegen:
#   filename:  apse/file/applications/espresso/7.2/pw.x.json
#   version:   0.28.5

from __future__ import annotations

from enum import Enum
from typing import List, Optional, Union

from pydantic import BaseModel, ConfigDict, Field, RootModel, confloat, conint


class Calculation(Enum):
    scf = "scf"
    nscf = "nscf"
    bands = "bands"
    relax = "relax"
    md = "md"
    vc_relax = "vc-relax"
    vc_md = "vc-md"


class Verbosity(Enum):
    high = "high"
    low = "low"
    debug = "debug"
    medium = "medium"
    minimal = "minimal"
    default = "default"


class RestartMode(Enum):
    from_scratch = "from_scratch"
    restart = "restart"


class DiskIo(Enum):
    high = "high"
    medium = "medium"
    low = "low"
    nowf = "nowf"
    none = "none"


class ControlSchema(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    calculation: Optional[Calculation] = "scf"
    """
    A string describing the task to be performed
    """
    title: Optional[str] = ""
    """
    reprinted on output.
    """
    verbosity: Optional[Verbosity] = "low"
    """
    Currently two verbosity levels are implemented: high, low. 'debug' and 'medium' have the same effect as 'high'; 'default' and 'minimal' as 'low'
    """
    restart_mode: Optional[RestartMode] = "from_scratch"
    wf_collect: Optional[bool] = None
    """
    OBSOLETE - NO LONGER IMPLEMENTED
    """
    nstep: Optional[float] = 1
    """
    Default: 1 if calculation == 'scf', 'nscf', 'bands'; 50 for the other cases; Number of molecular-dynamics or structural optimization steps performed in this run. If set to 0, the code performs a quick "dry run", stopping just after initialization. This is useful to check for input correctness and to have the summary printed. NOTE: in MD calculations, the code will perform "nstep" steps even if restarting from a previously interrupted calculation.
    """
    iprint: Optional[float] = None
    """
    band energies are written every iprint iterations
    """
    tstress: Optional[bool] = False
    """
    calculate stress. It is set to .TRUE. automatically if calculation == 'vc-md' or 'vc-relax'
    """
    tprnfor: Optional[bool] = None
    """
    calculate forces. It is set to .TRUE. automatically if calculation == 'relax','md','vc-md'
    """
    dt: Optional[float] = 20
    """
    time step for molecular dynamics, in Rydberg atomic units (1 a.u.=4.8378 * 10^-17 s : beware, the CP code uses Hartree atomic units, half that much!!!)
    """
    outdir: Optional[str] = None
    """
    input, temporary, output files are found in this directory, see also wfcdir
    """
    wfcdir: Optional[str] = None
    """
    This directory specifies where to store files generated by each processor (*.wfc{N}, *.igk{N}, etc.). Useful for machines without a parallel file system: set wfcdir to a local file system, while outdir should be a parallel or network file system, visible to all processors. Beware: in order to restart from interrupted runs, or to perform further calculations using the produced data files, you may need to copy files to outdir. Works only for pw.x.
    """
    prefix: Optional[str] = "pwscf"
    """
    prepended to input/output filenames: prefix.wfc, prefix.rho, etc.
    """
    lkpoint_dir: Optional[bool] = None
    """
    OBSOLETE - NO LONGER IMPLEMENTED
    """
    max_seconds: Optional[float] = 10000000
    """
    Jobs stops after max_seconds CPU time. Use this option in conjunction with option restart_mode if you need to split a job too long to complete into shorter jobs that fit into your batch queues.
    """
    etot_conv_thr: Optional[float] = 0.0001
    """
    Convergence threshold on total energy (a.u) for ionic minimization: the convergence criterion is satisfied when the total energy changes less than etot_conv_thr between two consecutive scf steps. Note that etot_conv_thr is extensive, like the total energy. See also forc_conv_thr - both criteria must be satisfied
    """
    forc_conv_thr: Optional[float] = 0.001
    """
    Convergence threshold on forces (a.u) for ionic minimization: the convergence criterion is satisfied when all components of all forces are smaller than forc_conv_thr. See also etot_conv_thr - both criteria must be satisfied
    """
    disk_io: Optional[DiskIo] = None
    """
    Specifies the amount of disk I/O activity: (only for binary files and xml data file in data directory; other files printed at each molecular dynamics / structural optimization step are not controlled by this option )
    """
    pseudo_dir: Optional[str] = None
    """
    directory containing pseudopotential files. Default: value of the $ESPRESSO_PSEUDO environment variable if set; '$HOME/espresso/pseudo/' otherwise
    """
    tefield: Optional[bool] = False
    """
    If .TRUE. a saw-like potential simulating an electric field is added to the bare ionic potential. See variables edir, eamp, emaxpos, eopreg for the form and size of the added potential.
    """
    dipfield: Optional[bool] = False
    """
    If .TRUE. and tefield==.TRUE. a dipole correction is also added to the bare ionic potential - implements the recipe of L. Bengtsson, PRB 59, 12301 (1999). See variables edir, emaxpos, eopreg for the form of the correction. Must be used ONLY in a slab geometry, for surface calculations, with the discontinuity FALLING IN THE EMPTY SPACE.
    """
    lelfield: Optional[bool] = False
    """
    If .TRUE. a homogeneous finite electric field described through the modern theory of the polarization is applied. This is different from tefield == .true. !
    """
    nberrycyc: Optional[int] = 1
    """
    In the case of a finite electric field  ( lelfield == .TRUE. ) it defines the number of iterations for converging the wavefunctions in the electric field Hamiltonian, for each external iteration on the charge density
    """
    lorbm: Optional[bool] = False
    """
    If .TRUE. perform orbital magnetization calculation.
    """
    lberry: Optional[bool] = False
    """
    If .TRUE. perform a Berry phase calculation. See the header of PW/src/bp_c_phase.f90 for documentation
    """
    gdir: Optional[float] = None
    """
    For Berry phase calculation: direction of the k-point strings in reciprocal space. Allowed values: 1, 2, 3 1=first, 2=second, 3=third reciprocal lattice vector For calculations with finite electric fields (lelfield==.true.) "gdir" is the direction of the field.
    """
    nppstr: Optional[float] = None
    """
    For Berry phase calculation: number of k-points to be calculated along each symmetry-reduced string. The same for calculation with finite electric fields (lelfield==.true.).
    """
    gate: Optional[bool] = False
    """
    In the case of charged cells (tot_charge .ne. 0) setting gate = .TRUE. represents the counter charge (i.e. -tot_charge) not by a homogeneous background charge but with a charged plate, which is placed at zgate (see below). Details of the gate potential can be found in T. Brumme, M. Calandra, F. Mauri; PRB 89, 245406 (2014). Note, that in systems which are not symmetric with respect to the plate, one needs to enable the dipole correction! (dipfield=.true.). Currently, symmetry can be used with gate=.true. but carefully check that no symmetry is included which maps z to -z even if in principle one could still use them for symmetric systems (i.e. no dipole correction). For nosym=.false. verbosity is set to 'high'. Note: this option was called "monopole" in v6.0 and 6.1 of pw.x
    """
    twochem: Optional[bool] = False
    """
    IF .TRUE. , a two chemical potential calculation for the simulation of photoexcited systems is performed, constraining a fraction of the electrons in the conduction manifold.
    """
    lfcp: Optional[bool] = False
    """
    If .TRUE. perform a constant bias potential (constant-mu) calculation for a system with ESM method. See the header of PW/src/fcp_module.f90 for documentation. To perform the calculation, you must set a namelist FCP.
    """
    trism: Optional[bool] = False
    """
    If .TRUE. perform a 3D-RISM-SCF calculation [for details see H.Sato et al., JCP 112, 9463 (2000), doi:10.1063/1.481564]. The solvent's distributions are calculated by 3D-RISM, though solute is treated as SCF. The charge density and the atomic positions are optimized, simultaneously with the solvents. To perform the calculation, you must set a namelist RISM and a card SOLVENTS. If assume_isolated = 'esm' and esm_bc = 'bc1', Laue-RISM is calculated instead of 3D-RISM and coupled with ESM method (i.e. ESM-RISM). [for details see S.Nishihara and M.Otani, PRB 96, 115429 (2017)]. The default of mixing_beta is 0.2 for both 3D-RISM and Laue-RISM. For structural relaxation with BFGS, ignore_wolfe is always .TRUE. .
    """


class Occupations(Enum):
    smearing = "smearing"
    tetrahedra = "tetrahedra"
    tetrahedra_lin = "tetrahedra_lin"
    tetrahedra_opt = "tetrahedra_opt"
    fixed = "fixed"
    from_input = "from_input"


class Smearing(Enum):
    gaussian = "gaussian"
    gauss = "gauss"
    methfessel_paxton = "methfessel-paxton"
    m_p = "m-p"
    mp = "mp"
    marzari_vanderbilt = "marzari-vanderbilt"
    cold = "cold"
    m_v = "m-v"
    mv = "mv"
    fermi_dirac = "fermi-dirac"
    f_d = "f-d"
    fd = "fd"


class PolType(Enum):
    e = "e"
    h = "h"


class ExxdivTreatment(Enum):
    gygi_baldereschi = "gygi-baldereschi"
    vcut_spherical = "vcut_spherical"
    vcut_ws = "vcut_ws"
    none = "none"


class HubbardOccItem(RootModel[conint(ge=1)]):
    root: conint(ge=1)


class HubbardOccItem1(RootModel[conint(ge=1, le=3)]):
    root: conint(ge=1, le=3)


class ConstrainedMagnetization(Enum):
    none = "none"
    total = "total"
    atomic = "atomic"
    total_direction = "total direction"
    atomic_direction = "atomic direction"


class AssumeIsolated(Enum):
    none = "none"
    makov_payne = "makov-payne"
    m_p = "m-p"
    mp = "mp"
    martyna_tuckerman = "martyna-tuckerman"
    m_t = "m-t"
    mt = "mt"
    esm = "esm"
    field_2D = "2D"


class EsmBc(Enum):
    pbc = "pbc"
    bc1 = "bc1"
    bc2 = "bc2"
    bc3 = "bc3"


class VdwCorr(Enum):
    none = "none"
    grimme_d2 = "grimme-d2"
    Grimme_D2 = "Grimme-D2"
    DFT_D = "DFT-D"
    dft_d = "dft-d"
    grimme_d3 = "grimme-d3"
    Grimme_D3 = "Grimme-D3"
    DFT_D3 = "DFT-D3"
    dft_d3 = "dft-d3"
    TS = "TS"
    ts = "ts"
    ts_vdw = "ts-vdw"
    ts_vdW = "ts-vdW"
    tkatchenko_scheffler = "tkatchenko-scheffler"
    MBD = "MBD"
    mbd = "mbd"
    many_body_dispersion = "many-body-dispersion"
    mbd_vdw = "mbd_vdw"
    XDM = "XDM"
    xdm = "xdm"


class SystemSchema(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    ibrav: int
    nat: int
    """
    number of atoms in the unit cell (ALL atoms, except if space_group is set, in which case, INEQUIVALENT atoms)
    """
    ntyp: int
    """
    number of types of atoms in the unit cell
    """
    nbnd: Optional[int] = None
    """
    Default: for an insulator, nbnd = number of valence bands (nbnd = # of electrons /2); for a metal, 20% more (minimum 4 more)
    """
    nbnd_cond: Optional[int] = None
    """
    Default: nbnd_cond = nbnd - # of electrons / 2 in the collinear case; nbnd_cond = nbnd - # of electrons in the noncollinear case.
    """
    tot_charge: Optional[float] = 0
    starting_charge: Optional[float] = 0
    """
    starting charge on atomic type 'i', to create starting potential with startingpot = 'atomic'.
    """
    tot_magnetization: Optional[float] = -10000
    """
    Total majority spin charge - minority spin charge. Used to impose a specific total electronic magnetization. If unspecified then tot_magnetization variable is ignored and the amount of electronic magnetization is determined during the self-consistent cycle.
    """
    starting_magnetization: Optional[List[confloat(ge=-1.0, le=1.0)]] = None
    ecutwfc: float
    """
    kinetic energy cutoff (Ry) for wavefunctions
    """
    ecutrho: Optional[float] = None
    """
    Kinetic energy cutoff (Ry) for charge density and potential For norm-conserving pseudopotential you should stick to the default value, you can reduce it by a little but it will introduce noise especially on forces and stress. Default: 4 * ecutwfc
    """
    ecutfock: Optional[float] = None
    """
    Kinetic energy cutoff (Ry) for the exact exchange operator in EXX type calculations. By default this is the same as ecutrho but in some EXX calculations, a significant speed-up can be obtained by reducing ecutfock, at the expense of some loss in accuracy. Must be .gt. ecutwfc. Not implemented for stress calculation and for US-PP and PAW pseudopotentials.
    """
    nr1: Optional[int] = None
    """
    Three-dimensional FFT mesh (hard grid) for charge density (and scf potential). If not specified the grid is calculated based on the cutoff for charge density (see also ecutrho)
    """
    nr2: Optional[int] = None
    """
    Three-dimensional FFT mesh (hard grid) for charge density (and scf potential). If not specified the grid is calculated based on the cutoff for charge density (see also ecutrho)
    """
    nr3: Optional[int] = None
    """
    Three-dimensional FFT mesh (hard grid) for charge density (and scf potential). If not specified the grid is calculated based on the cutoff for charge density (see also ecutrho)
    """
    nr1s: Optional[int] = None
    """
    Three-dimensional mesh for wavefunction FFT and for the smooth part of charge density ( smooth grid ). Coincides with nr1, nr2, nr3 if ecutrho = 4 * ecutwfc ( default )
    """
    nr2s: Optional[int] = None
    """
    Three-dimensional mesh for wavefunction FFT and for the smooth part of charge density ( smooth grid ). Coincides with nr1, nr2, nr3 if ecutrho = 4 * ecutwfc ( default )
    """
    nr3s: Optional[int] = None
    """
    Three-dimensional mesh for wavefunction FFT and for the smooth part of charge density ( smooth grid ). Coincides with nr1, nr2, nr3 if ecutrho = 4 * ecutwfc ( default )
    """
    nosym: Optional[bool] = False
    nosym_evc: Optional[bool] = False
    noinv: Optional[bool] = False
    """
    if (.TRUE.) disable the usage of k => -k symmetry (time reversal) in k-point generation
    """
    no_t_rev: Optional[bool] = False
    """
    if (.TRUE.) disable the usage of magnetic symmetry operations that consist in a rotation + time reversal.
    """
    force_symmorphic: Optional[bool] = False
    """
    if (.TRUE.) force the symmetry group to be symmorphic by disabling symmetry operations having an associated fractionary translation
    """
    use_all_frac: Optional[bool] = False
    occupations: Optional[Occupations] = None
    one_atom_occupations: Optional[bool] = False
    starting_spin_angle: Optional[bool] = False
    degauss_cond: Optional[float] = 0
    """
    value of the gaussian spreading (Ry) for brillouin-zone integration in the conduction manifold in a two-chemical potential calculation (twochem=.true.).
    """
    nelec_cond: Optional[float] = 0
    """
    Number of electrons placed in the conduction manifold in a two-chemical potential calculation (twochem=.true.). Of the total # of electrons nelec, nelec-nelec_cond will occupy the valence manifold and nelec_cond will be constrained in the conduction manifold.
    """
    degauss: Optional[float] = 0
    """
    value of the gaussian spreading (Ry) for brillouin-zone integration in metals.
    """
    smearing: Optional[Smearing] = "gaussian"
    nspin: Optional[int] = 1
    sic_gamma: Optional[float] = 0
    """
    Strength of the gammaDFT potential.
    """
    pol_type: Optional[PolType] = None
    """
    Type of polaron in gammaDFT.
    """
    sic_energy: Optional[bool] = False
    """
    Enable the calculation of the total energy in gammaDFT. When .true., a preliminary calculation is performed to calculate the electron density in the absence of the polaron. When .false., the total energy printed in output should not be considered. For structural relaxations, it is recommended to use .false. to avoid doubling the computational cost.
    """
    sci_vb: Optional[float] = 0
    """
    Valence band shift (in eV) through self-consistent scissor operator. When performing gammaDFT calculations of polarons, the polaron level is not shifted.
    """
    sci_cb: Optional[float] = 0
    """
    Conduction band band shift (in eV) through self-consistent scissor operator. When performing gammaDFT calculations of polarons, the polaron level is not shifted.
    """
    noncolin: Optional[bool] = False
    """
    if .true. the program will perform a noncollinear calculation.
    """
    ecfixed: Optional[float] = 0
    qcutz: Optional[float] = 0
    q2sigma: Optional[float] = 0.1
    input_dft: Optional[str] = None
    """
    Exchange-correlation functional: eg 'PBE', 'BLYP' etc See Modules/funct.f90 for allowed values. Overrides the value read from pseudopotential files. Use with care and if you know what you are doing!
    """
    ace: Optional[bool] = True
    """
    Use Adaptively Compressed Exchange operator as in Lin Lin, J. Chem. Theory Comput. 2016, 12, 2242--2249, doi:10.1021/acs.jctc.6b00092
    """
    exx_fraction: Optional[float] = None
    """
    Fraction of EXX for hybrid functional calculations. In the case of input_dft='PBE0', the default value is 0.25, while for input_dft='B3LYP' the exx_fraction default value is 0.20.
    """
    screening_parameter: Optional[float] = 0.106
    """
    screening_parameter for HSE like hybrid functionals.
    """
    exxdiv_treatment: Optional[ExxdivTreatment] = "gygi-baldereschi"
    x_gamma_extrapolation: Optional[bool] = True
    """
    Specific for EXX. If .true., extrapolate the G=0 term of the potential
    """
    ecutvcut: Optional[float] = None
    """
    Reciprocal space cutoff for correcting Coulomb potential divergencies at small q vectors.
    """
    nqx1: Optional[int] = 0
    """
    Three-dimensional mesh for q (k1-k2) sampling of the Fock operator (EXX). Can be smaller than the number of k-points.
    """
    nqx2: Optional[int] = None
    """
    Three-dimensional mesh for q (k1-k2) sampling of the Fock operator (EXX). Can be smaller than the number of k-points.
    """
    nqx3: Optional[int] = None
    """
    Three-dimensional mesh for q (k1-k2) sampling of the Fock operator (EXX). Can be smaller than the number of k-points.
    """
    localization_thr: Optional[float] = 0
    """
    Overlap threshold over which the exchange integral over a pair of localized orbitals is included in the evaluation of EXX operator. Any value greater than 0.0 triggers the SCDM localization and the evaluation on EXX using the localized orbitals. Very small value of the threshold should yield the same result as the default EXX evaluation
    """
    Hubbard_occ: Optional[List[List[Union[HubbardOccItem, HubbardOccItem1, float]]]] = None
    Hubbard_alpha: Optional[List[float]] = None
    Hubbard_beta: Optional[List[float]] = None
    starting_ns_eigenvalue: Optional[List[List[List[float]]]] = None
    dmft: Optional[bool] = False
    """
    If true, nscf calculation will exit in restart mode, scf calculation will restart from there if DMFT updates are provided as hdf5 archive. Scf calculation should be used only with electron_maxstep = 1.
    """
    dmft_prefix: Optional[str] = None
    """
    prepended to hdf5 archive: dmft_prefix.h5
    """
    ensemble_energies: Optional[bool] = False
    """
    If ensemble_energies = .true., an ensemble of xc energies is calculated non-selfconsistently for perturbed exchange-enhancement factors and LDA vs. PBE correlation ratios after each converged electronic ground state calculation.
    """
    edir: Optional[int] = None
    """
    The direction of the electric field or dipole correction is parallel to the bg(:,edir) reciprocal lattice vector, so the potential is constant in planes defined by FFT grid points; edir = 1, 2 or 3. Used only if tefield is .TRUE.
    """
    emaxpos: Optional[float] = 0.5
    """
    Position of the maximum of the saw-like potential along crystal axis edir, within the  unit cell (see below), 0 < emaxpos < 1 Used only if tefield is .TRUE.
    """
    eopreg: Optional[float] = 0.1
    """
    Zone in the unit cell where the saw-like potential decreases. ( see below, 0 < eopreg < 1 ). Used only if tefield is .TRUE.
    """
    eamp: Optional[float] = 0.001
    angle1: Optional[List[float]] = Field(None, max_length=1, min_length=1)
    """
    The angle expressed in degrees between the initial magnetization and the z-axis. For noncollinear calculations only; index i runs over the atom types.
    """
    angle2: Optional[List[float]] = Field(None, max_length=1, min_length=1)
    """
    The angle expressed in degrees between the projection of the initial magnetization on x-y plane and the x-axis. For noncollinear calculations only.
    """
    lforcet: Optional[bool] = None
    """
    When starting a non collinear calculation using an existing density file from a collinear lsda calculation assumes previous density points in z direction and rotates it in the direction described by angle1 and angle2 variables for atomic type 1
    """
    constrained_magnetization: Optional[ConstrainedMagnetization] = "none"
    """
    Used to perform constrained calculations in magnetic systems.
    """
    fixed_magnetization: Optional[List[float]] = Field(None, max_length=3, min_length=3)
    lambda_: Optional[float] = Field(1, alias="lambda")
    """
    parameter used for constrained_magnetization calculations N.B.: if the scf calculation does not converge, try to reduce lambda to obtain convergence, then restart the run with a larger lambda
    """
    report: Optional[int] = -1
    """
    determines when atomic magnetic moments are printed on output
    """
    lspinorb: Optional[bool] = None
    """
    if .TRUE. the noncollinear code can use a pseudopotential with spin-orbit.
    """
    assume_isolated: Optional[AssumeIsolated] = "none"
    """
    Used to perform calculation assuming the system to be isolated (a molecule or a cluster in a 3D supercell)
    """
    esm_bc: Optional[EsmBc] = "pbc"
    """
    If assume_isolated = 'esm', determines the boundary conditions used for either side of the slab.
    """
    esm_w: Optional[float] = 0
    """
    If assume_isolated = 'esm', determines the position offset [in a.u.] of the start of the effective screening region, measured relative to the cell edge. (ESM region begins at z = +/- [L_z/2 + esm_w] ).
    """
    esm_efield: Optional[float] = 0
    """
    If assume_isolated = 'esm' and esm_bc = 'bc2', gives the magnitude of the electric field [Ry/a.u.] to be applied between semi-infinite ESM electrodes.
    """
    esm_nfit: Optional[int] = 4
    """
    If assume_isolated = 'esm', gives the number of z-grid points for the polynomial fit along the cell edge.
    """
    lgcscf: Optional[bool] = False
    """
    If .TRUE. perform a constant bias potential (constant-mu) calculation with Grand-Canonical SCF.
    """
    gcscf_mu: Optional[float] = None
    """
    The target Fermi energy (eV) of GC-SCF. One can start with appropriate total charge of the system by giving tot_charge
    """
    gcscf_conv_thr: Optional[float] = 0.01
    """
    Convergence threshold of Fermi energy (eV) for GC-SCF.
    """
    gcscf_beta: Optional[float] = 0.05
    """
    Mixing factor for GC-SCF. Larger values are recommended, if systems with small DOS on Fermi surface as graphite.
    """
    vdw_corr: Optional[VdwCorr] = "none"
    """
    Type of Van der Waals correction
    """
    london: Optional[bool] = False
    """
    OBSOLESCENT, same as vdw_corr='DFT-D'
    """
    london_s6: Optional[float] = 0.75
    """
    global scaling parameter for DFT-D. Default is good for PBE.
    """
    london_c6: Optional[float] = None
    """
    atomic C6 coefficient of each atom type
    """
    london_rvdw: Optional[float] = None
    """
    atomic vdw radii of each atom type
    """
    london_rcut: Optional[float] = 200
    """
    cutoff radius (a.u.) for dispersion interactions
    """
    dftd3_version: Optional[conint(ge=2, le=6)] = 3
    """
    Version of Grimme implementation of Grimme-D3
    """
    dftd3_threebody: Optional[bool] = True
    """
    Turn three-body terms in Grimme-D3 on. If .false. two-body contributions only are computed, using two-body parameters of Grimme-D3. If dftd3_version=2, three-body contribution is always disabled.
    """
    ts_vdw_econv_thr: Optional[float] = 1e-06
    """
    Optional: controls the convergence of the vdW energy (and forces). The default value is a safe choice, likely too safe, but you do not gain much in increasing it
    """
    ts_vdw_isolated: Optional[bool] = False
    """
    Optional: set it to .TRUE. when computing the Tkatchenko-Scheffler vdW energy or the Many-Body dispersion (MBD) energy for an isolated (non-periodic) system.
    """
    xdm: Optional[bool] = False
    """
    OBSOLESCENT, same as vdw_corr='xdm'
    """
    xdm_a1: Optional[float] = 0.6836
    """
    Damping function parameter a1 (adimensional)
    """
    xdm_a2: Optional[float] = 1.5045
    """
    Damping function parameter a2 (angstrom)
    """
    space_group: Optional[int] = 0
    """
    The number of the space group of the crystal, as given in the International Tables of Crystallography A (ITA)
    """
    uniqueb: Optional[bool] = False
    """
    Used only for monoclinic lattices
    """
    origin_choice: Optional[int] = 1
    """
    Used only for space groups that in the ITA allow the use of two different origins
    """
    rhombohedral: Optional[bool] = True
    """
    Used only for rhombohedral space groups.
    """
    zgate: Optional[float] = 0.5
    """
    used only if gate = .TRUE.
    """
    relaxz: Optional[bool] = False
    """
    used only if gate = .TRUE.
    """
    block: Optional[bool] = False
    """
    used only if gate = .TRUE.
    """
    block_1: Optional[float] = 0.45
    """
    used only if gate = .TRUE. and block = .TRUE.
    """
    block_2: Optional[float] = 0.55
    """
    used only if gate = .TRUE. and block = .TRUE.
    """
    block_height: Optional[float] = 0.1
    """
    used only if gate = .TRUE. and block = .TRUE.
    """
    nextffield: Optional[int] = 0
    """
    Number of activated external ionic force fields.
    """
    celldm: Optional[List[float]] = Field(None, max_length=6, min_length=6)


class HubbardOccItem2(RootModel[conint(ge=1)]):
    root: conint(ge=1)


class HubbardOccItem3(RootModel[conint(ge=1, le=3)]):
    root: conint(ge=1, le=3)


class SystemSchema1(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    ibrav: int
    nat: int
    """
    number of atoms in the unit cell (ALL atoms, except if space_group is set, in which case, INEQUIVALENT atoms)
    """
    ntyp: int
    """
    number of types of atoms in the unit cell
    """
    nbnd: Optional[int] = None
    """
    Default: for an insulator, nbnd = number of valence bands (nbnd = # of electrons /2); for a metal, 20% more (minimum 4 more)
    """
    nbnd_cond: Optional[int] = None
    """
    Default: nbnd_cond = nbnd - # of electrons / 2 in the collinear case; nbnd_cond = nbnd - # of electrons in the noncollinear case.
    """
    tot_charge: Optional[float] = 0
    starting_charge: Optional[float] = 0
    """
    starting charge on atomic type 'i', to create starting potential with startingpot = 'atomic'.
    """
    tot_magnetization: Optional[float] = -10000
    """
    Total majority spin charge - minority spin charge. Used to impose a specific total electronic magnetization. If unspecified then tot_magnetization variable is ignored and the amount of electronic magnetization is determined during the self-consistent cycle.
    """
    starting_magnetization: Optional[List[confloat(ge=-1.0, le=1.0)]] = None
    ecutwfc: float
    """
    kinetic energy cutoff (Ry) for wavefunctions
    """
    ecutrho: Optional[float] = None
    """
    Kinetic energy cutoff (Ry) for charge density and potential For norm-conserving pseudopotential you should stick to the default value, you can reduce it by a little but it will introduce noise especially on forces and stress. Default: 4 * ecutwfc
    """
    ecutfock: Optional[float] = None
    """
    Kinetic energy cutoff (Ry) for the exact exchange operator in EXX type calculations. By default this is the same as ecutrho but in some EXX calculations, a significant speed-up can be obtained by reducing ecutfock, at the expense of some loss in accuracy. Must be .gt. ecutwfc. Not implemented for stress calculation and for US-PP and PAW pseudopotentials.
    """
    nr1: Optional[int] = None
    """
    Three-dimensional FFT mesh (hard grid) for charge density (and scf potential). If not specified the grid is calculated based on the cutoff for charge density (see also ecutrho)
    """
    nr2: Optional[int] = None
    """
    Three-dimensional FFT mesh (hard grid) for charge density (and scf potential). If not specified the grid is calculated based on the cutoff for charge density (see also ecutrho)
    """
    nr3: Optional[int] = None
    """
    Three-dimensional FFT mesh (hard grid) for charge density (and scf potential). If not specified the grid is calculated based on the cutoff for charge density (see also ecutrho)
    """
    nr1s: Optional[int] = None
    """
    Three-dimensional mesh for wavefunction FFT and for the smooth part of charge density ( smooth grid ). Coincides with nr1, nr2, nr3 if ecutrho = 4 * ecutwfc ( default )
    """
    nr2s: Optional[int] = None
    """
    Three-dimensional mesh for wavefunction FFT and for the smooth part of charge density ( smooth grid ). Coincides with nr1, nr2, nr3 if ecutrho = 4 * ecutwfc ( default )
    """
    nr3s: Optional[int] = None
    """
    Three-dimensional mesh for wavefunction FFT and for the smooth part of charge density ( smooth grid ). Coincides with nr1, nr2, nr3 if ecutrho = 4 * ecutwfc ( default )
    """
    nosym: Optional[bool] = False
    nosym_evc: Optional[bool] = False
    noinv: Optional[bool] = False
    """
    if (.TRUE.) disable the usage of k => -k symmetry (time reversal) in k-point generation
    """
    no_t_rev: Optional[bool] = False
    """
    if (.TRUE.) disable the usage of magnetic symmetry operations that consist in a rotation + time reversal.
    """
    force_symmorphic: Optional[bool] = False
    """
    if (.TRUE.) force the symmetry group to be symmorphic by disabling symmetry operations having an associated fractionary translation
    """
    use_all_frac: Optional[bool] = False
    occupations: Optional[Occupations] = None
    one_atom_occupations: Optional[bool] = False
    starting_spin_angle: Optional[bool] = False
    degauss_cond: Optional[float] = 0
    """
    value of the gaussian spreading (Ry) for brillouin-zone integration in the conduction manifold in a two-chemical potential calculation (twochem=.true.).
    """
    nelec_cond: Optional[float] = 0
    """
    Number of electrons placed in the conduction manifold in a two-chemical potential calculation (twochem=.true.). Of the total # of electrons nelec, nelec-nelec_cond will occupy the valence manifold and nelec_cond will be constrained in the conduction manifold.
    """
    degauss: Optional[float] = 0
    """
    value of the gaussian spreading (Ry) for brillouin-zone integration in metals.
    """
    smearing: Optional[Smearing] = "gaussian"
    nspin: Optional[int] = 1
    sic_gamma: Optional[float] = 0
    """
    Strength of the gammaDFT potential.
    """
    pol_type: Optional[PolType] = None
    """
    Type of polaron in gammaDFT.
    """
    sic_energy: Optional[bool] = False
    """
    Enable the calculation of the total energy in gammaDFT. When .true., a preliminary calculation is performed to calculate the electron density in the absence of the polaron. When .false., the total energy printed in output should not be considered. For structural relaxations, it is recommended to use .false. to avoid doubling the computational cost.
    """
    sci_vb: Optional[float] = 0
    """
    Valence band shift (in eV) through self-consistent scissor operator. When performing gammaDFT calculations of polarons, the polaron level is not shifted.
    """
    sci_cb: Optional[float] = 0
    """
    Conduction band band shift (in eV) through self-consistent scissor operator. When performing gammaDFT calculations of polarons, the polaron level is not shifted.
    """
    noncolin: Optional[bool] = False
    """
    if .true. the program will perform a noncollinear calculation.
    """
    ecfixed: Optional[float] = 0
    qcutz: Optional[float] = 0
    q2sigma: Optional[float] = 0.1
    input_dft: Optional[str] = None
    """
    Exchange-correlation functional: eg 'PBE', 'BLYP' etc See Modules/funct.f90 for allowed values. Overrides the value read from pseudopotential files. Use with care and if you know what you are doing!
    """
    ace: Optional[bool] = True
    """
    Use Adaptively Compressed Exchange operator as in Lin Lin, J. Chem. Theory Comput. 2016, 12, 2242--2249, doi:10.1021/acs.jctc.6b00092
    """
    exx_fraction: Optional[float] = None
    """
    Fraction of EXX for hybrid functional calculations. In the case of input_dft='PBE0', the default value is 0.25, while for input_dft='B3LYP' the exx_fraction default value is 0.20.
    """
    screening_parameter: Optional[float] = 0.106
    """
    screening_parameter for HSE like hybrid functionals.
    """
    exxdiv_treatment: Optional[ExxdivTreatment] = "gygi-baldereschi"
    x_gamma_extrapolation: Optional[bool] = True
    """
    Specific for EXX. If .true., extrapolate the G=0 term of the potential
    """
    ecutvcut: Optional[float] = None
    """
    Reciprocal space cutoff for correcting Coulomb potential divergencies at small q vectors.
    """
    nqx1: Optional[int] = 0
    """
    Three-dimensional mesh for q (k1-k2) sampling of the Fock operator (EXX). Can be smaller than the number of k-points.
    """
    nqx2: Optional[int] = None
    """
    Three-dimensional mesh for q (k1-k2) sampling of the Fock operator (EXX). Can be smaller than the number of k-points.
    """
    nqx3: Optional[int] = None
    """
    Three-dimensional mesh for q (k1-k2) sampling of the Fock operator (EXX). Can be smaller than the number of k-points.
    """
    localization_thr: Optional[float] = 0
    """
    Overlap threshold over which the exchange integral over a pair of localized orbitals is included in the evaluation of EXX operator. Any value greater than 0.0 triggers the SCDM localization and the evaluation on EXX using the localized orbitals. Very small value of the threshold should yield the same result as the default EXX evaluation
    """
    Hubbard_occ: Optional[List[List[Union[HubbardOccItem2, HubbardOccItem3, float]]]] = None
    Hubbard_alpha: Optional[List[float]] = None
    Hubbard_beta: Optional[List[float]] = None
    starting_ns_eigenvalue: Optional[List[List[List[float]]]] = None
    dmft: Optional[bool] = False
    """
    If true, nscf calculation will exit in restart mode, scf calculation will restart from there if DMFT updates are provided as hdf5 archive. Scf calculation should be used only with electron_maxstep = 1.
    """
    dmft_prefix: Optional[str] = None
    """
    prepended to hdf5 archive: dmft_prefix.h5
    """
    ensemble_energies: Optional[bool] = False
    """
    If ensemble_energies = .true., an ensemble of xc energies is calculated non-selfconsistently for perturbed exchange-enhancement factors and LDA vs. PBE correlation ratios after each converged electronic ground state calculation.
    """
    edir: Optional[int] = None
    """
    The direction of the electric field or dipole correction is parallel to the bg(:,edir) reciprocal lattice vector, so the potential is constant in planes defined by FFT grid points; edir = 1, 2 or 3. Used only if tefield is .TRUE.
    """
    emaxpos: Optional[float] = 0.5
    """
    Position of the maximum of the saw-like potential along crystal axis edir, within the  unit cell (see below), 0 < emaxpos < 1 Used only if tefield is .TRUE.
    """
    eopreg: Optional[float] = 0.1
    """
    Zone in the unit cell where the saw-like potential decreases. ( see below, 0 < eopreg < 1 ). Used only if tefield is .TRUE.
    """
    eamp: Optional[float] = 0.001
    angle1: Optional[List[float]] = Field(None, max_length=1, min_length=1)
    """
    The angle expressed in degrees between the initial magnetization and the z-axis. For noncollinear calculations only; index i runs over the atom types.
    """
    angle2: Optional[List[float]] = Field(None, max_length=1, min_length=1)
    """
    The angle expressed in degrees between the projection of the initial magnetization on x-y plane and the x-axis. For noncollinear calculations only.
    """
    lforcet: Optional[bool] = None
    """
    When starting a non collinear calculation using an existing density file from a collinear lsda calculation assumes previous density points in z direction and rotates it in the direction described by angle1 and angle2 variables for atomic type 1
    """
    constrained_magnetization: Optional[ConstrainedMagnetization] = "none"
    """
    Used to perform constrained calculations in magnetic systems.
    """
    fixed_magnetization: Optional[List[float]] = Field(None, max_length=3, min_length=3)
    lambda_: Optional[float] = Field(1, alias="lambda")
    """
    parameter used for constrained_magnetization calculations N.B.: if the scf calculation does not converge, try to reduce lambda to obtain convergence, then restart the run with a larger lambda
    """
    report: Optional[int] = -1
    """
    determines when atomic magnetic moments are printed on output
    """
    lspinorb: Optional[bool] = None
    """
    if .TRUE. the noncollinear code can use a pseudopotential with spin-orbit.
    """
    assume_isolated: Optional[AssumeIsolated] = "none"
    """
    Used to perform calculation assuming the system to be isolated (a molecule or a cluster in a 3D supercell)
    """
    esm_bc: Optional[EsmBc] = "pbc"
    """
    If assume_isolated = 'esm', determines the boundary conditions used for either side of the slab.
    """
    esm_w: Optional[float] = 0
    """
    If assume_isolated = 'esm', determines the position offset [in a.u.] of the start of the effective screening region, measured relative to the cell edge. (ESM region begins at z = +/- [L_z/2 + esm_w] ).
    """
    esm_efield: Optional[float] = 0
    """
    If assume_isolated = 'esm' and esm_bc = 'bc2', gives the magnitude of the electric field [Ry/a.u.] to be applied between semi-infinite ESM electrodes.
    """
    esm_nfit: Optional[int] = 4
    """
    If assume_isolated = 'esm', gives the number of z-grid points for the polynomial fit along the cell edge.
    """
    lgcscf: Optional[bool] = False
    """
    If .TRUE. perform a constant bias potential (constant-mu) calculation with Grand-Canonical SCF.
    """
    gcscf_mu: Optional[float] = None
    """
    The target Fermi energy (eV) of GC-SCF. One can start with appropriate total charge of the system by giving tot_charge
    """
    gcscf_conv_thr: Optional[float] = 0.01
    """
    Convergence threshold of Fermi energy (eV) for GC-SCF.
    """
    gcscf_beta: Optional[float] = 0.05
    """
    Mixing factor for GC-SCF. Larger values are recommended, if systems with small DOS on Fermi surface as graphite.
    """
    vdw_corr: Optional[VdwCorr] = "none"
    """
    Type of Van der Waals correction
    """
    london: Optional[bool] = False
    """
    OBSOLESCENT, same as vdw_corr='DFT-D'
    """
    london_s6: Optional[float] = 0.75
    """
    global scaling parameter for DFT-D. Default is good for PBE.
    """
    london_c6: Optional[float] = None
    """
    atomic C6 coefficient of each atom type
    """
    london_rvdw: Optional[float] = None
    """
    atomic vdw radii of each atom type
    """
    london_rcut: Optional[float] = 200
    """
    cutoff radius (a.u.) for dispersion interactions
    """
    dftd3_version: Optional[conint(ge=2, le=6)] = 3
    """
    Version of Grimme implementation of Grimme-D3
    """
    dftd3_threebody: Optional[bool] = True
    """
    Turn three-body terms in Grimme-D3 on. If .false. two-body contributions only are computed, using two-body parameters of Grimme-D3. If dftd3_version=2, three-body contribution is always disabled.
    """
    ts_vdw_econv_thr: Optional[float] = 1e-06
    """
    Optional: controls the convergence of the vdW energy (and forces). The default value is a safe choice, likely too safe, but you do not gain much in increasing it
    """
    ts_vdw_isolated: Optional[bool] = False
    """
    Optional: set it to .TRUE. when computing the Tkatchenko-Scheffler vdW energy or the Many-Body dispersion (MBD) energy for an isolated (non-periodic) system.
    """
    xdm: Optional[bool] = False
    """
    OBSOLESCENT, same as vdw_corr='xdm'
    """
    xdm_a1: Optional[float] = 0.6836
    """
    Damping function parameter a1 (adimensional)
    """
    xdm_a2: Optional[float] = 1.5045
    """
    Damping function parameter a2 (angstrom)
    """
    space_group: Optional[int] = 0
    """
    The number of the space group of the crystal, as given in the International Tables of Crystallography A (ITA)
    """
    uniqueb: Optional[bool] = False
    """
    Used only for monoclinic lattices
    """
    origin_choice: Optional[int] = 1
    """
    Used only for space groups that in the ITA allow the use of two different origins
    """
    rhombohedral: Optional[bool] = True
    """
    Used only for rhombohedral space groups.
    """
    zgate: Optional[float] = 0.5
    """
    used only if gate = .TRUE.
    """
    relaxz: Optional[bool] = False
    """
    used only if gate = .TRUE.
    """
    block: Optional[bool] = False
    """
    used only if gate = .TRUE.
    """
    block_1: Optional[float] = 0.45
    """
    used only if gate = .TRUE. and block = .TRUE.
    """
    block_2: Optional[float] = 0.55
    """
    used only if gate = .TRUE. and block = .TRUE.
    """
    block_height: Optional[float] = 0.1
    """
    used only if gate = .TRUE. and block = .TRUE.
    """
    nextffield: Optional[int] = 0
    """
    Number of activated external ionic force fields.
    """
    A: Optional[float] = None
    B: Optional[float] = None
    C: Optional[float] = None
    cosAB: Optional[float] = None
    cosAC: Optional[float] = None
    cosBC: Optional[float] = None


class MixingMode(Enum):
    plain = "plain"
    TF = "TF"
    local_TF = "local-TF"


class Diagonalization(Enum):
    david = "david"
    cg = "cg"
    ppcg = "ppcg"
    paro = "paro"
    ParO = "ParO"
    rmm_davidson = "rmm-davidson"
    rmm_paro = "rmm-paro"


class EfieldPhase(Enum):
    read = "read"
    write = "write"
    none = "none"


class Startingpot(Enum):
    atomic = "atomic"
    file = "file"


class Startingwfc(Enum):
    atomic = "atomic"
    atomic_random = "atomic+random"
    random = "random"
    file = "file"


class ElectronsSchema(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    electron_maxstep: Optional[int] = 100
    """
    maximum number of iterations in a scf step. If exact exchange is active, this will affect the inner loops.
    """
    exx_maxstep: Optional[int] = 100
    """
    maximum number of outer iterations in a scf calculation with exact exchange.
    """
    scf_must_converge: Optional[bool] = True
    """
    If .false. do not stop molecular dynamics or ionic relaxation when electron_maxstep is reached. Use with care.
    """
    conv_thr: Optional[float] = None
    adaptive_thr: Optional[bool] = False
    """
    If .TRUE. this turns on the use of an adaptive conv_thr for the inner scf loops when using EXX.
    """
    conv_thr_init: Optional[float] = None
    """
    When adaptive_thr = .TRUE. this is the convergence threshold used for the first scf cycle.
    """
    conv_thr_multi: Optional[float] = None
    """
    When adaptive_thr = .TRUE. the convergence threshold for each scf cycle is given by: max( conv_thr, conv_thr_multi * dexx )
    """
    mixing_mode: Optional[MixingMode] = "plain"
    mixing_beta: Optional[float] = None
    """
    mixing factor for self-consistency
    """
    mixing_ndim: Optional[int] = 8
    """
    number of iterations used in mixing scheme
    """
    mixing_fixed_ns: Optional[int] = 0
    """
    For DFT+U : number of iterations with fixed ns ( ns is the atomic density appearing in the Hubbard term ).
    """
    diagonalization: Optional[Diagonalization] = "david"
    diago_thr_init: Optional[float] = None
    """
    Convergence threshold (ethr) for iterative diagonalization (the check is on eigenvalue convergence).
    """
    diago_cg_maxiter: Optional[int] = None
    """
    For conjugate gradient diagonalization:  max number of iterations
    """
    diago_ppcg_maxiter: Optional[int] = None
    """
    For ppcg diagonalization:  max number of iterations
    """
    diago_david_ndim: Optional[int] = 2
    """
    For Davidson diagonalization: dimension of workspace (number of wavefunction packets, at least 2 needed).
    """
    diago_rmm_ndim: Optional[int] = 4
    """
    For RMM-DIIS diagonalization: dimension of workspace (number of wavefunction packets, at least 2 needed).
    """
    diago_rmm_conv: Optional[bool] = False
    """
    If .TRUE., RMM-DIIS is performed up to converge. If .FALSE., RMM-DIIS is performed only once.
    """
    diago_gs_nblock: Optional[int] = 16
    """
    For RMM-DIIS diagonalization: blocking size of Gram-Schmidt orthogonalization
    """
    diago_full_acc: Optional[bool] = False
    """
    If .TRUE. all the empty states are diagonalized at the same level of accuracy of the occupied ones. Otherwise the empty states are diagonalized using a larger threshold (this should not affect total energy, forces, and other ground-state properties).
    """
    efield: Optional[float] = None
    """
    Amplitude of the finite electric field (in Ry a.u.; 1 a.u. = 36.3609*10^10 V/m). Used only if lelfield==.TRUE. and if k-points (K_POINTS card) are not automatic.
    """
    efield_cart: Optional[List[float]] = Field(
        None, max_length=3, min_length=3, title="array of 3 number elements schema"
    )
    efield_phase: Optional[EfieldPhase] = "none"
    startingpot: Optional[Startingpot] = None
    startingwfc: Optional[Startingwfc] = "atomic+random"
    tqr: Optional[bool] = False
    """
    If .true., use a real-space algorithm for augmentation charges of ultrasoft pseudopotentials and PAWsets. Faster but numerically less accurate than the default G-space algorithm. Use with care and after testing!
    """
    real_space: Optional[bool] = False
    """
    If .true., exploit real-space localization to compute matrix elements for nonlocal projectors. Faster and in principle better scaling than the default G-space algorithm, but numerically less accurate, may lead to some loss of translational invariance. Use with care and after testing!
    """


class IonPositions(Enum):
    default = "default"
    from_input = "from_input"


class IonVelocities(Enum):
    default = "default"
    from_input = "from_input"


class PotExtrapolation(Enum):
    none = "none"
    atomic = "atomic"
    first_order = "first_order"
    second_order = "second_order"


class WfcExtrapolation(Enum):
    none = "none"
    first_order = "first_order"
    second_order = "second_order"


class IonTemperature(Enum):
    rescaling = "rescaling"
    rescale_v = "rescale-v"
    rescale_T = "rescale-T"
    reduce_T = "reduce-T"
    berendsen = "berendsen"
    andersen = "andersen"
    svr = "svr"
    initial = "initial"
    not_controlled = "not_controlled"


class IonDynamics(Enum):
    bfgs = "bfgs"
    damp = "damp"
    fire = "fire"


class IonsSchema(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    ion_positions: Optional[IonPositions] = "default"
    ion_velocities: Optional[IonVelocities] = "default"
    pot_extrapolation: Optional[PotExtrapolation] = "atomic"
    """
    Used to extrapolate the potential from preceding ionic steps.
    """
    wfc_extrapolation: Optional[WfcExtrapolation] = "none"
    """
    Used to extrapolate the wavefunctions from preceding ionic steps.
    """
    remove_rigid_rot: Optional[bool] = False
    """
    This keyword is useful when simulating the dynamics and/or the thermodynamics of an isolated system. If set to true the total torque of the internal forces is set to zero by adding new forces that compensate the spurious interaction with the periodic images. This allows for the use of smaller supercells.
    """
    ion_temperature: Optional[IonTemperature] = "not_controlled"
    tempw: Optional[float] = 300
    """
    Starting temperature (Kelvin) in MD runs target temperature for most thermostats.
    """
    tolp: Optional[float] = 100
    """
    Tolerance for velocity rescaling. Velocities are rescaled if the run-averaged and target temperature differ more than tolp.
    """
    delta_t: Optional[float] = 1
    nraise: Optional[int] = 1
    refold_pos: Optional[bool] = False
    """
    This keyword applies only in the case of molecular dynamics or damped dynamics. If true the ions are refolded at each step into the supercell.
    """
    upscale: Optional[float] = 100
    """
    Max reduction factor for conv_thr during structural optimization conv_thr is automatically reduced when the relaxation approaches convergence so that forces are still accurate, but conv_thr will not be reduced to less that conv_thr / upscale.
    """
    bfgs_ndim: Optional[int] = 1
    """
    Number of old forces and displacements vectors used in the PULAY mixing of the residual vectors obtained on the basis of the inverse hessian matrix given by the BFGS algorithm.
    """
    trust_radius_max: Optional[float] = 0.8
    """
    Maximum ionic displacement in the structural relaxation. (bfgs only)
    """
    trust_radius_min: Optional[float] = 0.001
    """
    Minimum ionic displacement in the structural relaxation BFGS is reset when trust_radius < trust_radius_min. (bfgs only)
    """
    trust_radius_ini: Optional[float] = 0.5
    """
    Initial ionic displacement in the structural relaxation. (bfgs only)
    """
    w_1: Optional[float] = 0.01
    w_2: Optional[float] = 0.5
    """
    Parameters used in line search based on the Wolfe conditions. (bfgs only)
    """
    fire_alpha_init: Optional[float] = 0.2
    """
    Initial value of the alpha mixing factor in the FIRE minimization scheme; recommended values are between 0.1 and 0.3
    """
    fire_falpha: Optional[float] = 0.99
    """
    Scaling of the alpha mixing parameter for steps with P > 0;
    """
    fire_nmin: Optional[int] = 5
    """
    Minimum number of steps with P > 0 before increase of dt
    """
    fire_f_inc: Optional[float] = 1.1
    """
    Factor for increasing dt
    """
    fire_f_dec: Optional[float] = 0.5
    """
    Factor for decreasing dt
    """
    fire_dtmax: Optional[float] = 10
    """
    Determines the maximum value of dt in the FIRE minimization; dtmax = fire_dtmax*dt
    """
    ion_dynamics: Optional[IonDynamics] = "bfgs"
    """
    CASE: calculation == 'relax'
    """


class IonDynamics5(Enum):
    verlet = "verlet"
    langevin = "langevin"
    langevin_smc = "langevin-smc"


class IonsSchema5(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    ion_positions: Optional[IonPositions] = "default"
    ion_velocities: Optional[IonVelocities] = "default"
    pot_extrapolation: Optional[PotExtrapolation] = "atomic"
    """
    Used to extrapolate the potential from preceding ionic steps.
    """
    wfc_extrapolation: Optional[WfcExtrapolation] = "none"
    """
    Used to extrapolate the wavefunctions from preceding ionic steps.
    """
    remove_rigid_rot: Optional[bool] = False
    """
    This keyword is useful when simulating the dynamics and/or the thermodynamics of an isolated system. If set to true the total torque of the internal forces is set to zero by adding new forces that compensate the spurious interaction with the periodic images. This allows for the use of smaller supercells.
    """
    ion_temperature: Optional[IonTemperature] = "not_controlled"
    tempw: Optional[float] = 300
    """
    Starting temperature (Kelvin) in MD runs target temperature for most thermostats.
    """
    tolp: Optional[float] = 100
    """
    Tolerance for velocity rescaling. Velocities are rescaled if the run-averaged and target temperature differ more than tolp.
    """
    delta_t: Optional[float] = 1
    nraise: Optional[int] = 1
    refold_pos: Optional[bool] = False
    """
    This keyword applies only in the case of molecular dynamics or damped dynamics. If true the ions are refolded at each step into the supercell.
    """
    upscale: Optional[float] = 100
    """
    Max reduction factor for conv_thr during structural optimization conv_thr is automatically reduced when the relaxation approaches convergence so that forces are still accurate, but conv_thr will not be reduced to less that conv_thr / upscale.
    """
    bfgs_ndim: Optional[int] = 1
    """
    Number of old forces and displacements vectors used in the PULAY mixing of the residual vectors obtained on the basis of the inverse hessian matrix given by the BFGS algorithm.
    """
    trust_radius_max: Optional[float] = 0.8
    """
    Maximum ionic displacement in the structural relaxation. (bfgs only)
    """
    trust_radius_min: Optional[float] = 0.001
    """
    Minimum ionic displacement in the structural relaxation BFGS is reset when trust_radius < trust_radius_min. (bfgs only)
    """
    trust_radius_ini: Optional[float] = 0.5
    """
    Initial ionic displacement in the structural relaxation. (bfgs only)
    """
    w_1: Optional[float] = 0.01
    w_2: Optional[float] = 0.5
    """
    Parameters used in line search based on the Wolfe conditions. (bfgs only)
    """
    fire_alpha_init: Optional[float] = 0.2
    """
    Initial value of the alpha mixing factor in the FIRE minimization scheme; recommended values are between 0.1 and 0.3
    """
    fire_falpha: Optional[float] = 0.99
    """
    Scaling of the alpha mixing parameter for steps with P > 0;
    """
    fire_nmin: Optional[int] = 5
    """
    Minimum number of steps with P > 0 before increase of dt
    """
    fire_f_inc: Optional[float] = 1.1
    """
    Factor for increasing dt
    """
    fire_f_dec: Optional[float] = 0.5
    """
    Factor for decreasing dt
    """
    fire_dtmax: Optional[float] = 10
    """
    Determines the maximum value of dt in the FIRE minimization; dtmax = fire_dtmax*dt
    """
    ion_dynamics: Optional[IonDynamics5] = "verlet"
    """
    CASE: calculation == 'md'
    """


class IonDynamics6(Enum):
    bfgs = "bfgs"
    damp = "damp"


class IonsSchema6(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    ion_positions: Optional[IonPositions] = "default"
    ion_velocities: Optional[IonVelocities] = "default"
    pot_extrapolation: Optional[PotExtrapolation] = "atomic"
    """
    Used to extrapolate the potential from preceding ionic steps.
    """
    wfc_extrapolation: Optional[WfcExtrapolation] = "none"
    """
    Used to extrapolate the wavefunctions from preceding ionic steps.
    """
    remove_rigid_rot: Optional[bool] = False
    """
    This keyword is useful when simulating the dynamics and/or the thermodynamics of an isolated system. If set to true the total torque of the internal forces is set to zero by adding new forces that compensate the spurious interaction with the periodic images. This allows for the use of smaller supercells.
    """
    ion_temperature: Optional[IonTemperature] = "not_controlled"
    tempw: Optional[float] = 300
    """
    Starting temperature (Kelvin) in MD runs target temperature for most thermostats.
    """
    tolp: Optional[float] = 100
    """
    Tolerance for velocity rescaling. Velocities are rescaled if the run-averaged and target temperature differ more than tolp.
    """
    delta_t: Optional[float] = 1
    nraise: Optional[int] = 1
    refold_pos: Optional[bool] = False
    """
    This keyword applies only in the case of molecular dynamics or damped dynamics. If true the ions are refolded at each step into the supercell.
    """
    upscale: Optional[float] = 100
    """
    Max reduction factor for conv_thr during structural optimization conv_thr is automatically reduced when the relaxation approaches convergence so that forces are still accurate, but conv_thr will not be reduced to less that conv_thr / upscale.
    """
    bfgs_ndim: Optional[int] = 1
    """
    Number of old forces and displacements vectors used in the PULAY mixing of the residual vectors obtained on the basis of the inverse hessian matrix given by the BFGS algorithm.
    """
    trust_radius_max: Optional[float] = 0.8
    """
    Maximum ionic displacement in the structural relaxation. (bfgs only)
    """
    trust_radius_min: Optional[float] = 0.001
    """
    Minimum ionic displacement in the structural relaxation BFGS is reset when trust_radius < trust_radius_min. (bfgs only)
    """
    trust_radius_ini: Optional[float] = 0.5
    """
    Initial ionic displacement in the structural relaxation. (bfgs only)
    """
    w_1: Optional[float] = 0.01
    w_2: Optional[float] = 0.5
    """
    Parameters used in line search based on the Wolfe conditions. (bfgs only)
    """
    fire_alpha_init: Optional[float] = 0.2
    """
    Initial value of the alpha mixing factor in the FIRE minimization scheme; recommended values are between 0.1 and 0.3
    """
    fire_falpha: Optional[float] = 0.99
    """
    Scaling of the alpha mixing parameter for steps with P > 0;
    """
    fire_nmin: Optional[int] = 5
    """
    Minimum number of steps with P > 0 before increase of dt
    """
    fire_f_inc: Optional[float] = 1.1
    """
    Factor for increasing dt
    """
    fire_f_dec: Optional[float] = 0.5
    """
    Factor for decreasing dt
    """
    fire_dtmax: Optional[float] = 10
    """
    Determines the maximum value of dt in the FIRE minimization; dtmax = fire_dtmax*dt
    """
    ion_dynamics: Optional[IonDynamics6] = "bfgs"
    """
    CASE: calculation == 'vc-relax'
    """


class IonDynamics7(Enum):
    beeman = "beeman"


class IonsSchema7(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    ion_positions: Optional[IonPositions] = "default"
    ion_velocities: Optional[IonVelocities] = "default"
    pot_extrapolation: Optional[PotExtrapolation] = "atomic"
    """
    Used to extrapolate the potential from preceding ionic steps.
    """
    wfc_extrapolation: Optional[WfcExtrapolation] = "none"
    """
    Used to extrapolate the wavefunctions from preceding ionic steps.
    """
    remove_rigid_rot: Optional[bool] = False
    """
    This keyword is useful when simulating the dynamics and/or the thermodynamics of an isolated system. If set to true the total torque of the internal forces is set to zero by adding new forces that compensate the spurious interaction with the periodic images. This allows for the use of smaller supercells.
    """
    ion_temperature: Optional[IonTemperature] = "not_controlled"
    tempw: Optional[float] = 300
    """
    Starting temperature (Kelvin) in MD runs target temperature for most thermostats.
    """
    tolp: Optional[float] = 100
    """
    Tolerance for velocity rescaling. Velocities are rescaled if the run-averaged and target temperature differ more than tolp.
    """
    delta_t: Optional[float] = 1
    nraise: Optional[int] = 1
    refold_pos: Optional[bool] = False
    """
    This keyword applies only in the case of molecular dynamics or damped dynamics. If true the ions are refolded at each step into the supercell.
    """
    upscale: Optional[float] = 100
    """
    Max reduction factor for conv_thr during structural optimization conv_thr is automatically reduced when the relaxation approaches convergence so that forces are still accurate, but conv_thr will not be reduced to less that conv_thr / upscale.
    """
    bfgs_ndim: Optional[int] = 1
    """
    Number of old forces and displacements vectors used in the PULAY mixing of the residual vectors obtained on the basis of the inverse hessian matrix given by the BFGS algorithm.
    """
    trust_radius_max: Optional[float] = 0.8
    """
    Maximum ionic displacement in the structural relaxation. (bfgs only)
    """
    trust_radius_min: Optional[float] = 0.001
    """
    Minimum ionic displacement in the structural relaxation BFGS is reset when trust_radius < trust_radius_min. (bfgs only)
    """
    trust_radius_ini: Optional[float] = 0.5
    """
    Initial ionic displacement in the structural relaxation. (bfgs only)
    """
    w_1: Optional[float] = 0.01
    w_2: Optional[float] = 0.5
    """
    Parameters used in line search based on the Wolfe conditions. (bfgs only)
    """
    fire_alpha_init: Optional[float] = 0.2
    """
    Initial value of the alpha mixing factor in the FIRE minimization scheme; recommended values are between 0.1 and 0.3
    """
    fire_falpha: Optional[float] = 0.99
    """
    Scaling of the alpha mixing parameter for steps with P > 0;
    """
    fire_nmin: Optional[int] = 5
    """
    Minimum number of steps with P > 0 before increase of dt
    """
    fire_f_inc: Optional[float] = 1.1
    """
    Factor for increasing dt
    """
    fire_f_dec: Optional[float] = 0.5
    """
    Factor for decreasing dt
    """
    fire_dtmax: Optional[float] = 10
    """
    Determines the maximum value of dt in the FIRE minimization; dtmax = fire_dtmax*dt
    """
    ion_dynamics: Optional[IonDynamics7] = "beeman"
    """
    CASE: calculation == 'vc-md'
    """


class CellDofree(Enum):
    all = "all"
    ibrav = "ibrav"
    a = "a"
    b = "b"
    c = "c"
    fixa = "fixa"
    fixb = "fixb"
    fixc = "fixc"
    x = "x"
    y = "y"
    xy = "xy"
    xz = "xz"
    xyz = "xyz"
    shape = "shape"
    volume = "volume"
    field_2Dxy = "2Dxy"
    field_2Dshape = "2Dshape"
    epitaxial_ab = "epitaxial_ab"
    epitaxial_ac = "epitaxial_ac"
    epitaxial_bc = "epitaxial_bc"


class CellDynamics(Enum):
    none = "none"
    sd = "sd"
    damp_pr = "damp-pr"
    damp_w = "damp-w"
    bfgs = "bfgs"


class CellSchema(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    press: Optional[float] = 0
    """
    Target pressure [KBar] in a variable-cell md or relaxation run.
    """
    wmass: Optional[float] = None
    """
    Fictitious cell mass [amu] for variable-cell simulations (both 'vc-md' and 'vc-relax'). Default: 0.75*Tot_Mass/pi**2 for Parrinello-Rahman MD; 0.75*Tot_Mass/pi**2/Omega**(2/3) for Wentzcovitch MD
    """
    cell_factor: Optional[float] = None
    """
    Used in the construction of the pseudopotential tables. It should exceed the maximum linear contraction of the cell during a simulation. Default: 2.0 for variable-cell calculations, 1.0 otherwise
    """
    press_conv_thr: Optional[float] = 0.5
    """
    Convergence threshold on the pressure for variable cell relaxation ('vc-relax' : note that the other convergence thresholds for ionic relaxation apply as well).
    """
    cell_dofree: Optional[CellDofree] = "all"
    """
    Select which of the cell parameters should be moved
    """
    cell_dynamics: Optional[CellDynamics] = "bfgs"
    """
    CASE ( calculation == 'vc-relax' )
    """


class CellDynamics3(Enum):
    none = "none"
    pr = "pr"
    w = "w"


class CellSchema3(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    press: Optional[float] = 0
    """
    Target pressure [KBar] in a variable-cell md or relaxation run.
    """
    wmass: Optional[float] = None
    """
    Fictitious cell mass [amu] for variable-cell simulations (both 'vc-md' and 'vc-relax'). Default: 0.75*Tot_Mass/pi**2 for Parrinello-Rahman MD; 0.75*Tot_Mass/pi**2/Omega**(2/3) for Wentzcovitch MD
    """
    cell_factor: Optional[float] = None
    """
    Used in the construction of the pseudopotential tables. It should exceed the maximum linear contraction of the cell during a simulation. Default: 2.0 for variable-cell calculations, 1.0 otherwise
    """
    press_conv_thr: Optional[float] = 0.5
    """
    Convergence threshold on the pressure for variable cell relaxation ('vc-relax' : note that the other convergence thresholds for ionic relaxation apply as well).
    """
    cell_dofree: Optional[CellDofree] = "all"
    """
    Select which of the cell parameters should be moved
    """
    cell_dynamics: Optional[CellDynamics3] = None
    """
    CASE ( calculation == 'vc-md' )
    """


class Value(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    X: Optional[str] = None
    """
    label of the atom. Acceptable syntax: chemical symbol X (1 or 2 characters, case-insensitive) or chemical symbol plus a number or a letter, as in "Xn" (e.g. Fe1) or "X_*" or "X-*" (e.g. C1, C_h; max total length cannot exceed 3 characters)
    """
    Mass_X: Optional[float] = None
    """
    mass of the atomic species [amu: mass of C = 12]. Used only when performing Molecular Dynamics run or structural optimization runs using Damped MD. Not actually used in all other cases (but stored in data files, so phonon calculations will use these values unless other values are provided)
    """
    PseudoPot_X: Optional[str] = None
    """
    PseudoPot_X
    """


class AtomicSpeciesSchema(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    values: Optional[List[Value]] = None


class CardOption(Enum):
    alat = "alat"
    bohr = "bohr"
    angstrom = "angstrom"
    crystal = "crystal"
    crystal_sg = "crystal_sg"


class Value143(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    X: Optional[str] = None
    """
    label of the atom as specified in ATOMIC_SPECIES
    """
    x: float
    """
    atomic positions
    """
    y: float
    """
    atomic positions
    """
    z: float
    """
    atomic positions
    """
    if_pos_1_: Optional[conint(ge=0, le=1)] = Field(None, alias="if_pos(1)", title="integer one or zero")
    if_pos_2_: Optional[conint(ge=0, le=1)] = Field(None, alias="if_pos(2)", title="integer one or zero")
    if_pos_3_: Optional[conint(ge=0, le=1)] = Field(None, alias="if_pos(3)", title="integer one or zero")


class AtomicPositionsSchema(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    card_option: Optional[CardOption] = "alat"
    values: Optional[List[Value143]] = None


class CardOption5(Enum):
    tpiba = "tpiba"
    automatic = "automatic"
    crystal = "crystal"
    gamma = "gamma"
    tpiba_b = "tpiba_b"
    crystal_b = "crystal_b"
    tpiba_c = "tpiba_c"
    crystal_c = "crystal_c"


class Value144(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    nks: Optional[int] = None
    """
    Number of supplied special k-points.
    """
    xk_x: Optional[float] = None
    xk_y: Optional[float] = None
    xk_z: Optional[float] = None
    wk: Optional[float] = None


class Values(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    nk1: Optional[int] = None
    """
    Number of supplied special k-points.
    """
    nk2: Optional[int] = None
    """
    Number of supplied special k-points.
    """
    nk3: Optional[int] = None
    """
    Number of supplied special k-points.
    """
    sk1: Optional[int] = None
    """
    Number of supplied special k-points.
    """
    sk2: Optional[int] = None
    """
    Number of supplied special k-points.
    """
    sk3: Optional[int] = None
    """
    Number of supplied special k-points.
    """


class KPointsSchema(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    card_option: Optional[CardOption5] = None
    values: Optional[Union[List[Value144], Values]] = None


class CardOption6(Enum):
    alat = "alat"
    bohr = "bohr"
    angstrom = "angstrom"


class Values8(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    v1: Optional[List[float]] = Field(None, max_length=3, min_length=3, title="array of 3 number elements schema")
    v2: Optional[List[float]] = Field(None, max_length=3, min_length=3, title="array of 3 number elements schema")
    v3: Optional[List[float]] = Field(None, max_length=3, min_length=3, title="array of 3 number elements schema")


class CellParametersSchema(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    card_option: Optional[CardOption6] = None
    """
    label of the atom. Acceptable syntax: chemical symbol X (1 or 2 characters, case-insensitive) or chemical symbol plus a number or a letter, as in "Xn" (e.g. Fe1) or "X_*" or "X-*" (e.g. C1, C_h; max total length cannot exceed 3 characters)
    """
    values: Optional[Values8] = None


class CardOption7(Enum):
    atomic = "atomic"
    ortho_atomic = "ortho-atomic"
    norm_atomic = "norm-atomic"
    wf = "wf"
    pseudo = "pseudo"


class U(Enum):
    U = "U"


class Values9(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    U_1: Optional[U] = Field(None, alias="U")
    """
    string constant "U"; indicates the specs for the U parameter will be given
    """
    label: Optional[str] = None
    """
    label of the atom (as defined in ATOMIC_SPECIES)
    """
    manifold: Optional[str] = None
    """
    specs of the manifold (e.g., 3d, 2p...)
    """
    u_val: Optional[float] = None
    """
    value of the U parameter (in eV)
    """


class J0(Enum):
    J0 = "J0"


class Values10(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    J0_1: Optional[J0] = Field(None, alias="J0")
    """
    string constant "J0"; indicates the specs for the J0 parameter will be given
    """
    label: Optional[str] = None
    """
    label of the atom (as defined in ATOMIC_SPECIES)
    """
    manifold: Optional[str] = None
    """
    specs of the manifold (e.g., 3d, 2p...)
    """
    j0_val: Optional[float] = None
    """
    value of the J0 parameter (in eV)
    """


class ParamType(Enum):
    U = "U"
    J = "J"
    B = "B"
    E2 = "E2"
    E3 = "E3"


class Value145(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    paramType: Optional[ParamType] = None
    """
    character describing the type of Hubbard parameter allowed values: U, J and either B (for d-orbitals) or E2 and E3 (for f-orbitals)
    """
    label: Optional[str] = None
    """
    label of the atom (as defined in ATOMIC_SPECIES)
    """
    manifold: Optional[str] = None
    """
    specs of the manifold (e.g., 3d, 2p...)
    """
    paramValue: Optional[float] = None
    """
    value of the J0 parameter (in eV)
    """


class Values11(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    U_1: Optional[U] = Field(None, alias="U")
    """
    string constant "U"; indicates the specs for the U parameter will be given
    """
    label: Optional[str] = None
    """
    label of the atom (as defined in ATOMIC_SPECIES)
    """
    manifold: Optional[str] = None
    """
    specs of the manifold (e.g., 3d, 2p...)
    """
    u_val: Optional[float] = None
    """
    value of the U parameter (in eV)
    """


class Values12(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    J0_1: Optional[J0] = Field(None, alias="J0")
    """
    string constant "J0"; indicates the specs for the J0 parameter will be given
    """
    label: Optional[str] = None
    """
    label of the atom (as defined in ATOMIC_SPECIES)
    """
    manifold: Optional[str] = None
    """
    specs of the manifold (e.g., 3d, 2p...)
    """
    j0_val: Optional[float] = None
    """
    value of the J0 parameter (in eV)
    """


class V(Enum):
    V = "V"


class Values13(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    V_1: Optional[V] = Field(None, alias="V")
    """
    string constant "V"; indicates the specs for the V parameter will be given
    """
    label_I_: Optional[str] = Field(None, alias="label(I)")
    """
    label of the atom I (as defined in ATOMIC_SPECIES)
    """
    manifold_I_: Optional[str] = Field(None, alias="manifold(I)")
    """
    specs of the manifold for atom I (e.g., 3d, 2p...)
    """
    label_J_: Optional[str] = Field(None, alias="label(J)")
    """
    label of the atom J (as defined in ATOMIC_SPECIES)
    """
    manifold_J_: Optional[str] = Field(None, alias="manifold(J)")
    """
    specs of the manifold for atom J (e.g., 3d, 2p...)
    """
    I: Optional[int] = None
    """
    index of the atom I
    """
    J: Optional[int] = None
    """
    index of the atom J
    """
    v_val_I_J_: Optional[float] = Field(None, alias="v_val(I,J)")
    """
    value of the V parameter for the atom pair I,J (in eV)
    """


class HubbardSchema(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    card_option: Optional[CardOption7] = None
    values: Optional[
        Union[List[Union[Values9, Values10]], List[Value145], List[Union[Values11, Values12, Values13]]]
    ] = None


class PwxMainSchema(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    field_CONTROL: Optional[ControlSchema] = Field(None, alias="&CONTROL", title="control schema")
    field_SYSTEM: Optional[Union[SystemSchema, SystemSchema1]] = Field(None, alias="&SYSTEM", title="system schema")
    field_ELECTRONS: Optional[ElectronsSchema] = Field(None, alias="&ELECTRONS", title="electrons schema")
    field_IONS: Optional[Union[IonsSchema, IonsSchema5, IonsSchema6, IonsSchema7]] = Field(None, alias="&IONS")
    field_CELL: Optional[Union[CellSchema, CellSchema3]] = Field(None, alias="&CELL")
    ATOMIC_SPECIES: Optional[AtomicSpeciesSchema] = Field(None, title="atomic species schema")
    ATOMIC_POSITIONS: Optional[AtomicPositionsSchema] = Field(None, title="atomic positions schema")
    """
    https://www.quantum-espresso.org/Doc/INPUT_PW.html#idm1493
    """
    K_POINTS: Optional[KPointsSchema] = Field(None, title="k points schema")
    CELL_PARAMETERS: Optional[CellParametersSchema] = Field(None, title="cell parameters schema")
    HUBBARD: Optional[HubbardSchema] = Field(None, title="hubbard schema")
