# generated by datamodel-codegen:
#   filename:  core/reference.json
#   version:   0.28.5

from __future__ import annotations

from enum import Enum
from typing import Any, Dict, List, Optional, Union

from pydantic import BaseModel, Field, RootModel, constr


class Type(Enum):
    exabyte = "exabyte"


class EntityReferenceSchema(BaseModel):
    field_id: str = Field(..., alias="_id")
    """
    entity identity
    """
    cls: Optional[str] = None
    """
    entity class
    """
    slug: Optional[str] = None
    """
    entity slug
    """


class InfoForCharacteristicObtainedByExabyteCalculation(BaseModel):
    type: Optional[Type] = None
    title: constr(max_length=300)
    """
    Human-readable title of the job
    """
    field_id: str = Field(..., alias="_id")
    """
    job identifier
    """
    owner: EntityReferenceSchema = Field(..., title="entity reference schema")


class Type71(Enum):
    experiment = "experiment"


class ExperimentAuthorSchema(BaseModel):
    first: str
    middle: Optional[str] = None
    last: str
    affiliation: Optional[str] = None


class ScalarItem(BaseModel):
    value: Optional[str] = None


class ConditionSchema(BaseModel):
    units: Optional[str] = None
    """
    condition unit
    """
    scalar: Optional[List[ScalarItem]] = None
    """
    array of condition values
    """
    name: str
    """
    human-readable name of the condition
    """


class LocationSchema(BaseModel):
    latitude: float
    """
    location latitude
    """
    longitude: float
    """
    location longitude
    """


class Type72(Enum):
    literature = "literature"


class PagesSchema(BaseModel):
    start: str
    end: Optional[str] = None


class LiteratureReferenceSchema(BaseModel):
    type: Optional[Type72] = None
    doi: Optional[str] = None
    """
    Digital Object Identifier of the reference.
    """
    isbn: Optional[str] = None
    """
    International Standard Book Number of the reference.
    """
    issn: Optional[str] = None
    """
    International Standard Serial Number of the reference.
    """
    url: Optional[str] = None
    """
    Internet address of the reference.
    """
    title: Optional[str] = None
    """
    Title of the work.
    """
    publisher: Optional[str] = None
    """
    Publisher of the work.
    """
    journal: Optional[str] = None
    """
    Journal in which the work appeared.
    """
    volume: Optional[str] = None
    """
    Volume of the series in which the work appeared.
    """
    year: Optional[str] = None
    """
    Year in which the reference was published.
    """
    issue: Optional[str] = None
    """
    Issue of the collection in which the work appeared.
    """
    pages: Optional[PagesSchema] = Field(None, title="pages schema")
    """
    Start and end pages of the work.
    """
    authors: Optional[List[ExperimentAuthorSchema]] = None
    """
    List of authors of the work.
    """
    editors: Optional[List[ExperimentAuthorSchema]] = None
    """
    List of editors of the work.
    """
    reference: Optional[List[Dict[str, Any]]] = None
    """
    References cited by the work. Reference objects can nest as deeply as needed. This is useful, for example, when tracking the history of a value referenced in a scholarly article; the top level reference would contain information about where the data was accessed while the nested reference would contain information about where it was originally published.
    """


class InfoForCharacteristicObtainedByExperiment(BaseModel):
    type: Optional[Type71] = None
    authors: List[ExperimentAuthorSchema]
    """
    experiment authors
    """
    title: str
    """
    experiment title
    """
    method: str
    """
    method used in experiment
    """
    conditions: List[ConditionSchema]
    location: Optional[LocationSchema] = Field(None, title="location schema")
    timestamp: float
    """
    epoch time.
    """
    note: Optional[str] = None
    """
    Note about experiment
    """
    references: Optional[List[LiteratureReferenceSchema]] = None
    """
    references to literature articles
    """


class LiteratureReferenceSchema15(BaseModel):
    type: Optional[Type72] = None
    doi: Optional[str] = None
    """
    Digital Object Identifier of the reference.
    """
    isbn: Optional[str] = None
    """
    International Standard Book Number of the reference.
    """
    issn: Optional[str] = None
    """
    International Standard Serial Number of the reference.
    """
    url: Optional[str] = None
    """
    Internet address of the reference.
    """
    title: Optional[str] = None
    """
    Title of the work.
    """
    publisher: Optional[str] = None
    """
    Publisher of the work.
    """
    journal: Optional[str] = None
    """
    Journal in which the work appeared.
    """
    volume: Optional[str] = None
    """
    Volume of the series in which the work appeared.
    """
    year: Optional[str] = None
    """
    Year in which the reference was published.
    """
    issue: Optional[str] = None
    """
    Issue of the collection in which the work appeared.
    """
    pages: Optional[PagesSchema] = Field(None, title="pages schema")
    """
    Start and end pages of the work.
    """
    authors: Optional[List[ExperimentAuthorSchema]] = None
    """
    List of authors of the work.
    """
    editors: Optional[List[ExperimentAuthorSchema]] = None
    """
    List of editors of the work.
    """
    reference: Optional[List[Dict[str, Any]]] = None
    """
    References cited by the work. Reference objects can nest as deeply as needed. This is useful, for example, when tracking the history of a value referenced in a scholarly article; the top level reference would contain information about where the data was accessed while the nested reference would contain information about where it was originally published.
    """


class ESSE(
    RootModel[
        Union[
            InfoForCharacteristicObtainedByExabyteCalculation,
            InfoForCharacteristicObtainedByExperiment,
            LiteratureReferenceSchema15,
        ]
    ]
):
    root: Union[
        InfoForCharacteristicObtainedByExabyteCalculation,
        InfoForCharacteristicObtainedByExperiment,
        LiteratureReferenceSchema15,
    ] = Field(
        ..., title="reference schema (using `anyOf` instead of `oneOf` below b/c current reference schemas overlap)"
    )
