# generated by datamodel-codegen:
#   filename:  core/reusable/band_gap.json
#   version:   0.28.5

from __future__ import annotations

from enum import Enum
from typing import List, Optional

from pydantic import BaseModel, Field


class Type(Enum):
    direct = "direct"
    indirect = "indirect"


class Units(Enum):
    kJ_mol = "kJ/mol"
    eV = "eV"
    J_mol = "J/mol"
    hartree = "hartree"
    cm_1 = "cm-1"
    Ry = "Ry"
    eV_atom = "eV/atom"


class BandGapSchema(BaseModel):
    kpointConduction: Optional[List[float]] = Field(None, max_length=3, min_length=3, title="kpoint schema")
    """
    A k-point is a point in reciprocal space of a crystal.
    """
    kpointValence: Optional[List[float]] = Field(None, max_length=3, min_length=3, title="kpoint schema")
    """
    A k-point is a point in reciprocal space of a crystal.
    """
    eigenvalueConduction: Optional[float] = None
    """
    eigenvalue at k-point in conduction band
    """
    eigenvalueValence: Optional[float] = None
    """
    eigenvalue at k-point in valence band
    """
    spin: Optional[float] = None
    type: Type
    units: Optional[Units] = None
    value: float
