# generated by datamodel-codegen:
#   filename:  in_memory_entity/has_consistency_check_has_metadata_named_defaultable.json
#   version:   0.28.5

from __future__ import annotations

from enum import Enum
from typing import Any, Dict, List, Optional

from pydantic import BaseModel, Field


class Severity(Enum):
    info = "info"
    warning = "warning"
    error = "error"


class ConsistencyCheck(BaseModel):
    key: str
    """
    Key of the property of the entity on which the consistency check is performed in Mongo dot notation, e.g. 'basis.coordinates.1'
    """
    name: str
    """
    Name of the consistency check that is performed, which is listed in an enum.
    """
    severity: Severity
    """
    Severity level of the problem, which is used in UI to differentiate.
    """
    message: str
    """
    Message generated by the consistency check describing the problem.
    """


class HasConsistencyCheckHasMetadataNamedDefaultableInMemoryEntitySchema(BaseModel):
    field_id: Optional[str] = Field(None, alias="_id")
    """
    entity identity
    """
    slug: Optional[str] = None
    """
    entity slug
    """
    systemName: Optional[str] = None
    schemaVersion: Optional[str] = "2022.8.16"
    """
    entity's schema version. Used to distinct between different schemas.
    """
    name: Optional[str] = None
    """
    entity name
    """
    isDefault: Optional[bool] = False
    """
    Identifies that entity is defaultable
    """
    metadata: Optional[Dict[str, Any]] = None
    consistencyChecks: Optional[List[ConsistencyCheck]] = None
