# generated by datamodel-codegen:
#   filename:  job/base.json
#   version:   0.28.5

from __future__ import annotations

from enum import Enum
from typing import Any, Dict, List, Optional

from pydantic import BaseModel, ConfigDict, Field, conint


class Status(Enum):
    pre_submission = "pre-submission"
    queued = "queued"
    submitted = "submitted"
    active = "active"
    finished = "finished"
    terminate_queued = "terminate-queued"
    terminated = "terminated"
    error = "error"
    deleted = "deleted"
    timeout = "timeout"


class Queue(Enum):
    D = "D"
    OR = "OR"
    OF = "OF"
    OFplus = "OFplus"
    SR = "SR"
    SF = "SF"
    SFplus = "SFplus"
    GPOF = "GPOF"
    GP2OF = "GP2OF"
    GP4OF = "GP4OF"
    GPSF = "GPSF"
    GP2SF = "GP2SF"
    GP4SF = "GP4SF"
    OR4 = "OR4"
    OR8 = "OR8"
    OR16 = "OR16"
    SR4 = "SR4"
    SR8 = "SR8"
    SR16 = "SR16"
    GOF = "GOF"
    G4OF = "G4OF"
    G8OF = "G8OF"
    GSF = "GSF"
    G4SF = "G4SF"
    G8SF = "G8SF"


class TimeLimitType(Enum):
    per_single_attempt = "per single attempt"
    compound = "compound"


class QuantumEspressoArgumentsSchema(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    nimage: Optional[conint(ge=1, le=100)] = 1
    """
    Processors can be divided into different `images`, each corresponding to a different self-consistent or linear-response calculation, loosely coupled to others.
    """
    npools: Optional[conint(ge=1, le=100)] = 1
    """
    Each image can be subpartitioned into `pools`, each taking care of a group of k-points.
    """
    nband: Optional[conint(ge=1, le=100)] = 1
    """
    Each pool is subpartitioned into `band groups`, each taking care of a group of Kohn-Sham orbitals (also called bands, or wavefunctions).
    """
    ntg: Optional[conint(ge=1, le=100)] = 1
    """
    In order to allow good parallelization of the 3D FFT when the number of processors exceeds the number of FFT planes, FFTs on Kohn-Sham states are redistributed to `task` groups so that each group can process several wavefunctions at the same time.
    """
    ndiag: Optional[conint(ge=1, le=100)] = 1
    """
    A further level of parallelization, independent on PW or k-point parallelization, is the parallelization of subspace diagonalization / iterative orthonormalization. Both operations required the diagonalization of arrays whose dimension is the number of Kohn-Sham states (or a small multiple of it). All such arrays are distributed block-like across the `linear-algebra group`, a subgroup of the pool of processors, organized in a square 2D grid. As a consequence the number of processors in the linear-algebra group is given by n2, where n is an integer; n2 must be smaller than the number of processors in the PW group. The diagonalization is then performed in parallel using standard linear algebra operations.
    """


class Cluster(BaseModel):
    fqdn: Optional[str] = None
    """
    FQDN of the cluster. e.g. master-1-staging.exabyte.io
    """
    jid: Optional[str] = None
    """
    Job's identity in RMS. e.g. 1234.master-1-staging.exabyte.io
    """


class Domain(Enum):
    rupy = "rupy"
    alfred = "alfred"
    celim = "celim"
    webapp = "webapp"


class Error(BaseModel):
    domain: Optional[Domain] = None
    """
    Domain of the error appearance (internal).
    """
    reason: Optional[str] = None
    """
    Should be a short, unique, machine-readable error code string. e.g. FileNotFound
    """
    message: Optional[str] = None
    """
    Human-readable error message. e.g. 'File Not Found: /home/demo/data/project1/job-123/job-config.json'
    """
    traceback: Optional[str] = None
    """
    Full machine-readable error traceback. e.g. FileNotFound
    """


class ComputeArgumentsSchema(BaseModel):
    queue: Queue
    """
    Name of the submission queues: https://docs.mat3ra.com/infrastructure/resource/queues/. Below enums are for Azure, then AWS circa 2022-08, hence the duplication.
    """
    nodes: int
    """
    number of nodes used for the job inside the RMS.
    """
    ppn: int
    """
    number of CPUs used for the job inside the RMS.
    """
    timeLimit: str
    """
    Wallclock time limit for computing a job. Clock format: 'hh:mm:ss'
    """
    timeLimitType: Optional[TimeLimitType] = "per single attempt"
    """
    Convention to use when reasoning about time limits
    """
    isRestartable: Optional[bool] = True
    """
    Job is allowed to restart on termination.
    """
    notify: Optional[str] = None
    """
    Email notification for the job: n - never, a - job aborted, b - job begins, e - job ends. Last three could be combined.
    """
    email: Optional[str] = None
    """
    Email address to notify about job execution.
    """
    maxCPU: Optional[int] = None
    """
    Maximum CPU count per node. This parameter is used to let backend job submission infrastructure know that this job is to be charged for the maximum CPU per node instead of the actual ppn. For premium/fast queues where resources are provisioned on-demand and exclusively per user.
    """
    arguments: Optional[QuantumEspressoArgumentsSchema] = Field({}, title="quantum espresso arguments schema")
    """
    Optional arguments specific to using application - VASP, Quantum Espresso, etc. Specified elsewhere
    """
    cluster: Optional[Cluster] = None
    """
    Cluster where the job is executed. Optional on create. Required on job submission.
    """
    errors: Optional[List[Error]] = None
    """
    Computation error. Optional. Appears only if something happens on jobs execution.
    """
    excludeFilesPattern: Optional[str] = None
    """
    A Python compatible regex to exclude files from upload. e.g. ^.*.txt& excludes all files with .txt suffix
    """


class EntityReferenceSchema(BaseModel):
    field_id: str = Field(..., alias="_id")
    """
    entity identity
    """
    cls: Optional[str] = None
    """
    entity class
    """
    slug: Optional[str] = None
    """
    entity slug
    """


class WorkflowScopeSchema(BaseModel):
    global_: Dict[str, Any] = Field(..., alias="global")
    local: Dict[str, Any]


class ScopeTrackItem(BaseModel):
    repetition: Optional[float] = None
    scope: Optional[WorkflowScopeSchema] = Field(None, title="workflow scope schema")


class JobBaseSchema(BaseModel):
    rmsId: Optional[str] = None
    """
    Identity used to track jobs originated from command-line
    """
    status: Status
    """
    job status
    """
    startTime: Optional[str] = None
    """
    Approximate start time of the job. e.g. within 10 min
    """
    workDir: Optional[str] = None
    """
    The path to the working directory of this job, when the job originates from command-line
    """
    compute: ComputeArgumentsSchema = Field(..., title="compute arguments schema")
    """
    Custom keywords prefixed with validate correspond to custom validation methods implemented downstream
    """
    field_project: EntityReferenceSchema = Field(..., alias="_project", title="entity reference schema")
    field_material: Optional[EntityReferenceSchema] = Field(None, alias="_material", title="entity reference schema")
    parent: Optional[EntityReferenceSchema] = Field(None, title="entity reference schema")
    runtimeContext: Optional[Dict[str, Any]] = None
    """
    Context variables that the job will have access to at runtime
    """
    scopeTrack: Optional[List[ScopeTrackItem]] = None
    """
    history of the workflow scope on each update
    """
    field_id: Optional[str] = Field(None, alias="_id")
    """
    entity identity
    """
    slug: Optional[str] = None
    """
    entity slug
    """
    systemName: Optional[str] = None
    schemaVersion: Optional[str] = "2022.8.16"
    """
    entity's schema version. Used to distinct between different schemas.
    """
    name: Optional[str] = None
    """
    entity name
    """
    isDefault: Optional[bool] = False
    """
    Identifies that entity is defaultable
    """
    metadata: Optional[Dict[str, Any]] = None
