# generated by datamodel-codegen:
#   filename:  materials_category/defective_structures/two_dimensional/grain_boundary_planar/configuration.json
#   version:   0.28.5

from __future__ import annotations

from enum import Enum
from typing import Any, Dict, List, Literal, Optional, Union

from pydantic import BaseModel, Field, RootModel, confloat, conint, constr


class AxisEnum(Enum):
    x = "x"
    y = "y"
    z = "z"


class ChemicalElements(Enum):
    H = "H"
    He = "He"
    Li = "Li"
    Be = "Be"
    B = "B"
    C = "C"
    N = "N"
    O = "O"
    F = "F"
    Ne = "Ne"
    Na = "Na"
    Mg = "Mg"
    Al = "Al"
    Si = "Si"
    P = "P"
    S = "S"
    Cl = "Cl"
    Ar = "Ar"
    K = "K"
    Ca = "Ca"
    Sc = "Sc"
    Ti = "Ti"
    V = "V"
    Cr = "Cr"
    Mn = "Mn"
    Fe = "Fe"
    Co = "Co"
    Ni = "Ni"
    Cu = "Cu"
    Zn = "Zn"
    Ga = "Ga"
    Ge = "Ge"
    As = "As"
    Se = "Se"
    Br = "Br"
    Kr = "Kr"
    Rb = "Rb"
    Sr = "Sr"
    Y = "Y"
    Zr = "Zr"
    Nb = "Nb"
    Mo = "Mo"
    Tc = "Tc"
    Ru = "Ru"
    Rh = "Rh"
    Pd = "Pd"
    Ag = "Ag"
    Cd = "Cd"
    In = "In"
    Sn = "Sn"
    Sb = "Sb"
    Te = "Te"
    I = "I"
    Xe = "Xe"
    Cs = "Cs"
    Ba = "Ba"
    La = "La"
    Ce = "Ce"
    Pr = "Pr"
    Nd = "Nd"
    Pm = "Pm"
    Sm = "Sm"
    Eu = "Eu"
    Gd = "Gd"
    Tb = "Tb"
    Dy = "Dy"
    Ho = "Ho"
    Er = "Er"
    Tm = "Tm"
    Yb = "Yb"
    Lu = "Lu"
    Hf = "Hf"
    Ta = "Ta"
    W = "W"
    Re = "Re"
    Os = "Os"
    Ir = "Ir"
    Pt = "Pt"
    Au = "Au"
    Hg = "Hg"
    Tl = "Tl"
    Pb = "Pb"
    Bi = "Bi"
    Po = "Po"
    At = "At"
    Rn = "Rn"
    Fr = "Fr"
    Ra = "Ra"
    Ac = "Ac"
    Th = "Th"
    Pa = "Pa"
    U = "U"
    Np = "Np"
    Pu = "Pu"
    Am = "Am"
    Cm = "Cm"
    Bk = "Bk"
    Cf = "Cf"
    Es = "Es"
    Fm = "Fm"
    Md = "Md"
    No = "No"
    Lr = "Lr"
    Rf = "Rf"
    Db = "Db"
    Sg = "Sg"
    Bh = "Bh"
    Hs = "Hs"
    Mt = "Mt"
    Ds = "Ds"
    Rg = "Rg"
    Cn = "Cn"
    Nh = "Nh"
    Fl = "Fl"
    Mc = "Mc"
    Lv = "Lv"
    Ts = "Ts"
    Og = "Og"


class TerminationSchema(BaseModel):
    chemical_elements: Union[ChemicalElements, constr(pattern=r"^([A-Z][a-z]?[0-9]*)+$")] = Field(
        ..., title="Chemical Elements"
    )
    """
    Chemical elements at the termination. Can be a single element (e.g. 'Si') or a compound (e.g. 'SiO')
    """
    space_group_symmetry_label: str = Field(..., title="Space Group Symmetry Label")
    """
    Space group symmetry designation for the termination
    """


class Value(Enum):
    H = "H"
    He = "He"
    Li = "Li"
    Be = "Be"
    B = "B"
    C = "C"
    N = "N"
    O = "O"
    F = "F"
    Ne = "Ne"
    Na = "Na"
    Mg = "Mg"
    Al = "Al"
    Si = "Si"
    P = "P"
    S = "S"
    Cl = "Cl"
    Ar = "Ar"
    K = "K"
    Ca = "Ca"
    Sc = "Sc"
    Ti = "Ti"
    V = "V"
    Cr = "Cr"
    Mn = "Mn"
    Fe = "Fe"
    Co = "Co"
    Ni = "Ni"
    Cu = "Cu"
    Zn = "Zn"
    Ga = "Ga"
    Ge = "Ge"
    As = "As"
    Se = "Se"
    Br = "Br"
    Kr = "Kr"
    Rb = "Rb"
    Sr = "Sr"
    Y = "Y"
    Zr = "Zr"
    Nb = "Nb"
    Mo = "Mo"
    Tc = "Tc"
    Ru = "Ru"
    Rh = "Rh"
    Pd = "Pd"
    Ag = "Ag"
    Cd = "Cd"
    In = "In"
    Sn = "Sn"
    Sb = "Sb"
    Te = "Te"
    I = "I"
    Xe = "Xe"
    Cs = "Cs"
    Ba = "Ba"
    La = "La"
    Ce = "Ce"
    Pr = "Pr"
    Nd = "Nd"
    Pm = "Pm"
    Sm = "Sm"
    Eu = "Eu"
    Gd = "Gd"
    Tb = "Tb"
    Dy = "Dy"
    Ho = "Ho"
    Er = "Er"
    Tm = "Tm"
    Yb = "Yb"
    Lu = "Lu"
    Hf = "Hf"
    Ta = "Ta"
    W = "W"
    Re = "Re"
    Os = "Os"
    Ir = "Ir"
    Pt = "Pt"
    Au = "Au"
    Hg = "Hg"
    Tl = "Tl"
    Pb = "Pb"
    Bi = "Bi"
    Po = "Po"
    At = "At"
    Rn = "Rn"
    Fr = "Fr"
    Ra = "Ra"
    Ac = "Ac"
    Th = "Th"
    Pa = "Pa"
    U = "U"
    Np = "Np"
    Pu = "Pu"
    Am = "Am"
    Cm = "Cm"
    Bk = "Bk"
    Cf = "Cf"
    Es = "Es"
    Fm = "Fm"
    Md = "Md"
    No = "No"
    Lr = "Lr"
    Rf = "Rf"
    Db = "Db"
    Sg = "Sg"
    Bh = "Bh"
    Hs = "Hs"
    Mt = "Mt"
    Ds = "Ds"
    Rg = "Rg"
    Cn = "Cn"
    Nh = "Nh"
    Fl = "Fl"
    Mc = "Mc"
    Lv = "Lv"
    Ts = "Ts"
    Og = "Og"


class Value17(Enum):
    X = "X"
    Vac = "Vac"


class AtomicElementSchema(BaseModel):
    value: Union[Value, Value17]
    """
    All elements, including extra elements
    """
    id: int
    """
    integer id of this entry
    """


class AtomicCoordinateSchema(BaseModel):
    value: List[float] = Field(..., max_length=3, min_length=3, title="coordinate 3d schema")
    """
    value of this entry
    """
    id: int
    """
    integer id of this entry
    """


class BasisUnitsEnum(Enum):
    crystal = "crystal"
    cartesian = "cartesian"


class AtomicLabelSchema(BaseModel):
    value: Union[Union[int, str, float], conint(ge=1, le=9)]
    """
    value of this entry
    """
    id: int
    """
    integer id of this entry
    """


class BasisSchema(BaseModel):
    elements: List[AtomicElementSchema] = Field(..., title="atomic elements schema")
    """
    atomic elements schema
    """
    coordinates: List[AtomicCoordinateSchema] = Field(..., title="atomic coordinates schema")
    """
    atomic coordinates schema
    """
    units: Optional[BasisUnitsEnum] = Field("crystal", title="basis units enum")
    labels: Optional[List[AtomicLabelSchema]] = Field(None, title="atomic labels schema")
    """
    atomic labels schema
    """


class LatticeVectorsUnitsEnum(Enum):
    angstrom = "angstrom"
    bohr = "bohr"


class LatticeVectorsSchema(BaseModel):
    a: List[float] = Field(..., max_length=3, min_length=3, title="vector 3d schema")
    b: List[float] = Field(..., max_length=3, min_length=3, title="vector 3d schema")
    c: List[float] = Field(..., max_length=3, min_length=3, title="vector 3d schema")
    alat: Optional[float] = 1
    """
    lattice parameter for fractional coordinates
    """
    units: Optional[LatticeVectorsUnitsEnum] = Field("angstrom", title="lattice vectors units enum")


class LatticeTypeEnum(Enum):
    CUB = "CUB"
    BCC = "BCC"
    FCC = "FCC"
    TET = "TET"
    MCL = "MCL"
    ORC = "ORC"
    ORCC = "ORCC"
    ORCF = "ORCF"
    ORCI = "ORCI"
    HEX = "HEX"
    BCT = "BCT"
    TRI = "TRI"
    MCLC = "MCLC"
    RHL = "RHL"


class LatticeUnitsLengthEnum(Enum):
    angstrom = "angstrom"
    bohr = "bohr"


class LatticeUnitsAngleEnum(Enum):
    degree = "degree"
    radian = "radian"


class LatticeUnitsSchema(BaseModel):
    length: Optional[LatticeUnitsLengthEnum] = Field("angstrom", title="lattice units length enum")
    angle: Optional[LatticeUnitsAngleEnum] = Field("degree", title="lattice units angle enum")


class LatticeSchema(BaseModel):
    a: float
    """
    length of the first lattice vector
    """
    b: float
    """
    length of the second lattice vector
    """
    c: float
    """
    length of the third lattice vector
    """
    alpha: float
    """
    angle between first and second lattice vector
    """
    beta: float
    """
    angle between second and third lattice vector
    """
    gamma: float
    """
    angle between first and third lattice vector
    """
    vectors: Optional[LatticeVectorsSchema] = Field(None, title="lattice vectors schema")
    type: Optional[LatticeTypeEnum] = Field("TRI", title="lattice type enum")
    units: Optional[LatticeUnitsSchema] = Field(
        default_factory=lambda: LatticeUnitsSchema.model_validate({"length": "angstrom", "angle": "degree"}),
        title="Lattice units schema",
    )


class Name(Enum):
    volume = "volume"


class Units(Enum):
    angstrom_3 = "angstrom^3"


class VolumeSchema(BaseModel):
    name: Literal["0#-datamodel-code-generator-#-object-#-special-#"]
    units: Optional[Units] = None
    value: float


class Name40(Enum):
    density = "density"


class Units22(Enum):
    g_cm_3 = "g/cm^3"


class DensitySchema(BaseModel):
    name: Literal["1#-datamodel-code-generator-#-object-#-special-#"]
    units: Optional[Units22] = None
    value: float


class Units23(Enum):
    angstrom = "angstrom"


class ScalarSchema(BaseModel):
    units: Optional[Units23] = None
    value: float


class Name41(Enum):
    symmetry = "symmetry"


class SymmetrySchema(BaseModel):
    pointGroupSymbol: Optional[str] = None
    """
    point group symbol in Schoenflies notation
    """
    spaceGroupSymbol: Optional[str] = None
    """
    space group symbol in Hermann–Mauguin notation
    """
    tolerance: Optional[ScalarSchema] = Field(None, title="scalar schema")
    """
    tolerance used for symmetry calculation
    """
    name: Literal["2#-datamodel-code-generator-#-object-#-special-#"]


class Name42(Enum):
    elemental_ratio = "elemental_ratio"


class ElementalRatio(BaseModel):
    name: Literal["3#-datamodel-code-generator-#-object-#-special-#"]
    value: confloat(ge=0.0, le=1.0)
    element: Optional[str] = None
    """
    the element this ratio is for
    """


class Name43(Enum):
    p_norm = "p-norm"


class PNorm(BaseModel):
    name: Literal["4#-datamodel-code-generator-#-object-#-special-#"]
    degree: Optional[int] = None
    """
    degree of the dimensionality of the norm
    """
    value: float


class Name44(Enum):
    inchi = "inchi"


class InChIRepresentationSchema(BaseModel):
    name: Literal["5#-datamodel-code-generator-#-object-#-special-#"]
    value: str


class Name45(Enum):
    inchi_key = "inchi_key"


class InChIKeyRepresentationSchema(BaseModel):
    name: Literal["6#-datamodel-code-generator-#-object-#-special-#"]
    value: str


class DerivedPropertiesSchema(
    RootModel[
        Union[
            VolumeSchema,
            DensitySchema,
            SymmetrySchema,
            ElementalRatio,
            PNorm,
            InChIRepresentationSchema,
            InChIKeyRepresentationSchema,
        ]
    ]
):
    root: Union[
        VolumeSchema,
        DensitySchema,
        SymmetrySchema,
        ElementalRatio,
        PNorm,
        InChIRepresentationSchema,
        InChIKeyRepresentationSchema,
    ] = Field(..., discriminator="name")


class DatabaseSourceSchema(BaseModel):
    id: Union[str, float]
    """
    ID string for the materials uploaded from a third party source inside the third party source. For materialsproject.org an example ID is mp-32
    """
    source: str
    """
    Third party source name, e.g. materials project, 2dmatpedia, ICSD, etc.
    """
    origin: bool
    """
    Deprecated. To be removed. A flag that is true when material is initially imported from a third party * (as opposed to being independently designed from scratch).
    """
    data: Optional[Dict[str, Any]] = None
    """
    Original response from external source.
    """
    doi: Optional[str] = None
    """
    Digital Object Identifier, e.g. 10.1088/0953-8984/25/10/105506
    """
    url: Optional[str] = None
    """
    The URL of the original record, e.g. https://next-gen.materialsproject.org/materials/mp-48; ToDo: update to use URI type per https://json-schema.org/understanding-json-schema/reference/string#resource-identifiers
    """


class FileSourceSchema(BaseModel):
    extension: Optional[str] = None
    """
    file extension
    """
    filename: str
    """
    file name without extension
    """
    text: str
    """
    file content as raw text
    """
    hash: str
    """
    MD5 hash based on file content
    """


class Name46(Enum):
    default = "default"
    atomsTooClose = "atomsTooClose"
    atomsOverlap = "atomsOverlap"


class Severity(Enum):
    info = "info"
    warning = "warning"
    error = "error"


class MaterialConsistencyCheckSchema(BaseModel):
    name: Name46
    """
    Name of the consistency check that is performed, which is listed in an enum.
    """
    key: str
    """
    Key of the property of the entity on which the consistency check is performed in Mongo dot notation, e.g. 'basis.coordinates.1'
    """
    severity: Severity
    """
    Severity level of the problem, which is used in UI to differentiate.
    """
    message: str
    """
    Message generated by the consistency check describing the problem.
    """


class CrystalSchema(BaseModel):
    formula: Optional[str] = None
    """
    reduced chemical formula
    """
    unitCellFormula: Optional[str] = None
    """
    chemical formula based on the number of atoms of each element in the supercell
    """
    basis: BasisSchema = Field(..., title="basis schema")
    lattice: LatticeSchema = Field(..., title="lattice schema")
    derivedProperties: Optional[List[DerivedPropertiesSchema]] = Field(None, title="derived properties schema")
    external: Optional[DatabaseSourceSchema] = Field(None, title="database source schema")
    """
    information about a database source
    """
    src: Optional[FileSourceSchema] = Field(None, title="file source schema")
    """
    file source with the information inside
    """
    scaledHash: Optional[str] = None
    """
    Hash string for a scaled structure with lattice vector a set to 1 (eg. for materials under pressure).
    """
    icsdId: Optional[int] = None
    """
    Corresponding ICSD id of the material
    """
    isNonPeriodic: Optional[bool] = None
    """
    Whether to work in the finite molecular picture (usually with atomic orbital basis)
    """
    consistencyChecks: Optional[List[MaterialConsistencyCheckSchema]] = None
    field_id: Optional[str] = Field(None, alias="_id")
    """
    entity identity
    """
    slug: Optional[str] = None
    """
    entity slug
    """
    systemName: Optional[str] = None
    schemaVersion: Optional[str] = "2022.8.16"
    """
    entity's schema version. Used to distinct between different schemas.
    """
    name: Optional[str] = None
    """
    entity name
    """
    isDefault: Optional[bool] = False
    """
    Identifies that entity is defaultable
    """
    metadata: Optional[Dict[str, Any]] = None


class AtomicLayersUniqueRepeatedSchema(BaseModel):
    termination_top: TerminationSchema = Field(..., title="Termination Schema")
    """
    Defines a specific termination of a slab
    """
    number_of_repetitions: conint(ge=1)
    """
    Number of repetitions of the unique atomic layers
    """
    miller_indices: Optional[List[int]] = Field([0, 0, 1], max_length=3, min_length=3, title="Miller Indices Schema")
    """
    Miller indices [h, k, l] defining crystallographic planes
    """
    crystal: CrystalSchema = Field(..., title="Crystal Schema")
    """
    A crystal structure, referencing the base material schema
    """
    use_conventional_cell: Optional[bool] = True
    """
    Use the conventional cell for the crystal structure
    """


class Value18(Enum):
    H = "H"
    He = "He"
    Li = "Li"
    Be = "Be"
    B = "B"
    C = "C"
    N = "N"
    O = "O"
    F = "F"
    Ne = "Ne"
    Na = "Na"
    Mg = "Mg"
    Al = "Al"
    Si = "Si"
    P = "P"
    S = "S"
    Cl = "Cl"
    Ar = "Ar"
    K = "K"
    Ca = "Ca"
    Sc = "Sc"
    Ti = "Ti"
    V = "V"
    Cr = "Cr"
    Mn = "Mn"
    Fe = "Fe"
    Co = "Co"
    Ni = "Ni"
    Cu = "Cu"
    Zn = "Zn"
    Ga = "Ga"
    Ge = "Ge"
    As = "As"
    Se = "Se"
    Br = "Br"
    Kr = "Kr"
    Rb = "Rb"
    Sr = "Sr"
    Y = "Y"
    Zr = "Zr"
    Nb = "Nb"
    Mo = "Mo"
    Tc = "Tc"
    Ru = "Ru"
    Rh = "Rh"
    Pd = "Pd"
    Ag = "Ag"
    Cd = "Cd"
    In = "In"
    Sn = "Sn"
    Sb = "Sb"
    Te = "Te"
    I = "I"
    Xe = "Xe"
    Cs = "Cs"
    Ba = "Ba"
    La = "La"
    Ce = "Ce"
    Pr = "Pr"
    Nd = "Nd"
    Pm = "Pm"
    Sm = "Sm"
    Eu = "Eu"
    Gd = "Gd"
    Tb = "Tb"
    Dy = "Dy"
    Ho = "Ho"
    Er = "Er"
    Tm = "Tm"
    Yb = "Yb"
    Lu = "Lu"
    Hf = "Hf"
    Ta = "Ta"
    W = "W"
    Re = "Re"
    Os = "Os"
    Ir = "Ir"
    Pt = "Pt"
    Au = "Au"
    Hg = "Hg"
    Tl = "Tl"
    Pb = "Pb"
    Bi = "Bi"
    Po = "Po"
    At = "At"
    Rn = "Rn"
    Fr = "Fr"
    Ra = "Ra"
    Ac = "Ac"
    Th = "Th"
    Pa = "Pa"
    U = "U"
    Np = "Np"
    Pu = "Pu"
    Am = "Am"
    Cm = "Cm"
    Bk = "Bk"
    Cf = "Cf"
    Es = "Es"
    Fm = "Fm"
    Md = "Md"
    No = "No"
    Lr = "Lr"
    Rf = "Rf"
    Db = "Db"
    Sg = "Sg"
    Bh = "Bh"
    Hs = "Hs"
    Mt = "Mt"
    Ds = "Ds"
    Rg = "Rg"
    Cn = "Cn"
    Nh = "Nh"
    Fl = "Fl"
    Mc = "Mc"
    Lv = "Lv"
    Ts = "Ts"
    Og = "Og"


class Value19(Enum):
    X = "X"
    Vac = "Vac"


class AtomicElementSchema8(BaseModel):
    value: Union[Value18, Value19]
    """
    All elements, including extra elements
    """
    id: int
    """
    integer id of this entry
    """


class BasisSchema6(BaseModel):
    elements: List[AtomicElementSchema8] = Field(..., title="atomic elements schema")
    """
    atomic elements schema
    """
    coordinates: List[AtomicCoordinateSchema] = Field(..., title="atomic coordinates schema")
    """
    atomic coordinates schema
    """
    units: Optional[BasisUnitsEnum] = Field("crystal", title="basis units enum")
    labels: Optional[List[AtomicLabelSchema]] = Field(None, title="atomic labels schema")
    """
    atomic labels schema
    """


class LatticeVectorsSchema5(BaseModel):
    a: List[float] = Field(..., max_length=3, min_length=3, title="vector 3d schema")
    b: List[float] = Field(..., max_length=3, min_length=3, title="vector 3d schema")
    c: List[float] = Field(..., max_length=3, min_length=3, title="vector 3d schema")
    alat: Optional[float] = 1
    """
    lattice parameter for fractional coordinates
    """
    units: Optional[LatticeVectorsUnitsEnum] = Field("angstrom", title="lattice vectors units enum")


class LatticeUnitsSchema5(BaseModel):
    length: Optional[LatticeUnitsLengthEnum] = Field("angstrom", title="lattice units length enum")
    angle: Optional[LatticeUnitsAngleEnum] = Field("degree", title="lattice units angle enum")


class LatticeSchema5(BaseModel):
    a: float
    """
    length of the first lattice vector
    """
    b: float
    """
    length of the second lattice vector
    """
    c: float
    """
    length of the third lattice vector
    """
    alpha: float
    """
    angle between first and second lattice vector
    """
    beta: float
    """
    angle between second and third lattice vector
    """
    gamma: float
    """
    angle between first and third lattice vector
    """
    vectors: Optional[LatticeVectorsSchema5] = Field(None, title="lattice vectors schema")
    type: Optional[LatticeTypeEnum] = Field("TRI", title="lattice type enum")
    units: Optional[LatticeUnitsSchema5] = Field(
        default_factory=lambda: LatticeUnitsSchema5.model_validate({"length": "angstrom", "angle": "degree"}),
        title="Lattice units schema",
    )


class Name47(Enum):
    volume = "volume"


class Units24(Enum):
    angstrom_3 = "angstrom^3"


class VolumeSchema5(BaseModel):
    name: Literal["0#-datamodel-code-generator-#-object-#-special-#"]
    units: Optional[Units24] = None
    value: float


class Name48(Enum):
    density = "density"


class Units25(Enum):
    g_cm_3 = "g/cm^3"


class DensitySchema5(BaseModel):
    name: Literal["1#-datamodel-code-generator-#-object-#-special-#"]
    units: Optional[Units25] = None
    value: float


class Units26(Enum):
    angstrom = "angstrom"


class ScalarSchema6(BaseModel):
    units: Optional[Units26] = None
    value: float


class Name49(Enum):
    symmetry = "symmetry"


class SymmetrySchema5(BaseModel):
    pointGroupSymbol: Optional[str] = None
    """
    point group symbol in Schoenflies notation
    """
    spaceGroupSymbol: Optional[str] = None
    """
    space group symbol in Hermann–Mauguin notation
    """
    tolerance: Optional[ScalarSchema6] = Field(None, title="scalar schema")
    """
    tolerance used for symmetry calculation
    """
    name: Literal["2#-datamodel-code-generator-#-object-#-special-#"]


class Name50(Enum):
    elemental_ratio = "elemental_ratio"


class ElementalRatio5(BaseModel):
    name: Literal["3#-datamodel-code-generator-#-object-#-special-#"]
    value: confloat(ge=0.0, le=1.0)
    element: Optional[str] = None
    """
    the element this ratio is for
    """


class Name51(Enum):
    p_norm = "p-norm"


class PNorm5(BaseModel):
    name: Literal["4#-datamodel-code-generator-#-object-#-special-#"]
    degree: Optional[int] = None
    """
    degree of the dimensionality of the norm
    """
    value: float


class Name52(Enum):
    inchi = "inchi"


class InChIRepresentationSchema5(BaseModel):
    name: Literal["5#-datamodel-code-generator-#-object-#-special-#"]
    value: str


class Name53(Enum):
    inchi_key = "inchi_key"


class InChIKeyRepresentationSchema5(BaseModel):
    name: Literal["6#-datamodel-code-generator-#-object-#-special-#"]
    value: str


class DerivedPropertiesSchema5(
    RootModel[
        Union[
            VolumeSchema5,
            DensitySchema5,
            SymmetrySchema5,
            ElementalRatio5,
            PNorm5,
            InChIRepresentationSchema5,
            InChIKeyRepresentationSchema5,
        ]
    ]
):
    root: Union[
        VolumeSchema5,
        DensitySchema5,
        SymmetrySchema5,
        ElementalRatio5,
        PNorm5,
        InChIRepresentationSchema5,
        InChIKeyRepresentationSchema5,
    ] = Field(..., discriminator="name")


class Name54(Enum):
    default = "default"
    atomsTooClose = "atomsTooClose"
    atomsOverlap = "atomsOverlap"


class MaterialConsistencyCheckSchema5(BaseModel):
    name: Name54
    """
    Name of the consistency check that is performed, which is listed in an enum.
    """
    key: str
    """
    Key of the property of the entity on which the consistency check is performed in Mongo dot notation, e.g. 'basis.coordinates.1'
    """
    severity: Severity
    """
    Severity level of the problem, which is used in UI to differentiate.
    """
    message: str
    """
    Message generated by the consistency check describing the problem.
    """


class CrystalSchema5(BaseModel):
    formula: Optional[str] = None
    """
    reduced chemical formula
    """
    unitCellFormula: Optional[str] = None
    """
    chemical formula based on the number of atoms of each element in the supercell
    """
    basis: BasisSchema6 = Field(..., title="basis schema")
    lattice: LatticeSchema5 = Field(..., title="lattice schema")
    derivedProperties: Optional[List[DerivedPropertiesSchema5]] = Field(None, title="derived properties schema")
    external: Optional[DatabaseSourceSchema] = Field(None, title="database source schema")
    """
    information about a database source
    """
    src: Optional[FileSourceSchema] = Field(None, title="file source schema")
    """
    file source with the information inside
    """
    scaledHash: Optional[str] = None
    """
    Hash string for a scaled structure with lattice vector a set to 1 (eg. for materials under pressure).
    """
    icsdId: Optional[int] = None
    """
    Corresponding ICSD id of the material
    """
    isNonPeriodic: Optional[bool] = None
    """
    Whether to work in the finite molecular picture (usually with atomic orbital basis)
    """
    consistencyChecks: Optional[List[MaterialConsistencyCheckSchema5]] = None
    field_id: Optional[str] = Field(None, alias="_id")
    """
    entity identity
    """
    slug: Optional[str] = None
    """
    entity slug
    """
    systemName: Optional[str] = None
    schemaVersion: Optional[str] = "2022.8.16"
    """
    entity's schema version. Used to distinct between different schemas.
    """
    name: Optional[str] = None
    """
    entity name
    """
    isDefault: Optional[bool] = False
    """
    Identifies that entity is defaultable
    """
    metadata: Optional[Dict[str, Any]] = None


class VacuumConfigurationSchema(BaseModel):
    direction: AxisEnum = Field(..., title="Axis Enum")
    """
    Enum for axis types
    """
    size: Optional[confloat(ge=0.0)] = 10
    """
    Size of the vacuum slab in angstroms
    """
    crystal: CrystalSchema5 = Field(..., title="Crystal Schema")
    """
    A crystal structure, referencing the base material schema
    """


class ObjectWithIdAndValueSchema(BaseModel):
    value: float
    """
    value of this entry
    """
    id: int
    """
    integer id of this entry
    """


class SlabConfigurationSchema(BaseModel):
    stack_components: List[Union[AtomicLayersUniqueRepeatedSchema, VacuumConfigurationSchema]] = Field(
        ..., max_length=2, min_length=2
    )
    direction: Optional[AxisEnum] = Field("z", title="Axis Enum")
    """
    Enum for axis types
    """
    gaps: Optional[List[ObjectWithIdAndValueSchema]] = None
    """
    Gap distances between stack components as array of objects with id and value
    """


class SupercellMatrix2DSchemaItem(RootModel[List[int]]):
    root: List[int]


class ArrayOf3NumberElementsSchema(RootModel[List[float]]):
    root: List[float] = Field(..., title="array of 3 number elements schema")


class TerminationSchema4(BaseModel):
    chemical_elements: Union[ChemicalElements, constr(pattern=r"^([A-Z][a-z]?[0-9]*)+$")] = Field(
        ..., title="Chemical Elements"
    )
    """
    Chemical elements at the termination. Can be a single element (e.g. 'Si') or a compound (e.g. 'SiO')
    """
    space_group_symmetry_label: str = Field(..., title="Space Group Symmetry Label")
    """
    Space group symmetry designation for the termination
    """


class Value20(Enum):
    H = "H"
    He = "He"
    Li = "Li"
    Be = "Be"
    B = "B"
    C = "C"
    N = "N"
    O = "O"
    F = "F"
    Ne = "Ne"
    Na = "Na"
    Mg = "Mg"
    Al = "Al"
    Si = "Si"
    P = "P"
    S = "S"
    Cl = "Cl"
    Ar = "Ar"
    K = "K"
    Ca = "Ca"
    Sc = "Sc"
    Ti = "Ti"
    V = "V"
    Cr = "Cr"
    Mn = "Mn"
    Fe = "Fe"
    Co = "Co"
    Ni = "Ni"
    Cu = "Cu"
    Zn = "Zn"
    Ga = "Ga"
    Ge = "Ge"
    As = "As"
    Se = "Se"
    Br = "Br"
    Kr = "Kr"
    Rb = "Rb"
    Sr = "Sr"
    Y = "Y"
    Zr = "Zr"
    Nb = "Nb"
    Mo = "Mo"
    Tc = "Tc"
    Ru = "Ru"
    Rh = "Rh"
    Pd = "Pd"
    Ag = "Ag"
    Cd = "Cd"
    In = "In"
    Sn = "Sn"
    Sb = "Sb"
    Te = "Te"
    I = "I"
    Xe = "Xe"
    Cs = "Cs"
    Ba = "Ba"
    La = "La"
    Ce = "Ce"
    Pr = "Pr"
    Nd = "Nd"
    Pm = "Pm"
    Sm = "Sm"
    Eu = "Eu"
    Gd = "Gd"
    Tb = "Tb"
    Dy = "Dy"
    Ho = "Ho"
    Er = "Er"
    Tm = "Tm"
    Yb = "Yb"
    Lu = "Lu"
    Hf = "Hf"
    Ta = "Ta"
    W = "W"
    Re = "Re"
    Os = "Os"
    Ir = "Ir"
    Pt = "Pt"
    Au = "Au"
    Hg = "Hg"
    Tl = "Tl"
    Pb = "Pb"
    Bi = "Bi"
    Po = "Po"
    At = "At"
    Rn = "Rn"
    Fr = "Fr"
    Ra = "Ra"
    Ac = "Ac"
    Th = "Th"
    Pa = "Pa"
    U = "U"
    Np = "Np"
    Pu = "Pu"
    Am = "Am"
    Cm = "Cm"
    Bk = "Bk"
    Cf = "Cf"
    Es = "Es"
    Fm = "Fm"
    Md = "Md"
    No = "No"
    Lr = "Lr"
    Rf = "Rf"
    Db = "Db"
    Sg = "Sg"
    Bh = "Bh"
    Hs = "Hs"
    Mt = "Mt"
    Ds = "Ds"
    Rg = "Rg"
    Cn = "Cn"
    Nh = "Nh"
    Fl = "Fl"
    Mc = "Mc"
    Lv = "Lv"
    Ts = "Ts"
    Og = "Og"


class Value21(Enum):
    X = "X"
    Vac = "Vac"


class AtomicElementSchema9(BaseModel):
    value: Union[Value20, Value21]
    """
    All elements, including extra elements
    """
    id: int
    """
    integer id of this entry
    """


class BasisSchema7(BaseModel):
    elements: List[AtomicElementSchema9] = Field(..., title="atomic elements schema")
    """
    atomic elements schema
    """
    coordinates: List[AtomicCoordinateSchema] = Field(..., title="atomic coordinates schema")
    """
    atomic coordinates schema
    """
    units: Optional[BasisUnitsEnum] = Field("crystal", title="basis units enum")
    labels: Optional[List[AtomicLabelSchema]] = Field(None, title="atomic labels schema")
    """
    atomic labels schema
    """


class LatticeVectorsSchema6(BaseModel):
    a: List[float] = Field(..., max_length=3, min_length=3, title="vector 3d schema")
    b: List[float] = Field(..., max_length=3, min_length=3, title="vector 3d schema")
    c: List[float] = Field(..., max_length=3, min_length=3, title="vector 3d schema")
    alat: Optional[float] = 1
    """
    lattice parameter for fractional coordinates
    """
    units: Optional[LatticeVectorsUnitsEnum] = Field("angstrom", title="lattice vectors units enum")


class LatticeUnitsSchema6(BaseModel):
    length: Optional[LatticeUnitsLengthEnum] = Field("angstrom", title="lattice units length enum")
    angle: Optional[LatticeUnitsAngleEnum] = Field("degree", title="lattice units angle enum")


class LatticeSchema6(BaseModel):
    a: float
    """
    length of the first lattice vector
    """
    b: float
    """
    length of the second lattice vector
    """
    c: float
    """
    length of the third lattice vector
    """
    alpha: float
    """
    angle between first and second lattice vector
    """
    beta: float
    """
    angle between second and third lattice vector
    """
    gamma: float
    """
    angle between first and third lattice vector
    """
    vectors: Optional[LatticeVectorsSchema6] = Field(None, title="lattice vectors schema")
    type: Optional[LatticeTypeEnum] = Field("TRI", title="lattice type enum")
    units: Optional[LatticeUnitsSchema6] = Field(
        default_factory=lambda: LatticeUnitsSchema6.model_validate({"length": "angstrom", "angle": "degree"}),
        title="Lattice units schema",
    )


class Name55(Enum):
    volume = "volume"


class Units27(Enum):
    angstrom_3 = "angstrom^3"


class VolumeSchema6(BaseModel):
    name: Literal["0#-datamodel-code-generator-#-object-#-special-#"]
    units: Optional[Units27] = None
    value: float


class Name56(Enum):
    density = "density"


class Units28(Enum):
    g_cm_3 = "g/cm^3"


class DensitySchema6(BaseModel):
    name: Literal["1#-datamodel-code-generator-#-object-#-special-#"]
    units: Optional[Units28] = None
    value: float


class Units29(Enum):
    angstrom = "angstrom"


class ScalarSchema7(BaseModel):
    units: Optional[Units29] = None
    value: float


class Name57(Enum):
    symmetry = "symmetry"


class SymmetrySchema6(BaseModel):
    pointGroupSymbol: Optional[str] = None
    """
    point group symbol in Schoenflies notation
    """
    spaceGroupSymbol: Optional[str] = None
    """
    space group symbol in Hermann–Mauguin notation
    """
    tolerance: Optional[ScalarSchema7] = Field(None, title="scalar schema")
    """
    tolerance used for symmetry calculation
    """
    name: Literal["2#-datamodel-code-generator-#-object-#-special-#"]


class Name58(Enum):
    elemental_ratio = "elemental_ratio"


class ElementalRatio6(BaseModel):
    name: Literal["3#-datamodel-code-generator-#-object-#-special-#"]
    value: confloat(ge=0.0, le=1.0)
    element: Optional[str] = None
    """
    the element this ratio is for
    """


class Name59(Enum):
    p_norm = "p-norm"


class PNorm6(BaseModel):
    name: Literal["4#-datamodel-code-generator-#-object-#-special-#"]
    degree: Optional[int] = None
    """
    degree of the dimensionality of the norm
    """
    value: float


class Name60(Enum):
    inchi = "inchi"


class InChIRepresentationSchema6(BaseModel):
    name: Literal["5#-datamodel-code-generator-#-object-#-special-#"]
    value: str


class Name61(Enum):
    inchi_key = "inchi_key"


class InChIKeyRepresentationSchema6(BaseModel):
    name: Literal["6#-datamodel-code-generator-#-object-#-special-#"]
    value: str


class DerivedPropertiesSchema6(
    RootModel[
        Union[
            VolumeSchema6,
            DensitySchema6,
            SymmetrySchema6,
            ElementalRatio6,
            PNorm6,
            InChIRepresentationSchema6,
            InChIKeyRepresentationSchema6,
        ]
    ]
):
    root: Union[
        VolumeSchema6,
        DensitySchema6,
        SymmetrySchema6,
        ElementalRatio6,
        PNorm6,
        InChIRepresentationSchema6,
        InChIKeyRepresentationSchema6,
    ] = Field(..., discriminator="name")


class Name62(Enum):
    default = "default"
    atomsTooClose = "atomsTooClose"
    atomsOverlap = "atomsOverlap"


class MaterialConsistencyCheckSchema6(BaseModel):
    name: Name62
    """
    Name of the consistency check that is performed, which is listed in an enum.
    """
    key: str
    """
    Key of the property of the entity on which the consistency check is performed in Mongo dot notation, e.g. 'basis.coordinates.1'
    """
    severity: Severity
    """
    Severity level of the problem, which is used in UI to differentiate.
    """
    message: str
    """
    Message generated by the consistency check describing the problem.
    """


class CrystalSchema6(BaseModel):
    formula: Optional[str] = None
    """
    reduced chemical formula
    """
    unitCellFormula: Optional[str] = None
    """
    chemical formula based on the number of atoms of each element in the supercell
    """
    basis: BasisSchema7 = Field(..., title="basis schema")
    lattice: LatticeSchema6 = Field(..., title="lattice schema")
    derivedProperties: Optional[List[DerivedPropertiesSchema6]] = Field(None, title="derived properties schema")
    external: Optional[DatabaseSourceSchema] = Field(None, title="database source schema")
    """
    information about a database source
    """
    src: Optional[FileSourceSchema] = Field(None, title="file source schema")
    """
    file source with the information inside
    """
    scaledHash: Optional[str] = None
    """
    Hash string for a scaled structure with lattice vector a set to 1 (eg. for materials under pressure).
    """
    icsdId: Optional[int] = None
    """
    Corresponding ICSD id of the material
    """
    isNonPeriodic: Optional[bool] = None
    """
    Whether to work in the finite molecular picture (usually with atomic orbital basis)
    """
    consistencyChecks: Optional[List[MaterialConsistencyCheckSchema6]] = None
    field_id: Optional[str] = Field(None, alias="_id")
    """
    entity identity
    """
    slug: Optional[str] = None
    """
    entity slug
    """
    systemName: Optional[str] = None
    schemaVersion: Optional[str] = "2022.8.16"
    """
    entity's schema version. Used to distinct between different schemas.
    """
    name: Optional[str] = None
    """
    entity name
    """
    isDefault: Optional[bool] = False
    """
    Identifies that entity is defaultable
    """
    metadata: Optional[Dict[str, Any]] = None


class AtomicLayersUniqueRepeatedSchema2(BaseModel):
    termination_top: TerminationSchema4 = Field(..., title="Termination Schema")
    """
    Defines a specific termination of a slab
    """
    number_of_repetitions: conint(ge=1)
    """
    Number of repetitions of the unique atomic layers
    """
    miller_indices: Optional[List[int]] = Field([0, 0, 1], max_length=3, min_length=3, title="Miller Indices Schema")
    """
    Miller indices [h, k, l] defining crystallographic planes
    """
    crystal: CrystalSchema6 = Field(..., title="Crystal Schema")
    """
    A crystal structure, referencing the base material schema
    """
    use_conventional_cell: Optional[bool] = True
    """
    Use the conventional cell for the crystal structure
    """


class Value22(Enum):
    H = "H"
    He = "He"
    Li = "Li"
    Be = "Be"
    B = "B"
    C = "C"
    N = "N"
    O = "O"
    F = "F"
    Ne = "Ne"
    Na = "Na"
    Mg = "Mg"
    Al = "Al"
    Si = "Si"
    P = "P"
    S = "S"
    Cl = "Cl"
    Ar = "Ar"
    K = "K"
    Ca = "Ca"
    Sc = "Sc"
    Ti = "Ti"
    V = "V"
    Cr = "Cr"
    Mn = "Mn"
    Fe = "Fe"
    Co = "Co"
    Ni = "Ni"
    Cu = "Cu"
    Zn = "Zn"
    Ga = "Ga"
    Ge = "Ge"
    As = "As"
    Se = "Se"
    Br = "Br"
    Kr = "Kr"
    Rb = "Rb"
    Sr = "Sr"
    Y = "Y"
    Zr = "Zr"
    Nb = "Nb"
    Mo = "Mo"
    Tc = "Tc"
    Ru = "Ru"
    Rh = "Rh"
    Pd = "Pd"
    Ag = "Ag"
    Cd = "Cd"
    In = "In"
    Sn = "Sn"
    Sb = "Sb"
    Te = "Te"
    I = "I"
    Xe = "Xe"
    Cs = "Cs"
    Ba = "Ba"
    La = "La"
    Ce = "Ce"
    Pr = "Pr"
    Nd = "Nd"
    Pm = "Pm"
    Sm = "Sm"
    Eu = "Eu"
    Gd = "Gd"
    Tb = "Tb"
    Dy = "Dy"
    Ho = "Ho"
    Er = "Er"
    Tm = "Tm"
    Yb = "Yb"
    Lu = "Lu"
    Hf = "Hf"
    Ta = "Ta"
    W = "W"
    Re = "Re"
    Os = "Os"
    Ir = "Ir"
    Pt = "Pt"
    Au = "Au"
    Hg = "Hg"
    Tl = "Tl"
    Pb = "Pb"
    Bi = "Bi"
    Po = "Po"
    At = "At"
    Rn = "Rn"
    Fr = "Fr"
    Ra = "Ra"
    Ac = "Ac"
    Th = "Th"
    Pa = "Pa"
    U = "U"
    Np = "Np"
    Pu = "Pu"
    Am = "Am"
    Cm = "Cm"
    Bk = "Bk"
    Cf = "Cf"
    Es = "Es"
    Fm = "Fm"
    Md = "Md"
    No = "No"
    Lr = "Lr"
    Rf = "Rf"
    Db = "Db"
    Sg = "Sg"
    Bh = "Bh"
    Hs = "Hs"
    Mt = "Mt"
    Ds = "Ds"
    Rg = "Rg"
    Cn = "Cn"
    Nh = "Nh"
    Fl = "Fl"
    Mc = "Mc"
    Lv = "Lv"
    Ts = "Ts"
    Og = "Og"


class Value23(Enum):
    X = "X"
    Vac = "Vac"


class AtomicElementSchema10(BaseModel):
    value: Union[Value22, Value23]
    """
    All elements, including extra elements
    """
    id: int
    """
    integer id of this entry
    """


class BasisSchema8(BaseModel):
    elements: List[AtomicElementSchema10] = Field(..., title="atomic elements schema")
    """
    atomic elements schema
    """
    coordinates: List[AtomicCoordinateSchema] = Field(..., title="atomic coordinates schema")
    """
    atomic coordinates schema
    """
    units: Optional[BasisUnitsEnum] = Field("crystal", title="basis units enum")
    labels: Optional[List[AtomicLabelSchema]] = Field(None, title="atomic labels schema")
    """
    atomic labels schema
    """


class LatticeVectorsSchema7(BaseModel):
    a: List[float] = Field(..., max_length=3, min_length=3, title="vector 3d schema")
    b: List[float] = Field(..., max_length=3, min_length=3, title="vector 3d schema")
    c: List[float] = Field(..., max_length=3, min_length=3, title="vector 3d schema")
    alat: Optional[float] = 1
    """
    lattice parameter for fractional coordinates
    """
    units: Optional[LatticeVectorsUnitsEnum] = Field("angstrom", title="lattice vectors units enum")


class LatticeUnitsSchema7(BaseModel):
    length: Optional[LatticeUnitsLengthEnum] = Field("angstrom", title="lattice units length enum")
    angle: Optional[LatticeUnitsAngleEnum] = Field("degree", title="lattice units angle enum")


class LatticeSchema7(BaseModel):
    a: float
    """
    length of the first lattice vector
    """
    b: float
    """
    length of the second lattice vector
    """
    c: float
    """
    length of the third lattice vector
    """
    alpha: float
    """
    angle between first and second lattice vector
    """
    beta: float
    """
    angle between second and third lattice vector
    """
    gamma: float
    """
    angle between first and third lattice vector
    """
    vectors: Optional[LatticeVectorsSchema7] = Field(None, title="lattice vectors schema")
    type: Optional[LatticeTypeEnum] = Field("TRI", title="lattice type enum")
    units: Optional[LatticeUnitsSchema7] = Field(
        default_factory=lambda: LatticeUnitsSchema7.model_validate({"length": "angstrom", "angle": "degree"}),
        title="Lattice units schema",
    )


class Name63(Enum):
    volume = "volume"


class Units30(Enum):
    angstrom_3 = "angstrom^3"


class VolumeSchema7(BaseModel):
    name: Literal["0#-datamodel-code-generator-#-object-#-special-#"]
    units: Optional[Units30] = None
    value: float


class Name64(Enum):
    density = "density"


class Units31(Enum):
    g_cm_3 = "g/cm^3"


class DensitySchema7(BaseModel):
    name: Literal["1#-datamodel-code-generator-#-object-#-special-#"]
    units: Optional[Units31] = None
    value: float


class Units32(Enum):
    angstrom = "angstrom"


class ScalarSchema8(BaseModel):
    units: Optional[Units32] = None
    value: float


class Name65(Enum):
    symmetry = "symmetry"


class SymmetrySchema7(BaseModel):
    pointGroupSymbol: Optional[str] = None
    """
    point group symbol in Schoenflies notation
    """
    spaceGroupSymbol: Optional[str] = None
    """
    space group symbol in Hermann–Mauguin notation
    """
    tolerance: Optional[ScalarSchema8] = Field(None, title="scalar schema")
    """
    tolerance used for symmetry calculation
    """
    name: Literal["2#-datamodel-code-generator-#-object-#-special-#"]


class Name66(Enum):
    elemental_ratio = "elemental_ratio"


class ElementalRatio7(BaseModel):
    name: Literal["3#-datamodel-code-generator-#-object-#-special-#"]
    value: confloat(ge=0.0, le=1.0)
    element: Optional[str] = None
    """
    the element this ratio is for
    """


class Name67(Enum):
    p_norm = "p-norm"


class PNorm7(BaseModel):
    name: Literal["4#-datamodel-code-generator-#-object-#-special-#"]
    degree: Optional[int] = None
    """
    degree of the dimensionality of the norm
    """
    value: float


class Name68(Enum):
    inchi = "inchi"


class InChIRepresentationSchema7(BaseModel):
    name: Literal["5#-datamodel-code-generator-#-object-#-special-#"]
    value: str


class Name69(Enum):
    inchi_key = "inchi_key"


class InChIKeyRepresentationSchema7(BaseModel):
    name: Literal["6#-datamodel-code-generator-#-object-#-special-#"]
    value: str


class DerivedPropertiesSchema7(
    RootModel[
        Union[
            VolumeSchema7,
            DensitySchema7,
            SymmetrySchema7,
            ElementalRatio7,
            PNorm7,
            InChIRepresentationSchema7,
            InChIKeyRepresentationSchema7,
        ]
    ]
):
    root: Union[
        VolumeSchema7,
        DensitySchema7,
        SymmetrySchema7,
        ElementalRatio7,
        PNorm7,
        InChIRepresentationSchema7,
        InChIKeyRepresentationSchema7,
    ] = Field(..., discriminator="name")


class Name70(Enum):
    default = "default"
    atomsTooClose = "atomsTooClose"
    atomsOverlap = "atomsOverlap"


class MaterialConsistencyCheckSchema7(BaseModel):
    name: Name70
    """
    Name of the consistency check that is performed, which is listed in an enum.
    """
    key: str
    """
    Key of the property of the entity on which the consistency check is performed in Mongo dot notation, e.g. 'basis.coordinates.1'
    """
    severity: Severity
    """
    Severity level of the problem, which is used in UI to differentiate.
    """
    message: str
    """
    Message generated by the consistency check describing the problem.
    """


class CrystalSchema7(BaseModel):
    formula: Optional[str] = None
    """
    reduced chemical formula
    """
    unitCellFormula: Optional[str] = None
    """
    chemical formula based on the number of atoms of each element in the supercell
    """
    basis: BasisSchema8 = Field(..., title="basis schema")
    lattice: LatticeSchema7 = Field(..., title="lattice schema")
    derivedProperties: Optional[List[DerivedPropertiesSchema7]] = Field(None, title="derived properties schema")
    external: Optional[DatabaseSourceSchema] = Field(None, title="database source schema")
    """
    information about a database source
    """
    src: Optional[FileSourceSchema] = Field(None, title="file source schema")
    """
    file source with the information inside
    """
    scaledHash: Optional[str] = None
    """
    Hash string for a scaled structure with lattice vector a set to 1 (eg. for materials under pressure).
    """
    icsdId: Optional[int] = None
    """
    Corresponding ICSD id of the material
    """
    isNonPeriodic: Optional[bool] = None
    """
    Whether to work in the finite molecular picture (usually with atomic orbital basis)
    """
    consistencyChecks: Optional[List[MaterialConsistencyCheckSchema7]] = None
    field_id: Optional[str] = Field(None, alias="_id")
    """
    entity identity
    """
    slug: Optional[str] = None
    """
    entity slug
    """
    systemName: Optional[str] = None
    schemaVersion: Optional[str] = "2022.8.16"
    """
    entity's schema version. Used to distinct between different schemas.
    """
    name: Optional[str] = None
    """
    entity name
    """
    isDefault: Optional[bool] = False
    """
    Identifies that entity is defaultable
    """
    metadata: Optional[Dict[str, Any]] = None


class VacuumConfigurationSchema1(BaseModel):
    direction: AxisEnum = Field(..., title="Axis Enum")
    """
    Enum for axis types
    """
    size: Optional[confloat(ge=0.0)] = 10
    """
    Size of the vacuum slab in angstroms
    """
    crystal: CrystalSchema7 = Field(..., title="Crystal Schema")
    """
    A crystal structure, referencing the base material schema
    """


class SlabStrainedSupercellConfigurationSchema(BaseModel):
    xy_supercell_matrix: Optional[List[SupercellMatrix2DSchemaItem]] = Field(
        default_factory=lambda: [SupercellMatrix2DSchemaItem.model_validate(v) for v in [[1, 0], [0, 1]]],
        max_length=2,
        min_length=2,
        title="Supercell Matrix 2D Schema",
    )
    """
    Supercell matrix for xy plane transformations
    """
    strain_matrix: List[ArrayOf3NumberElementsSchema] = Field(
        ..., max_length=3, min_length=3, title="matrix 3x3 schema"
    )
    stack_components: List[Union[AtomicLayersUniqueRepeatedSchema2, VacuumConfigurationSchema1]] = Field(
        ..., max_length=2, min_length=2
    )
    direction: Optional[AxisEnum] = Field("z", title="Axis Enum")
    """
    Enum for axis types
    """
    gaps: Optional[List[ObjectWithIdAndValueSchema]] = None
    """
    Gap distances between stack components as array of objects with id and value
    """


class TerminationSchema5(BaseModel):
    chemical_elements: Union[ChemicalElements, constr(pattern=r"^([A-Z][a-z]?[0-9]*)+$")] = Field(
        ..., title="Chemical Elements"
    )
    """
    Chemical elements at the termination. Can be a single element (e.g. 'Si') or a compound (e.g. 'SiO')
    """
    space_group_symmetry_label: str = Field(..., title="Space Group Symmetry Label")
    """
    Space group symmetry designation for the termination
    """


class Value24(Enum):
    H = "H"
    He = "He"
    Li = "Li"
    Be = "Be"
    B = "B"
    C = "C"
    N = "N"
    O = "O"
    F = "F"
    Ne = "Ne"
    Na = "Na"
    Mg = "Mg"
    Al = "Al"
    Si = "Si"
    P = "P"
    S = "S"
    Cl = "Cl"
    Ar = "Ar"
    K = "K"
    Ca = "Ca"
    Sc = "Sc"
    Ti = "Ti"
    V = "V"
    Cr = "Cr"
    Mn = "Mn"
    Fe = "Fe"
    Co = "Co"
    Ni = "Ni"
    Cu = "Cu"
    Zn = "Zn"
    Ga = "Ga"
    Ge = "Ge"
    As = "As"
    Se = "Se"
    Br = "Br"
    Kr = "Kr"
    Rb = "Rb"
    Sr = "Sr"
    Y = "Y"
    Zr = "Zr"
    Nb = "Nb"
    Mo = "Mo"
    Tc = "Tc"
    Ru = "Ru"
    Rh = "Rh"
    Pd = "Pd"
    Ag = "Ag"
    Cd = "Cd"
    In = "In"
    Sn = "Sn"
    Sb = "Sb"
    Te = "Te"
    I = "I"
    Xe = "Xe"
    Cs = "Cs"
    Ba = "Ba"
    La = "La"
    Ce = "Ce"
    Pr = "Pr"
    Nd = "Nd"
    Pm = "Pm"
    Sm = "Sm"
    Eu = "Eu"
    Gd = "Gd"
    Tb = "Tb"
    Dy = "Dy"
    Ho = "Ho"
    Er = "Er"
    Tm = "Tm"
    Yb = "Yb"
    Lu = "Lu"
    Hf = "Hf"
    Ta = "Ta"
    W = "W"
    Re = "Re"
    Os = "Os"
    Ir = "Ir"
    Pt = "Pt"
    Au = "Au"
    Hg = "Hg"
    Tl = "Tl"
    Pb = "Pb"
    Bi = "Bi"
    Po = "Po"
    At = "At"
    Rn = "Rn"
    Fr = "Fr"
    Ra = "Ra"
    Ac = "Ac"
    Th = "Th"
    Pa = "Pa"
    U = "U"
    Np = "Np"
    Pu = "Pu"
    Am = "Am"
    Cm = "Cm"
    Bk = "Bk"
    Cf = "Cf"
    Es = "Es"
    Fm = "Fm"
    Md = "Md"
    No = "No"
    Lr = "Lr"
    Rf = "Rf"
    Db = "Db"
    Sg = "Sg"
    Bh = "Bh"
    Hs = "Hs"
    Mt = "Mt"
    Ds = "Ds"
    Rg = "Rg"
    Cn = "Cn"
    Nh = "Nh"
    Fl = "Fl"
    Mc = "Mc"
    Lv = "Lv"
    Ts = "Ts"
    Og = "Og"


class Value25(Enum):
    X = "X"
    Vac = "Vac"


class AtomicElementSchema11(BaseModel):
    value: Union[Value24, Value25]
    """
    All elements, including extra elements
    """
    id: int
    """
    integer id of this entry
    """


class BasisSchema9(BaseModel):
    elements: List[AtomicElementSchema11] = Field(..., title="atomic elements schema")
    """
    atomic elements schema
    """
    coordinates: List[AtomicCoordinateSchema] = Field(..., title="atomic coordinates schema")
    """
    atomic coordinates schema
    """
    units: Optional[BasisUnitsEnum] = Field("crystal", title="basis units enum")
    labels: Optional[List[AtomicLabelSchema]] = Field(None, title="atomic labels schema")
    """
    atomic labels schema
    """


class LatticeVectorsSchema8(BaseModel):
    a: List[float] = Field(..., max_length=3, min_length=3, title="vector 3d schema")
    b: List[float] = Field(..., max_length=3, min_length=3, title="vector 3d schema")
    c: List[float] = Field(..., max_length=3, min_length=3, title="vector 3d schema")
    alat: Optional[float] = 1
    """
    lattice parameter for fractional coordinates
    """
    units: Optional[LatticeVectorsUnitsEnum] = Field("angstrom", title="lattice vectors units enum")


class LatticeUnitsSchema8(BaseModel):
    length: Optional[LatticeUnitsLengthEnum] = Field("angstrom", title="lattice units length enum")
    angle: Optional[LatticeUnitsAngleEnum] = Field("degree", title="lattice units angle enum")


class LatticeSchema8(BaseModel):
    a: float
    """
    length of the first lattice vector
    """
    b: float
    """
    length of the second lattice vector
    """
    c: float
    """
    length of the third lattice vector
    """
    alpha: float
    """
    angle between first and second lattice vector
    """
    beta: float
    """
    angle between second and third lattice vector
    """
    gamma: float
    """
    angle between first and third lattice vector
    """
    vectors: Optional[LatticeVectorsSchema8] = Field(None, title="lattice vectors schema")
    type: Optional[LatticeTypeEnum] = Field("TRI", title="lattice type enum")
    units: Optional[LatticeUnitsSchema8] = Field(
        default_factory=lambda: LatticeUnitsSchema8.model_validate({"length": "angstrom", "angle": "degree"}),
        title="Lattice units schema",
    )


class Name71(Enum):
    volume = "volume"


class Units33(Enum):
    angstrom_3 = "angstrom^3"


class VolumeSchema8(BaseModel):
    name: Literal["0#-datamodel-code-generator-#-object-#-special-#"]
    units: Optional[Units33] = None
    value: float


class Name72(Enum):
    density = "density"


class Units34(Enum):
    g_cm_3 = "g/cm^3"


class DensitySchema8(BaseModel):
    name: Literal["1#-datamodel-code-generator-#-object-#-special-#"]
    units: Optional[Units34] = None
    value: float


class Units35(Enum):
    angstrom = "angstrom"


class ScalarSchema9(BaseModel):
    units: Optional[Units35] = None
    value: float


class Name73(Enum):
    symmetry = "symmetry"


class SymmetrySchema8(BaseModel):
    pointGroupSymbol: Optional[str] = None
    """
    point group symbol in Schoenflies notation
    """
    spaceGroupSymbol: Optional[str] = None
    """
    space group symbol in Hermann–Mauguin notation
    """
    tolerance: Optional[ScalarSchema9] = Field(None, title="scalar schema")
    """
    tolerance used for symmetry calculation
    """
    name: Literal["2#-datamodel-code-generator-#-object-#-special-#"]


class Name74(Enum):
    elemental_ratio = "elemental_ratio"


class ElementalRatio8(BaseModel):
    name: Literal["3#-datamodel-code-generator-#-object-#-special-#"]
    value: confloat(ge=0.0, le=1.0)
    element: Optional[str] = None
    """
    the element this ratio is for
    """


class Name75(Enum):
    p_norm = "p-norm"


class PNorm8(BaseModel):
    name: Literal["4#-datamodel-code-generator-#-object-#-special-#"]
    degree: Optional[int] = None
    """
    degree of the dimensionality of the norm
    """
    value: float


class Name76(Enum):
    inchi = "inchi"


class InChIRepresentationSchema8(BaseModel):
    name: Literal["5#-datamodel-code-generator-#-object-#-special-#"]
    value: str


class Name77(Enum):
    inchi_key = "inchi_key"


class InChIKeyRepresentationSchema8(BaseModel):
    name: Literal["6#-datamodel-code-generator-#-object-#-special-#"]
    value: str


class DerivedPropertiesSchema8(
    RootModel[
        Union[
            VolumeSchema8,
            DensitySchema8,
            SymmetrySchema8,
            ElementalRatio8,
            PNorm8,
            InChIRepresentationSchema8,
            InChIKeyRepresentationSchema8,
        ]
    ]
):
    root: Union[
        VolumeSchema8,
        DensitySchema8,
        SymmetrySchema8,
        ElementalRatio8,
        PNorm8,
        InChIRepresentationSchema8,
        InChIKeyRepresentationSchema8,
    ] = Field(..., discriminator="name")


class Name78(Enum):
    default = "default"
    atomsTooClose = "atomsTooClose"
    atomsOverlap = "atomsOverlap"


class MaterialConsistencyCheckSchema8(BaseModel):
    name: Name78
    """
    Name of the consistency check that is performed, which is listed in an enum.
    """
    key: str
    """
    Key of the property of the entity on which the consistency check is performed in Mongo dot notation, e.g. 'basis.coordinates.1'
    """
    severity: Severity
    """
    Severity level of the problem, which is used in UI to differentiate.
    """
    message: str
    """
    Message generated by the consistency check describing the problem.
    """


class CrystalSchema8(BaseModel):
    formula: Optional[str] = None
    """
    reduced chemical formula
    """
    unitCellFormula: Optional[str] = None
    """
    chemical formula based on the number of atoms of each element in the supercell
    """
    basis: BasisSchema9 = Field(..., title="basis schema")
    lattice: LatticeSchema8 = Field(..., title="lattice schema")
    derivedProperties: Optional[List[DerivedPropertiesSchema8]] = Field(None, title="derived properties schema")
    external: Optional[DatabaseSourceSchema] = Field(None, title="database source schema")
    """
    information about a database source
    """
    src: Optional[FileSourceSchema] = Field(None, title="file source schema")
    """
    file source with the information inside
    """
    scaledHash: Optional[str] = None
    """
    Hash string for a scaled structure with lattice vector a set to 1 (eg. for materials under pressure).
    """
    icsdId: Optional[int] = None
    """
    Corresponding ICSD id of the material
    """
    isNonPeriodic: Optional[bool] = None
    """
    Whether to work in the finite molecular picture (usually with atomic orbital basis)
    """
    consistencyChecks: Optional[List[MaterialConsistencyCheckSchema8]] = None
    field_id: Optional[str] = Field(None, alias="_id")
    """
    entity identity
    """
    slug: Optional[str] = None
    """
    entity slug
    """
    systemName: Optional[str] = None
    schemaVersion: Optional[str] = "2022.8.16"
    """
    entity's schema version. Used to distinct between different schemas.
    """
    name: Optional[str] = None
    """
    entity name
    """
    isDefault: Optional[bool] = False
    """
    Identifies that entity is defaultable
    """
    metadata: Optional[Dict[str, Any]] = None


class AtomicLayersUniqueRepeatedSchema3(BaseModel):
    termination_top: TerminationSchema5 = Field(..., title="Termination Schema")
    """
    Defines a specific termination of a slab
    """
    number_of_repetitions: conint(ge=1)
    """
    Number of repetitions of the unique atomic layers
    """
    miller_indices: Optional[List[int]] = Field([0, 0, 1], max_length=3, min_length=3, title="Miller Indices Schema")
    """
    Miller indices [h, k, l] defining crystallographic planes
    """
    crystal: CrystalSchema8 = Field(..., title="Crystal Schema")
    """
    A crystal structure, referencing the base material schema
    """
    use_conventional_cell: Optional[bool] = True
    """
    Use the conventional cell for the crystal structure
    """


class Value26(Enum):
    H = "H"
    He = "He"
    Li = "Li"
    Be = "Be"
    B = "B"
    C = "C"
    N = "N"
    O = "O"
    F = "F"
    Ne = "Ne"
    Na = "Na"
    Mg = "Mg"
    Al = "Al"
    Si = "Si"
    P = "P"
    S = "S"
    Cl = "Cl"
    Ar = "Ar"
    K = "K"
    Ca = "Ca"
    Sc = "Sc"
    Ti = "Ti"
    V = "V"
    Cr = "Cr"
    Mn = "Mn"
    Fe = "Fe"
    Co = "Co"
    Ni = "Ni"
    Cu = "Cu"
    Zn = "Zn"
    Ga = "Ga"
    Ge = "Ge"
    As = "As"
    Se = "Se"
    Br = "Br"
    Kr = "Kr"
    Rb = "Rb"
    Sr = "Sr"
    Y = "Y"
    Zr = "Zr"
    Nb = "Nb"
    Mo = "Mo"
    Tc = "Tc"
    Ru = "Ru"
    Rh = "Rh"
    Pd = "Pd"
    Ag = "Ag"
    Cd = "Cd"
    In = "In"
    Sn = "Sn"
    Sb = "Sb"
    Te = "Te"
    I = "I"
    Xe = "Xe"
    Cs = "Cs"
    Ba = "Ba"
    La = "La"
    Ce = "Ce"
    Pr = "Pr"
    Nd = "Nd"
    Pm = "Pm"
    Sm = "Sm"
    Eu = "Eu"
    Gd = "Gd"
    Tb = "Tb"
    Dy = "Dy"
    Ho = "Ho"
    Er = "Er"
    Tm = "Tm"
    Yb = "Yb"
    Lu = "Lu"
    Hf = "Hf"
    Ta = "Ta"
    W = "W"
    Re = "Re"
    Os = "Os"
    Ir = "Ir"
    Pt = "Pt"
    Au = "Au"
    Hg = "Hg"
    Tl = "Tl"
    Pb = "Pb"
    Bi = "Bi"
    Po = "Po"
    At = "At"
    Rn = "Rn"
    Fr = "Fr"
    Ra = "Ra"
    Ac = "Ac"
    Th = "Th"
    Pa = "Pa"
    U = "U"
    Np = "Np"
    Pu = "Pu"
    Am = "Am"
    Cm = "Cm"
    Bk = "Bk"
    Cf = "Cf"
    Es = "Es"
    Fm = "Fm"
    Md = "Md"
    No = "No"
    Lr = "Lr"
    Rf = "Rf"
    Db = "Db"
    Sg = "Sg"
    Bh = "Bh"
    Hs = "Hs"
    Mt = "Mt"
    Ds = "Ds"
    Rg = "Rg"
    Cn = "Cn"
    Nh = "Nh"
    Fl = "Fl"
    Mc = "Mc"
    Lv = "Lv"
    Ts = "Ts"
    Og = "Og"


class Value27(Enum):
    X = "X"
    Vac = "Vac"


class AtomicElementSchema12(BaseModel):
    value: Union[Value26, Value27]
    """
    All elements, including extra elements
    """
    id: int
    """
    integer id of this entry
    """


class BasisSchema10(BaseModel):
    elements: List[AtomicElementSchema12] = Field(..., title="atomic elements schema")
    """
    atomic elements schema
    """
    coordinates: List[AtomicCoordinateSchema] = Field(..., title="atomic coordinates schema")
    """
    atomic coordinates schema
    """
    units: Optional[BasisUnitsEnum] = Field("crystal", title="basis units enum")
    labels: Optional[List[AtomicLabelSchema]] = Field(None, title="atomic labels schema")
    """
    atomic labels schema
    """


class LatticeVectorsSchema9(BaseModel):
    a: List[float] = Field(..., max_length=3, min_length=3, title="vector 3d schema")
    b: List[float] = Field(..., max_length=3, min_length=3, title="vector 3d schema")
    c: List[float] = Field(..., max_length=3, min_length=3, title="vector 3d schema")
    alat: Optional[float] = 1
    """
    lattice parameter for fractional coordinates
    """
    units: Optional[LatticeVectorsUnitsEnum] = Field("angstrom", title="lattice vectors units enum")


class LatticeUnitsSchema9(BaseModel):
    length: Optional[LatticeUnitsLengthEnum] = Field("angstrom", title="lattice units length enum")
    angle: Optional[LatticeUnitsAngleEnum] = Field("degree", title="lattice units angle enum")


class LatticeSchema9(BaseModel):
    a: float
    """
    length of the first lattice vector
    """
    b: float
    """
    length of the second lattice vector
    """
    c: float
    """
    length of the third lattice vector
    """
    alpha: float
    """
    angle between first and second lattice vector
    """
    beta: float
    """
    angle between second and third lattice vector
    """
    gamma: float
    """
    angle between first and third lattice vector
    """
    vectors: Optional[LatticeVectorsSchema9] = Field(None, title="lattice vectors schema")
    type: Optional[LatticeTypeEnum] = Field("TRI", title="lattice type enum")
    units: Optional[LatticeUnitsSchema9] = Field(
        default_factory=lambda: LatticeUnitsSchema9.model_validate({"length": "angstrom", "angle": "degree"}),
        title="Lattice units schema",
    )


class Name79(Enum):
    volume = "volume"


class Units36(Enum):
    angstrom_3 = "angstrom^3"


class VolumeSchema9(BaseModel):
    name: Literal["0#-datamodel-code-generator-#-object-#-special-#"]
    units: Optional[Units36] = None
    value: float


class Name80(Enum):
    density = "density"


class Units37(Enum):
    g_cm_3 = "g/cm^3"


class DensitySchema9(BaseModel):
    name: Literal["1#-datamodel-code-generator-#-object-#-special-#"]
    units: Optional[Units37] = None
    value: float


class Units38(Enum):
    angstrom = "angstrom"


class ScalarSchema10(BaseModel):
    units: Optional[Units38] = None
    value: float


class Name81(Enum):
    symmetry = "symmetry"


class SymmetrySchema9(BaseModel):
    pointGroupSymbol: Optional[str] = None
    """
    point group symbol in Schoenflies notation
    """
    spaceGroupSymbol: Optional[str] = None
    """
    space group symbol in Hermann–Mauguin notation
    """
    tolerance: Optional[ScalarSchema10] = Field(None, title="scalar schema")
    """
    tolerance used for symmetry calculation
    """
    name: Literal["2#-datamodel-code-generator-#-object-#-special-#"]


class Name82(Enum):
    elemental_ratio = "elemental_ratio"


class ElementalRatio9(BaseModel):
    name: Literal["3#-datamodel-code-generator-#-object-#-special-#"]
    value: confloat(ge=0.0, le=1.0)
    element: Optional[str] = None
    """
    the element this ratio is for
    """


class Name83(Enum):
    p_norm = "p-norm"


class PNorm9(BaseModel):
    name: Literal["4#-datamodel-code-generator-#-object-#-special-#"]
    degree: Optional[int] = None
    """
    degree of the dimensionality of the norm
    """
    value: float


class Name84(Enum):
    inchi = "inchi"


class InChIRepresentationSchema9(BaseModel):
    name: Literal["5#-datamodel-code-generator-#-object-#-special-#"]
    value: str


class Name85(Enum):
    inchi_key = "inchi_key"


class InChIKeyRepresentationSchema9(BaseModel):
    name: Literal["6#-datamodel-code-generator-#-object-#-special-#"]
    value: str


class DerivedPropertiesSchema9(
    RootModel[
        Union[
            VolumeSchema9,
            DensitySchema9,
            SymmetrySchema9,
            ElementalRatio9,
            PNorm9,
            InChIRepresentationSchema9,
            InChIKeyRepresentationSchema9,
        ]
    ]
):
    root: Union[
        VolumeSchema9,
        DensitySchema9,
        SymmetrySchema9,
        ElementalRatio9,
        PNorm9,
        InChIRepresentationSchema9,
        InChIKeyRepresentationSchema9,
    ] = Field(..., discriminator="name")


class Name86(Enum):
    default = "default"
    atomsTooClose = "atomsTooClose"
    atomsOverlap = "atomsOverlap"


class MaterialConsistencyCheckSchema9(BaseModel):
    name: Name86
    """
    Name of the consistency check that is performed, which is listed in an enum.
    """
    key: str
    """
    Key of the property of the entity on which the consistency check is performed in Mongo dot notation, e.g. 'basis.coordinates.1'
    """
    severity: Severity
    """
    Severity level of the problem, which is used in UI to differentiate.
    """
    message: str
    """
    Message generated by the consistency check describing the problem.
    """


class CrystalSchema9(BaseModel):
    formula: Optional[str] = None
    """
    reduced chemical formula
    """
    unitCellFormula: Optional[str] = None
    """
    chemical formula based on the number of atoms of each element in the supercell
    """
    basis: BasisSchema10 = Field(..., title="basis schema")
    lattice: LatticeSchema9 = Field(..., title="lattice schema")
    derivedProperties: Optional[List[DerivedPropertiesSchema9]] = Field(None, title="derived properties schema")
    external: Optional[DatabaseSourceSchema] = Field(None, title="database source schema")
    """
    information about a database source
    """
    src: Optional[FileSourceSchema] = Field(None, title="file source schema")
    """
    file source with the information inside
    """
    scaledHash: Optional[str] = None
    """
    Hash string for a scaled structure with lattice vector a set to 1 (eg. for materials under pressure).
    """
    icsdId: Optional[int] = None
    """
    Corresponding ICSD id of the material
    """
    isNonPeriodic: Optional[bool] = None
    """
    Whether to work in the finite molecular picture (usually with atomic orbital basis)
    """
    consistencyChecks: Optional[List[MaterialConsistencyCheckSchema9]] = None
    field_id: Optional[str] = Field(None, alias="_id")
    """
    entity identity
    """
    slug: Optional[str] = None
    """
    entity slug
    """
    systemName: Optional[str] = None
    schemaVersion: Optional[str] = "2022.8.16"
    """
    entity's schema version. Used to distinct between different schemas.
    """
    name: Optional[str] = None
    """
    entity name
    """
    isDefault: Optional[bool] = False
    """
    Identifies that entity is defaultable
    """
    metadata: Optional[Dict[str, Any]] = None


class VacuumConfigurationSchema2(BaseModel):
    direction: AxisEnum = Field(..., title="Axis Enum")
    """
    Enum for axis types
    """
    size: Optional[confloat(ge=0.0)] = 10
    """
    Size of the vacuum slab in angstroms
    """
    crystal: CrystalSchema9 = Field(..., title="Crystal Schema")
    """
    A crystal structure, referencing the base material schema
    """


class SlabConfigurationSchema1(BaseModel):
    stack_components: List[Union[AtomicLayersUniqueRepeatedSchema3, VacuumConfigurationSchema2]] = Field(
        ..., max_length=2, min_length=2
    )
    direction: Optional[AxisEnum] = Field("z", title="Axis Enum")
    """
    Enum for axis types
    """
    gaps: Optional[List[ObjectWithIdAndValueSchema]] = None
    """
    Gap distances between stack components as array of objects with id and value
    """


class TerminationSchema6(BaseModel):
    chemical_elements: Union[ChemicalElements, constr(pattern=r"^([A-Z][a-z]?[0-9]*)+$")] = Field(
        ..., title="Chemical Elements"
    )
    """
    Chemical elements at the termination. Can be a single element (e.g. 'Si') or a compound (e.g. 'SiO')
    """
    space_group_symmetry_label: str = Field(..., title="Space Group Symmetry Label")
    """
    Space group symmetry designation for the termination
    """


class Value28(Enum):
    H = "H"
    He = "He"
    Li = "Li"
    Be = "Be"
    B = "B"
    C = "C"
    N = "N"
    O = "O"
    F = "F"
    Ne = "Ne"
    Na = "Na"
    Mg = "Mg"
    Al = "Al"
    Si = "Si"
    P = "P"
    S = "S"
    Cl = "Cl"
    Ar = "Ar"
    K = "K"
    Ca = "Ca"
    Sc = "Sc"
    Ti = "Ti"
    V = "V"
    Cr = "Cr"
    Mn = "Mn"
    Fe = "Fe"
    Co = "Co"
    Ni = "Ni"
    Cu = "Cu"
    Zn = "Zn"
    Ga = "Ga"
    Ge = "Ge"
    As = "As"
    Se = "Se"
    Br = "Br"
    Kr = "Kr"
    Rb = "Rb"
    Sr = "Sr"
    Y = "Y"
    Zr = "Zr"
    Nb = "Nb"
    Mo = "Mo"
    Tc = "Tc"
    Ru = "Ru"
    Rh = "Rh"
    Pd = "Pd"
    Ag = "Ag"
    Cd = "Cd"
    In = "In"
    Sn = "Sn"
    Sb = "Sb"
    Te = "Te"
    I = "I"
    Xe = "Xe"
    Cs = "Cs"
    Ba = "Ba"
    La = "La"
    Ce = "Ce"
    Pr = "Pr"
    Nd = "Nd"
    Pm = "Pm"
    Sm = "Sm"
    Eu = "Eu"
    Gd = "Gd"
    Tb = "Tb"
    Dy = "Dy"
    Ho = "Ho"
    Er = "Er"
    Tm = "Tm"
    Yb = "Yb"
    Lu = "Lu"
    Hf = "Hf"
    Ta = "Ta"
    W = "W"
    Re = "Re"
    Os = "Os"
    Ir = "Ir"
    Pt = "Pt"
    Au = "Au"
    Hg = "Hg"
    Tl = "Tl"
    Pb = "Pb"
    Bi = "Bi"
    Po = "Po"
    At = "At"
    Rn = "Rn"
    Fr = "Fr"
    Ra = "Ra"
    Ac = "Ac"
    Th = "Th"
    Pa = "Pa"
    U = "U"
    Np = "Np"
    Pu = "Pu"
    Am = "Am"
    Cm = "Cm"
    Bk = "Bk"
    Cf = "Cf"
    Es = "Es"
    Fm = "Fm"
    Md = "Md"
    No = "No"
    Lr = "Lr"
    Rf = "Rf"
    Db = "Db"
    Sg = "Sg"
    Bh = "Bh"
    Hs = "Hs"
    Mt = "Mt"
    Ds = "Ds"
    Rg = "Rg"
    Cn = "Cn"
    Nh = "Nh"
    Fl = "Fl"
    Mc = "Mc"
    Lv = "Lv"
    Ts = "Ts"
    Og = "Og"


class Value29(Enum):
    X = "X"
    Vac = "Vac"


class AtomicElementSchema13(BaseModel):
    value: Union[Value28, Value29]
    """
    All elements, including extra elements
    """
    id: int
    """
    integer id of this entry
    """


class BasisSchema11(BaseModel):
    elements: List[AtomicElementSchema13] = Field(..., title="atomic elements schema")
    """
    atomic elements schema
    """
    coordinates: List[AtomicCoordinateSchema] = Field(..., title="atomic coordinates schema")
    """
    atomic coordinates schema
    """
    units: Optional[BasisUnitsEnum] = Field("crystal", title="basis units enum")
    labels: Optional[List[AtomicLabelSchema]] = Field(None, title="atomic labels schema")
    """
    atomic labels schema
    """


class LatticeVectorsSchema10(BaseModel):
    a: List[float] = Field(..., max_length=3, min_length=3, title="vector 3d schema")
    b: List[float] = Field(..., max_length=3, min_length=3, title="vector 3d schema")
    c: List[float] = Field(..., max_length=3, min_length=3, title="vector 3d schema")
    alat: Optional[float] = 1
    """
    lattice parameter for fractional coordinates
    """
    units: Optional[LatticeVectorsUnitsEnum] = Field("angstrom", title="lattice vectors units enum")


class LatticeUnitsSchema10(BaseModel):
    length: Optional[LatticeUnitsLengthEnum] = Field("angstrom", title="lattice units length enum")
    angle: Optional[LatticeUnitsAngleEnum] = Field("degree", title="lattice units angle enum")


class LatticeSchema10(BaseModel):
    a: float
    """
    length of the first lattice vector
    """
    b: float
    """
    length of the second lattice vector
    """
    c: float
    """
    length of the third lattice vector
    """
    alpha: float
    """
    angle between first and second lattice vector
    """
    beta: float
    """
    angle between second and third lattice vector
    """
    gamma: float
    """
    angle between first and third lattice vector
    """
    vectors: Optional[LatticeVectorsSchema10] = Field(None, title="lattice vectors schema")
    type: Optional[LatticeTypeEnum] = Field("TRI", title="lattice type enum")
    units: Optional[LatticeUnitsSchema10] = Field(
        default_factory=lambda: LatticeUnitsSchema10.model_validate({"length": "angstrom", "angle": "degree"}),
        title="Lattice units schema",
    )


class Name87(Enum):
    volume = "volume"


class Units39(Enum):
    angstrom_3 = "angstrom^3"


class VolumeSchema10(BaseModel):
    name: Literal["0#-datamodel-code-generator-#-object-#-special-#"]
    units: Optional[Units39] = None
    value: float


class Name88(Enum):
    density = "density"


class Units40(Enum):
    g_cm_3 = "g/cm^3"


class DensitySchema10(BaseModel):
    name: Literal["1#-datamodel-code-generator-#-object-#-special-#"]
    units: Optional[Units40] = None
    value: float


class Units41(Enum):
    angstrom = "angstrom"


class ScalarSchema11(BaseModel):
    units: Optional[Units41] = None
    value: float


class Name89(Enum):
    symmetry = "symmetry"


class SymmetrySchema10(BaseModel):
    pointGroupSymbol: Optional[str] = None
    """
    point group symbol in Schoenflies notation
    """
    spaceGroupSymbol: Optional[str] = None
    """
    space group symbol in Hermann–Mauguin notation
    """
    tolerance: Optional[ScalarSchema11] = Field(None, title="scalar schema")
    """
    tolerance used for symmetry calculation
    """
    name: Literal["2#-datamodel-code-generator-#-object-#-special-#"]


class Name90(Enum):
    elemental_ratio = "elemental_ratio"


class ElementalRatio10(BaseModel):
    name: Literal["3#-datamodel-code-generator-#-object-#-special-#"]
    value: confloat(ge=0.0, le=1.0)
    element: Optional[str] = None
    """
    the element this ratio is for
    """


class Name91(Enum):
    p_norm = "p-norm"


class PNorm10(BaseModel):
    name: Literal["4#-datamodel-code-generator-#-object-#-special-#"]
    degree: Optional[int] = None
    """
    degree of the dimensionality of the norm
    """
    value: float


class Name92(Enum):
    inchi = "inchi"


class InChIRepresentationSchema10(BaseModel):
    name: Literal["5#-datamodel-code-generator-#-object-#-special-#"]
    value: str


class Name93(Enum):
    inchi_key = "inchi_key"


class InChIKeyRepresentationSchema10(BaseModel):
    name: Literal["6#-datamodel-code-generator-#-object-#-special-#"]
    value: str


class DerivedPropertiesSchema10(
    RootModel[
        Union[
            VolumeSchema10,
            DensitySchema10,
            SymmetrySchema10,
            ElementalRatio10,
            PNorm10,
            InChIRepresentationSchema10,
            InChIKeyRepresentationSchema10,
        ]
    ]
):
    root: Union[
        VolumeSchema10,
        DensitySchema10,
        SymmetrySchema10,
        ElementalRatio10,
        PNorm10,
        InChIRepresentationSchema10,
        InChIKeyRepresentationSchema10,
    ] = Field(..., discriminator="name")


class Name94(Enum):
    default = "default"
    atomsTooClose = "atomsTooClose"
    atomsOverlap = "atomsOverlap"


class MaterialConsistencyCheckSchema10(BaseModel):
    name: Name94
    """
    Name of the consistency check that is performed, which is listed in an enum.
    """
    key: str
    """
    Key of the property of the entity on which the consistency check is performed in Mongo dot notation, e.g. 'basis.coordinates.1'
    """
    severity: Severity
    """
    Severity level of the problem, which is used in UI to differentiate.
    """
    message: str
    """
    Message generated by the consistency check describing the problem.
    """


class CrystalSchema10(BaseModel):
    formula: Optional[str] = None
    """
    reduced chemical formula
    """
    unitCellFormula: Optional[str] = None
    """
    chemical formula based on the number of atoms of each element in the supercell
    """
    basis: BasisSchema11 = Field(..., title="basis schema")
    lattice: LatticeSchema10 = Field(..., title="lattice schema")
    derivedProperties: Optional[List[DerivedPropertiesSchema10]] = Field(None, title="derived properties schema")
    external: Optional[DatabaseSourceSchema] = Field(None, title="database source schema")
    """
    information about a database source
    """
    src: Optional[FileSourceSchema] = Field(None, title="file source schema")
    """
    file source with the information inside
    """
    scaledHash: Optional[str] = None
    """
    Hash string for a scaled structure with lattice vector a set to 1 (eg. for materials under pressure).
    """
    icsdId: Optional[int] = None
    """
    Corresponding ICSD id of the material
    """
    isNonPeriodic: Optional[bool] = None
    """
    Whether to work in the finite molecular picture (usually with atomic orbital basis)
    """
    consistencyChecks: Optional[List[MaterialConsistencyCheckSchema10]] = None
    field_id: Optional[str] = Field(None, alias="_id")
    """
    entity identity
    """
    slug: Optional[str] = None
    """
    entity slug
    """
    systemName: Optional[str] = None
    schemaVersion: Optional[str] = "2022.8.16"
    """
    entity's schema version. Used to distinct between different schemas.
    """
    name: Optional[str] = None
    """
    entity name
    """
    isDefault: Optional[bool] = False
    """
    Identifies that entity is defaultable
    """
    metadata: Optional[Dict[str, Any]] = None


class AtomicLayersUniqueRepeatedSchema4(BaseModel):
    termination_top: TerminationSchema6 = Field(..., title="Termination Schema")
    """
    Defines a specific termination of a slab
    """
    number_of_repetitions: conint(ge=1)
    """
    Number of repetitions of the unique atomic layers
    """
    miller_indices: Optional[List[int]] = Field([0, 0, 1], max_length=3, min_length=3, title="Miller Indices Schema")
    """
    Miller indices [h, k, l] defining crystallographic planes
    """
    crystal: CrystalSchema10 = Field(..., title="Crystal Schema")
    """
    A crystal structure, referencing the base material schema
    """
    use_conventional_cell: Optional[bool] = True
    """
    Use the conventional cell for the crystal structure
    """


class Value30(Enum):
    H = "H"
    He = "He"
    Li = "Li"
    Be = "Be"
    B = "B"
    C = "C"
    N = "N"
    O = "O"
    F = "F"
    Ne = "Ne"
    Na = "Na"
    Mg = "Mg"
    Al = "Al"
    Si = "Si"
    P = "P"
    S = "S"
    Cl = "Cl"
    Ar = "Ar"
    K = "K"
    Ca = "Ca"
    Sc = "Sc"
    Ti = "Ti"
    V = "V"
    Cr = "Cr"
    Mn = "Mn"
    Fe = "Fe"
    Co = "Co"
    Ni = "Ni"
    Cu = "Cu"
    Zn = "Zn"
    Ga = "Ga"
    Ge = "Ge"
    As = "As"
    Se = "Se"
    Br = "Br"
    Kr = "Kr"
    Rb = "Rb"
    Sr = "Sr"
    Y = "Y"
    Zr = "Zr"
    Nb = "Nb"
    Mo = "Mo"
    Tc = "Tc"
    Ru = "Ru"
    Rh = "Rh"
    Pd = "Pd"
    Ag = "Ag"
    Cd = "Cd"
    In = "In"
    Sn = "Sn"
    Sb = "Sb"
    Te = "Te"
    I = "I"
    Xe = "Xe"
    Cs = "Cs"
    Ba = "Ba"
    La = "La"
    Ce = "Ce"
    Pr = "Pr"
    Nd = "Nd"
    Pm = "Pm"
    Sm = "Sm"
    Eu = "Eu"
    Gd = "Gd"
    Tb = "Tb"
    Dy = "Dy"
    Ho = "Ho"
    Er = "Er"
    Tm = "Tm"
    Yb = "Yb"
    Lu = "Lu"
    Hf = "Hf"
    Ta = "Ta"
    W = "W"
    Re = "Re"
    Os = "Os"
    Ir = "Ir"
    Pt = "Pt"
    Au = "Au"
    Hg = "Hg"
    Tl = "Tl"
    Pb = "Pb"
    Bi = "Bi"
    Po = "Po"
    At = "At"
    Rn = "Rn"
    Fr = "Fr"
    Ra = "Ra"
    Ac = "Ac"
    Th = "Th"
    Pa = "Pa"
    U = "U"
    Np = "Np"
    Pu = "Pu"
    Am = "Am"
    Cm = "Cm"
    Bk = "Bk"
    Cf = "Cf"
    Es = "Es"
    Fm = "Fm"
    Md = "Md"
    No = "No"
    Lr = "Lr"
    Rf = "Rf"
    Db = "Db"
    Sg = "Sg"
    Bh = "Bh"
    Hs = "Hs"
    Mt = "Mt"
    Ds = "Ds"
    Rg = "Rg"
    Cn = "Cn"
    Nh = "Nh"
    Fl = "Fl"
    Mc = "Mc"
    Lv = "Lv"
    Ts = "Ts"
    Og = "Og"


class Value31(Enum):
    X = "X"
    Vac = "Vac"


class AtomicElementSchema14(BaseModel):
    value: Union[Value30, Value31]
    """
    All elements, including extra elements
    """
    id: int
    """
    integer id of this entry
    """


class BasisSchema12(BaseModel):
    elements: List[AtomicElementSchema14] = Field(..., title="atomic elements schema")
    """
    atomic elements schema
    """
    coordinates: List[AtomicCoordinateSchema] = Field(..., title="atomic coordinates schema")
    """
    atomic coordinates schema
    """
    units: Optional[BasisUnitsEnum] = Field("crystal", title="basis units enum")
    labels: Optional[List[AtomicLabelSchema]] = Field(None, title="atomic labels schema")
    """
    atomic labels schema
    """


class LatticeVectorsSchema11(BaseModel):
    a: List[float] = Field(..., max_length=3, min_length=3, title="vector 3d schema")
    b: List[float] = Field(..., max_length=3, min_length=3, title="vector 3d schema")
    c: List[float] = Field(..., max_length=3, min_length=3, title="vector 3d schema")
    alat: Optional[float] = 1
    """
    lattice parameter for fractional coordinates
    """
    units: Optional[LatticeVectorsUnitsEnum] = Field("angstrom", title="lattice vectors units enum")


class LatticeUnitsSchema11(BaseModel):
    length: Optional[LatticeUnitsLengthEnum] = Field("angstrom", title="lattice units length enum")
    angle: Optional[LatticeUnitsAngleEnum] = Field("degree", title="lattice units angle enum")


class LatticeSchema11(BaseModel):
    a: float
    """
    length of the first lattice vector
    """
    b: float
    """
    length of the second lattice vector
    """
    c: float
    """
    length of the third lattice vector
    """
    alpha: float
    """
    angle between first and second lattice vector
    """
    beta: float
    """
    angle between second and third lattice vector
    """
    gamma: float
    """
    angle between first and third lattice vector
    """
    vectors: Optional[LatticeVectorsSchema11] = Field(None, title="lattice vectors schema")
    type: Optional[LatticeTypeEnum] = Field("TRI", title="lattice type enum")
    units: Optional[LatticeUnitsSchema11] = Field(
        default_factory=lambda: LatticeUnitsSchema11.model_validate({"length": "angstrom", "angle": "degree"}),
        title="Lattice units schema",
    )


class Name95(Enum):
    volume = "volume"


class Units42(Enum):
    angstrom_3 = "angstrom^3"


class VolumeSchema11(BaseModel):
    name: Literal["0#-datamodel-code-generator-#-object-#-special-#"]
    units: Optional[Units42] = None
    value: float


class Name96(Enum):
    density = "density"


class Units43(Enum):
    g_cm_3 = "g/cm^3"


class DensitySchema11(BaseModel):
    name: Literal["1#-datamodel-code-generator-#-object-#-special-#"]
    units: Optional[Units43] = None
    value: float


class Units44(Enum):
    angstrom = "angstrom"


class ScalarSchema12(BaseModel):
    units: Optional[Units44] = None
    value: float


class Name97(Enum):
    symmetry = "symmetry"


class SymmetrySchema11(BaseModel):
    pointGroupSymbol: Optional[str] = None
    """
    point group symbol in Schoenflies notation
    """
    spaceGroupSymbol: Optional[str] = None
    """
    space group symbol in Hermann–Mauguin notation
    """
    tolerance: Optional[ScalarSchema12] = Field(None, title="scalar schema")
    """
    tolerance used for symmetry calculation
    """
    name: Literal["2#-datamodel-code-generator-#-object-#-special-#"]


class Name98(Enum):
    elemental_ratio = "elemental_ratio"


class ElementalRatio11(BaseModel):
    name: Literal["3#-datamodel-code-generator-#-object-#-special-#"]
    value: confloat(ge=0.0, le=1.0)
    element: Optional[str] = None
    """
    the element this ratio is for
    """


class Name99(Enum):
    p_norm = "p-norm"


class PNorm11(BaseModel):
    name: Literal["4#-datamodel-code-generator-#-object-#-special-#"]
    degree: Optional[int] = None
    """
    degree of the dimensionality of the norm
    """
    value: float


class Name100(Enum):
    inchi = "inchi"


class InChIRepresentationSchema11(BaseModel):
    name: Literal["5#-datamodel-code-generator-#-object-#-special-#"]
    value: str


class Name101(Enum):
    inchi_key = "inchi_key"


class InChIKeyRepresentationSchema11(BaseModel):
    name: Literal["6#-datamodel-code-generator-#-object-#-special-#"]
    value: str


class DerivedPropertiesSchema11(
    RootModel[
        Union[
            VolumeSchema11,
            DensitySchema11,
            SymmetrySchema11,
            ElementalRatio11,
            PNorm11,
            InChIRepresentationSchema11,
            InChIKeyRepresentationSchema11,
        ]
    ]
):
    root: Union[
        VolumeSchema11,
        DensitySchema11,
        SymmetrySchema11,
        ElementalRatio11,
        PNorm11,
        InChIRepresentationSchema11,
        InChIKeyRepresentationSchema11,
    ] = Field(..., discriminator="name")


class Name102(Enum):
    default = "default"
    atomsTooClose = "atomsTooClose"
    atomsOverlap = "atomsOverlap"


class MaterialConsistencyCheckSchema11(BaseModel):
    name: Name102
    """
    Name of the consistency check that is performed, which is listed in an enum.
    """
    key: str
    """
    Key of the property of the entity on which the consistency check is performed in Mongo dot notation, e.g. 'basis.coordinates.1'
    """
    severity: Severity
    """
    Severity level of the problem, which is used in UI to differentiate.
    """
    message: str
    """
    Message generated by the consistency check describing the problem.
    """


class CrystalSchema11(BaseModel):
    formula: Optional[str] = None
    """
    reduced chemical formula
    """
    unitCellFormula: Optional[str] = None
    """
    chemical formula based on the number of atoms of each element in the supercell
    """
    basis: BasisSchema12 = Field(..., title="basis schema")
    lattice: LatticeSchema11 = Field(..., title="lattice schema")
    derivedProperties: Optional[List[DerivedPropertiesSchema11]] = Field(None, title="derived properties schema")
    external: Optional[DatabaseSourceSchema] = Field(None, title="database source schema")
    """
    information about a database source
    """
    src: Optional[FileSourceSchema] = Field(None, title="file source schema")
    """
    file source with the information inside
    """
    scaledHash: Optional[str] = None
    """
    Hash string for a scaled structure with lattice vector a set to 1 (eg. for materials under pressure).
    """
    icsdId: Optional[int] = None
    """
    Corresponding ICSD id of the material
    """
    isNonPeriodic: Optional[bool] = None
    """
    Whether to work in the finite molecular picture (usually with atomic orbital basis)
    """
    consistencyChecks: Optional[List[MaterialConsistencyCheckSchema11]] = None
    field_id: Optional[str] = Field(None, alias="_id")
    """
    entity identity
    """
    slug: Optional[str] = None
    """
    entity slug
    """
    systemName: Optional[str] = None
    schemaVersion: Optional[str] = "2022.8.16"
    """
    entity's schema version. Used to distinct between different schemas.
    """
    name: Optional[str] = None
    """
    entity name
    """
    isDefault: Optional[bool] = False
    """
    Identifies that entity is defaultable
    """
    metadata: Optional[Dict[str, Any]] = None


class VacuumConfigurationSchema3(BaseModel):
    direction: AxisEnum = Field(..., title="Axis Enum")
    """
    Enum for axis types
    """
    size: Optional[confloat(ge=0.0)] = 10
    """
    Size of the vacuum slab in angstroms
    """
    crystal: CrystalSchema11 = Field(..., title="Crystal Schema")
    """
    A crystal structure, referencing the base material schema
    """


class SlabStrainedSupercellConfigurationSchema1(BaseModel):
    xy_supercell_matrix: Optional[List[SupercellMatrix2DSchemaItem]] = Field(
        default_factory=lambda: [SupercellMatrix2DSchemaItem.model_validate(v) for v in [[1, 0], [0, 1]]],
        max_length=2,
        min_length=2,
        title="Supercell Matrix 2D Schema",
    )
    """
    Supercell matrix for xy plane transformations
    """
    strain_matrix: List[ArrayOf3NumberElementsSchema] = Field(
        ..., max_length=3, min_length=3, title="matrix 3x3 schema"
    )
    stack_components: List[Union[AtomicLayersUniqueRepeatedSchema4, VacuumConfigurationSchema3]] = Field(
        ..., max_length=2, min_length=2
    )
    direction: Optional[AxisEnum] = Field("z", title="Axis Enum")
    """
    Enum for axis types
    """
    gaps: Optional[List[ObjectWithIdAndValueSchema]] = None
    """
    Gap distances between stack components as array of objects with id and value
    """


class Value32(Enum):
    H = "H"
    He = "He"
    Li = "Li"
    Be = "Be"
    B = "B"
    C = "C"
    N = "N"
    O = "O"
    F = "F"
    Ne = "Ne"
    Na = "Na"
    Mg = "Mg"
    Al = "Al"
    Si = "Si"
    P = "P"
    S = "S"
    Cl = "Cl"
    Ar = "Ar"
    K = "K"
    Ca = "Ca"
    Sc = "Sc"
    Ti = "Ti"
    V = "V"
    Cr = "Cr"
    Mn = "Mn"
    Fe = "Fe"
    Co = "Co"
    Ni = "Ni"
    Cu = "Cu"
    Zn = "Zn"
    Ga = "Ga"
    Ge = "Ge"
    As = "As"
    Se = "Se"
    Br = "Br"
    Kr = "Kr"
    Rb = "Rb"
    Sr = "Sr"
    Y = "Y"
    Zr = "Zr"
    Nb = "Nb"
    Mo = "Mo"
    Tc = "Tc"
    Ru = "Ru"
    Rh = "Rh"
    Pd = "Pd"
    Ag = "Ag"
    Cd = "Cd"
    In = "In"
    Sn = "Sn"
    Sb = "Sb"
    Te = "Te"
    I = "I"
    Xe = "Xe"
    Cs = "Cs"
    Ba = "Ba"
    La = "La"
    Ce = "Ce"
    Pr = "Pr"
    Nd = "Nd"
    Pm = "Pm"
    Sm = "Sm"
    Eu = "Eu"
    Gd = "Gd"
    Tb = "Tb"
    Dy = "Dy"
    Ho = "Ho"
    Er = "Er"
    Tm = "Tm"
    Yb = "Yb"
    Lu = "Lu"
    Hf = "Hf"
    Ta = "Ta"
    W = "W"
    Re = "Re"
    Os = "Os"
    Ir = "Ir"
    Pt = "Pt"
    Au = "Au"
    Hg = "Hg"
    Tl = "Tl"
    Pb = "Pb"
    Bi = "Bi"
    Po = "Po"
    At = "At"
    Rn = "Rn"
    Fr = "Fr"
    Ra = "Ra"
    Ac = "Ac"
    Th = "Th"
    Pa = "Pa"
    U = "U"
    Np = "Np"
    Pu = "Pu"
    Am = "Am"
    Cm = "Cm"
    Bk = "Bk"
    Cf = "Cf"
    Es = "Es"
    Fm = "Fm"
    Md = "Md"
    No = "No"
    Lr = "Lr"
    Rf = "Rf"
    Db = "Db"
    Sg = "Sg"
    Bh = "Bh"
    Hs = "Hs"
    Mt = "Mt"
    Ds = "Ds"
    Rg = "Rg"
    Cn = "Cn"
    Nh = "Nh"
    Fl = "Fl"
    Mc = "Mc"
    Lv = "Lv"
    Ts = "Ts"
    Og = "Og"


class Value33(Enum):
    X = "X"
    Vac = "Vac"


class AtomicElementSchema15(BaseModel):
    value: Union[Value32, Value33]
    """
    All elements, including extra elements
    """
    id: int
    """
    integer id of this entry
    """


class BasisSchema13(BaseModel):
    elements: List[AtomicElementSchema15] = Field(..., title="atomic elements schema")
    """
    atomic elements schema
    """
    coordinates: List[AtomicCoordinateSchema] = Field(..., title="atomic coordinates schema")
    """
    atomic coordinates schema
    """
    units: Optional[BasisUnitsEnum] = Field("crystal", title="basis units enum")
    labels: Optional[List[AtomicLabelSchema]] = Field(None, title="atomic labels schema")
    """
    atomic labels schema
    """


class LatticeVectorsSchema12(BaseModel):
    a: List[float] = Field(..., max_length=3, min_length=3, title="vector 3d schema")
    b: List[float] = Field(..., max_length=3, min_length=3, title="vector 3d schema")
    c: List[float] = Field(..., max_length=3, min_length=3, title="vector 3d schema")
    alat: Optional[float] = 1
    """
    lattice parameter for fractional coordinates
    """
    units: Optional[LatticeVectorsUnitsEnum] = Field("angstrom", title="lattice vectors units enum")


class LatticeUnitsSchema12(BaseModel):
    length: Optional[LatticeUnitsLengthEnum] = Field("angstrom", title="lattice units length enum")
    angle: Optional[LatticeUnitsAngleEnum] = Field("degree", title="lattice units angle enum")


class LatticeSchema12(BaseModel):
    a: float
    """
    length of the first lattice vector
    """
    b: float
    """
    length of the second lattice vector
    """
    c: float
    """
    length of the third lattice vector
    """
    alpha: float
    """
    angle between first and second lattice vector
    """
    beta: float
    """
    angle between second and third lattice vector
    """
    gamma: float
    """
    angle between first and third lattice vector
    """
    vectors: Optional[LatticeVectorsSchema12] = Field(None, title="lattice vectors schema")
    type: Optional[LatticeTypeEnum] = Field("TRI", title="lattice type enum")
    units: Optional[LatticeUnitsSchema12] = Field(
        default_factory=lambda: LatticeUnitsSchema12.model_validate({"length": "angstrom", "angle": "degree"}),
        title="Lattice units schema",
    )


class Name103(Enum):
    volume = "volume"


class Units45(Enum):
    angstrom_3 = "angstrom^3"


class VolumeSchema12(BaseModel):
    name: Literal["0#-datamodel-code-generator-#-object-#-special-#"]
    units: Optional[Units45] = None
    value: float


class Name104(Enum):
    density = "density"


class Units46(Enum):
    g_cm_3 = "g/cm^3"


class DensitySchema12(BaseModel):
    name: Literal["1#-datamodel-code-generator-#-object-#-special-#"]
    units: Optional[Units46] = None
    value: float


class Units47(Enum):
    angstrom = "angstrom"


class ScalarSchema13(BaseModel):
    units: Optional[Units47] = None
    value: float


class Name105(Enum):
    symmetry = "symmetry"


class SymmetrySchema12(BaseModel):
    pointGroupSymbol: Optional[str] = None
    """
    point group symbol in Schoenflies notation
    """
    spaceGroupSymbol: Optional[str] = None
    """
    space group symbol in Hermann–Mauguin notation
    """
    tolerance: Optional[ScalarSchema13] = Field(None, title="scalar schema")
    """
    tolerance used for symmetry calculation
    """
    name: Literal["2#-datamodel-code-generator-#-object-#-special-#"]


class Name106(Enum):
    elemental_ratio = "elemental_ratio"


class ElementalRatio12(BaseModel):
    name: Literal["3#-datamodel-code-generator-#-object-#-special-#"]
    value: confloat(ge=0.0, le=1.0)
    element: Optional[str] = None
    """
    the element this ratio is for
    """


class Name107(Enum):
    p_norm = "p-norm"


class PNorm12(BaseModel):
    name: Literal["4#-datamodel-code-generator-#-object-#-special-#"]
    degree: Optional[int] = None
    """
    degree of the dimensionality of the norm
    """
    value: float


class Name108(Enum):
    inchi = "inchi"


class InChIRepresentationSchema12(BaseModel):
    name: Literal["5#-datamodel-code-generator-#-object-#-special-#"]
    value: str


class Name109(Enum):
    inchi_key = "inchi_key"


class InChIKeyRepresentationSchema12(BaseModel):
    name: Literal["6#-datamodel-code-generator-#-object-#-special-#"]
    value: str


class DerivedPropertiesSchema12(
    RootModel[
        Union[
            VolumeSchema12,
            DensitySchema12,
            SymmetrySchema12,
            ElementalRatio12,
            PNorm12,
            InChIRepresentationSchema12,
            InChIKeyRepresentationSchema12,
        ]
    ]
):
    root: Union[
        VolumeSchema12,
        DensitySchema12,
        SymmetrySchema12,
        ElementalRatio12,
        PNorm12,
        InChIRepresentationSchema12,
        InChIKeyRepresentationSchema12,
    ] = Field(..., discriminator="name")


class Name110(Enum):
    default = "default"
    atomsTooClose = "atomsTooClose"
    atomsOverlap = "atomsOverlap"


class MaterialConsistencyCheckSchema12(BaseModel):
    name: Name110
    """
    Name of the consistency check that is performed, which is listed in an enum.
    """
    key: str
    """
    Key of the property of the entity on which the consistency check is performed in Mongo dot notation, e.g. 'basis.coordinates.1'
    """
    severity: Severity
    """
    Severity level of the problem, which is used in UI to differentiate.
    """
    message: str
    """
    Message generated by the consistency check describing the problem.
    """


class CrystalSchema12(BaseModel):
    formula: Optional[str] = None
    """
    reduced chemical formula
    """
    unitCellFormula: Optional[str] = None
    """
    chemical formula based on the number of atoms of each element in the supercell
    """
    basis: BasisSchema13 = Field(..., title="basis schema")
    lattice: LatticeSchema12 = Field(..., title="lattice schema")
    derivedProperties: Optional[List[DerivedPropertiesSchema12]] = Field(None, title="derived properties schema")
    external: Optional[DatabaseSourceSchema] = Field(None, title="database source schema")
    """
    information about a database source
    """
    src: Optional[FileSourceSchema] = Field(None, title="file source schema")
    """
    file source with the information inside
    """
    scaledHash: Optional[str] = None
    """
    Hash string for a scaled structure with lattice vector a set to 1 (eg. for materials under pressure).
    """
    icsdId: Optional[int] = None
    """
    Corresponding ICSD id of the material
    """
    isNonPeriodic: Optional[bool] = None
    """
    Whether to work in the finite molecular picture (usually with atomic orbital basis)
    """
    consistencyChecks: Optional[List[MaterialConsistencyCheckSchema12]] = None
    field_id: Optional[str] = Field(None, alias="_id")
    """
    entity identity
    """
    slug: Optional[str] = None
    """
    entity slug
    """
    systemName: Optional[str] = None
    schemaVersion: Optional[str] = "2022.8.16"
    """
    entity's schema version. Used to distinct between different schemas.
    """
    name: Optional[str] = None
    """
    entity name
    """
    isDefault: Optional[bool] = False
    """
    Identifies that entity is defaultable
    """
    metadata: Optional[Dict[str, Any]] = None


class VacuumConfigurationSchema4(BaseModel):
    direction: AxisEnum = Field(..., title="Axis Enum")
    """
    Enum for axis types
    """
    size: Optional[confloat(ge=0.0)] = 10
    """
    Size of the vacuum slab in angstroms
    """
    crystal: CrystalSchema12 = Field(..., title="Crystal Schema")
    """
    A crystal structure, referencing the base material schema
    """


class GrainBoundaryPlanarConfigurationSchema(BaseModel):
    direction: Optional[AxisEnum] = Field("z", title="Axis Enum")
    """
    Enum for axis types
    """
    stack_components: List[
        Union[
            Union[SlabConfigurationSchema, SlabStrainedSupercellConfigurationSchema],
            Union[SlabConfigurationSchema1, SlabStrainedSupercellConfigurationSchema1],
            VacuumConfigurationSchema4,
        ]
    ] = Field(..., max_length=3, min_length=2)
    """
    Components of the interface: slab, slab and vacuum
    """
    xy_shift: Optional[List[float]] = Field([0, 0], max_length=2, min_length=2, title="vector 2d schema")
    """
    xy shift for the film as cartesian 2D vector on the xy plane.
    """
    gaps: Optional[List[ObjectWithIdAndValueSchema]] = None
    """
    Gap distances between stack components as array of objects with id and value
    """
