# generated by datamodel-codegen:
#   filename:  materials_category/defective_structures/zero_dimensional/point_defect/substitutional.json
#   version:   0.28.5

from __future__ import annotations

from enum import Enum
from typing import Any, Dict, List, Literal, Optional, Union

from pydantic import BaseModel, Field, RootModel, confloat, conint


class Value(Enum):
    H = "H"
    He = "He"
    Li = "Li"
    Be = "Be"
    B = "B"
    C = "C"
    N = "N"
    O = "O"
    F = "F"
    Ne = "Ne"
    Na = "Na"
    Mg = "Mg"
    Al = "Al"
    Si = "Si"
    P = "P"
    S = "S"
    Cl = "Cl"
    Ar = "Ar"
    K = "K"
    Ca = "Ca"
    Sc = "Sc"
    Ti = "Ti"
    V = "V"
    Cr = "Cr"
    Mn = "Mn"
    Fe = "Fe"
    Co = "Co"
    Ni = "Ni"
    Cu = "Cu"
    Zn = "Zn"
    Ga = "Ga"
    Ge = "Ge"
    As = "As"
    Se = "Se"
    Br = "Br"
    Kr = "Kr"
    Rb = "Rb"
    Sr = "Sr"
    Y = "Y"
    Zr = "Zr"
    Nb = "Nb"
    Mo = "Mo"
    Tc = "Tc"
    Ru = "Ru"
    Rh = "Rh"
    Pd = "Pd"
    Ag = "Ag"
    Cd = "Cd"
    In = "In"
    Sn = "Sn"
    Sb = "Sb"
    Te = "Te"
    I = "I"
    Xe = "Xe"
    Cs = "Cs"
    Ba = "Ba"
    La = "La"
    Ce = "Ce"
    Pr = "Pr"
    Nd = "Nd"
    Pm = "Pm"
    Sm = "Sm"
    Eu = "Eu"
    Gd = "Gd"
    Tb = "Tb"
    Dy = "Dy"
    Ho = "Ho"
    Er = "Er"
    Tm = "Tm"
    Yb = "Yb"
    Lu = "Lu"
    Hf = "Hf"
    Ta = "Ta"
    W = "W"
    Re = "Re"
    Os = "Os"
    Ir = "Ir"
    Pt = "Pt"
    Au = "Au"
    Hg = "Hg"
    Tl = "Tl"
    Pb = "Pb"
    Bi = "Bi"
    Po = "Po"
    At = "At"
    Rn = "Rn"
    Fr = "Fr"
    Ra = "Ra"
    Ac = "Ac"
    Th = "Th"
    Pa = "Pa"
    U = "U"
    Np = "Np"
    Pu = "Pu"
    Am = "Am"
    Cm = "Cm"
    Bk = "Bk"
    Cf = "Cf"
    Es = "Es"
    Fm = "Fm"
    Md = "Md"
    No = "No"
    Lr = "Lr"
    Rf = "Rf"
    Db = "Db"
    Sg = "Sg"
    Bh = "Bh"
    Hs = "Hs"
    Mt = "Mt"
    Ds = "Ds"
    Rg = "Rg"
    Cn = "Cn"
    Nh = "Nh"
    Fl = "Fl"
    Mc = "Mc"
    Lv = "Lv"
    Ts = "Ts"
    Og = "Og"


class Value165(Enum):
    X = "X"
    Vac = "Vac"


class AtomicElementSchema(BaseModel):
    value: Union[Value, Value165]
    """
    All elements, including extra elements
    """
    id: int
    """
    integer id of this entry
    """


class AtomicCoordinateSchema(BaseModel):
    value: List[float] = Field(..., max_length=3, min_length=3, title="coordinate 3d schema")
    """
    value of this entry
    """
    id: int
    """
    integer id of this entry
    """


class BasisUnitsEnum(Enum):
    crystal = "crystal"
    cartesian = "cartesian"


class AtomicLabelSchema(BaseModel):
    value: Union[Union[int, str, float], conint(ge=1, le=9)]
    """
    value of this entry
    """
    id: int
    """
    integer id of this entry
    """


class BasisSchema(BaseModel):
    elements: List[AtomicElementSchema] = Field(..., title="atomic elements schema")
    """
    atomic elements schema
    """
    coordinates: List[AtomicCoordinateSchema] = Field(..., title="atomic coordinates schema")
    """
    atomic coordinates schema
    """
    units: Optional[BasisUnitsEnum] = Field("crystal", title="basis units enum")
    labels: Optional[List[AtomicLabelSchema]] = Field(None, title="atomic labels schema")
    """
    atomic labels schema
    """


class LatticeVectorsUnitsEnum(Enum):
    angstrom = "angstrom"
    bohr = "bohr"


class LatticeVectorsSchema(BaseModel):
    a: List[float] = Field(..., max_length=3, min_length=3, title="vector 3d schema")
    b: List[float] = Field(..., max_length=3, min_length=3, title="vector 3d schema")
    c: List[float] = Field(..., max_length=3, min_length=3, title="vector 3d schema")
    alat: Optional[float] = 1
    """
    lattice parameter for fractional coordinates
    """
    units: Optional[LatticeVectorsUnitsEnum] = Field("angstrom", title="lattice vectors units enum")


class LatticeTypeEnum(Enum):
    CUB = "CUB"
    BCC = "BCC"
    FCC = "FCC"
    TET = "TET"
    MCL = "MCL"
    ORC = "ORC"
    ORCC = "ORCC"
    ORCF = "ORCF"
    ORCI = "ORCI"
    HEX = "HEX"
    BCT = "BCT"
    TRI = "TRI"
    MCLC = "MCLC"
    RHL = "RHL"


class LatticeUnitsLengthEnum(Enum):
    angstrom = "angstrom"
    bohr = "bohr"


class LatticeUnitsAngleEnum(Enum):
    degree = "degree"
    radian = "radian"


class LatticeUnitsSchema(BaseModel):
    length: Optional[LatticeUnitsLengthEnum] = Field("angstrom", title="lattice units length enum")
    angle: Optional[LatticeUnitsAngleEnum] = Field("degree", title="lattice units angle enum")


class LatticeSchema(BaseModel):
    a: float
    """
    length of the first lattice vector
    """
    b: float
    """
    length of the second lattice vector
    """
    c: float
    """
    length of the third lattice vector
    """
    alpha: float
    """
    angle between first and second lattice vector
    """
    beta: float
    """
    angle between second and third lattice vector
    """
    gamma: float
    """
    angle between first and third lattice vector
    """
    vectors: Optional[LatticeVectorsSchema] = Field(None, title="lattice vectors schema")
    type: Optional[LatticeTypeEnum] = Field("TRI", title="lattice type enum")
    units: Optional[LatticeUnitsSchema] = Field(
        default_factory=lambda: LatticeUnitsSchema.model_validate({"length": "angstrom", "angle": "degree"}),
        title="Lattice units schema",
    )


class Name(Enum):
    volume = "volume"


class Units(Enum):
    angstrom_3 = "angstrom^3"


class VolumeSchema(BaseModel):
    name: Literal["0#-datamodel-code-generator-#-object-#-special-#"]
    units: Optional[Units] = None
    value: float


class Name663(Enum):
    density = "density"


class Units271(Enum):
    g_cm_3 = "g/cm^3"


class DensitySchema(BaseModel):
    name: Literal["1#-datamodel-code-generator-#-object-#-special-#"]
    units: Optional[Units271] = None
    value: float


class Units272(Enum):
    angstrom = "angstrom"


class ScalarSchema(BaseModel):
    units: Optional[Units272] = None
    value: float


class Name664(Enum):
    symmetry = "symmetry"


class SymmetrySchema(BaseModel):
    pointGroupSymbol: Optional[str] = None
    """
    point group symbol in Schoenflies notation
    """
    spaceGroupSymbol: Optional[str] = None
    """
    space group symbol in Hermann–Mauguin notation
    """
    tolerance: Optional[ScalarSchema] = Field(None, title="scalar schema")
    """
    tolerance used for symmetry calculation
    """
    name: Literal["2#-datamodel-code-generator-#-object-#-special-#"]


class Name665(Enum):
    elemental_ratio = "elemental_ratio"


class ElementalRatio(BaseModel):
    name: Literal["3#-datamodel-code-generator-#-object-#-special-#"]
    value: confloat(ge=0.0, le=1.0)
    element: Optional[str] = None
    """
    the element this ratio is for
    """


class Name666(Enum):
    p_norm = "p-norm"


class PNorm(BaseModel):
    name: Literal["4#-datamodel-code-generator-#-object-#-special-#"]
    degree: Optional[int] = None
    """
    degree of the dimensionality of the norm
    """
    value: float


class Name667(Enum):
    inchi = "inchi"


class InChIRepresentationSchema(BaseModel):
    name: Literal["5#-datamodel-code-generator-#-object-#-special-#"]
    value: str


class Name668(Enum):
    inchi_key = "inchi_key"


class InChIKeyRepresentationSchema(BaseModel):
    name: Literal["6#-datamodel-code-generator-#-object-#-special-#"]
    value: str


class DerivedPropertiesSchema(
    RootModel[
        Union[
            VolumeSchema,
            DensitySchema,
            SymmetrySchema,
            ElementalRatio,
            PNorm,
            InChIRepresentationSchema,
            InChIKeyRepresentationSchema,
        ]
    ]
):
    root: Union[
        VolumeSchema,
        DensitySchema,
        SymmetrySchema,
        ElementalRatio,
        PNorm,
        InChIRepresentationSchema,
        InChIKeyRepresentationSchema,
    ] = Field(..., discriminator="name")


class DatabaseSourceSchema(BaseModel):
    id: Union[str, float]
    """
    ID string for the materials uploaded from a third party source inside the third party source. For materialsproject.org an example ID is mp-32
    """
    source: str
    """
    Third party source name, e.g. materials project, 2dmatpedia, ICSD, etc.
    """
    origin: bool
    """
    Deprecated. To be removed. A flag that is true when material is initially imported from a third party * (as opposed to being independently designed from scratch).
    """
    data: Optional[Dict[str, Any]] = None
    """
    Original response from external source.
    """
    doi: Optional[str] = None
    """
    Digital Object Identifier, e.g. 10.1088/0953-8984/25/10/105506
    """
    url: Optional[str] = None
    """
    The URL of the original record, e.g. https://next-gen.materialsproject.org/materials/mp-48; ToDo: update to use URI type per https://json-schema.org/understanding-json-schema/reference/string#resource-identifiers
    """


class FileSourceSchema(BaseModel):
    extension: Optional[str] = None
    """
    file extension
    """
    filename: str
    """
    file name without extension
    """
    text: str
    """
    file content as raw text
    """
    hash: str
    """
    MD5 hash based on file content
    """


class Name669(Enum):
    default = "default"
    atomsTooClose = "atomsTooClose"
    atomsOverlap = "atomsOverlap"


class Severity(Enum):
    info = "info"
    warning = "warning"
    error = "error"


class MaterialConsistencyCheckSchema(BaseModel):
    name: Name669
    """
    Name of the consistency check that is performed, which is listed in an enum.
    """
    key: str
    """
    Key of the property of the entity on which the consistency check is performed in Mongo dot notation, e.g. 'basis.coordinates.1'
    """
    severity: Severity
    """
    Severity level of the problem, which is used in UI to differentiate.
    """
    message: str
    """
    Message generated by the consistency check describing the problem.
    """


class CrystalSchema(BaseModel):
    formula: Optional[str] = None
    """
    reduced chemical formula
    """
    unitCellFormula: Optional[str] = None
    """
    chemical formula based on the number of atoms of each element in the supercell
    """
    basis: BasisSchema = Field(..., title="basis schema")
    lattice: LatticeSchema = Field(..., title="lattice schema")
    derivedProperties: Optional[List[DerivedPropertiesSchema]] = Field(None, title="derived properties schema")
    external: Optional[DatabaseSourceSchema] = Field(None, title="database source schema")
    """
    information about a database source
    """
    src: Optional[FileSourceSchema] = Field(None, title="file source schema")
    """
    file source with the information inside
    """
    scaledHash: Optional[str] = None
    """
    Hash string for a scaled structure with lattice vector a set to 1 (eg. for materials under pressure).
    """
    icsdId: Optional[int] = None
    """
    Corresponding ICSD id of the material
    """
    isNonPeriodic: Optional[bool] = None
    """
    Whether to work in the finite molecular picture (usually with atomic orbital basis)
    """
    consistencyChecks: Optional[List[MaterialConsistencyCheckSchema]] = None
    field_id: Optional[str] = Field(None, alias="_id")
    """
    entity identity
    """
    slug: Optional[str] = None
    """
    entity slug
    """
    systemName: Optional[str] = None
    schemaVersion: Optional[str] = "2022.8.16"
    """
    entity's schema version. Used to distinct between different schemas.
    """
    name: Optional[str] = None
    """
    entity name
    """
    isDefault: Optional[bool] = False
    """
    Identifies that entity is defaultable
    """
    metadata: Optional[Dict[str, Any]] = None


class Value166(Enum):
    H = "H"
    He = "He"
    Li = "Li"
    Be = "Be"
    B = "B"
    C = "C"
    N = "N"
    O = "O"
    F = "F"
    Ne = "Ne"
    Na = "Na"
    Mg = "Mg"
    Al = "Al"
    Si = "Si"
    P = "P"
    S = "S"
    Cl = "Cl"
    Ar = "Ar"
    K = "K"
    Ca = "Ca"
    Sc = "Sc"
    Ti = "Ti"
    V = "V"
    Cr = "Cr"
    Mn = "Mn"
    Fe = "Fe"
    Co = "Co"
    Ni = "Ni"
    Cu = "Cu"
    Zn = "Zn"
    Ga = "Ga"
    Ge = "Ge"
    As = "As"
    Se = "Se"
    Br = "Br"
    Kr = "Kr"
    Rb = "Rb"
    Sr = "Sr"
    Y = "Y"
    Zr = "Zr"
    Nb = "Nb"
    Mo = "Mo"
    Tc = "Tc"
    Ru = "Ru"
    Rh = "Rh"
    Pd = "Pd"
    Ag = "Ag"
    Cd = "Cd"
    In = "In"
    Sn = "Sn"
    Sb = "Sb"
    Te = "Te"
    I = "I"
    Xe = "Xe"
    Cs = "Cs"
    Ba = "Ba"
    La = "La"
    Ce = "Ce"
    Pr = "Pr"
    Nd = "Nd"
    Pm = "Pm"
    Sm = "Sm"
    Eu = "Eu"
    Gd = "Gd"
    Tb = "Tb"
    Dy = "Dy"
    Ho = "Ho"
    Er = "Er"
    Tm = "Tm"
    Yb = "Yb"
    Lu = "Lu"
    Hf = "Hf"
    Ta = "Ta"
    W = "W"
    Re = "Re"
    Os = "Os"
    Ir = "Ir"
    Pt = "Pt"
    Au = "Au"
    Hg = "Hg"
    Tl = "Tl"
    Pb = "Pb"
    Bi = "Bi"
    Po = "Po"
    At = "At"
    Rn = "Rn"
    Fr = "Fr"
    Ra = "Ra"
    Ac = "Ac"
    Th = "Th"
    Pa = "Pa"
    U = "U"
    Np = "Np"
    Pu = "Pu"
    Am = "Am"
    Cm = "Cm"
    Bk = "Bk"
    Cf = "Cf"
    Es = "Es"
    Fm = "Fm"
    Md = "Md"
    No = "No"
    Lr = "Lr"
    Rf = "Rf"
    Db = "Db"
    Sg = "Sg"
    Bh = "Bh"
    Hs = "Hs"
    Mt = "Mt"
    Ds = "Ds"
    Rg = "Rg"
    Cn = "Cn"
    Nh = "Nh"
    Fl = "Fl"
    Mc = "Mc"
    Lv = "Lv"
    Ts = "Ts"
    Og = "Og"


class Value167(Enum):
    X = "X"
    Vac = "Vac"


class AtomicElementSchema79(BaseModel):
    value: Union[Value166, Value167]
    """
    All elements, including extra elements
    """
    id: int
    """
    integer id of this entry
    """


class BasisSchema77(BaseModel):
    elements: List[AtomicElementSchema79] = Field(..., title="atomic elements schema")
    """
    atomic elements schema
    """
    coordinates: List[AtomicCoordinateSchema] = Field(..., title="atomic coordinates schema")
    """
    atomic coordinates schema
    """
    units: Optional[BasisUnitsEnum] = Field("crystal", title="basis units enum")
    labels: Optional[List[AtomicLabelSchema]] = Field(None, title="atomic labels schema")
    """
    atomic labels schema
    """


class LatticeVectorsSchema77(BaseModel):
    a: List[float] = Field(..., max_length=3, min_length=3, title="vector 3d schema")
    b: List[float] = Field(..., max_length=3, min_length=3, title="vector 3d schema")
    c: List[float] = Field(..., max_length=3, min_length=3, title="vector 3d schema")
    alat: Optional[float] = 1
    """
    lattice parameter for fractional coordinates
    """
    units: Optional[LatticeVectorsUnitsEnum] = Field("angstrom", title="lattice vectors units enum")


class LatticeUnitsSchema78(BaseModel):
    length: Optional[LatticeUnitsLengthEnum] = Field("angstrom", title="lattice units length enum")
    angle: Optional[LatticeUnitsAngleEnum] = Field("degree", title="lattice units angle enum")


class LatticeSchema77(BaseModel):
    a: float
    """
    length of the first lattice vector
    """
    b: float
    """
    length of the second lattice vector
    """
    c: float
    """
    length of the third lattice vector
    """
    alpha: float
    """
    angle between first and second lattice vector
    """
    beta: float
    """
    angle between second and third lattice vector
    """
    gamma: float
    """
    angle between first and third lattice vector
    """
    vectors: Optional[LatticeVectorsSchema77] = Field(None, title="lattice vectors schema")
    type: Optional[LatticeTypeEnum] = Field("TRI", title="lattice type enum")
    units: Optional[LatticeUnitsSchema78] = Field(
        default_factory=lambda: LatticeUnitsSchema78.model_validate({"length": "angstrom", "angle": "degree"}),
        title="Lattice units schema",
    )


class Name670(Enum):
    volume = "volume"


class Units273(Enum):
    angstrom_3 = "angstrom^3"


class VolumeSchema77(BaseModel):
    name: Literal["0#-datamodel-code-generator-#-object-#-special-#"]
    units: Optional[Units273] = None
    value: float


class Name671(Enum):
    density = "density"


class Units274(Enum):
    g_cm_3 = "g/cm^3"


class DensitySchema78(BaseModel):
    name: Literal["1#-datamodel-code-generator-#-object-#-special-#"]
    units: Optional[Units274] = None
    value: float


class Units275(Enum):
    angstrom = "angstrom"


class ScalarSchema79(BaseModel):
    units: Optional[Units275] = None
    value: float


class Name672(Enum):
    symmetry = "symmetry"


class SymmetrySchema77(BaseModel):
    pointGroupSymbol: Optional[str] = None
    """
    point group symbol in Schoenflies notation
    """
    spaceGroupSymbol: Optional[str] = None
    """
    space group symbol in Hermann–Mauguin notation
    """
    tolerance: Optional[ScalarSchema79] = Field(None, title="scalar schema")
    """
    tolerance used for symmetry calculation
    """
    name: Literal["2#-datamodel-code-generator-#-object-#-special-#"]


class Name673(Enum):
    elemental_ratio = "elemental_ratio"


class ElementalRatio78(BaseModel):
    name: Literal["3#-datamodel-code-generator-#-object-#-special-#"]
    value: confloat(ge=0.0, le=1.0)
    element: Optional[str] = None
    """
    the element this ratio is for
    """


class Name674(Enum):
    p_norm = "p-norm"


class PNorm78(BaseModel):
    name: Literal["4#-datamodel-code-generator-#-object-#-special-#"]
    degree: Optional[int] = None
    """
    degree of the dimensionality of the norm
    """
    value: float


class Name675(Enum):
    inchi = "inchi"


class InChIRepresentationSchema78(BaseModel):
    name: Literal["5#-datamodel-code-generator-#-object-#-special-#"]
    value: str


class Name676(Enum):
    inchi_key = "inchi_key"


class InChIKeyRepresentationSchema78(BaseModel):
    name: Literal["6#-datamodel-code-generator-#-object-#-special-#"]
    value: str


class DerivedPropertiesSchema78(
    RootModel[
        Union[
            VolumeSchema77,
            DensitySchema78,
            SymmetrySchema77,
            ElementalRatio78,
            PNorm78,
            InChIRepresentationSchema78,
            InChIKeyRepresentationSchema78,
        ]
    ]
):
    root: Union[
        VolumeSchema77,
        DensitySchema78,
        SymmetrySchema77,
        ElementalRatio78,
        PNorm78,
        InChIRepresentationSchema78,
        InChIKeyRepresentationSchema78,
    ] = Field(..., discriminator="name")


class Name677(Enum):
    default = "default"
    atomsTooClose = "atomsTooClose"
    atomsOverlap = "atomsOverlap"


class MaterialConsistencyCheckSchema77(BaseModel):
    name: Name677
    """
    Name of the consistency check that is performed, which is listed in an enum.
    """
    key: str
    """
    Key of the property of the entity on which the consistency check is performed in Mongo dot notation, e.g. 'basis.coordinates.1'
    """
    severity: Severity
    """
    Severity level of the problem, which is used in UI to differentiate.
    """
    message: str
    """
    Message generated by the consistency check describing the problem.
    """


class CrystalSchema72(BaseModel):
    formula: Optional[str] = None
    """
    reduced chemical formula
    """
    unitCellFormula: Optional[str] = None
    """
    chemical formula based on the number of atoms of each element in the supercell
    """
    basis: BasisSchema77 = Field(..., title="basis schema")
    lattice: LatticeSchema77 = Field(..., title="lattice schema")
    derivedProperties: Optional[List[DerivedPropertiesSchema78]] = Field(None, title="derived properties schema")
    external: Optional[DatabaseSourceSchema] = Field(None, title="database source schema")
    """
    information about a database source
    """
    src: Optional[FileSourceSchema] = Field(None, title="file source schema")
    """
    file source with the information inside
    """
    scaledHash: Optional[str] = None
    """
    Hash string for a scaled structure with lattice vector a set to 1 (eg. for materials under pressure).
    """
    icsdId: Optional[int] = None
    """
    Corresponding ICSD id of the material
    """
    isNonPeriodic: Optional[bool] = None
    """
    Whether to work in the finite molecular picture (usually with atomic orbital basis)
    """
    consistencyChecks: Optional[List[MaterialConsistencyCheckSchema77]] = None
    field_id: Optional[str] = Field(None, alias="_id")
    """
    entity identity
    """
    slug: Optional[str] = None
    """
    entity slug
    """
    systemName: Optional[str] = None
    schemaVersion: Optional[str] = "2022.8.16"
    """
    entity's schema version. Used to distinct between different schemas.
    """
    name: Optional[str] = None
    """
    entity name
    """
    isDefault: Optional[bool] = False
    """
    Identifies that entity is defaultable
    """
    metadata: Optional[Dict[str, Any]] = None


class ChemicalElement(Enum):
    H = "H"
    He = "He"
    Li = "Li"
    Be = "Be"
    B = "B"
    C = "C"
    N = "N"
    O = "O"
    F = "F"
    Ne = "Ne"
    Na = "Na"
    Mg = "Mg"
    Al = "Al"
    Si = "Si"
    P = "P"
    S = "S"
    Cl = "Cl"
    Ar = "Ar"
    K = "K"
    Ca = "Ca"
    Sc = "Sc"
    Ti = "Ti"
    V = "V"
    Cr = "Cr"
    Mn = "Mn"
    Fe = "Fe"
    Co = "Co"
    Ni = "Ni"
    Cu = "Cu"
    Zn = "Zn"
    Ga = "Ga"
    Ge = "Ge"
    As = "As"
    Se = "Se"
    Br = "Br"
    Kr = "Kr"
    Rb = "Rb"
    Sr = "Sr"
    Y = "Y"
    Zr = "Zr"
    Nb = "Nb"
    Mo = "Mo"
    Tc = "Tc"
    Ru = "Ru"
    Rh = "Rh"
    Pd = "Pd"
    Ag = "Ag"
    Cd = "Cd"
    In = "In"
    Sn = "Sn"
    Sb = "Sb"
    Te = "Te"
    I = "I"
    Xe = "Xe"
    Cs = "Cs"
    Ba = "Ba"
    La = "La"
    Ce = "Ce"
    Pr = "Pr"
    Nd = "Nd"
    Pm = "Pm"
    Sm = "Sm"
    Eu = "Eu"
    Gd = "Gd"
    Tb = "Tb"
    Dy = "Dy"
    Ho = "Ho"
    Er = "Er"
    Tm = "Tm"
    Yb = "Yb"
    Lu = "Lu"
    Hf = "Hf"
    Ta = "Ta"
    W = "W"
    Re = "Re"
    Os = "Os"
    Ir = "Ir"
    Pt = "Pt"
    Au = "Au"
    Hg = "Hg"
    Tl = "Tl"
    Pb = "Pb"
    Bi = "Bi"
    Po = "Po"
    At = "At"
    Rn = "Rn"
    Fr = "Fr"
    Ra = "Ra"
    Ac = "Ac"
    Th = "Th"
    Pa = "Pa"
    U = "U"
    Np = "Np"
    Pu = "Pu"
    Am = "Am"
    Cm = "Cm"
    Bk = "Bk"
    Cf = "Cf"
    Es = "Es"
    Fm = "Fm"
    Md = "Md"
    No = "No"
    Lr = "Lr"
    Rf = "Rf"
    Db = "Db"
    Sg = "Sg"
    Bh = "Bh"
    Hs = "Hs"
    Mt = "Mt"
    Ds = "Ds"
    Rg = "Rg"
    Cn = "Cn"
    Nh = "Nh"
    Fl = "Fl"
    Mc = "Mc"
    Lv = "Lv"
    Ts = "Ts"
    Og = "Og"


class AtomSchema(BaseModel):
    chemical_element: ChemicalElement


class ChemicalElement11(Enum):
    X = "X"
    Vac = "Vac"


class VacancySchema(BaseModel):
    chemical_element: Optional[ChemicalElement11] = "Vac"
    """
    Extra elements, used for convenience purposed
    """


class PointDefectSiteSchema(BaseModel):
    crystal: CrystalSchema72 = Field(..., title="Crystal Schema")
    """
    A crystal structure, referencing the base material schema
    """
    coordinate: List[float] = Field(..., max_length=3, min_length=3, title="coordinate 3d schema")
    element: Union[AtomSchema, VacancySchema]


class MergeMethodsEnum(Enum):
    ADD = "ADD"
    REPLACE = "REPLACE"
    YIELD = "YIELD"


class SubstitutionalPointDefectSchema(BaseModel):
    merge_components: List[Union[CrystalSchema, PointDefectSiteSchema]] = Field(..., max_length=2, min_length=2)
    merge_method: Optional[MergeMethodsEnum] = Field("REPLACE", title="Merge Methods Enum")
    """
    Available methods for merging components
    """
