# generated by datamodel-codegen:
#   filename:  methods_directory/physical/ao/dunning.json
#   version:   0.28.5

from __future__ import annotations

from enum import Enum
from typing import Any, Dict, List, Optional, Union

from pydantic import BaseModel, Field


class SlugifiedEntry(BaseModel):
    name: str
    """
    descriptive human-readable name of entry
    """
    slug: str
    """
    machine-readable identifier
    """


class SlugifiedEntryOrSlug(Enum):
    dunning = "dunning"


class SlugifiedEntryOrSlug64(Enum):
    ao = "ao"


class SlugifiedEntryOrSlug65(Enum):
    wf = "wf"


class SlugifiedEntryOrSlug66(Enum):
    qm = "qm"


class DunningCorrelationConsistentBasisSetCategorySchema(BaseModel):
    subtype: Optional[Union[SlugifiedEntry, SlugifiedEntryOrSlug]] = Field(None, title="slugified entry or slug")
    """
    contains either object with slugified entry or slug only as a string
    """
    type: Optional[Union[SlugifiedEntry, SlugifiedEntryOrSlug64]] = Field(None, title="slugified entry or slug")
    """
    contains either object with slugified entry or slug only as a string
    """
    tier2: Optional[Union[SlugifiedEntry, SlugifiedEntryOrSlug65]] = Field(None, title="slugified entry or slug")
    """
    contains either object with slugified entry or slug only as a string
    """
    tier1: Optional[Union[SlugifiedEntry, SlugifiedEntryOrSlug66]] = Field(None, title="slugified entry or slug")
    """
    contains either object with slugified entry or slug only as a string
    """
    tier3: Optional[Union[SlugifiedEntry, str]] = Field(None, title="slugified entry or slug")
    """
    contains either object with slugified entry or slug only as a string
    """


class BasisSlug(Enum):
    cc_pvdz = "cc-pvdz"
    cc_pvtz = "cc-pvtz"
    cc_pvqz = "cc-pvqz"


class Parameters(BaseModel):
    basisSlug: Optional[BasisSlug] = None


class UnitMethodAoDunning(BaseModel):
    categories: DunningCorrelationConsistentBasisSetCategorySchema = Field(
        ..., title="Dunning correlation-consistent basis set category schema"
    )
    """
    Used to categorize entities such as models and methods
    """
    parameters: Optional[Parameters] = None
    """
    Instructive parameters defining the method
    """
    precision: Optional[Dict[str, Any]] = None
    """
    Object showing the actual possible precision based on theory and implementation
    """
    name: Optional[str] = None
    """
    entity name
    """
    path: Optional[str] = Field(None, title="category path schema")
    """
    TODO: Use regex once schema draft version has been updated
    """
    tags: Optional[List[str]] = None
    """
    entity tags
    """


class AoBasisDunning(BaseModel):
    basisSlug: Optional[BasisSlug] = None
