# generated by datamodel-codegen:
#   filename:  methods_directory/physical/psp/file_data_item.json
#   version:   0.28.5

from __future__ import annotations

from enum import Enum
from typing import List, Optional

from pydantic import BaseModel, ConfigDict, Field, confloat, conint, constr

from .Reusable_schema_for_energy_value_with_unit_corresponding_to_a_specific_accuracy_level__e import (
    g,
)


class Type(Enum):
    us = "us"
    nc = "nc"
    nc_fr = "nc-fr"
    paw = "paw"
    coulomb = "coulomb"


class ExchangeCorrelation(BaseModel):
    approximation: Optional[str] = None
    """
    DFT approximation
    """
    functional: Optional[str] = None
    """
    Exchange correlation functional
    """
    path: Optional[str] = Field(None, title="category path schema")
    """
    TODO: Use regex once schema draft version has been updated
    """


class AtomicOrbitalSchema(BaseModel):
    orbitalName: Optional[constr(pattern=r"^[1-7][sSpPdDfF]$")] = None
    orbitalIndex: Optional[conint(ge=1)] = None
    principalNumber: Optional[conint(ge=1, le=7)] = None
    angularMomentum: Optional[conint(ge=0, le=3)] = None
    occupation: Optional[confloat(ge=0.0, le=14.0)] = None
    """
    Shell occupation
    """


class Name(Enum):
    pseudopotential = "pseudopotential"


class Cutoffs(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    wavefunction: Optional[List[g.FieldUsedForSuggestedWavefunctionAndChargeDensityCutoffs]] = None
    """
    Energy cutoff values for wavefunction plane wave expansion.
    """
    density: Optional[List[g.FieldUsedForSuggestedWavefunctionAndChargeDensityCutoffs]] = None
    """
    Energy cutoff values for charge density plane wave expansion.
    """


class FileDataItem(BaseModel):
    element: str
    """
    chemical element
    """
    hash: Optional[str] = None
    """
    MD5 hash of the pseudopotential file
    """
    type: Type
    source: str
    """
    explains where this came from
    """
    version: Optional[str] = None
    """
    explains the version of where this came from
    """
    exchangeCorrelation: ExchangeCorrelation
    valenceConfiguration: Optional[List[AtomicOrbitalSchema]] = None
    """
    contains pseudo orbital information, including orbital names and occupations
    """
    path: str
    """
    location of the pseudopotential file on filesystem
    """
    apps: List[str]
    """
    The names of the simulation engines that can use this pseudopotential, e.g. espresso
    """
    filename: Optional[str] = None
    """
    filename of pseudopotential file on filesystem
    """
    name: Optional[Name] = None
    """
    name of the data category
    """
    cutoffs: Optional[Cutoffs] = None
    """
    Suggested cutoff values for wave function and charge density.
    """
