# generated by datamodel-codegen:
#   filename:  model.json
#   version:   0.28.5

from __future__ import annotations

from typing import Any, Dict, Optional

from pydantic import BaseModel, ConfigDict, Field


class BaseMethod(BaseModel):
    type: str
    """
    general type of this method, eg. `pseudopotential`
    """
    subtype: str
    """
    general subtype of this method, eg. `ultra-soft`
    """
    precision: Optional[Dict[str, Any]] = None
    """
    Object showing the actual possible precision based on theory and implementation
    """
    data: Optional[Dict[str, Any]] = None
    """
    additional data specific to method, eg. array of pseudopotentials
    """


class BaseModel1(BaseModel):
    model_config = ConfigDict(
        extra="allow",
    )
    type: str
    """
    general type of the model, eg. `dft`
    """
    subtype: str
    """
    general subtype of the model, eg. `lda`
    """
    method: BaseMethod = Field(..., title="base method")
