# generated by datamodel-codegen:
#   filename:  models_directory/gw.json
#   version:   0.28.5

from __future__ import annotations

from enum import Enum
from typing import Any, Dict, List, Optional, Union

from pydantic import BaseModel, ConfigDict, Field


class SlugifiedEntry(BaseModel):
    name: str
    """
    descriptive human-readable name of entry
    """
    slug: str
    """
    machine-readable identifier
    """


class SlugifiedEntryOrSlug(Enum):
    gw = "gw"


class SlugifiedEntryOrSlug96(Enum):
    g0w0 = "g0w0"
    evgw0 = "evgw0"
    evgw = "evgw"


class SlugifiedEntryOrSlug97(Enum):
    abin = "abin"


class SlugifiedEntryOrSlug98(Enum):
    qm = "qm"


class SlugifiedEntryOrSlug99(Enum):
    pb = "pb"


class GWCategorySchema(BaseModel):
    type: Optional[Union[SlugifiedEntry, SlugifiedEntryOrSlug]] = Field(None, title="slugified entry or slug")
    """
    contains either object with slugified entry or slug only as a string
    """
    subtype: Optional[Union[SlugifiedEntry, SlugifiedEntryOrSlug96]] = Field(None, title="slugified entry or slug")
    """
    contains either object with slugified entry or slug only as a string
    """
    tier3: Optional[Union[SlugifiedEntry, SlugifiedEntryOrSlug97]] = Field(None, title="slugified entry or slug")
    """
    contains either object with slugified entry or slug only as a string
    """
    tier2: Optional[Union[SlugifiedEntry, SlugifiedEntryOrSlug98]] = Field(None, title="slugified entry or slug")
    """
    contains either object with slugified entry or slug only as a string
    """
    tier1: Optional[Union[SlugifiedEntry, SlugifiedEntryOrSlug99]] = Field(None, title="slugified entry or slug")
    """
    contains either object with slugified entry or slug only as a string
    """


class SpinPolarization(Enum):
    collinear = "collinear"
    non_collinear = "non-collinear"


class Functional(Enum):
    pz = "pz"


class LDAFunctionalMixin(BaseModel):
    model_config = ConfigDict(
        extra="allow",
    )
    require: Optional[str] = Field(None, title="category path schema")
    """
    TODO: Use regex once schema draft version has been updated
    """
    spinPolarization: Optional[SpinPolarization] = None
    functional: Optional[Functional] = None


class Functional16(Enum):
    pbe = "pbe"
    pbesol = "pbesol"


class GGAFunctionalMixin(BaseModel):
    model_config = ConfigDict(
        extra="allow",
    )
    require: Optional[str] = Field(None, title="category path schema")
    """
    TODO: Use regex once schema draft version has been updated
    """
    spinPolarization: Optional[SpinPolarization] = None
    functional: Optional[Functional16] = None


class Functional17(Enum):
    scan = "scan"


class MetaGGAFunctionalMixin(BaseModel):
    model_config = ConfigDict(
        extra="allow",
    )
    require: Optional[str] = Field(None, title="category path schema")
    """
    TODO: Use regex once schema draft version has been updated
    """
    spinPolarization: Optional[SpinPolarization] = None
    functional: Optional[Functional17] = None


class Functional18(Enum):
    pz = "pz"


class LDAFunctionalMixin1(BaseModel):
    model_config = ConfigDict(
        extra="allow",
    )
    require: Optional[str] = Field(None, title="category path schema")
    """
    TODO: Use regex once schema draft version has been updated
    """
    spinOrbitCoupling: Optional[bool] = None
    functional: Optional[Functional18] = None


class Functional19(Enum):
    pbe = "pbe"
    pbesol = "pbesol"


class GGAFunctionalMixin2(BaseModel):
    model_config = ConfigDict(
        extra="allow",
    )
    require: Optional[str] = Field(None, title="category path schema")
    """
    TODO: Use regex once schema draft version has been updated
    """
    spinOrbitCoupling: Optional[bool] = None
    functional: Optional[Functional19] = None


class Functional20(Enum):
    scan = "scan"


class MetaGGAFunctionalMixin1(BaseModel):
    model_config = ConfigDict(
        extra="allow",
    )
    require: Optional[str] = Field(None, title="category path schema")
    """
    TODO: Use regex once schema draft version has been updated
    """
    spinOrbitCoupling: Optional[bool] = None
    functional: Optional[Functional20] = None


class Type(Enum):
    literature = "literature"


class PagesSchema(BaseModel):
    start: str
    end: Optional[str] = None


class ExperimentAuthorSchema(BaseModel):
    first: str
    middle: Optional[str] = None
    last: str
    affiliation: Optional[str] = None


class LiteratureReferenceSchema(BaseModel):
    type: Optional[Type] = None
    doi: Optional[str] = None
    """
    Digital Object Identifier of the reference.
    """
    isbn: Optional[str] = None
    """
    International Standard Book Number of the reference.
    """
    issn: Optional[str] = None
    """
    International Standard Serial Number of the reference.
    """
    url: Optional[str] = None
    """
    Internet address of the reference.
    """
    title: Optional[str] = None
    """
    Title of the work.
    """
    publisher: Optional[str] = None
    """
    Publisher of the work.
    """
    journal: Optional[str] = None
    """
    Journal in which the work appeared.
    """
    volume: Optional[str] = None
    """
    Volume of the series in which the work appeared.
    """
    year: Optional[str] = None
    """
    Year in which the reference was published.
    """
    issue: Optional[str] = None
    """
    Issue of the collection in which the work appeared.
    """
    pages: Optional[PagesSchema] = Field(None, title="pages schema")
    """
    Start and end pages of the work.
    """
    authors: Optional[List[ExperimentAuthorSchema]] = None
    """
    List of authors of the work.
    """
    editors: Optional[List[ExperimentAuthorSchema]] = None
    """
    List of editors of the work.
    """
    reference: Optional[List[Dict[str, Any]]] = None
    """
    References cited by the work. Reference objects can nest as deeply as needed. This is useful, for example, when tracking the history of a value referenced in a scholarly article; the top level reference would contain information about where the data was accessed while the nested reference would contain information about where it was originally published.
    """


class ModelGwApproximation(BaseModel):
    categories: GWCategorySchema = Field(..., title="GW category schema")
    """
    Used to categorize entities such as models and methods
    """
    parameters: Union[
        Union[LDAFunctionalMixin, GGAFunctionalMixin, MetaGGAFunctionalMixin],
        Union[LDAFunctionalMixin1, GGAFunctionalMixin2, MetaGGAFunctionalMixin1],
    ]
    """
    Model parameters defined in-place or via model mixins
    """
    reference: Optional[LiteratureReferenceSchema] = Field(None, title="literature reference schema")
    name: Optional[str] = None
    """
    entity name
    """
    path: Optional[str] = Field(None, title="category path schema")
    """
    TODO: Use regex once schema draft version has been updated
    """
    tags: Optional[List[str]] = None
    """
    entity tags
    """
