# generated by datamodel-codegen:
#   filename:  properties_directory/non_scalar/average_potential_profile.json
#   version:   0.28.5

from __future__ import annotations

from enum import Enum
from typing import List, Optional, Union

from pydantic import BaseModel, Field


class Label(Enum):
    z_coordinate = "z coordinate"


class Units(Enum):
    km = "km"
    m = "m"
    cm = "cm"
    mm = "mm"
    um = "um"
    nm = "nm"
    angstrom = "angstrom"
    a_u_ = "a.u."
    bohr = "bohr"
    pm = "pm"


class AxisSchema(BaseModel):
    label: Label
    """
    label of an axis object
    """
    units: Optional[Units] = None
    """
    units for an axis
    """


class Label1(Enum):
    energy = "energy"


class Units12(Enum):
    kJ_mol = "kJ/mol"
    eV = "eV"
    J_mol = "J/mol"
    hartree = "hartree"
    cm_1 = "cm-1"
    Ry = "Ry"
    eV_atom = "eV/atom"


class AxisSchema3(BaseModel):
    label: Label1
    """
    label of an axis object
    """
    units: Optional[Units12] = None
    """
    units for an axis
    """


class Name(Enum):
    average_potential_profile = "average_potential_profile"


class AveragePotentialProfileSchema(BaseModel):
    xAxis: AxisSchema = Field(..., title="axis schema")
    yAxis: AxisSchema3 = Field(..., title="axis schema")
    name: Optional[Name] = None
    legend: Optional[List] = Field(None, min_length=1)
    """
    Legend of y Axis data series
    """
    xDataArray: List
    """
    array containing values of x Axis
    """
    yDataSeries: List[List[Union[float, str]]] = Field(..., title="1 dimension data series schema")
