# generated by datamodel-codegen:
#   filename:  properties_directory/non_scalar/band_gaps.json
#   version:   0.28.5

from __future__ import annotations

from enum import Enum
from typing import List, Optional

from pydantic import BaseModel, Field


class Name(Enum):
    band_gaps = "band_gaps"


class Type(Enum):
    direct = "direct"
    indirect = "indirect"


class Units(Enum):
    kJ_mol = "kJ/mol"
    eV = "eV"
    J_mol = "J/mol"
    hartree = "hartree"
    cm_1 = "cm-1"
    Ry = "Ry"
    eV_atom = "eV/atom"


class BandGapSchema(BaseModel):
    kpointConduction: Optional[List[float]] = Field(None, max_length=3, min_length=3, title="kpoint schema")
    """
    A k-point is a point in reciprocal space of a crystal.
    """
    kpointValence: Optional[List[float]] = Field(None, max_length=3, min_length=3, title="kpoint schema")
    """
    A k-point is a point in reciprocal space of a crystal.
    """
    eigenvalueConduction: Optional[float] = None
    """
    eigenvalue at k-point in conduction band
    """
    eigenvalueValence: Optional[float] = None
    """
    eigenvalue at k-point in valence band
    """
    spin: Optional[float] = None
    type: Type
    units: Optional[Units] = None
    value: float


class Eigenvalue1(BaseModel):
    spin: Optional[float] = None
    energies: Optional[List] = None
    occupations: Optional[List] = None


class Eigenvalue(BaseModel):
    kpoint: Optional[List[float]] = Field(None, max_length=3, min_length=3, title="kpoint schema")
    """
    A k-point is a point in reciprocal space of a crystal.
    """
    weight: Optional[float] = None
    eigenvalues: Optional[List[Eigenvalue1]] = None


class BandGapsSchema(BaseModel):
    name: Name
    values: Optional[List[BandGapSchema]] = None
    eigenvalues: Optional[List[Eigenvalue]] = None
