# generated by datamodel-codegen:
#   filename:  properties_directory/non_scalar/file_content.json
#   version:   0.28.5

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import BaseModel, Field


class Name(Enum):
    file_content = "file_content"


class Filetype(Enum):
    image = "image"
    text = "text"
    csv = "csv"


class ObjectStorageContainerData(BaseModel):
    CONTAINER: Optional[str] = None
    """
    Object storage container for the file
    """
    NAME: Optional[str] = None
    """
    Name of the file inside the object storage bucket
    """
    PROVIDER: Optional[str] = None
    """
    Object storage provider
    """
    REGION: Optional[str] = None
    """
    Region for the object container specified in Container
    """
    SIZE: Optional[int] = None
    """
    Size of the file in bytes
    """
    TIMESTAMP: Optional[str] = None
    """
    Unix timestamp showing when the file was last modified
    """


class FileContent(BaseModel):
    name: Name
    filetype: Optional[Filetype] = None
    """
    What kind of file this is, e.g. image / text
    """
    objectData: ObjectStorageContainerData = Field(..., title="Object Storage Container Data")
    pathname: Optional[str] = None
    """
    Relative path to the directory that contains the file.
    """
    basename: Optional[str] = None
    """
    Basename of the file
    """
