# generated by datamodel-codegen:
#   filename:  properties_directory/non_scalar/hubbard_u.json
#   version:   0.28.5

from __future__ import annotations

from enum import Enum
from typing import List, Optional

from pydantic import BaseModel, constr


class Name(Enum):
    hubbard_u = "hubbard_u"


class Units(Enum):
    eV = "eV"


class AtomicDataPerOrbitalNumeric(BaseModel):
    id: int
    """
    Site number or index in the lattice
    """
    atomicSpecies: constr(pattern=r"^[a-zA-Z]{1,2}[\d+]?$")
    """
    Example: Co1, Mn
    """
    orbitalName: constr(pattern=r"^[1-7][sSpPdDfF]$")
    value: float
    """
    Value related to a specific property, e.g., Hubbard U, V etc.
    """


class HubbardUParameters(BaseModel):
    name: Name
    units: Optional[Units] = None
    values: Optional[List[AtomicDataPerOrbitalNumeric]] = None
