# generated by datamodel-codegen:
#   filename:  properties_directory/non_scalar/hubbard_v.json
#   version:   0.28.5

from __future__ import annotations

from enum import Enum
from typing import List, Optional

from pydantic import BaseModel, constr


class Name(Enum):
    hubbard_v = "hubbard_v"
    hubbard_v_nn = "hubbard_v_nn"


class Units(Enum):
    eV = "eV"


class AtomicDataPerOrbitalPairNumeric(BaseModel):
    id: int
    """
    Site number or index in the lattice
    """
    id2: int
    """
    Site number or index in the lattice of second site
    """
    atomicSpecies: constr(pattern=r"^[a-zA-Z]{1,2}[\d+]?$")
    """
    Example: Co1, Mn
    """
    atomicSpecies2: constr(pattern=r"^[a-zA-Z]{1,2}[\d+]?$")
    """
    Example: Co2, O
    """
    orbitalName: Optional[constr(pattern=r"^[1-7][sSpPdDfF]$")] = None
    orbitalName2: Optional[constr(pattern=r"^[1-7][sSpPdDfF]$")] = None
    distance: Optional[float] = None
    """
    Distance between two sites in Bohr.
    """
    value: float
    """
    Value related to a specific property, e.g., Hubbard U, V etc.
    """


class HubbardVParameters(BaseModel):
    name: Name
    units: Optional[Units] = None
    values: Optional[List[AtomicDataPerOrbitalPairNumeric]] = None
