# generated by datamodel-codegen:
#   filename:  properties_directory/non_scalar/potential_profile.json
#   version:   0.28.5

from __future__ import annotations

from enum import Enum
from typing import List, Optional, Union

from pydantic import BaseModel, Field


class Label(Enum):
    z_coordinate = "z coordinate"


class AxisSchema(BaseModel):
    label: Label
    """
    label of an axis object
    """
    units: Optional[str] = None
    """
    units for an axis
    """


class Label13(Enum):
    energy = "energy"


class Units(Enum):
    kJ_mol = "kJ/mol"
    eV = "eV"
    J_mol = "J/mol"
    hartree = "hartree"
    cm_1 = "cm-1"
    Ry = "Ry"
    eV_atom = "eV/atom"


class AxisSchema16(BaseModel):
    label: Label13
    """
    label of an axis object
    """
    units: Optional[Units] = None
    """
    units for an axis
    """


class Name(Enum):
    potential_profile = "potential_profile"


class PotentialProfileSchema(BaseModel):
    xAxis: AxisSchema = Field(..., title="axis schema")
    yAxis: AxisSchema16 = Field(..., title="axis schema")
    name: Optional[Name] = None
    legend: Optional[List] = Field(None, min_length=1)
    """
    Legend of y Axis data series
    """
    xDataArray: List
    """
    array containing values of x Axis
    """
    yDataSeries: List[List[Union[float, str]]] = Field(..., title="1 dimension data series schema")
