# generated by datamodel-codegen:
#   filename:  properties_directory/non_scalar/vibrational_spectrum.json
#   version:   0.28.5

from __future__ import annotations

from enum import Enum
from typing import List, Optional, Union

from pydantic import BaseModel, Field


class Label(Enum):
    frequency = "frequency"
    wavenumber = "wavenumber"


class Units(Enum):
    cm_1 = "cm-1"
    THz = "THz"
    meV = "meV"


class AxisSchema(BaseModel):
    label: Label
    """
    label of an axis object
    """
    units: Optional[Units] = None
    """
    units for an axis
    """


class Label17(Enum):
    Intensity = "Intensity"
    Absorbance = "Absorbance"
    Absorption_coefficient = "Absorption coefficient"


class Units295(Enum):
    field_debye_angstrom__2 = "(debye/angstrom)^2"
    km_mol = "km/mol"
    m_mol = "m/mol"
    a_u_ = "a.u."


class AxisSchema20(BaseModel):
    label: Label17
    """
    label of an axis object
    """
    units: Optional[Units295] = None
    """
    units for an axis
    """


class Name(Enum):
    vibrational_spectrum = "vibrational_spectrum"


class VibrationalSpectrumSchema(BaseModel):
    xAxis: AxisSchema = Field(..., title="axis schema")
    yAxis: AxisSchema20 = Field(..., title="axis schema")
    name: Optional[Name] = None
    legend: Optional[List] = Field(None, min_length=1)
    """
    Legend of y Axis data series
    """
    xDataArray: List
    """
    array containing values of x Axis
    """
    yDataSeries: List[List[Union[float, str]]] = Field(..., title="1 dimension data series schema")
