# generated by datamodel-codegen:
#   filename:  properties_directory/structural/basis/bonds.json
#   version:   0.28.5

from __future__ import annotations

from enum import Enum
from typing import List, Optional

from pydantic import BaseModel, Field, RootModel


class ObjectWithId(BaseModel):
    id: int
    """
    integer id of this entry
    """


class BondType(Enum):
    single = "single"
    double = "double"
    triple = "triple"
    quadruple = "quadruple"
    aromatic = "aromatic"
    tautomeric = "tautomeric"
    dative = "dative"
    other = "other"


class BondsSchemaItem(BaseModel):
    atomPair: Optional[List[ObjectWithId]] = Field(None, max_length=2, min_length=2, title="array of ids")
    """
    indices of the two connected atoms
    """
    bondType: Optional[BondType] = None


class BondsSchema(RootModel[List[BondsSchemaItem]]):
    root: List[BondsSchemaItem] = Field(..., title="bonds schema")
