# generated by datamodel-codegen:
#   filename:  properties_directory/structural/lattice.json
#   version:   0.28.5

from __future__ import annotations

from enum import Enum
from typing import List, Optional

from pydantic import BaseModel, Field


class LatticeVectorsUnitsEnum(Enum):
    angstrom = "angstrom"
    bohr = "bohr"


class LatticeVectorsSchema(BaseModel):
    a: List[float] = Field(..., max_length=3, min_length=3, title="vector 3d schema")
    b: List[float] = Field(..., max_length=3, min_length=3, title="vector 3d schema")
    c: List[float] = Field(..., max_length=3, min_length=3, title="vector 3d schema")
    alat: Optional[float] = 1
    """
    lattice parameter for fractional coordinates
    """
    units: Optional[LatticeVectorsUnitsEnum] = Field("angstrom", title="lattice vectors units enum")


class LatticeTypeEnum(Enum):
    CUB = "CUB"
    BCC = "BCC"
    FCC = "FCC"
    TET = "TET"
    MCL = "MCL"
    ORC = "ORC"
    ORCC = "ORCC"
    ORCF = "ORCF"
    ORCI = "ORCI"
    HEX = "HEX"
    BCT = "BCT"
    TRI = "TRI"
    MCLC = "MCLC"
    RHL = "RHL"


class LatticeUnitsLengthEnum(Enum):
    angstrom = "angstrom"
    bohr = "bohr"


class LatticeUnitsAngleEnum(Enum):
    degree = "degree"
    radian = "radian"


class LatticeUnitsSchema(BaseModel):
    length: Optional[LatticeUnitsLengthEnum] = Field("angstrom", title="lattice units length enum")
    angle: Optional[LatticeUnitsAngleEnum] = Field("degree", title="lattice units angle enum")


class LatticeSchema(BaseModel):
    a: float
    """
    length of the first lattice vector
    """
    b: float
    """
    length of the second lattice vector
    """
    c: float
    """
    length of the third lattice vector
    """
    alpha: float
    """
    angle between first and second lattice vector
    """
    beta: float
    """
    angle between second and third lattice vector
    """
    gamma: float
    """
    angle between first and third lattice vector
    """
    vectors: Optional[LatticeVectorsSchema] = Field(None, title="lattice vectors schema")
    type: Optional[LatticeTypeEnum] = Field("TRI", title="lattice type enum")
    units: Optional[LatticeUnitsSchema] = Field(
        default_factory=lambda: LatticeUnitsSchema.model_validate({"length": "angstrom", "angle": "degree"}),
        title="Lattice units schema",
    )
