# generated by datamodel-codegen:
#   filename:  properties_directory/structural/molecular_pattern.json
#   version:   0.28.5

from __future__ import annotations

from enum import Enum
from typing import List, Optional, Union

from pydantic import BaseModel, Field, RootModel


class Name(Enum):
    functional_group = "functional_group"


class ObjectWithId(BaseModel):
    isConnector: Optional[bool] = None
    """
    whether atom connects to atoms outside of functional group.
    """
    id: int
    """
    integer id of this entry
    """


class FunctionalGroupPatternSchema(BaseModel):
    name: Optional[Name] = None
    atoms: Optional[List[ObjectWithId]] = Field(None, title="array of ids")
    """
    array of objects containing integer id each
    """
    SMARTS: Optional[str] = None
    """
    SMARTS string for classification of FG; https://en.wikipedia.org/wiki/SMILES_arbitrary_target_specification
    """


class Name518(Enum):
    ring = "ring"


class RingPatternSchema(BaseModel):
    name: Optional[Name518] = None
    atoms: Optional[List[ObjectWithId]] = Field(None, title="array of ids")
    """
    array of objects containing integer id each
    """
    isAromatic: Optional[bool] = None


class Name519(Enum):
    special_bond = "special_bond"


class SpecialBondPatternSchema(BaseModel):
    name: Optional[Name519] = None
    atoms: Optional[List[ObjectWithId]] = Field(None, title="array of ids")
    """
    array of objects containing integer id each
    """


class MolecularPatternSchema(
    RootModel[List[Union[FunctionalGroupPatternSchema, RingPatternSchema, SpecialBondPatternSchema]]]
):
    root: List[Union[FunctionalGroupPatternSchema, RingPatternSchema, SpecialBondPatternSchema]] = Field(
        ..., title="molecular pattern schema"
    )
