# generated by datamodel-codegen:
#   filename:  software/executable.json
#   version:   0.28.5

from __future__ import annotations

from typing import List, Optional, Union

from pydantic import BaseModel, Field


class NameResultSchema(BaseModel):
    name: str
    """
    The name of this item. e.g. scf_accuracy
    """


class ExecutableSchema(BaseModel):
    name: str
    """
    The name of the executable. e.g. pw.x
    """
    applicationId: Optional[List[str]] = None
    """
    _ids of the application this executable belongs to
    """
    hasAdvancedComputeOptions: Optional[bool] = None
    """
    Whether advanced compute options are present
    """
    field_id: Optional[str] = Field(None, alias="_id")
    """
    entity identity
    """
    slug: Optional[str] = None
    """
    entity slug
    """
    systemName: Optional[str] = None
    schemaVersion: Optional[str] = "2022.8.16"
    """
    entity's schema version. Used to distinct between different schemas.
    """
    isDefault: Optional[bool] = False
    """
    Identifies that entity is defaultable
    """
    preProcessors: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the pre-processors for this calculation
    """
    postProcessors: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the post-processors for this calculation
    """
    monitors: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the monitors for this calculation
    """
    results: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the results for this calculation
    """
