# generated by datamodel-codegen:
#   filename:  software_directory/ml/unit/processing.json
#   version:   0.28.5

from __future__ import annotations

from enum import Enum
from typing import Any, Dict, List, Optional, Union

from pydantic import BaseModel, ConfigDict, Field, RootModel


class Operation(Enum):
    data_transformation = "data_transformation"


class OperationType(Enum):
    scale_and_reduce = "scale_and_reduce"


class Scaler(Enum):
    standard_scaler = "standard_scaler"


class PerFeatureItem(BaseModel):
    variance: Optional[float] = None
    """
    variance in original training data
    """
    mean: Optional[float] = None
    """
    mean value of the original training data
    """
    scale: float
    """
    scale multiplier for this feature/property
    """
    name: str
    """
    feature/property name in 'flattened' format
    """


class InputData(BaseModel):
    scaler: Optional[Scaler] = "standard_scaler"
    """
    type of scaler to be applied
    """
    perFeature: Optional[List[PerFeatureItem]] = None
    """
    per-feature scaling data
    """


class Type(Enum):
    processing = "processing"


class Status(Enum):
    idle = "idle"
    active = "active"
    warning = "warning"
    error = "error"
    finished = "finished"


class NameResultSchema(BaseModel):
    name: str
    """
    The name of this item. e.g. scf_accuracy
    """


class StatusTrackItem(BaseModel):
    trackedAt: float
    status: str
    repetition: Optional[float] = None


class ScaleAndReduceUnitSchema(BaseModel):
    model_config = ConfigDict(
        extra="allow",
    )
    operation: Operation
    """
    Contains information about the operation used.
    """
    operationType: OperationType
    """
    Contains information about the specific type of the operation used.
    """
    inputData: InputData
    """
    unit input (type to be specified by the child units)
    """
    type: Type
    """
    type of the unit
    """
    field_id: Optional[str] = Field(None, alias="_id")
    """
    entity identity
    """
    isDraft: Optional[bool] = None
    name: Optional[str] = None
    """
    name of the unit. e.g. pw_scf
    """
    status: Optional[Status] = None
    """
    Status of the unit.
    """
    head: Optional[bool] = None
    """
    Whether this unit is the first one to be executed.
    """
    flowchartId: str
    """
    Identity of the unit in the workflow. Used to trace the execution flow of the workflow.
    """
    next: Optional[str] = None
    """
    Next unit's flowchartId. If empty, the current unit is the last.
    """
    enableRender: Optional[bool] = None
    """
    Whether Rupy should attempt to use Jinja templating to add context variables into the unit
    """
    context: Optional[Dict[str, Any]] = None
    slug: Optional[str] = None
    """
    entity slug
    """
    systemName: Optional[str] = None
    schemaVersion: Optional[str] = "2022.8.16"
    """
    entity's schema version. Used to distinct between different schemas.
    """
    isDefault: Optional[bool] = False
    """
    Identifies that entity is defaultable
    """
    preProcessors: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the pre-processors for this calculation
    """
    postProcessors: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the post-processors for this calculation
    """
    monitors: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the monitors for this calculation
    """
    results: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the results for this calculation
    """
    tags: Optional[List[str]] = None
    """
    entity tags
    """
    statusTrack: Optional[List[StatusTrackItem]] = None


class Operation5(Enum):
    feature_selection = "feature_selection"


class OperationType5(Enum):
    filter_based = "filter_based"


class Algorithm(Enum):
    f_regression = "f_regression"


class InputData5(BaseModel):
    nFeatures: float
    """
    number of features to select for model training. If equal to 0, will use all available features
    """
    algorithm: Algorithm
    """
    feature selection algorithm following sklearn.feature_selection
    """


class FilterBasedFeatureSelectionUnitSchema(BaseModel):
    model_config = ConfigDict(
        extra="allow",
    )
    operation: Operation5
    """
    Contains information about the operation used.
    """
    operationType: OperationType5
    """
    Contains information about the specific type of the operation used.
    """
    inputData: InputData5
    """
    unit input (type to be specified by the child units)
    """
    type: Type
    """
    type of the unit
    """
    field_id: Optional[str] = Field(None, alias="_id")
    """
    entity identity
    """
    isDraft: Optional[bool] = None
    name: Optional[str] = None
    """
    name of the unit. e.g. pw_scf
    """
    status: Optional[Status] = None
    """
    Status of the unit.
    """
    head: Optional[bool] = None
    """
    Whether this unit is the first one to be executed.
    """
    flowchartId: str
    """
    Identity of the unit in the workflow. Used to trace the execution flow of the workflow.
    """
    next: Optional[str] = None
    """
    Next unit's flowchartId. If empty, the current unit is the last.
    """
    enableRender: Optional[bool] = None
    """
    Whether Rupy should attempt to use Jinja templating to add context variables into the unit
    """
    context: Optional[Dict[str, Any]] = None
    slug: Optional[str] = None
    """
    entity slug
    """
    systemName: Optional[str] = None
    schemaVersion: Optional[str] = "2022.8.16"
    """
    entity's schema version. Used to distinct between different schemas.
    """
    isDefault: Optional[bool] = False
    """
    Identifies that entity is defaultable
    """
    preProcessors: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the pre-processors for this calculation
    """
    postProcessors: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the post-processors for this calculation
    """
    monitors: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the monitors for this calculation
    """
    results: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the results for this calculation
    """
    tags: Optional[List[str]] = None
    """
    entity tags
    """
    statusTrack: Optional[List[StatusTrackItem]] = None


class ESSE(RootModel[Union[ScaleAndReduceUnitSchema, FilterBasedFeatureSelectionUnitSchema]]):
    root: Union[ScaleAndReduceUnitSchema, FilterBasedFeatureSelectionUnitSchema]
