# generated by datamodel-codegen:
#   filename:  software_directory/scripting/python.json
#   version:   0.28.5

from __future__ import annotations

from enum import Enum
from typing import Any, Dict, List, Optional

from pydantic import BaseModel, ConfigDict, Field


class Name(Enum):
    python = "python"


class Flavor(Enum):
    python2 = "python2"
    python3 = "python3"


class Summary(Enum):
    Python_Script = "Python Script"


class Version(Enum):
    field_2_7_5 = "2.7.5"
    field_3_6_1 = "3.6.1"


class Exec(Enum):
    python = "python"


class PythonProgramingLanguageSchema(BaseModel):
    model_config = ConfigDict(
        extra="allow",
    )
    name: Optional[Name] = None
    """
    entity name
    """
    flavor: Optional[Flavor] = None
    summary: Optional[Summary] = None
    """
    Application's short description.
    """
    version: Optional[Version] = None
    """
    Application version. e.g. 5.3.5
    """
    exec: Optional[Exec] = None
    arguments: Optional[str] = None
    """
    Optional arguments passed to the Python script
    """
    environment: Optional[Dict[str, Any]] = None
    """
    Optional environment variables exported before running the Python script
    """
    dependencies: Optional[List] = None
    """
    Optional Python dependencies, e.g. amqp==1.4.6
    """
    shortName: Optional[str] = None
    """
    The short name of the application. e.g. qe
    """
    build: Optional[str] = None
    """
    Application build. e.g. VTST
    """
    hasAdvancedComputeOptions: Optional[bool] = None
    """
    Whether advanced compute options are present
    """
    isLicensed: Optional[bool] = None
    """
    Whether licensing is present
    """
    field_id: Optional[str] = Field(None, alias="_id")
    """
    entity identity
    """
    slug: Optional[str] = None
    """
    entity slug
    """
    systemName: Optional[str] = None
    schemaVersion: Optional[str] = "2022.8.16"
    """
    entity's schema version. Used to distinct between different schemas.
    """
    isDefault: Optional[bool] = False
    """
    Identifies that entity is defaultable
    """
