# generated by datamodel-codegen:
#   filename:  system/has_consistency_check.json
#   version:   0.28.5

from __future__ import annotations

from enum import Enum
from typing import List, Optional

from pydantic import BaseModel


class Severity(Enum):
    info = "info"
    warning = "warning"
    error = "error"


class ConsistencyCheck(BaseModel):
    key: str
    """
    Key of the property of the entity on which the consistency check is performed in Mongo dot notation, e.g. 'basis.coordinates.1'
    """
    name: str
    """
    Name of the consistency check that is performed, which is listed in an enum.
    """
    severity: Severity
    """
    Severity level of the problem, which is used in UI to differentiate.
    """
    message: str
    """
    Message generated by the consistency check describing the problem.
    """


class HasConsistencyCheckSchema(BaseModel):
    consistencyChecks: Optional[List[ConsistencyCheck]] = None
