# generated by datamodel-codegen:
#   filename:  workflow/unit/execution.json
#   version:   0.28.5

from __future__ import annotations

from enum import Enum
from typing import Any, Dict, List, Optional, Union

from pydantic import BaseModel, ConfigDict, Field


class Type(Enum):
    execution = "execution"


class ApplicationSchemaBase(BaseModel):
    model_config = ConfigDict(
        extra="allow",
    )
    shortName: Optional[str] = None
    """
    The short name of the application. e.g. qe
    """
    summary: Optional[str] = None
    """
    Application's short description.
    """
    version: Optional[str] = None
    """
    Application version. e.g. 5.3.5
    """
    build: Optional[str] = None
    """
    Application build. e.g. VTST
    """
    hasAdvancedComputeOptions: Optional[bool] = None
    """
    Whether advanced compute options are present
    """
    isLicensed: Optional[bool] = None
    """
    Whether licensing is present
    """
    field_id: Optional[str] = Field(None, alias="_id")
    """
    entity identity
    """
    slug: Optional[str] = None
    """
    entity slug
    """
    systemName: Optional[str] = None
    schemaVersion: Optional[str] = "2022.8.16"
    """
    entity's schema version. Used to distinct between different schemas.
    """
    name: Optional[str] = None
    """
    entity name
    """
    isDefault: Optional[bool] = False
    """
    Identifies that entity is defaultable
    """


class NameResultSchema(BaseModel):
    name: str
    """
    The name of this item. e.g. scf_accuracy
    """


class ExecutableSchema(BaseModel):
    name: str
    """
    The name of the executable. e.g. pw.x
    """
    applicationId: Optional[List[str]] = None
    """
    _ids of the application this executable belongs to
    """
    hasAdvancedComputeOptions: Optional[bool] = None
    """
    Whether advanced compute options are present
    """
    field_id: Optional[str] = Field(None, alias="_id")
    """
    entity identity
    """
    slug: Optional[str] = None
    """
    entity slug
    """
    systemName: Optional[str] = None
    schemaVersion: Optional[str] = "2022.8.16"
    """
    entity's schema version. Used to distinct between different schemas.
    """
    isDefault: Optional[bool] = False
    """
    Identifies that entity is defaultable
    """
    preProcessors: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the pre-processors for this calculation
    """
    postProcessors: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the post-processors for this calculation
    """
    monitors: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the monitors for this calculation
    """
    results: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the results for this calculation
    """


class ExecutionUnitInputIdItemSchemaForPhysicsBasedSimulationEngines(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    templateId: Optional[str] = None
    templateName: Optional[str] = None
    name: Optional[str] = None
    """
    name of the resulting input file, if different than template name
    """


class FlavorSchema(BaseModel):
    executableId: Optional[str] = None
    """
    _id of the executable this flavor belongs to
    """
    executableName: Optional[str] = None
    """
    name of the executable this flavor belongs to
    """
    applicationName: Optional[str] = None
    """
    name of the application this flavor belongs to
    """
    input: Optional[List[ExecutionUnitInputIdItemSchemaForPhysicsBasedSimulationEngines]] = Field(
        None, title="execution unit input schema"
    )
    supportedApplicationVersions: Optional[List[str]] = None
    """
    list of application versions this flavor supports
    """
    field_id: Optional[str] = Field(None, alias="_id")
    """
    entity identity
    """
    slug: Optional[str] = None
    """
    entity slug
    """
    systemName: Optional[str] = None
    schemaVersion: Optional[str] = "2022.8.16"
    """
    entity's schema version. Used to distinct between different schemas.
    """
    name: Optional[str] = None
    """
    entity name
    """
    isDefault: Optional[bool] = False
    """
    Identifies that entity is defaultable
    """
    preProcessors: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the pre-processors for this calculation
    """
    postProcessors: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the post-processors for this calculation
    """
    monitors: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the monitors for this calculation
    """
    results: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the results for this calculation
    """


class Status(Enum):
    idle = "idle"
    active = "active"
    warning = "warning"
    error = "error"
    finished = "finished"


class StatusTrackItem(BaseModel):
    trackedAt: float
    status: str
    repetition: Optional[float] = None


class ExecutionUnitSchemaBase(BaseModel):
    model_config = ConfigDict(
        extra="allow",
    )
    type: Type
    """
    type of the unit
    """
    application: ApplicationSchemaBase = Field(..., title="application schema (base)")
    executable: Optional[ExecutableSchema] = Field(None, title="executable schema")
    flavor: Optional[FlavorSchema] = Field(None, title="flavor schema")
    input: Any
    """
    unit input (type to be specified by the application's execution unit)
    """
    field_id: Optional[str] = Field(None, alias="_id")
    """
    entity identity
    """
    isDraft: Optional[bool] = None
    name: Optional[str] = None
    """
    name of the unit. e.g. pw_scf
    """
    status: Optional[Status] = None
    """
    Status of the unit.
    """
    head: Optional[bool] = None
    """
    Whether this unit is the first one to be executed.
    """
    flowchartId: str
    """
    Identity of the unit in the workflow. Used to trace the execution flow of the workflow.
    """
    next: Optional[str] = None
    """
    Next unit's flowchartId. If empty, the current unit is the last.
    """
    enableRender: Optional[bool] = None
    """
    Whether Rupy should attempt to use Jinja templating to add context variables into the unit
    """
    context: Optional[Dict[str, Any]] = None
    slug: Optional[str] = None
    """
    entity slug
    """
    systemName: Optional[str] = None
    schemaVersion: Optional[str] = "2022.8.16"
    """
    entity's schema version. Used to distinct between different schemas.
    """
    isDefault: Optional[bool] = False
    """
    Identifies that entity is defaultable
    """
    preProcessors: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the pre-processors for this calculation
    """
    postProcessors: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the post-processors for this calculation
    """
    monitors: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the monitors for this calculation
    """
    results: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the results for this calculation
    """
    tags: Optional[List[str]] = None
    """
    entity tags
    """
    statusTrack: Optional[List[StatusTrackItem]] = None
