# generated by datamodel-codegen:
#   filename:  workflow/unit/io.json
#   version:   0.28.5

from __future__ import annotations

from enum import Enum
from typing import Any, Dict, List, Optional, Union

from pydantic import BaseModel, ConfigDict, Field


class Type(Enum):
    io = "io"


class Subtype(Enum):
    input = "input"
    output = "output"
    dataFrame = "dataFrame"


class Source(Enum):
    api = "api"
    db = "db"
    object_storage = "object_storage"


class DataIORestAPIInputSchema(BaseModel):
    model_config = ConfigDict(
        extra="allow",
    )
    endpoint: str
    """
    rest API endpoint
    """
    endpoint_options: Dict[str, Any]
    """
    rest API endpoint options
    """
    name: Optional[str] = None
    """
    the name of the variable in local scope to save the data under
    """


class DataIODatabaseInputOutputSchema(BaseModel):
    model_config = ConfigDict(
        extra="allow",
    )
    ids: List[str]
    """
    IDs of item to retrieve from db
    """


class DataIODatabaseInputOutputSchema3(BaseModel):
    model_config = ConfigDict(
        extra="allow",
    )
    collection: str
    """
    db collection name
    """
    draft: Optional[bool] = True
    """
    whether the result should be saved as draft
    """


class ObjectStorageContainerData(BaseModel):
    CONTAINER: Optional[str] = None
    """
    Object storage container for the file
    """
    NAME: Optional[str] = None
    """
    Name of the file inside the object storage bucket
    """
    PROVIDER: Optional[str] = None
    """
    Object storage provider
    """
    REGION: Optional[str] = None
    """
    Region for the object container specified in Container
    """
    SIZE: Optional[int] = None
    """
    Size of the file in bytes
    """
    TIMESTAMP: Optional[str] = None
    """
    Unix timestamp showing when the file was last modified
    """


class ObjectStorageIoSchema(BaseModel):
    model_config = ConfigDict(
        extra="allow",
    )
    objectData: ObjectStorageContainerData = Field(..., title="Object Storage Container Data")
    overwrite: Optional[bool] = False
    """
    if a file with the same filename already exists, whether to overwrite the old file
    """
    pathname: Optional[str] = None
    """
    Relative path to the directory that contains the file.
    """
    basename: Optional[str] = None
    """
    Basename of the file
    """
    filetype: Optional[str] = None
    """
    What kind of file this is, e.g. image / text
    """


class Status(Enum):
    idle = "idle"
    active = "active"
    warning = "warning"
    error = "error"
    finished = "finished"


class NameResultSchema(BaseModel):
    name: str
    """
    The name of this item. e.g. scf_accuracy
    """


class StatusTrackItem(BaseModel):
    trackedAt: float
    status: str
    repetition: Optional[float] = None


class DataIOUnitSchema(BaseModel):
    model_config = ConfigDict(
        extra="allow",
    )
    type: Type
    """
    type of the unit
    """
    subtype: Subtype
    source: Source
    input: List[
        Union[
            DataIORestAPIInputSchema,
            Union[DataIODatabaseInputOutputSchema, DataIODatabaseInputOutputSchema3],
            ObjectStorageIoSchema,
        ]
    ]
    field_id: Optional[str] = Field(None, alias="_id")
    """
    entity identity
    """
    isDraft: Optional[bool] = None
    name: Optional[str] = None
    """
    name of the unit. e.g. pw_scf
    """
    status: Optional[Status] = None
    """
    Status of the unit.
    """
    head: Optional[bool] = None
    """
    Whether this unit is the first one to be executed.
    """
    flowchartId: str
    """
    Identity of the unit in the workflow. Used to trace the execution flow of the workflow.
    """
    next: Optional[str] = None
    """
    Next unit's flowchartId. If empty, the current unit is the last.
    """
    enableRender: Optional[bool] = None
    """
    Whether Rupy should attempt to use Jinja templating to add context variables into the unit
    """
    context: Optional[Dict[str, Any]] = None
    slug: Optional[str] = None
    """
    entity slug
    """
    systemName: Optional[str] = None
    schemaVersion: Optional[str] = "2022.8.16"
    """
    entity's schema version. Used to distinct between different schemas.
    """
    isDefault: Optional[bool] = False
    """
    Identifies that entity is defaultable
    """
    preProcessors: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the pre-processors for this calculation
    """
    postProcessors: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the post-processors for this calculation
    """
    monitors: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the monitors for this calculation
    """
    results: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the results for this calculation
    """
    tags: Optional[List[str]] = None
    """
    entity tags
    """
    statusTrack: Optional[List[StatusTrackItem]] = None
