# Mflow — 并行分片流代理（Multi Flow）

并行化的 HTTP 流代理。将客户端的 Range 请求拆分为多个并发分片（chunk）向上游并行下载，按序合并后转发给客户端，从而提升带宽利用与播放稳定性。适用于 mpv、VLC 等支持 HTTP 流的播放器，或作为加速下载的中间层。

## 核心能力

- 并行分片下载与按序回写
- 上游重定向检测与自动跟随（默认最多 3 次）
- 可配置：并发连接数、分片大小、重试次数、最小速度检测等
- 支持 aria2 风格的 JSON-RPC（`/jsonrpc` / method=`aria2.addUri`）来创建任务并返回 GID
- 可选内存缓存以减少重复读取（SafeMemory）
- Windows 下彩色日志输出（colorama）

## 安装

通过 PyPI：

```powershell
pip install mflow
```

或从源码安装（开发）：

```powershell
cd Mflow
pip install -e .
```

> 依赖与版本请参见 `pyproject.toml`。

## 快速运行

在仓库根目录或已安装后：

```powershell
# 使用默认配置启动（默认端口 80）
python -m mflow

# 或指定端口 / 并发 / 分片大小
mflow --port 8080 --connections 8 --chunk-size 1M
```

默认监听地址为 0.0.0.0，端口可通过 `--port` 覆盖。

## 使用示例

播放器直接使用代理 URL：

```powershell
mpv "http://localhost:8080/stream?url=https://example.com/video.mp4"
```

使用 JSON-RPC 创建任务（aria2.addUri 风格）：

POST 到 `http://localhost:PORT/jsonrpc`，示例 body：

```json
{
  "jsonrpc": "2.0",
  "method": "aria2.addUri",
  "id": "1",
  "params": [
    ["https://example.com/video.mp4"],
    {"header": ["User-Agent: MyAgent/1.0"]}
  ]
}
```

返回将包含任务 GID（字符串）；随后可通过 `/stream?gid={GID}` 来复用任务信息。

## 命令行参数

- `-p, --port`：监听端口，默认 80
- `-c, --connections`：每个流允许的最大并发连接数，默认 4
- `-s, --chunk-size`：分片大小，支持后缀 K/M（例如 `1M`, `512K`），默认 1M
- `-r, --retry`：每个分片的最大重试次数，默认 5
- `--log-level`：日志级别（DEBUG|INFO|WARNING|ERROR|CRITICAL），默认 INFO
- `--cache`：启用内存缓存（默认关闭）
- `--min-speed`：最低速度阈值（例如 `100K`, `0.5M`），低于该值会触发重试或重建连接（默认 0，表示禁用）

示例：

```powershell
mflow --port 9000 --connections 16 --chunk-size 2M --log-level DEBUG
```

## HTTP 接口

- GET `/stream`：流媒体主接口
  - 参数：`url`（直接上游 URL）或 `gid`（JSON-RPC 返回的任务 ID）
  - 必须支持 Range（若上游不支持 Range，代理会返回 403/Forbidden）
  - 返回 200 或 206，包含 `Content-Range`、`Content-Length`、`Content-Type` 和可选 `Content-Disposition`

- POST `/jsonrpc`：接收 aria2 风格的 `aria2.addUri`，用于创建后台任务并返回 GID

## 实现

- 入口：`src/mflow.py`（解析命令行并启动 aiohttp 应用）
- 主要模块：
  - `mflow/app.py`：应用初始化、路由与日志配置
  - `mflow/handler.py`：MultiFlow 控制器，实现 `/stream` 与 `/jsonrpc` 的核心逻辑
  - `mflow/link_info.py`：LinkInfo（上游信息解析、client pool、文件名/类型检测）
  - `mflow/utils.py`：SafeMemory、Range 解析、彩色日志格式化等工具

- 分片下载流程：解析客户端 Range -> 根据 CHUNK_SIZE 切分区间 -> 并发下载分片 -> 通过序号同步机制按序写入响应流。
- 速度检测：以 1 秒为粒度监测下载速率，低于 `MIN_SPEED` 并且连续达到 `MAX_STREAK` 次将触发 LowSpeed 策略（例如重建连接或重试）。

## 排查建议

- 若播放停滞或卡顿：尝试增大 `--connections` 或减小 `--chunk-size`，或开启 DEBUG 日志查看详细重试信息。
- 若上游不支持 Range：无法并行化，代理会拒绝并以 403 返回。
- 使用 `--cache` 在内存允许的情况下降低重复请求对上游的压力。

## 许可与贡献

项目含 LICENSE（见仓库根目录）。欢迎通过 issue/PR 贡献改进或报告问题。