"""
Stub file for PyCharm and static analyzers.

This file declares attributes of the BIOGEME class that are dynamically
added at runtime (e.g., through setattr or property injection), so that
IDEs like PyCharm can provide autocompletion and suppress false warnings.
"""

class BIOGEME:
    seed: int  # Dynamically injected parameter (e.g., via setattr or property)
    tolerance: float  # Dynamically injected parameter (e.g., via setattr or property)
    steptol: float  # Dynamically injected parameter (e.g., via setattr or property)
    max_iterations: (
        int  # Dynamically injected parameter (e.g., via setattr or property)
    )
    number_of_threads: (
        int  # Dynamically injected parameter (e.g., via setattr or property)
    )
    enlarging_factor: (
        float  # Dynamically injected parameter (e.g., via setattr or property)
    )
    initial_radius: (
        float  # Dynamically injected parameter (e.g., via setattr or property)
    )
    infeasible_cg: (
        bool  # Dynamically injected parameter (e.g., via setattr or property)
    )
    second_derivatives: (
        int  # Dynamically injected parameter (e.g., via setattr or property)
    )
    dogleg: bool  # Dynamically injected parameter (e.g., via setattr or property)
    bootstrap_samples: (
        int  # Dynamically injected parameter (e.g., via setattr or property)
    )
    save_iterations: (
        bool  # Dynamically injected parameter (e.g., via setattr or property)
    )
    generate_html: (
        bool  # Dynamically injected parameter (e.g., via setattr or property)
    )
    generate_yaml: (
        bool  # Dynamically injected parameter (e.g., via setattr or property)
    )
    optimization_algorithm: (
        str  # Dynamically injected parameter (e.g., via setattr or property)
    )
    maximum_number_catalog_expressions: (
        int  # Dynamically injected parameter (e.g., via setattr or property)
    )
