from __future__ import annotations

from typing import Literal

from .....utils.dev import ModelScopeLayoutComponent, resolve_frontend_dir


class AntdBadgeRibbon(ModelScopeLayoutComponent):
    """
    Ant Design: https://ant.design/components/badge
    """
    EVENTS = []

    def __init__(
            self,
            text: str | None = None,
            props: dict | None = None,
            *,
            color: str | None = None,
            placement: Literal['start', 'end'] = 'end',
            root_class_name: str | None = None,
            as_item: str | None = None,
            _internal: None = None,
            # gradio properties
            visible: bool = True,
            elem_id: str | None = None,
            elem_classes: list[str] | str | None = None,
            elem_style: dict | None = None,
            render: bool = True,
            **kwargs):
        super().__init__(visible=visible,
                         elem_id=elem_id,
                         elem_classes=elem_classes,
                         render=render,
                         as_item=as_item,
                         elem_style=elem_style,
                         **kwargs)
        self.props = props
        self.color = color
        self.placement = placement
        self.root_class_name = root_class_name
        self.text = text

    FRONTEND_DIR = resolve_frontend_dir("badge", 'ribbon')

    @property
    def skip_api(self):
        return True

    def preprocess(self, payload: None) -> None:
        return payload

    def postprocess(self, value: None) -> None:

        return value

    def example_payload(self) -> None:
        return None

    def example_value(self) -> None:
        return None
