from __future__ import annotations

from .....utils.dev import ModelScopeLayoutComponent, resolve_frontend_dir


class AntdIconIconfontProvider(ModelScopeLayoutComponent):
    """
    Ant Design: https://ant.design/components/icon

    Semantic vector graphics.

    A component to help developer use their own icons deployed at https://iconfont.cn in a convenient way.
    """
    EVENTS = []

    # supported slots
    SLOTS = []

    def __init__(
            self,
            script_url: str | list[str] | None = None,
            props: dict | None = None,
            *,
            extra_common_props: dict | None = None,
            as_item: str | None = None,
            _internal: None = None,
            # gradio properties
            visible: bool = True,
            render: bool = True,
            **kwargs):
        """
        Parameters:
            script_url: The URL generated by https://iconfont.cn project.
            extra_common_props: Define extra properties to the component.
        """
        super().__init__(visible=visible,
                         render=render,
                         as_item=as_item,
                         **kwargs)
        self.script_url = script_url
        self.extra_common_props = extra_common_props
        self.props = props

    FRONTEND_DIR = resolve_frontend_dir("icon", "iconfont-provider")

    @property
    def skip_api(self):
        return True

    def preprocess(self, payload: None) -> None:
        return payload

    def postprocess(self, value: None) -> None:

        return value

    def example_payload(self) -> None:
        return "GithubOutlined"

    def example_value(self) -> None:
        return "GithubOutlined"
