# mypy-boto3-appstream<a id="mypy-boto3-appstream"></a>

[![PyPI - mypy-boto3-appstream](https://img.shields.io/pypi/v/mypy-boto3-appstream.svg?color=blue)](https://pypi.org/project/mypy-boto3-appstream)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-appstream.svg?color=blue)](https://pypi.org/project/mypy-boto3-appstream)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dw/mypy-boto3-appstream?color=blue)](https://pypistats.org/packages/mypy-boto3-appstream)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.AppStream 1.17.83](https://boto3.amazonaws.com/v1/documentation/api/1.17.83/reference/services/appstream.html#AppStream)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-buider 4.14.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-appstream docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_appstream/)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-appstream](#mypy-boto3-appstream)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Waiters annotations](#waiters-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)
  - [Versioning](#versioning)
  - [Documentation](#documentation)
  - [Support and contributing](#support-and-contributing)

## How to install<a id="how-to-install"></a>

Install `boto3-stubs` for `AppStream` service.

```bash
python -m pip install boto3-stubs[appstream]
```

## Usage<a id="usage"></a>

### VSCode<a id="vscode"></a>

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[appstream]` in your environment:
  `python -m pip install 'boto3-stubs[appstream]'`

Both type checking and auto-complete should work for `AppStream` service. No
explicit type annotations required, write your `boto3` code as usual.

### PyCharm<a id="pycharm"></a>

- Install `boto-stubs[appstream]` in your environment:
  `python -m pip install 'boto3-stubs[appstream]'`

Both type checking and auto-complete should work for `AppStream` service. No
explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed
`boto3-stubs` submodules.

### Other IDEs<a id="other-ides"></a>

Not tested, but as long as your IDE support `mypy` or `pyright`, everything
should work.

### mypy<a id="mypy"></a>

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[appstream]` in your environment:
  `python -m pip install 'boto3-stubs[appstream]'`
- Run `mypy` as usual

Type checking should work for `AppStream` service. No explicit type annotations
required, write your `boto3` code as usual.

### pyright<a id="pyright"></a>

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[appstream]` in your environment:
  `python -m pip install 'boto3-stubs[appstream]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `AppStream` service. No explicit type annotations
required, write your `boto3` code as usual.

## Explicit type annotations<a id="explicit-type-annotations"></a>

### Client annotations<a id="client-annotations"></a>

`AppStreamClient` provides annotations for `boto3.client("appstream")`.

```python
import boto3

from mypy_boto3_appstream import AppStreamClient

client: AppStreamClient = boto3.client("appstream")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: AppStreamClient = session.client("appstream")
```

### Paginators annotations<a id="paginators-annotations"></a>

`mypy_boto3_appstream.paginator` module contains type annotations for all
paginators.

```python
from mypy_boto3_appstream import AppStreamClient
from mypy_boto3_appstream.paginator import (
    DescribeDirectoryConfigsPaginator,
    DescribeFleetsPaginator,
    DescribeImageBuildersPaginator,
    DescribeImagesPaginator,
    DescribeSessionsPaginator,
    DescribeStacksPaginator,
    DescribeUserStackAssociationsPaginator,
    DescribeUsersPaginator,
    ListAssociatedFleetsPaginator,
    ListAssociatedStacksPaginator,
)

client: AppStreamClient = boto3.client("appstream")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
describe_directory_configs_paginator: DescribeDirectoryConfigsPaginator = client.get_paginator("describe_directory_configs")
describe_fleets_paginator: DescribeFleetsPaginator = client.get_paginator("describe_fleets")
describe_image_builders_paginator: DescribeImageBuildersPaginator = client.get_paginator("describe_image_builders")
describe_images_paginator: DescribeImagesPaginator = client.get_paginator("describe_images")
describe_sessions_paginator: DescribeSessionsPaginator = client.get_paginator("describe_sessions")
describe_stacks_paginator: DescribeStacksPaginator = client.get_paginator("describe_stacks")
describe_user_stack_associations_paginator: DescribeUserStackAssociationsPaginator = client.get_paginator("describe_user_stack_associations")
describe_users_paginator: DescribeUsersPaginator = client.get_paginator("describe_users")
list_associated_fleets_paginator: ListAssociatedFleetsPaginator = client.get_paginator("list_associated_fleets")
list_associated_stacks_paginator: ListAssociatedStacksPaginator = client.get_paginator("list_associated_stacks")
```

### Waiters annotations<a id="waiters-annotations"></a>

`mypy_boto3_appstream.waiter` module contains type annotations for all waiters.

```python
from mypy_boto3_appstream import AppStreamClient
from mypy_boto3_appstream.waiter import (
    FleetStartedWaiter,
    FleetStoppedWaiter,
)

client: AppStreamClient = boto3.client("appstream")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
fleet_started_waiter: FleetStartedWaiter = client.get_waiter("fleet_started")
fleet_stopped_waiter: FleetStoppedWaiter = client.get_waiter("fleet_stopped")
```

### Literals<a id="literals"></a>

`mypy_boto3_appstream.literals` module contains literals extracted from shapes
that can be used in user code for type checking.

```python
from mypy_boto3_appstream.literals import (
    AccessEndpointTypeType,
    ActionType,
    AuthenticationTypeType,
    DescribeDirectoryConfigsPaginatorName,
    DescribeFleetsPaginatorName,
    DescribeImageBuildersPaginatorName,
    DescribeImagesPaginatorName,
    DescribeSessionsPaginatorName,
    DescribeStacksPaginatorName,
    DescribeUserStackAssociationsPaginatorName,
    DescribeUsersPaginatorName,
    FleetAttributeType,
    FleetErrorCodeType,
    FleetStartedWaiterName,
    FleetStateType,
    FleetStoppedWaiterName,
    FleetTypeType,
    ImageBuilderStateChangeReasonCodeType,
    ImageBuilderStateType,
    ImageStateChangeReasonCodeType,
    ImageStateType,
    ListAssociatedFleetsPaginatorName,
    ListAssociatedStacksPaginatorName,
    MessageActionType,
    PermissionType,
    PlatformTypeType,
    SessionConnectionStateType,
    SessionStateType,
    StackAttributeType,
    StackErrorCodeType,
    StorageConnectorTypeType,
    StreamViewType,
    UsageReportExecutionErrorCodeType,
    UsageReportScheduleType,
    UserStackAssociationErrorCodeType,
    VisibilityTypeType,
)

def check_value(value: AccessEndpointTypeType) -> bool:
    ...
```

### Typed dictionaries<a id="typed-dictionaries"></a>

`mypy_boto3_appstream.type_defs` module contains structures and shapes
assembled to typed dictionaries for additional type checking.

```python
from mypy_boto3_appstream.type_defs import (
    AccessEndpointTypeDef,
    ApplicationSettingsResponseTypeDef,
    ApplicationSettingsTypeDef,
    ApplicationTypeDef,
    BatchAssociateUserStackResultTypeDef,
    BatchDisassociateUserStackResultTypeDef,
    ComputeCapacityStatusTypeDef,
    ComputeCapacityTypeDef,
    CopyImageResponseTypeDef,
    CreateDirectoryConfigResultTypeDef,
    CreateFleetResultTypeDef,
    CreateImageBuilderResultTypeDef,
    CreateImageBuilderStreamingURLResultTypeDef,
    CreateStackResultTypeDef,
    CreateStreamingURLResultTypeDef,
    CreateUpdatedImageResultTypeDef,
    CreateUsageReportSubscriptionResultTypeDef,
    DeleteImageBuilderResultTypeDef,
    DeleteImageResultTypeDef,
    DescribeDirectoryConfigsResultTypeDef,
    DescribeFleetsResultTypeDef,
    DescribeImageBuildersResultTypeDef,
    DescribeImagePermissionsResultTypeDef,
    DescribeImagesResultTypeDef,
    DescribeSessionsResultTypeDef,
    DescribeStacksResultTypeDef,
    DescribeUsageReportSubscriptionsResultTypeDef,
    DescribeUserStackAssociationsResultTypeDef,
    DescribeUsersResultTypeDef,
    DirectoryConfigTypeDef,
    DomainJoinInfoTypeDef,
    FleetErrorTypeDef,
    FleetTypeDef,
    ImageBuilderStateChangeReasonTypeDef,
    ImageBuilderTypeDef,
    ImagePermissionsTypeDef,
    ImageStateChangeReasonTypeDef,
    ImageTypeDef,
    LastReportGenerationExecutionErrorTypeDef,
    ListAssociatedFleetsResultTypeDef,
    ListAssociatedStacksResultTypeDef,
    ListTagsForResourceResponseTypeDef,
    NetworkAccessConfigurationTypeDef,
    PaginatorConfigTypeDef,
    ResourceErrorTypeDef,
    ServiceAccountCredentialsTypeDef,
    SessionTypeDef,
    SharedImagePermissionsTypeDef,
    StackErrorTypeDef,
    StackTypeDef,
    StartImageBuilderResultTypeDef,
    StopImageBuilderResultTypeDef,
    StorageConnectorTypeDef,
    UpdateDirectoryConfigResultTypeDef,
    UpdateFleetResultTypeDef,
    UpdateStackResultTypeDef,
    UsageReportSubscriptionTypeDef,
    UserSettingTypeDef,
    UserStackAssociationErrorTypeDef,
    UserStackAssociationTypeDef,
    UserTypeDef,
    VpcConfigTypeDef,
    WaiterConfigTypeDef,
)

def get_structure() -> AccessEndpointTypeDef:
    return {
      ...
    }
```

## Versioning<a id="versioning"></a>

`mypy-boto3-appstream` version is the same as related `boto3` version and
follows [PEP 440](https://www.python.org/dev/peps/pep-0440/) format.

## Documentation<a id="documentation"></a>

All type annotations can be found in
[mypy-boto3-appstream docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_appstream/)

## Support and contributing<a id="support-and-contributing"></a>

This package is auto-generated. Please reports any bugs or request new features
in [mypy-boto3-builder](https://github.com/vemel/mypy_boto3_builder/issues/)
repository.
