# transcript_schema.py
"""Schema definition for transcription documents produced by the Transcriber agent.

The schema captures high-level session metadata alongside a chronological list
of speech segments. Downstream tools can rely on the ordered <segments>
container to iterate through transcription results in the sequence they were
observed.
"""

from meshagent.api.schema import (
    MeshSchema,
    ElementType,
    ChildProperty,
    ValueProperty,
)

transcript_schema = MeshSchema(
    root_tag_name="transcript",
    elements=[
        ElementType(
            tag_name="transcript",
            description=(
                "Root element describing a transcription session generated by "
                "the Transcriber agent."
            ),
            properties=[
                ChildProperty(
                    name="segments",
                    description="Ordered collection of speech segments captured during the session.",
                    child_tag_names=["segment"],
                ),
            ],
        ),
        ElementType(
            tag_name="segment",
            description="A contiguous span of speech transcribed from a participant.",
            properties=[
                ValueProperty(
                    name="participant_id",
                    description="MeshAgent participant identifier associated with the audio segment.",
                    type="string",
                ),
                ValueProperty(
                    name="participant_name",
                    description="Human-friendly participant name when available.",
                    type="string",
                ),
                ValueProperty(
                    name="time",
                    description="Segment start time as an ISO-8601 UTC timestamp.",
                    type="string",
                ),
                ValueProperty(
                    name="text",
                    description="Transcript text emitted by the speech-to-text engine.",
                    type="string",
                ),
            ],
        ),
    ],
)
