# TODO: started with numbers 100+ to make it easier to rearrange and renumber
# when we tidy up the messages

# fmt: off
class Messages:
    E001 = "Could not create {noun} {name}"
    E002 = "Could not create {noun} {name}: {noun} already exists"
    E003 = "Could not create {noun} {name}: forbidden"
    E004 = "Could not create {noun} {name}: invalid data"
    E005 = "Could not delete {noun} {name}"
    E006 = "Could not delete {noun} {name}: {noun} not found"
    E007 = "Could not delete {noun} {name}: forbidden"
    E008 = "Could not load {noun} {name}"
    E009 = "Error requesting recipe schemas from cluster"
    E010 = "Could not find {noun} recipe '{name}' on cluster"
    E011 = "Could not request {noun} logs from cluster"
    E012 = "Default project not set and no --project-id provided"
    E013 = "Could not find project {name}"
    E014 = "Could not create {noun} {name}: {noun} already exists in project {project}"
    E015 = "Could not {verb}: received two local paths"
    E016 = "Could not upload directory. Did you mean cp --recurse?"
    E017 = "Could not {verb} file"
    E018 = "Cannot list directory"
    E019 = "Could not copy file: more than one file. Maybe you forgot to use --recurse?"
    E020 = "Could not copy file: file already exists. Maybe you forgot to use --overwrite?"
    E021 = "Could not copy file: parent directory does not exists. Maybe you forgot to use --make-dirs?"
    E022 = "Could not make the copy tree plan"
    E024 = "Cannot rsync a file: use the cp command instead"
    E025 = "Could not start {noun} {name}"
    E026 = "Could not stop {noun} {name}"
    E027 = "Could not deregister {noun} {name}: error contacting PAM"
    E028 = "Could not deregister {noun} {name}: Nomad error"
    E029 = "Could not deregister {noun} {name}: {noun} not found"
    E030 = "Could not deregister {noun} {name}: forbidden"
    E031 = "Login failed: timed out waiting for browser authentication"
    E032 = "Login failed: the device authentication API sent an incomplete response"
    E033 = "Login failed: unable to load CLI config from {url}"
    E034 = "{code} {reason} for URL {url}"
    E035 = "Cluster host unset: use the config set-cluster-host command to provide a cluster URL"
    E036 = "Cluster ID unset"
    E037 = "PAM host unset: use the config set-pam-host command to provide a PAM URL"
    E038 = "Could not find {noun}: {name_or_id}"
    E039 = "Authentication error: {message}"
    E040 = "Run {command} to log in"  # TODO: this could be better to include more scenarios?
    E041 = "Could not check status of cluster '{name}'"
    E042 = "Could not create {noun} {name}: project ID unset"
    E043 = "The following arguments are required: {args}"
    E044 = "Could not start {noun} {name}: input validation failed"
    E045 = "Could not parse secrets file{path_details}. The file may be out of date or corrupted.{error_details}\n\nTo re-authenticate and overwrite the file, run `ptc login`"
    E046 = "{type} on cluster"
    E047 = "Unexpected request error"
    E048 = "Could not delete {noun} {name} because it is being referenced by {others}. Remove them before deleting the {noun}. Alternatively use {flag} to delete the related objects as well."

    T001 = "Not creating {noun} {name}: {noun} already exists"
    T002 = "Successfully created {noun} {name}"
    T003 = "Successfully deleted {noun} {name}"
    T004 = "Successfully created {noun} with ID {id} and set as the default {noun}"
    T005 = "Successfully started {noun} {name}"
    T006 = "Not starting {noun} {name}: already running"
    T007 = "Successfully stopped {noun} {name}"
    T008 = "Not stopping {noun} {name}: already stopped"
    T009 = "Successfully deregistered {noun} {name}"
    T011 = "Successfully copied files"
    T012 = "Login successful"
    T014 = "Opening browser to authenticate..."
    T015 = "If a browser doesn't open automatically after some seconds, you can copy and open this link:"
    T016 = "Alternatively, you can manually open:"
    T017 = "And type the code:"
    T018 = "Successfully saved {noun}"
    T019 = "Default {noun} set as {name}"
    T020 = "Fetching recipes from the cluster..."
    T021 = "Clearing {subpath}"
    T022 = "Found valid meta.json in package"
    T023 = "Custom recipes found"
    T024 = "Valid recipes package"
    T025 = "Building wheel for {src}"
    T026 = "Package {name} exists"
    T027 = "Computing meta for wheel {name}"
    T028 = "Done"
    T029 = "Uploading wheel to cluster"
    T030 = "Uploading {count} files"
    T031 = "Creating virtual environment"
    T032 = "Registering recipes"
    T033 = "Uploaded {src}"
    T034 = "Starting {noun}..."
    T035 = "Downloading {count} assets"
    T036 = "Downloaded assets"
    T037 = "Not downloading any assets. Make sure to specify the source in the JSON manually if you're planning on using it to import later."
    T038 = "Generated {n_projects} projects, {n_tasks} tasks, {n_actions} actions, {n_assets} assets, {n_datasets} datasets, {n_paths} paths"
    T039 = "Successfully saved data"
    T040 = "Create projects"
    T041 = "Configure cluster paths"
    T042 = "Transfer asset files"
    T043 = "Register assets"
    T044 = "Create tasks and actions"
    T045 = "Upload recipes"

    # CLI docstrings for placeholders (parent commands with no functions)
    doc_actions = "Interact with actions on the cluster"
    doc_assets = "View and manage assets on the cluster"
    doc_clusters = "Interact with clusters"
    doc_config = "Configure the CLI"
    doc_consul = "View and manage cluster secrets"
    doc_datasets = "View and manage Prodigy datasets on the cluster"
    doc_files = "Manage files on the cluster. Your files are only ever sent to servers or buckets you control. They are never sent to our servers."
    doc_packages = "View and manage Python packages on the cluster"
    doc_paths = "View and manage path aliases on the cluster"
    doc_projects = "View and manage Prodigy Teams projects"
    doc_recipes = "View and manage annotation recipe packages on the cluster"
    doc_secrets = "View and manage named pointers to secrets on the cluster"
    doc_tasks = "Interact with annotation tasks on the cluster"
    doc_team = "View and manage Prodigy Teams users"

    # CLI argument annotations
    help = "Show help message"
    select = "Comma-separated fields to select and show in output. Available: {opts}"
    select_field = "Field to select and show in output"
    name_or_id = "Name or ID of the {noun}"
    name_or_id_optional = "Name or ID of the {noun} (or the last {noun} if not set)"
    project_id = "ID of {noun}'s project (or the last project if not set)"
    cluster_id = "ID of the cluster to search for {noun} name (or the last cluster if not set)"
    cluster_host = "Name of the cluster (or the last cluster if not set)"
    as_json = "Output the result as JSON"
    exists_ok = "Don't raise an error if it exists"
    missing_ok = "If missing, don't raise an error"
    no_start = "Don't start {noun} after creation"
    overwrite = "Overwrite if exists"
    make_dirs = "Create parent directories if they don't exist"
    name = "Name of the {noun}"
    new_name = "New name of the {noun}"
    new_address = "New address of the {noun}"
    description = "Description of the {noun}"
    version = "Version of the {noun}"
    author = "Author of the {noun}"
    email = "Email of the {noun}"
    url = "URL of the {noun}"
    license = "License of the {noun}"
    path = "Path of the {noun}"
    local_path = "Local path of the {noun}"
    remote_local_path = "Remote or local path of the {noun}"
    value = "Value of the {noun}"
    kind = "Kind of the {noun}, used to filter in recipes to only allow specific types"
    asset_kind = "Kind of the asset. Generally one of: ['Input', 'Model', 'Patterns]"
    asset_meta = "Asset meta, formatted as a JSON string"
    output_dir = "Output directory for the {noun}"
    cluster_host_config = "Host or URL of the cluster"
    pam_host_config = "Host or URL of the Prodigy Annotation Manager (PAM) app"
    no_cluster = "Don't use a cluster"
    use_active_venv = "Use the currently active virtualenv, instead of making a temporary one"
    filter_by = "Filter by {filter}"
    wheelhouse = "Local path to a cache of python packages in wheel format"
    recurse_list = "List files recursively"
    recurse_copy = "Copy whole directory recursively"
    remote_path = "Remote location path"
    recipe_project_id = "Project ID to add {noun} to"
    check_s3_bucket = "Run checks involving the S3 storage"
    check_nfs_path = "Run checks involving the NFS storage"
    check_recipe = "Run checks that need to operate over a recipe. This argument only makes sense when used with --recipe-args"
    check_recipe_args = "Run checks that need to operate over a recipe. This argument only makes sense when used with --recipe"
    import_data = "JSON file to import"
    export_output = "JSON output path for data"
    assets_dir = "Local directory to download assets to"
    include = "Comma-separated items to include"
    import_strict = "Error if items already exist and don't skip or overwrite anything"

    # To be replaced
    E101 = "Could not communicate with the device authentication API"
    E104 = "Error authenticating device and user with Prodigy Teams"
    E105 = "Error communicating with Prodigy Teams API"
    E106 = "No clusters registered"
    E107 = "Multiple clusters registered, pick one with --cluster-host"
    E116 = "Could not login to cluster. Run {command} to log in to without connecting to a cluster"
    E117 = "Unrecognized token type {token_type!r}"
    E118 = "Error requesting recipe schemas"
    E121 = "Invalid JSON for meta"
    E128 = "Cannot parse path: {path}"
    E144 = "Not a valid Python package: name should end in .tar.gz or .whl"
    E145 = "No valid meta.json found in package"
    E146 = "Invalid meta.json key prodigy_teams_recipes"
    E147 = "No custom recipes found"
    E148 = "Make sure you have prodigy_teams_recipes and prodigy installed in your virtual env, then run: python setup.py sdist bdish_wheel"
    E149 = "One or more recipes are not valid"
    E152 = "Error listing wheels"
    E153 = "Can't create package '{name}': a package with this name and version already exists"
    E154 = "Can't initialize recipe package '{name}': existing files would be overwritten"
    E176 = "Unexpected type for {name}: {value}"
    E177 = "Asset not found: {name}"
    E178 = "Dataset not found: {value}. Recipe args do not mark it for creation"
    E179 = "Dataset not found, and ambiguous recipe arguments: more than one could apply"
    E180 = "Invalid kind or access for resolved object for field: {name}"
    E185 = "Invalid recipe argument type: {type}"
    E186 = "Schema definitions are expected to be under 'definitions'"


#  fmt: on
