# flake8: noqa
# generated by datamodel-codegen:
#   filename:  openapi.json

from __future__ import annotations

from datetime import datetime
from enum import Enum
from typing import Any, Dict, List, Optional, Union
from uuid import UUID

from pydantic import BaseModel, Field


class AccessTokenResponse(BaseModel):
    access_token: str = Field(..., title="Access Token")
    token_type: Optional[str] = Field("bearer", title="Token Type")
    expires_in: int = Field(..., title="Expires In")
    expiration: Optional[int] = Field(None, title="Expiration")


class BodyApiV1UploadFileApiV1FilesUploadPost(BaseModel):
    file: bytes = Field(..., description="File to Upload with valid name", title="File")


class CheckProgressRequest(BaseModel):
    id: UUID = Field(..., title="Id")


class Status(Enum):
    running = "running"
    done = "done"


class CheckProgressResponse(BaseModel):
    id: UUID = Field(..., title="Id")
    status: Status = Field(..., title="Status")
    report: Optional[Any] = Field(None, title="Report")


class CheckStartRequest(BaseModel):
    s3_bucket: Optional[str] = Field(None, title="S3 Bucket")
    nfs_path: Optional[str] = Field(None, title="Nfs Path")
    package_environment: Optional[str] = Field(None, title="Package Environment")
    recipe_name: Optional[str] = Field(None, title="Recipe Name")
    recipe_args: Optional[Dict[str, Any]] = Field(None, title="Recipe Args")


class CheckStartResponse(BaseModel):
    id: UUID = Field(..., title="Id")


class Copying(BaseModel):
    src: str = Field(..., title="Src")
    dest: str = Field(..., title="Dest")
    make_dirs: bool = Field(..., title="Make Dirs")
    overwrite: bool = Field(..., title="Overwrite")


class Dataset(BaseModel):
    name: str = Field(
        ..., description="a unique name for the dataset", title="Dataset Name"
    )
    created: Optional[datetime] = Field(
        None,
        description="the date and time that the dataset was created",
        title="Created Time",
    )
    meta: Optional[str] = Field(
        "{}",
        description="An arbitrary JSON string containing metadata for your dataset",
        title="Dataset Metadata",
    )
    session: Optional[bool] = Field(
        False,
        description="True when the dataset contains examples for a user session",
        title="Session Dataset",
    )


class DatasetCreating(BaseModel):
    author: Optional[str] = Field(
        "", description="the user that authored created dataset", title="Dataset Author"
    )
    description: Optional[str] = Field(
        "",
        description="human readable description of what kind of examples the dataset contains",
        title="Dataset Description",
    )
    created: Optional[datetime] = Field(
        None,
        description="the date and time that the dataset was created",
        title="Created Time",
    )
    name: str = Field(
        ..., description="a unique name for the dataset", title="Dataset Name"
    )


class DatasetExample(BaseModel):
    id: int = Field(..., description="The database id", ge=1, title="Id")
    input_hash: int = Field(
        ..., description="The hash value of the input", title="Input Hash"
    )
    task_hash: int = Field(
        ..., description="The hash value of the task", title="Task Hash"
    )
    content: Dict[str, Any] = Field(
        ..., description="The dict content of the example", title="Content"
    )


class DatasetMeta(BaseModel):
    author: Optional[str] = Field(
        "", description="the user that authored created dataset", title="Dataset Author"
    )
    description: Optional[str] = Field(
        "",
        description="human readable description of what kind of examples the dataset contains",
        title="Dataset Description",
    )
    created: Optional[datetime] = Field(
        None,
        description="the date and time that the dataset was created",
        title="Created Time",
    )


class DatasetQueryResponse(BaseModel):
    items: List[DatasetExample] = Field(..., title="Items")
    total: int = Field(..., ge=0, title="Total")
    page: int = Field(..., ge=1, title="Page")
    size: int = Field(..., ge=1, title="Size")
    name: str = Field(..., title="Name")
    meta: Optional[DatasetMeta] = None


class Deleting(BaseModel):
    path: str = Field(..., title="Path")
    missing_ok: Optional[bool] = Field(True, title="Missing Ok")


class Downloading(BaseModel):
    target: str = Field(..., title="Target")


class EnvAwaiting(BaseModel):
    path: str = Field(..., title="Path")


class EnvCreating(BaseModel):
    requirements: List[str] = Field(..., title="Requirements")
    envs_path: str = Field(..., title="Envs Path")
    wheels_path: str = Field(..., title="Wheels Path")
    blocking: bool = Field(..., title="Blocking")


class EnvReturning(BaseModel):
    name: str = Field(..., title="Name")
    path: str = Field(..., title="Path")
    ready: bool = Field(..., title="Ready")


class FileCopyPlan(BaseModel):
    src: str = Field(..., title="Src")
    dest: str = Field(..., title="Dest")


class FileStats(BaseModel):
    size: int = Field(..., title="Size")
    modification_time: datetime = Field(..., title="Modification Time")


class Action(Enum):
    start = "start"
    stop = "stop"
    delete = "delete"


class JobLogRequest(BaseModel):
    id: UUID = Field(..., title="Id")


class JobLogResponse(BaseModel):
    text: str = Field(..., title="Text")


class JobType(Enum):
    task = "task"
    action = "action"


class Listing(BaseModel):
    path: str = Field(..., title="Path")
    recurse: bool = Field(..., title="Recurse")
    include_stats: Optional[bool] = Field(False, title="Include Stats")


class NomadErrorResponse(BaseModel):
    status_code: int = Field(..., title="Status Code")
    body: str = Field(..., title="Body")
    url: str = Field(..., title="Url")
    method: str = Field(..., title="Method")


class NomadJobActionResponse(BaseModel):
    action: str = Field(..., title="Action")
    job_id: UUID = Field(..., title="Job Id")
    eval_id: UUID = Field(..., title="Eval Id")
    eval_create_index: int = Field(..., title="Eval Create Index")
    job_modify_index: int = Field(..., title="Job Modify Index")


class PageStr(BaseModel):
    items: List[str] = Field(..., title="Items")
    total: int = Field(..., ge=0, title="Total")
    page: int = Field(..., ge=1, title="Page")
    size: int = Field(..., ge=1, title="Size")


class PamErrorResponse(BaseModel):
    status_code: int = Field(..., title="Status Code")
    body: str = Field(..., title="Body")
    url: str = Field(..., title="Url")
    method: str = Field(..., title="Method")


class PathList(BaseModel):
    paths: List[str] = Field(..., title="Paths")
    stats: Optional[List[FileStats]] = Field(None, title="Stats")
    exists: bool = Field(..., title="Exists")
    is_file: bool = Field(..., title="Is File")


class RsyncPlan(BaseModel):
    copy_: List[FileCopyPlan] = Field(..., title="Copy ")
    delete: List[str] = Field(..., title="Delete")
    file_exists: List[str] = Field(..., title="File Exists")
    directory_missing: List[str] = Field(..., title="Directory Missing")


class Secret(BaseModel):
    key: str = Field(..., title="Key")
    value: str = Field(..., title="Value")


class SecretResponse(BaseModel):
    CreateIndex: int = Field(..., title="Createindex")
    ModifyIndex: int = Field(..., title="Modifyindex")
    LockIndex: int = Field(..., title="Lockindex")
    Key: str = Field(..., title="Key")
    Flags: int = Field(..., title="Flags")
    Value: str = Field(..., title="Value")


class SpecValidationFailure(BaseModel):
    message: str = Field(..., title="Message")
    errors: List[Dict[str, Any]] = Field(..., title="Errors")


class Statting(BaseModel):
    path: str = Field(..., title="Path")


class StatusModel(Enum):
    Ready = "Ready"
    Error = "Error"


class TasksBaseUrl(BaseModel):
    url: str = Field(..., title="Url")


class ValidationError(BaseModel):
    loc: List[Union[str, int]] = Field(..., title="Location")
    msg: str = Field(..., title="Message")
    type: str = Field(..., title="Error Type")


class CopyPlan(BaseModel):
    copy_: List[FileCopyPlan] = Field(..., title="Copy ")
    file_exists: List[str] = Field(..., title="File Exists")
    directory_missing: List[str] = Field(..., title="Directory Missing")


class HTTPValidationError(BaseModel):
    detail: Optional[List[ValidationError]] = Field(None, title="Detail")


class HealthCheck(BaseModel):
    status: StatusModel
    cluster: StatusModel
    nomad_error: Optional[NomadErrorResponse] = None


class JobActionResponse(BaseModel):
    job_id: UUID = Field(..., title="Job Id")
    attempt_id: Optional[UUID] = Field(None, title="Attempt Id")
    status: str = Field(..., title="Status")
    action: Action = Field(..., title="Action")
    job_type: JobType
    pam_error: Optional[PamErrorResponse] = None
    validation_error: Optional[SpecValidationFailure] = None
    nomad_error: Optional[NomadErrorResponse] = None
    nomad_change: Optional[NomadJobActionResponse] = None


class JobID(BaseModel):
    id: UUID = Field(..., title="Id")
    job_type: JobType
